/*
 * Decompiled with CFR 0.152.
 */
package harmony.java.awt.geom;

import harmony.java.awt.geom.AffineTransform;
import harmony.java.awt.geom.PathIterator;
import harmony.java.awt.geom.Rectangle2D;
import harmony.java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class Ellipse2D
extends RectangularShape {
    protected Ellipse2D() {
    }

    @Override
    public boolean contains(double px, double py) {
        double b;
        if (this.isEmpty()) {
            return false;
        }
        double a = (px - this.getX()) / this.getWidth() - 0.5;
        return a * a + (b = (py - this.getY()) / this.getHeight() - 0.5) * b < 0.25;
    }

    @Override
    public boolean intersects(double rx, double ry, double rw, double rh) {
        double nx;
        if (this.isEmpty() || rw <= 0.0 || rh <= 0.0) {
            return false;
        }
        double cx = this.getX() + this.getWidth() / 2.0;
        double cy = this.getY() + this.getHeight() / 2.0;
        double rx1 = rx;
        double ry1 = ry;
        double rx2 = rx + rw;
        double ry2 = ry + rh;
        double d = cx < rx1 ? rx1 : (nx = cx > rx2 ? rx2 : cx);
        double ny = cy < ry1 ? ry1 : (cy > ry2 ? ry2 : cy);
        return this.contains(nx, ny);
    }

    @Override
    public boolean contains(double rx, double ry, double rw, double rh) {
        if (this.isEmpty() || rw <= 0.0 || rh <= 0.0) {
            return false;
        }
        double rx1 = rx;
        double ry1 = ry;
        double rx2 = rx + rw;
        double ry2 = ry + rh;
        return this.contains(rx1, ry1) && this.contains(rx2, ry1) && this.contains(rx2, ry2) && this.contains(rx1, ry2);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(this, at);
    }

    public static class Double
    extends Ellipse2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x, double y, double width, double height) {
            this.setFrame(x, y, width, height);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setFrame(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    public static class Float
    extends Ellipse2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x, float y, float width, float height) {
            this.setFrame(x, y, width, height);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return (double)this.width <= 0.0 || (double)this.height <= 0.0;
        }

        public void setFrame(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void setFrame(double x, double y, double width, double height) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)width;
            this.height = (float)height;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }
    }

    class Iterator
    implements PathIterator {
        final double u = 0.6666666666666666 * (Math.sqrt(2.0) - 1.0);
        final double[][] points = new double[][]{{1.0, 0.5 + this.u, 0.5 + this.u, 1.0, 0.5, 1.0}, {0.5 - this.u, 1.0, 0.0, 0.5 + this.u, 0.0, 0.5}, {0.0, 0.5 - this.u, 0.5 - this.u, 0.0, 0.5, 0.0}, {0.5 + this.u, 0.0, 1.0, 0.5 - this.u, 1.0, 0.5}};
        double x;
        double y;
        double width;
        double height;
        AffineTransform t;
        int index;

        Iterator(Ellipse2D e, AffineTransform t) {
            this.x = e.getX();
            this.y = e.getY();
            this.width = e.getWidth();
            this.height = e.getHeight();
            this.t = t;
            if (this.width < 0.0 || this.height < 0.0) {
                this.index = 6;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index > 5;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(double[] coords) {
            int count;
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                type = 0;
                count = 1;
                double[] p = this.points[3];
                coords[0] = this.x + p[4] * this.width;
                coords[1] = this.y + p[5] * this.height;
            } else {
                type = 3;
                count = 3;
                double[] p = this.points[this.index - 1];
                int j = 0;
                int i = 0;
                while (i < 3) {
                    coords[j] = this.x + p[j++] * this.width;
                    coords[j] = this.y + p[j++] * this.height;
                    ++i;
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count);
            }
            return type;
        }

        @Override
        public int currentSegment(float[] coords) {
            int count;
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                type = 0;
                count = 1;
                double[] p = this.points[3];
                coords[0] = (float)(this.x + p[4] * this.width);
                coords[1] = (float)(this.y + p[5] * this.height);
            } else {
                type = 3;
                count = 3;
                int j = 0;
                double[] p = this.points[this.index - 1];
                int i = 0;
                while (i < 3) {
                    coords[j] = (float)(this.x + p[j++] * this.width);
                    coords[j] = (float)(this.y + p[j++] * this.height);
                    ++i;
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count);
            }
            return type;
        }
    }
}

