/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import repack.org.bouncycastle.crypto.BlockCipher;
import repack.org.bouncycastle.crypto.Digest;
import repack.org.bouncycastle.crypto.params.KeyParameter;
import repack.org.bouncycastle.crypto.params.ParametersWithIV;
import repack.org.bouncycastle.crypto.tls.SecurityParameters;
import repack.org.bouncycastle.crypto.tls.TlsCipher;
import repack.org.bouncycastle.crypto.tls.TlsClientContext;
import repack.org.bouncycastle.crypto.tls.TlsFatalAlert;
import repack.org.bouncycastle.crypto.tls.TlsMac;
import repack.org.bouncycastle.crypto.tls.TlsUtils;
import repack.org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsBlockCipher(TlsClientContext context, BlockCipher encryptCipher, BlockCipher decryptCipher, Digest writeDigest, Digest readDigest, int cipherKeySize) {
        this.context = context;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        int prfSize = 2 * cipherKeySize + writeDigest.getDigestSize() + readDigest.getDigestSize() + encryptCipher.getBlockSize() + decryptCipher.getBlockSize();
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] key_block = TlsUtils.PRF(securityParameters.masterSecret, "key expansion", TlsUtils.concat(securityParameters.serverRandom, securityParameters.clientRandom), prfSize);
        int offset = 0;
        this.writeMac = new TlsMac(writeDigest, key_block, offset, writeDigest.getDigestSize());
        this.readMac = new TlsMac(readDigest, key_block, offset += writeDigest.getDigestSize(), readDigest.getDigestSize());
        this.initCipher(true, encryptCipher, key_block, cipherKeySize, offset += readDigest.getDigestSize(), offset + cipherKeySize * 2);
        this.initCipher(false, decryptCipher, key_block, cipherKeySize, offset += cipherKeySize, offset + cipherKeySize + encryptCipher.getBlockSize());
    }

    protected void initCipher(boolean forEncryption, BlockCipher cipher, byte[] key_block, int key_size, int key_offset, int iv_offset) {
        KeyParameter key_parameter = new KeyParameter(key_block, key_offset, key_size);
        ParametersWithIV parameters_with_iv = new ParametersWithIV(key_parameter, key_block, iv_offset, cipher.getBlockSize());
        cipher.init(forEncryption, parameters_with_iv);
    }

    @Override
    public byte[] encodePlaintext(short type, byte[] plaintext, int offset, int len) {
        int blocksize = this.encryptCipher.getBlockSize();
        int minPaddingSize = blocksize - (len + this.writeMac.getSize() + 1) % blocksize;
        int maxExtraPadBlocks = (255 - minPaddingSize) / blocksize;
        int actualExtraPadBlocks = this.chooseExtraPadBlocks(this.context.getSecureRandom(), maxExtraPadBlocks);
        int paddingsize = minPaddingSize + actualExtraPadBlocks * blocksize;
        int totalsize = len + this.writeMac.getSize() + paddingsize + 1;
        byte[] outbuf = new byte[totalsize];
        System.arraycopy(plaintext, offset, outbuf, 0, len);
        byte[] mac = this.writeMac.calculateMac(type, plaintext, offset, len);
        System.arraycopy(mac, 0, outbuf, len, mac.length);
        int paddoffset = len + mac.length;
        int i = 0;
        while (i <= paddingsize) {
            outbuf[i + paddoffset] = (byte)paddingsize;
            ++i;
        }
        i = 0;
        while (i < totalsize) {
            this.encryptCipher.processBlock(outbuf, i, outbuf, i);
            i += blocksize;
        }
        return outbuf;
    }

    @Override
    public byte[] decodeCiphertext(short type, byte[] ciphertext, int offset, int len) throws IOException {
        int minLength = this.readMac.getSize() + 1;
        int blocksize = this.decryptCipher.getBlockSize();
        boolean decrypterror = false;
        if (len < minLength) {
            throw new TlsFatalAlert(50);
        }
        if (len % blocksize != 0) {
            throw new TlsFatalAlert(21);
        }
        int i = 0;
        while (i < len) {
            this.decryptCipher.processBlock(ciphertext, i + offset, ciphertext, i + offset);
            i += blocksize;
        }
        int lastByteOffset = offset + len - 1;
        byte paddingsizebyte = ciphertext[lastByteOffset];
        int paddingsize = paddingsizebyte & 0xFF;
        int maxPaddingSize = len - minLength;
        if (paddingsize > maxPaddingSize) {
            decrypterror = true;
            paddingsize = 0;
        } else {
            int diff = 0;
            int i2 = lastByteOffset - paddingsize;
            while (i2 < lastByteOffset) {
                diff = (byte)(diff | ciphertext[i2] ^ paddingsizebyte);
                ++i2;
            }
            if (diff != 0) {
                decrypterror = true;
                paddingsize = 0;
            }
        }
        int plaintextlength = len - minLength - paddingsize;
        byte[] calculatedMac = this.readMac.calculateMac(type, ciphertext, offset, plaintextlength);
        byte[] decryptedMac = new byte[calculatedMac.length];
        System.arraycopy(ciphertext, offset + plaintextlength, decryptedMac, 0, calculatedMac.length);
        if (!Arrays.constantTimeAreEqual(calculatedMac, decryptedMac)) {
            decrypterror = true;
        }
        if (decrypterror) {
            throw new TlsFatalAlert(20);
        }
        byte[] plaintext = new byte[plaintextlength];
        System.arraycopy(ciphertext, offset, plaintext, 0, plaintextlength);
        return plaintext;
    }

    protected int chooseExtraPadBlocks(SecureRandom r, int max) {
        int x = r.nextInt();
        int n = this.lowestBitSet(x);
        return Math.min(n, max);
    }

    protected int lowestBitSet(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 0;
        while ((x & 1) == 0) {
            ++n;
            x >>= 1;
        }
        return n;
    }
}

