/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import repack.org.bouncycastle.crypto.tls.CombinedHash;
import repack.org.bouncycastle.crypto.tls.TlsCipher;
import repack.org.bouncycastle.crypto.tls.TlsCompression;
import repack.org.bouncycastle.crypto.tls.TlsNullCipher;
import repack.org.bouncycastle.crypto.tls.TlsNullCompression;
import repack.org.bouncycastle.crypto.tls.TlsProtocolHandler;
import repack.org.bouncycastle.crypto.tls.TlsUtils;

class RecordStream {
    private TlsProtocolHandler handler;
    private InputStream is;
    private OutputStream os;
    private CombinedHash hash;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    RecordStream(TlsProtocolHandler handler, InputStream is, OutputStream os) {
        this.handler = handler;
        this.is = is;
        this.os = os;
        this.hash = new CombinedHash();
        this.writeCompression = this.readCompression = new TlsNullCompression();
        this.writeCipher = this.readCipher = new TlsNullCipher();
    }

    void clientCipherSpecDecided(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.writeCompression = tlsCompression;
        this.writeCipher = tlsCipher;
    }

    void serverClientSpecReceived() {
        this.readCompression = this.writeCompression;
        this.readCipher = this.writeCipher;
    }

    public void readData() throws IOException {
        short type = TlsUtils.readUint8(this.is);
        TlsUtils.checkVersion(this.is, this.handler);
        int size = TlsUtils.readUint16(this.is);
        byte[] buf = this.decodeAndVerify(type, this.is, size);
        this.handler.processData(type, buf, 0, buf.length);
    }

    protected byte[] decodeAndVerify(short type, InputStream is, int len) throws IOException {
        byte[] buf = new byte[len];
        TlsUtils.readFully(buf, is);
        byte[] decoded = this.readCipher.decodeCiphertext(type, buf, 0, buf.length);
        OutputStream cOut = this.readCompression.decompress(this.buffer);
        if (cOut == this.buffer) {
            return decoded;
        }
        cOut.write(decoded, 0, decoded.length);
        cOut.flush();
        return this.getBufferContents();
    }

    protected void writeMessage(short type, byte[] message, int offset, int len) throws IOException {
        byte[] ciphertext;
        OutputStream cOut;
        if (type == 22) {
            this.updateHandshakeData(message, offset, len);
        }
        if ((cOut = this.writeCompression.compress(this.buffer)) == this.buffer) {
            ciphertext = this.writeCipher.encodePlaintext(type, message, offset, len);
        } else {
            cOut.write(message, offset, len);
            cOut.flush();
            byte[] compressed = this.getBufferContents();
            ciphertext = this.writeCipher.encodePlaintext(type, compressed, 0, compressed.length);
        }
        byte[] writeMessage = new byte[ciphertext.length + 5];
        TlsUtils.writeUint8(type, writeMessage, 0);
        TlsUtils.writeVersion(writeMessage, 1);
        TlsUtils.writeUint16(ciphertext.length, writeMessage, 3);
        System.arraycopy(ciphertext, 0, writeMessage, 5, ciphertext.length);
        this.os.write(writeMessage);
        this.os.flush();
    }

    void updateHandshakeData(byte[] message, int offset, int len) {
        this.hash.update(message, offset, len);
    }

    byte[] getCurrentHash() {
        return RecordStream.doFinal(new CombinedHash(this.hash));
    }

    protected void close() throws IOException {
        IOException e = null;
        try {
            this.is.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        if (e != null) {
            throw e;
        }
    }

    protected void flush() throws IOException {
        this.os.flush();
    }

    private byte[] getBufferContents() {
        byte[] contents = this.buffer.toByteArray();
        this.buffer.reset();
        return contents;
    }

    private static byte[] doFinal(CombinedHash ch) {
        byte[] bs = new byte[ch.getDigestSize()];
        ch.doFinal(bs, 0);
        return bs;
    }
}

