/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.crypto.macs;

import repack.org.bouncycastle.crypto.CipherParameters;
import repack.org.bouncycastle.crypto.DataLengthException;
import repack.org.bouncycastle.crypto.Mac;
import repack.org.bouncycastle.crypto.params.KeyParameter;
import repack.org.bouncycastle.crypto.params.ParametersWithSBox;

public class GOST28147Mac
implements Mac {
    private int blockSize = 8;
    private int macSize = 4;
    private int bufOff;
    private byte[] buf;
    private byte[] mac;
    private boolean firstStep = true;
    private int[] workingKey = null;
    private byte[] S;

    public GOST28147Mac() {
        byte[] byArray = new byte[128];
        byArray[0] = 9;
        byArray[1] = 6;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 8;
        byArray[5] = 11;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[8] = 10;
        byArray[9] = 4;
        byArray[10] = 14;
        byArray[11] = 15;
        byArray[12] = 12;
        byArray[14] = 13;
        byArray[15] = 5;
        byArray[16] = 3;
        byArray[17] = 7;
        byArray[18] = 14;
        byArray[19] = 9;
        byArray[20] = 8;
        byArray[21] = 10;
        byArray[22] = 15;
        byArray[24] = 5;
        byArray[25] = 2;
        byArray[26] = 6;
        byArray[27] = 12;
        byArray[28] = 11;
        byArray[29] = 4;
        byArray[30] = 13;
        byArray[31] = 1;
        byArray[32] = 14;
        byArray[33] = 4;
        byArray[34] = 6;
        byArray[35] = 2;
        byArray[36] = 11;
        byArray[37] = 3;
        byArray[38] = 13;
        byArray[39] = 8;
        byArray[40] = 12;
        byArray[41] = 15;
        byArray[42] = 5;
        byArray[43] = 10;
        byArray[45] = 7;
        byArray[46] = 1;
        byArray[47] = 9;
        byArray[48] = 14;
        byArray[49] = 7;
        byArray[50] = 10;
        byArray[51] = 12;
        byArray[52] = 13;
        byArray[53] = 1;
        byArray[54] = 3;
        byArray[55] = 9;
        byArray[57] = 2;
        byArray[58] = 11;
        byArray[59] = 4;
        byArray[60] = 15;
        byArray[61] = 8;
        byArray[62] = 5;
        byArray[63] = 6;
        byArray[64] = 11;
        byArray[65] = 5;
        byArray[66] = 1;
        byArray[67] = 9;
        byArray[68] = 8;
        byArray[69] = 13;
        byArray[70] = 15;
        byArray[72] = 14;
        byArray[73] = 4;
        byArray[74] = 2;
        byArray[75] = 3;
        byArray[76] = 12;
        byArray[77] = 7;
        byArray[78] = 10;
        byArray[79] = 6;
        byArray[80] = 3;
        byArray[81] = 10;
        byArray[82] = 13;
        byArray[83] = 12;
        byArray[84] = 1;
        byArray[85] = 2;
        byArray[87] = 11;
        byArray[88] = 7;
        byArray[89] = 5;
        byArray[90] = 9;
        byArray[91] = 4;
        byArray[92] = 8;
        byArray[93] = 15;
        byArray[94] = 14;
        byArray[95] = 6;
        byArray[96] = 1;
        byArray[97] = 13;
        byArray[98] = 2;
        byArray[99] = 9;
        byArray[100] = 7;
        byArray[101] = 10;
        byArray[102] = 6;
        byArray[104] = 8;
        byArray[105] = 12;
        byArray[106] = 4;
        byArray[107] = 5;
        byArray[108] = 15;
        byArray[109] = 3;
        byArray[110] = 11;
        byArray[111] = 14;
        byArray[112] = 11;
        byArray[113] = 10;
        byArray[114] = 15;
        byArray[115] = 5;
        byArray[117] = 12;
        byArray[118] = 14;
        byArray[119] = 8;
        byArray[120] = 6;
        byArray[121] = 2;
        byArray[122] = 3;
        byArray[123] = 9;
        byArray[124] = 1;
        byArray[125] = 7;
        byArray[126] = 13;
        byArray[127] = 4;
        this.S = byArray;
        this.mac = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
        this.bufOff = 0;
    }

    private int[] generateWorkingKey(byte[] userKey) {
        if (userKey.length != 32) {
            throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
        }
        int[] key = new int[8];
        int i = 0;
        while (i != 8) {
            key[i] = this.bytesToint(userKey, i * 4);
            ++i;
        }
        return key;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        this.reset();
        this.buf = new byte[this.blockSize];
        if (params instanceof ParametersWithSBox) {
            ParametersWithSBox param = (ParametersWithSBox)params;
            System.arraycopy(param.getSBox(), 0, this.S, 0, param.getSBox().length);
            if (param.getParameters() != null) {
                this.workingKey = this.generateWorkingKey(((KeyParameter)param.getParameters()).getKey());
            }
        } else if (params instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(((KeyParameter)params).getKey());
        } else {
            throw new IllegalArgumentException("invalid parameter passed to GOST28147 init - " + params.getClass().getName());
        }
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Mac";
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    private int gost28147_mainStep(int n1, int key) {
        int cm = key + n1;
        int om = this.S[0 + (cm >> 0 & 0xF)] << 0;
        om += this.S[16 + (cm >> 4 & 0xF)] << 4;
        om += this.S[32 + (cm >> 8 & 0xF)] << 8;
        om += this.S[48 + (cm >> 12 & 0xF)] << 12;
        om += this.S[64 + (cm >> 16 & 0xF)] << 16;
        om += this.S[80 + (cm >> 20 & 0xF)] << 20;
        om += this.S[96 + (cm >> 24 & 0xF)] << 24;
        return (om += this.S[112 + (cm >> 28 & 0xF)] << 28) << 11 | om >>> 21;
    }

    private void gost28147MacFunc(int[] workingKey, byte[] in, int inOff, byte[] out, int outOff) {
        int N1 = this.bytesToint(in, inOff);
        int N2 = this.bytesToint(in, inOff + 4);
        int k = 0;
        while (k < 2) {
            int j = 0;
            while (j < 8) {
                int tmp = N1;
                N1 = N2 ^ this.gost28147_mainStep(N1, workingKey[j]);
                N2 = tmp;
                ++j;
            }
            ++k;
        }
        this.intTobytes(N1, out, outOff);
        this.intTobytes(N2, out, outOff + 4);
    }

    private int bytesToint(byte[] in, int inOff) {
        return (in[inOff + 3] << 24 & 0xFF000000) + (in[inOff + 2] << 16 & 0xFF0000) + (in[inOff + 1] << 8 & 0xFF00) + (in[inOff] & 0xFF);
    }

    private void intTobytes(int num, byte[] out, int outOff) {
        out[outOff + 3] = (byte)(num >>> 24);
        out[outOff + 2] = (byte)(num >>> 16);
        out[outOff + 1] = (byte)(num >>> 8);
        out[outOff] = (byte)num;
    }

    private byte[] CM5func(byte[] buf, int bufOff, byte[] mac) {
        byte[] sum = new byte[buf.length - bufOff];
        System.arraycopy(buf, bufOff, sum, 0, mac.length);
        int i = 0;
        while (i != mac.length) {
            sum[i] = (byte)(sum[i] ^ mac[i]);
            ++i;
        }
        return sum;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        if (this.bufOff == this.buf.length) {
            byte[] sumbuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, sumbuf, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
            } else {
                sumbuf = this.CM5func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(this.workingKey, sumbuf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int gapLen = this.blockSize - this.bufOff;
        if (len > gapLen) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, gapLen);
            byte[] sumbuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, sumbuf, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
            } else {
                sumbuf = this.CM5func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(this.workingKey, sumbuf, 0, this.mac, 0);
            this.bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            while (len > this.blockSize) {
                sumbuf = this.CM5func(in, inOff, this.mac);
                this.gost28147MacFunc(this.workingKey, sumbuf, 0, this.mac, 0);
                len -= this.blockSize;
                inOff += this.blockSize;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        while (this.bufOff < this.blockSize) {
            this.buf[this.bufOff] = 0;
            ++this.bufOff;
        }
        byte[] sumbuf = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, sumbuf, 0, this.mac.length);
        if (this.firstStep) {
            this.firstStep = false;
        } else {
            sumbuf = this.CM5func(this.buf, 0, this.mac);
        }
        this.gost28147MacFunc(this.workingKey, sumbuf, 0, this.mac, 0);
        System.arraycopy(this.mac, this.mac.length / 2 - this.macSize, out, outOff, this.macSize);
        this.reset();
        return this.macSize;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = 0;
            ++i;
        }
        this.bufOff = 0;
        this.firstStep = true;
    }
}

