/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms.jcajce;

import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import repack.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import repack.org.bouncycastle.jcajce.NamedJcaJceHelper;
import repack.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import repack.org.bouncycastle.jcajce.io.MacOutputStream;
import repack.org.bouncycastle.operator.GenericKey;
import repack.org.bouncycastle.operator.MacCalculator;

public class JceCMSMacCalculatorBuilder {
    private final ASN1ObjectIdentifier macOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private MacOutputStream macOutputStream;

    public JceCMSMacCalculatorBuilder(ASN1ObjectIdentifier macOID) {
        this(macOID, -1);
    }

    public JceCMSMacCalculatorBuilder(ASN1ObjectIdentifier macOID, int keySize) {
        this.macOID = macOID;
        this.keySize = keySize;
    }

    public JceCMSMacCalculatorBuilder setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceCMSMacCalculatorBuilder setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceCMSMacCalculatorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public MacCalculator build() throws CMSException {
        return new CMSOutputEncryptor(this.macOID, this.keySize, this.random);
    }

    private class CMSOutputEncryptor
    implements MacCalculator {
        private SecretKey encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Mac mac;
        private SecureRandom random;

        CMSOutputEncryptor(ASN1ObjectIdentifier macOID, int keySize, SecureRandom random) throws CMSException {
            KeyGenerator keyGen = JceCMSMacCalculatorBuilder.this.helper.createKeyGenerator(macOID);
            if (random == null) {
                random = new SecureRandom();
            }
            this.random = random;
            if (keySize < 0) {
                keyGen.init(random);
            } else {
                keyGen.init(keySize, random);
            }
            this.encKey = keyGen.generateKey();
            AlgorithmParameterSpec paramSpec = this.generateParameterSpec(macOID, this.encKey);
            this.algorithmIdentifier = JceCMSMacCalculatorBuilder.this.helper.getAlgorithmIdentifier(macOID, paramSpec);
            this.mac = JceCMSMacCalculatorBuilder.this.helper.createContentMac(this.encKey, this.algorithmIdentifier);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        @Override
        public OutputStream getOutputStream() {
            return new MacOutputStream(this.mac);
        }

        @Override
        public byte[] getMac() {
            return this.mac.doFinal();
        }

        @Override
        public GenericKey getKey() {
            return new GenericKey(this.encKey);
        }

        protected AlgorithmParameterSpec generateParameterSpec(ASN1ObjectIdentifier macOID, SecretKey encKey) throws CMSException {
            try {
                if (macOID.equals(PKCSObjectIdentifiers.RC2_CBC)) {
                    byte[] iv = new byte[8];
                    this.random.nextBytes(iv);
                    return new RC2ParameterSpec(encKey.getEncoded().length * 8, iv);
                }
                AlgorithmParameterGenerator pGen = JceCMSMacCalculatorBuilder.this.helper.createAlgorithmParameterGenerator(macOID);
                AlgorithmParameters p = pGen.generateParameters();
                return p.getParameterSpec(IvParameterSpec.class);
            }
            catch (GeneralSecurityException e) {
                return null;
            }
        }
    }
}

