/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Generator;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.ASN1OctetStringParser;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.ASN1SequenceParser;
import repack.org.bouncycastle.asn1.ASN1Set;
import repack.org.bouncycastle.asn1.ASN1SetParser;
import repack.org.bouncycastle.asn1.ASN1StreamParser;
import repack.org.bouncycastle.asn1.ASN1TaggedObject;
import repack.org.bouncycastle.asn1.BERSequenceGenerator;
import repack.org.bouncycastle.asn1.BERSetParser;
import repack.org.bouncycastle.asn1.BERTaggedObject;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSet;
import repack.org.bouncycastle.asn1.DERTaggedObject;
import repack.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import repack.org.bouncycastle.asn1.cms.ContentInfoParser;
import repack.org.bouncycastle.asn1.cms.SignedDataParser;
import repack.org.bouncycastle.asn1.cms.SignerInfo;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.AttributeCertificate;
import repack.org.bouncycastle.asn1.x509.CertificateList;
import repack.org.bouncycastle.asn1.x509.X509CertificateStructure;
import repack.org.bouncycastle.cert.X509AttributeCertificateHolder;
import repack.org.bouncycastle.cert.X509CRLHolder;
import repack.org.bouncycastle.cert.X509CertificateHolder;
import repack.org.bouncycastle.cms.BaseDigestCalculator;
import repack.org.bouncycastle.cms.CMSContentInfoParser;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.CMSSignedHelper;
import repack.org.bouncycastle.cms.CMSTypedStream;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.SignerInformation;
import repack.org.bouncycastle.cms.SignerInformationStore;
import repack.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import repack.org.bouncycastle.util.CollectionStore;
import repack.org.bouncycastle.util.Store;
import repack.org.bouncycastle.util.io.Streams;
import repack.org.bouncycastle.x509.NoSuchStoreException;
import repack.org.bouncycastle.x509.X509Store;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private ASN1ObjectIdentifier _signedContentType;
    private CMSTypedStream _signedContent;
    private Map _digests;
    private CertStore _certStore;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] sigBlock) throws CMSException {
        this(new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(InputStream sigData) throws CMSException {
        this(null, sigData);
    }

    public CMSSignedDataParser(CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        super(sigData);
        try {
            DEREncodable o;
            this._signedContent = signedContent;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this._digests = new HashMap();
            ASN1SetParser digAlgs = this._signedData.getDigestAlgorithms();
            while ((o = digAlgs.readObject()) != null) {
                AlgorithmIdentifier id = AlgorithmIdentifier.getInstance(o.getDERObject());
                try {
                    String digestName = HELPER.getDigestAlgName(id.getObjectId().toString());
                    MessageDigest dig = HELPER.getDigestInstance(digestName, null);
                    this._digests.put(digestName, dig);
                }
                catch (NoSuchAlgorithmException digestName) {
                    // empty catch block
                }
            }
            ContentInfoParser cont = this._signedData.getEncapContentInfo();
            ASN1OctetStringParser octs = (ASN1OctetStringParser)cont.getContent(4);
            if (octs != null) {
                CMSTypedStream ctStr = new CMSTypedStream(cont.getContentType().getId(), octs.getOctetStream());
                if (this._signedContent == null) {
                    this._signedContent = ctStr;
                } else {
                    ctStr.drain();
                }
            }
            this._signedContentType = signedContent == null ? cont.getContentType() : this._signedContent.getContentType();
        }
        catch (IOException e) {
            throw new CMSException("io exception: " + e.getMessage(), e);
        }
        if (this._digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            HashMap hashes = new HashMap();
            for (Object digestKey : this._digests.keySet()) {
                hashes.put(digestKey, ((MessageDigest)this._digests.get(digestKey)).digest());
            }
            try {
                DEREncodable o;
                ASN1SetParser s = this._signedData.getSignerInfos();
                DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
                while ((o = s.readObject()) != null) {
                    SignerInfo info = SignerInfo.getInstance(o.getDERObject());
                    String digestName = HELPER.getDigestAlgName(info.getDigestAlgorithm().getAlgorithm().getId());
                    byte[] hash = (byte[])hashes.get(digestName);
                    signerInfos.add(new SignerInformation(info, this._signedContentType, null, new BaseDigestCalculator(hash), sigAlgFinder));
                }
            }
            catch (IOException e) {
                throw new CMSException("io exception: " + e.getMessage(), e);
            }
            this._signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getAttributeCertificates(type, CMSUtils.getProvider(provider));
    }

    public X509Store getAttributeCertificates(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.createAttributeStore(type, provider, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCertificates(type, CMSUtils.getProvider(provider));
    }

    public X509Store getCertificates(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.createCertificateStore(type, provider, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCRLs(type, CMSUtils.getProvider(provider));
    }

    public X509Store getCRLs(String type, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.createCRLsStore(type, provider, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.getCertificatesAndCRLs(type, CMSUtils.getProvider(provider));
    }

    public CertStore getCertificatesAndCRLs(String type, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.populateCertCrlSets();
        return HELPER.createCertStore(type, provider, this._certSet, this._crlSet);
    }

    public Store getCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set certSet = this._certSet;
        if (certSet != null) {
            ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>(certSet.size());
            Enumeration en = certSet.getObjects();
            while (en.hasMoreElements()) {
                DERObject obj = ((DEREncodable)en.nextElement()).getDERObject();
                if (!(obj instanceof ASN1Sequence)) continue;
                certList.add(new X509CertificateHolder(X509CertificateStructure.getInstance(obj)));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set crlSet = this._crlSet;
        if (crlSet != null) {
            ArrayList<X509CRLHolder> crlList = new ArrayList<X509CRLHolder>(crlSet.size());
            Enumeration en = crlSet.getObjects();
            while (en.hasMoreElements()) {
                DERObject obj = ((DEREncodable)en.nextElement()).getDERObject();
                if (!(obj instanceof ASN1Sequence)) continue;
                crlList.add(new X509CRLHolder(CertificateList.getInstance(obj)));
            }
            return new CollectionStore(crlList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getAttributeCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set certSet = this._certSet;
        if (certSet != null) {
            ArrayList<X509AttributeCertificateHolder> certList = new ArrayList<X509AttributeCertificateHolder>(certSet.size());
            Enumeration en = certSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1TaggedObject tagged;
                DERObject obj = ((DEREncodable)en.nextElement()).getDERObject();
                if (!(obj instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)obj).getTagNo() != 2) continue;
                certList.add(new X509AttributeCertificateHolder(AttributeCertificate.getInstance(ASN1Sequence.getInstance(tagged, false))));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            this._certSet = CMSSignedDataParser.getASN1Set(this._signedData.getCertificates());
            this._crlSet = CMSSignedDataParser.getASN1Set(this._signedData.getCrls());
        }
        catch (IOException e) {
            throw new CMSException("problem parsing cert/crl sets", e);
        }
    }

    public String getSignedContentTypeOID() {
        return this._signedContentType.getId();
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent == null) {
            return null;
        }
        InputStream digStream = CMSUtils.attachDigestsToInputStream(this._digests.values(), this._signedContent.getContentStream());
        return new CMSTypedStream(this._signedContent.getContentType(), digStream);
    }

    public static OutputStream replaceSigners(InputStream original, SignerInformationStore signerInformationStore, OutputStream out) throws CMSException, IOException {
        ASN1StreamParser in = new ASN1StreamParser(original, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        signedData.getDigestAlgorithms().getDERObject();
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.writeSetToGeneratorTagged(sigGen, signedData.getCertificates(), 0);
        CMSSignedDataParser.writeSetToGeneratorTagged(sigGen, signedData.getCrls(), 1);
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            signerInfos.add(signer.toSignerInfo());
        }
        sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, CertStore certsAndCrls, OutputStream out) throws CMSException, IOException {
        ASN1Set crls;
        ASN1Set certs;
        ASN1StreamParser in = new ASN1StreamParser(original, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().getDERObject().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        try {
            certs = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting certs from certStore", e);
        }
        if (certs.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, certs).getEncoded());
        }
        try {
            crls = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certsAndCrls));
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting crls from certStore", e);
        }
        if (crls.size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().getDERObject().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, Store certs, Store crls, Store attrCerts, OutputStream out) throws CMSException, IOException {
        ASN1Set asn1Crls;
        ASN1StreamParser in = new ASN1StreamParser(original, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().getDERObject().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        if (certs != null || attrCerts != null) {
            ASN1Set asn1Certs;
            ArrayList certificates = new ArrayList();
            if (certs != null) {
                certificates.addAll(CMSUtils.getCertificatesFromStore(certs));
            }
            if (attrCerts != null) {
                certificates.addAll(CMSUtils.getAttributeCertificatesFromStore(attrCerts));
            }
            if ((asn1Certs = CMSUtils.createBerSetFromList(certificates)).size() > 0) {
                sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, asn1Certs).getEncoded());
            }
        }
        if (crls != null && (asn1Crls = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(crls))).size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, asn1Crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().getDERObject().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    private static void writeSetToGeneratorTagged(ASN1Generator asn1Gen, ASN1SetParser asn1SetParser, int tagNo) throws IOException {
        ASN1Set asn1Set = CMSSignedDataParser.getASN1Set(asn1SetParser);
        if (asn1Set != null) {
            DERTaggedObject taggedObj = asn1SetParser instanceof BERSetParser ? new BERTaggedObject(false, tagNo, asn1Set) : new DERTaggedObject(false, tagNo, asn1Set);
            asn1Gen.getRawOutputStream().write(taggedObj.getEncoded());
        }
    }

    private static ASN1Set getASN1Set(ASN1SetParser asn1SetParser) {
        return asn1SetParser == null ? null : ASN1Set.getInstance(asn1SetParser.getDERObject());
    }

    private static void pipeEncapsulatedOctetString(ContentInfoParser encapContentInfo, OutputStream rawOutputStream) throws IOException {
        ASN1OctetStringParser octs = (ASN1OctetStringParser)encapContentInfo.getContent(4);
        if (octs != null) {
            CMSSignedDataParser.pipeOctetString(octs, rawOutputStream);
        }
    }

    private static void pipeOctetString(ASN1OctetStringParser octs, OutputStream output) throws IOException {
        OutputStream outOctets = CMSUtils.createBEROctetOutputStream(output, 0, true, 0);
        Streams.pipeAll(octs.getOctetStream(), outOctets);
        outOctets.close();
    }
}

