/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.security.Provider;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1OctetStringParser;
import repack.org.bouncycastle.asn1.ASN1SequenceParser;
import repack.org.bouncycastle.asn1.ASN1Set;
import repack.org.bouncycastle.asn1.ASN1SetParser;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERSet;
import repack.org.bouncycastle.asn1.cms.AttributeTable;
import repack.org.bouncycastle.asn1.cms.EncryptedContentInfoParser;
import repack.org.bouncycastle.asn1.cms.EnvelopedDataParser;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.cms.CMSContentInfoParser;
import repack.org.bouncycastle.cms.CMSEnvelopedHelper;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.CMSProcessableInputStream;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.RecipientInformationStore;

public class CMSEnvelopedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore _recipientInfoStore;
    EnvelopedDataParser _envelopedData = new EnvelopedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier _encAlg;
    private AttributeTable _unprotectedAttributes;
    private boolean _attrNotRead = true;

    public CMSEnvelopedDataParser(byte[] envelopedData) throws CMSException, IOException {
        this(new ByteArrayInputStream(envelopedData));
    }

    public CMSEnvelopedDataParser(InputStream envelopedData) throws CMSException, IOException {
        super(envelopedData);
        ASN1Set recipientInfos = ASN1Set.getInstance(this._envelopedData.getRecipientInfos().getDERObject());
        EncryptedContentInfoParser encInfo = this._envelopedData.getEncryptedContentInfo();
        this._encAlg = encInfo.getContentEncryptionAlgorithm();
        CMSProcessableInputStream readable = new CMSProcessableInputStream(((ASN1OctetStringParser)encInfo.getEncryptedContent(4)).getOctetStream());
        CMSEnvelopedHelper.CMSEnvelopedSecureReadable secureReadable = new CMSEnvelopedHelper.CMSEnvelopedSecureReadable(this._encAlg, readable);
        this._recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this._encAlg, secureReadable);
    }

    public String getEncryptionAlgOID() {
        return this._encAlg.getObjectId().toString();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this._encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return this.getEncryptionAlgorithmParameters(CMSUtils.getProvider(provider));
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(Provider provider) throws CMSException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this._recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() throws IOException {
        if (this._unprotectedAttributes == null && this._attrNotRead) {
            ASN1SetParser set = this._envelopedData.getUnprotectedAttrs();
            this._attrNotRead = false;
            if (set != null) {
                DEREncodable o;
                ASN1EncodableVector v = new ASN1EncodableVector();
                while ((o = set.readObject()) != null) {
                    ASN1SequenceParser seq = (ASN1SequenceParser)o;
                    v.add(seq.getDERObject());
                }
                this._unprotectedAttributes = new AttributeTable(new DERSet(v));
            }
        }
        return this._unprotectedAttributes;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            return obj.getDERObject().getEncoded();
        }
        return null;
    }
}

