/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert.crmf;

import repack.org.bouncycastle.asn1.DERBitString;
import repack.org.bouncycastle.asn1.crmf.PKMACValue;
import repack.org.bouncycastle.asn1.crmf.POPOSigningKey;
import repack.org.bouncycastle.asn1.crmf.POPOSigningKeyInput;
import repack.org.bouncycastle.asn1.x509.GeneralName;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.cert.crmf.CRMFException;
import repack.org.bouncycastle.cert.crmf.CRMFUtil;
import repack.org.bouncycastle.cert.crmf.PKMACValueGenerator;
import repack.org.bouncycastle.operator.ContentSigner;

public class ProofOfPossessionSigningKeyBuilder {
    private SubjectPublicKeyInfo pubKeyInfo;
    private GeneralName name;
    private PKMACValue publicKeyMAC;

    public ProofOfPossessionSigningKeyBuilder(SubjectPublicKeyInfo pubKeyInfo) {
        this.pubKeyInfo = pubKeyInfo;
    }

    public ProofOfPossessionSigningKeyBuilder setSender(GeneralName name) {
        this.name = name;
        return this;
    }

    public ProofOfPossessionSigningKeyBuilder setPublicKeyMac(PKMACValueGenerator generator, char[] password) throws CRMFException {
        this.publicKeyMAC = generator.generate(password, this.pubKeyInfo);
        return this;
    }

    public POPOSigningKey build(ContentSigner signer) {
        if (this.name != null && this.publicKeyMAC != null) {
            throw new IllegalStateException("name and publicKeyMAC cannot both be set.");
        }
        POPOSigningKeyInput popo = this.name != null ? new POPOSigningKeyInput(this.name, this.pubKeyInfo) : new POPOSigningKeyInput(this.publicKeyMAC, this.pubKeyInfo);
        CRMFUtil.derEncodeToStream(popo, signer.getOutputStream());
        return new POPOSigningKey(popo, signer.getAlgorithmIdentifier(), new DERBitString(signer.getSignature()));
    }
}

