/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert.crmf;

import java.io.IOException;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.DERUTF8String;
import repack.org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import repack.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import repack.org.bouncycastle.asn1.crmf.CertReqMsg;
import repack.org.bouncycastle.asn1.crmf.CertTemplate;
import repack.org.bouncycastle.asn1.crmf.Controls;
import repack.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import repack.org.bouncycastle.asn1.crmf.PKMACValue;
import repack.org.bouncycastle.asn1.crmf.POPOSigningKey;
import repack.org.bouncycastle.asn1.crmf.ProofOfPossession;
import repack.org.bouncycastle.cert.CertIOException;
import repack.org.bouncycastle.cert.crmf.AuthenticatorControl;
import repack.org.bouncycastle.cert.crmf.CRMFException;
import repack.org.bouncycastle.cert.crmf.CRMFUtil;
import repack.org.bouncycastle.cert.crmf.Control;
import repack.org.bouncycastle.cert.crmf.PKIArchiveControl;
import repack.org.bouncycastle.cert.crmf.PKMACBuilder;
import repack.org.bouncycastle.cert.crmf.PKMACValueVerifier;
import repack.org.bouncycastle.cert.crmf.RegTokenControl;
import repack.org.bouncycastle.operator.ContentVerifier;
import repack.org.bouncycastle.operator.ContentVerifierProvider;
import repack.org.bouncycastle.operator.OperatorCreationException;

public class CertificateRequestMessage {
    public static final int popRaVerified = 0;
    public static final int popSigningKey = 1;
    public static final int popKeyEncipherment = 2;
    public static final int popKeyAgreement = 3;
    private final CertReqMsg certReqMsg;
    private final Controls controls;

    private static CertReqMsg parseBytes(byte[] encoding) throws IOException {
        try {
            return CertReqMsg.getInstance(ASN1Object.fromByteArray(encoding));
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public CertificateRequestMessage(byte[] certReqMsg) throws IOException {
        this(CertificateRequestMessage.parseBytes(certReqMsg));
    }

    public CertificateRequestMessage(CertReqMsg certReqMsg) {
        this.certReqMsg = certReqMsg;
        this.controls = certReqMsg.getCertReq().getControls();
    }

    public CertReqMsg toASN1Structure() {
        return this.certReqMsg;
    }

    public CertTemplate getCertTemplate() {
        return this.certReqMsg.getCertReq().getCertTemplate();
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public boolean hasControl(ASN1ObjectIdentifier type) {
        return this.findControl(type) != null;
    }

    public Control getControl(ASN1ObjectIdentifier type) {
        AttributeTypeAndValue found = this.findControl(type);
        if (found != null) {
            if (found.getType().equals(CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions)) {
                return new PKIArchiveControl(PKIArchiveOptions.getInstance(found.getValue()));
            }
            if (found.getType().equals(CRMFObjectIdentifiers.id_regCtrl_regToken)) {
                return new RegTokenControl(DERUTF8String.getInstance(found.getValue()));
            }
            if (found.getType().equals(CRMFObjectIdentifiers.id_regCtrl_authenticator)) {
                return new AuthenticatorControl(DERUTF8String.getInstance(found.getValue()));
            }
        }
        return null;
    }

    private AttributeTypeAndValue findControl(ASN1ObjectIdentifier type) {
        if (this.controls == null) {
            return null;
        }
        AttributeTypeAndValue[] tAndVs = this.controls.toAttributeTypeAndValueArray();
        AttributeTypeAndValue found = null;
        int i = 0;
        while (i != tAndVs.length) {
            if (tAndVs[i].getType().equals(type)) {
                found = tAndVs[i];
                break;
            }
            ++i;
        }
        return found;
    }

    public boolean hasProofOfPossession() {
        return this.certReqMsg.getPopo() != null;
    }

    public int getProofOfPossessionType() {
        return this.certReqMsg.getPopo().getType();
    }

    public boolean hasSigningKeyProofOfPossessionWithPKMAC() {
        ProofOfPossession pop = this.certReqMsg.getPopo();
        if (pop.getType() == 1) {
            POPOSigningKey popoSign = POPOSigningKey.getInstance(pop.getObject());
            return popoSign.getPoposkInput().getPublicKeyMAC() != null;
        }
        return false;
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider verifierProvider) throws CRMFException, IllegalStateException {
        ProofOfPossession pop = this.certReqMsg.getPopo();
        if (pop.getType() == 1) {
            POPOSigningKey popoSign = POPOSigningKey.getInstance(pop.getObject());
            if (popoSign.getPoposkInput().getPublicKeyMAC() != null) {
                throw new IllegalStateException("verification requires password check");
            }
            return this.verifySignature(verifierProvider, popoSign);
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider verifierProvider, PKMACBuilder macBuilder, char[] password) throws CRMFException, IllegalStateException {
        ProofOfPossession pop = this.certReqMsg.getPopo();
        if (pop.getType() == 1) {
            POPOSigningKey popoSign = POPOSigningKey.getInstance(pop.getObject());
            if (popoSign.getPoposkInput().getSender() != null) {
                throw new IllegalStateException("no PKMAC present in proof of possession");
            }
            PKMACValueVerifier macVerifier = new PKMACValueVerifier(macBuilder);
            PKMACValue pkMAC = popoSign.getPoposkInput().getPublicKeyMAC();
            if (macVerifier.isValid(pkMAC, password, this.getCertTemplate().getPublicKey())) {
                return this.verifySignature(verifierProvider, popoSign);
            }
            return false;
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    private boolean verifySignature(ContentVerifierProvider verifierProvider, POPOSigningKey popoSign) throws CRMFException {
        ContentVerifier verifier;
        try {
            verifier = verifierProvider.get(popoSign.getAlgorithmIdentifier());
        }
        catch (OperatorCreationException e) {
            throw new CRMFException("unable to create verifier: " + e.getMessage(), e);
        }
        CRMFUtil.derEncodeToStream(popoSign.getPoposkInput(), verifier.getOutputStream());
        return verifier.verify(popoSign.getSignature().getBytes());
    }

    public byte[] getEncoded() throws IOException {
        return this.certReqMsg.getEncoded();
    }
}

