/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert.cmp;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.cmp.CertConfirmContent;
import repack.org.bouncycastle.asn1.cmp.CertStatus;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.cert.X509CertificateHolder;
import repack.org.bouncycastle.cert.cmp.CMPException;
import repack.org.bouncycastle.cert.cmp.CMPUtil;
import repack.org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import repack.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import repack.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import repack.org.bouncycastle.operator.DigestCalculator;
import repack.org.bouncycastle.operator.DigestCalculatorProvider;
import repack.org.bouncycastle.operator.OperatorCreationException;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List acceptedCerts = new ArrayList();
    private List acceptedReqIds = new ArrayList();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgFinder) {
        this.digestAlgFinder = digestAlgFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder certHolder, BigInteger certReqID) {
        this.acceptedCerts.add(certHolder);
        this.acceptedReqIds.add(certReqID);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digesterProvider) throws CMPException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i != this.acceptedCerts.size()) {
            DigestCalculator digester;
            X509CertificateHolder certHolder = (X509CertificateHolder)this.acceptedCerts.get(i);
            BigInteger reqID = (BigInteger)this.acceptedReqIds.get(i);
            AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
            if (digAlg == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digester = digesterProvider.get(digAlg);
            }
            catch (OperatorCreationException e) {
                throw new CMPException("unable to create digest: " + e.getMessage(), e);
            }
            CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
            v.add(new CertStatus(digester.getDigest(), reqID));
            ++i;
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(v)), this.digestAlgFinder);
    }
}

