/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.cms;

import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.ASN1Set;
import repack.org.bouncycastle.asn1.ASN1TaggedObject;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.DERTaggedObject;

public class OriginatorInfo
extends ASN1Encodable {
    private ASN1Set certs;
    private ASN1Set crls;

    public OriginatorInfo(ASN1Set certs, ASN1Set crls) {
        this.certs = certs;
        this.crls = crls;
    }

    public OriginatorInfo(ASN1Sequence seq) {
        block0 : switch (seq.size()) {
            case 0: {
                break;
            }
            case 1: {
                ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(0);
                switch (o.getTagNo()) {
                    case 0: {
                        this.certs = ASN1Set.getInstance(o, false);
                        break block0;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(o, false);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Bad tag in OriginatorInfo: " + o.getTagNo());
            }
            case 2: {
                this.certs = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(0), false);
                this.crls = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(1), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("OriginatorInfo too big");
            }
        }
    }

    public static OriginatorInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OriginatorInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static OriginatorInfo getInstance(Object obj) {
        if (obj == null || obj instanceof OriginatorInfo) {
            return (OriginatorInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new OriginatorInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid OriginatorInfo: " + obj.getClass().getName());
    }

    public ASN1Set getCertificates() {
        return this.certs;
    }

    public ASN1Set getCRLs() {
        return this.crls;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.certs != null) {
            v.add(new DERTaggedObject(false, 0, this.certs));
        }
        if (this.crls != null) {
            v.add(new DERTaggedObject(false, 1, this.crls));
        }
        return new DERSequence(v);
    }
}

