/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1;

import java.io.IOException;
import repack.org.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import repack.org.bouncycastle.asn1.ASN1ParsingException;
import repack.org.bouncycastle.asn1.ASN1StreamParser;
import repack.org.bouncycastle.asn1.BERApplicationSpecific;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERObject;

public class BERApplicationSpecificParser
implements ASN1ApplicationSpecificParser {
    private final int tag;
    private final ASN1StreamParser parser;

    BERApplicationSpecificParser(int tag, ASN1StreamParser parser) {
        this.tag = tag;
        this.parser = parser;
    }

    @Override
    public DEREncodable readObject() throws IOException {
        return this.parser.readObject();
    }

    @Override
    public DERObject getLoadedObject() throws IOException {
        return new BERApplicationSpecific(this.tag, this.parser.readVector());
    }

    @Override
    public DERObject getDERObject() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException(e.getMessage(), e);
        }
    }
}

