/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.geom;

import org.apache.harmony.awt.gl.Crossing;

public class GeometryUtil {
    public static final double EPSILON = Math.pow(10.0, -14.0);

    public static int intersectLinesWithParams(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] params) {
        double dx = x4 - x3;
        double dy = y4 - y3;
        double d = dx * (y2 - y1) - dy * (x2 - x1);
        if (Math.abs(d) < EPSILON) {
            return 0;
        }
        params[0] = (-dx * (y1 - y3) + dy * (x1 - x3)) / d;
        params[1] = dx != 0.0 ? (GeometryUtil.line(params[0], x1, x2) - x3) / dx : (dy != 0.0 ? (GeometryUtil.line(params[0], y1, y2) - y3) / dy : 0.0);
        if (params[0] >= 0.0 && params[0] <= 1.0 && params[1] >= 0.0 && params[1] <= 1.0) {
            return 1;
        }
        return 0;
    }

    public static int intersectLines(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] point) {
        double A1 = -(y2 - y1);
        double B1 = x2 - x1;
        double C1 = x1 * y2 - x2 * y1;
        double A2 = -(y4 - y3);
        double B2 = x4 - x3;
        double C2 = x3 * y4 - x4 * y3;
        double coefParallel = A1 * B2 - A2 * B1;
        if (x3 == x4 && y3 == y4 && A1 * x3 + B1 * y3 + C1 == 0.0 && x3 >= Math.min(x1, x2) && x3 <= Math.max(x1, x2) && y3 >= Math.min(y1, y2) && y3 <= Math.max(y1, y2)) {
            return 1;
        }
        if (Math.abs(coefParallel) < EPSILON) {
            return 0;
        }
        point[0] = (B1 * C2 - B2 * C1) / coefParallel;
        point[1] = (A2 * C1 - A1 * C2) / coefParallel;
        if (point[0] >= Math.min(x1, x2) && point[0] >= Math.min(x3, x4) && point[0] <= Math.max(x1, x2) && point[0] <= Math.max(x3, x4) && point[1] >= Math.min(y1, y2) && point[1] >= Math.min(y3, y4) && point[1] <= Math.max(y1, y2) && point[1] <= Math.max(y3, y4)) {
            return 1;
        }
        return 0;
    }

    public static int intersectLineAndQuad(double x1, double y1, double x2, double y2, double qx1, double qy1, double qx2, double qy2, double qx3, double qy3, double[] params) {
        double[] eqn = new double[3];
        double[] t = new double[2];
        double[] s = new double[2];
        double dy = y2 - y1;
        double dx = x2 - x1;
        int quantity = 0;
        int count = 0;
        eqn[0] = dy * (qx1 - x1) - dx * (qy1 - y1);
        eqn[1] = 2.0 * dy * (qx2 - qx1) - 2.0 * dx * (qy2 - qy1);
        eqn[2] = dy * (qx1 - 2.0 * qx2 + qx3) - dx * (qy1 - 2.0 * qy2 + qy3);
        count = Crossing.solveQuad(eqn, t);
        if (count == 0) {
            return 0;
        }
        int i = 0;
        while (i < count) {
            s[i] = dx != 0.0 ? (GeometryUtil.quad(t[i], qx1, qx2, qx3) - x1) / dx : (dy != 0.0 ? (GeometryUtil.quad(t[i], qy1, qy2, qy3) - y1) / dy : 0.0);
            if (t[i] >= 0.0 && t[i] <= 1.0 && s[i] >= 0.0 && s[i] <= 1.0) {
                params[2 * quantity] = t[i];
                params[2 * quantity + 1] = s[i];
                ++quantity;
            }
            ++i;
        }
        return quantity;
    }

    public static int intersectLineAndCubic(double x1, double y1, double x2, double y2, double cx1, double cy1, double cx2, double cy2, double cx3, double cy3, double cx4, double cy4, double[] params) {
        double[] eqn = new double[4];
        double[] t = new double[3];
        double[] s = new double[3];
        double dy = y2 - y1;
        double dx = x2 - x1;
        int quantity = 0;
        int count = 0;
        eqn[0] = (cy1 - y1) * dx + (x1 - cx1) * dy;
        eqn[1] = -3.0 * (cy1 - cy2) * dx + 3.0 * (cx1 - cx2) * dy;
        eqn[2] = (3.0 * cy1 - 6.0 * cy2 + 3.0 * cy3) * dx - (3.0 * cx1 - 6.0 * cx2 + 3.0 * cx3) * dy;
        eqn[3] = (-3.0 * cy1 + 3.0 * cy2 - 3.0 * cy3 + cy4) * dx + (3.0 * cx1 - 3.0 * cx2 + 3.0 * cx3 - cx4) * dy;
        count = Crossing.solveCubic(eqn, t);
        if (count == 0) {
            return 0;
        }
        int i = 0;
        while (i < count) {
            s[i] = dx != 0.0 ? (GeometryUtil.cubic(t[i], cx1, cx2, cx3, cx4) - x1) / dx : (dy != 0.0 ? (GeometryUtil.cubic(t[i], cy1, cy2, cy3, cy4) - y1) / dy : 0.0);
            if (t[i] >= 0.0 && t[i] <= 1.0 && s[i] >= 0.0 && s[i] <= 1.0) {
                params[2 * quantity] = t[i];
                params[2 * quantity + 1] = s[i];
                ++quantity;
            }
            ++i;
        }
        return quantity;
    }

    public static int intersectQuads(double x1, double y1, double x2, double y2, double x3, double y3, double qx1, double qy1, double qx2, double qy2, double qx3, double qy3, double[] params) {
        double[] initParams = new double[2];
        double[] xCoefs1 = new double[3];
        double[] yCoefs1 = new double[3];
        double[] xCoefs2 = new double[3];
        double[] yCoefs2 = new double[3];
        int quantity = 0;
        xCoefs1[0] = x1 - 2.0 * x2 + x3;
        xCoefs1[1] = -2.0 * x1 + 2.0 * x2;
        xCoefs1[2] = x1;
        yCoefs1[0] = y1 - 2.0 * y2 + y3;
        yCoefs1[1] = -2.0 * y1 + 2.0 * y2;
        yCoefs1[2] = y1;
        xCoefs2[0] = qx1 - 2.0 * qx2 + qx3;
        xCoefs2[1] = -2.0 * qx1 + 2.0 * qx2;
        xCoefs2[2] = qx1;
        yCoefs2[0] = qy1 - 2.0 * qy2 + qy3;
        yCoefs2[1] = -2.0 * qy1 + 2.0 * qy2;
        yCoefs2[2] = qy1;
        params[1] = 0.25;
        params[0] = 0.25;
        GeometryUtil.quadNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, initParams);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        params[1] = 0.75;
        params[0] = 0.75;
        GeometryUtil.quadNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, params);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        return quantity;
    }

    public static int intersectQuadAndCubic(double qx1, double qy1, double qx2, double qy2, double qx3, double qy3, double cx1, double cy1, double cx2, double cy2, double cx3, double cy3, double cx4, double cy4, double[] params) {
        int quantity = 0;
        double[] initParams = new double[3];
        double[] xCoefs1 = new double[3];
        double[] yCoefs1 = new double[3];
        double[] xCoefs2 = new double[4];
        double[] yCoefs2 = new double[4];
        xCoefs1[0] = qx1 - 2.0 * qx2 + qx3;
        xCoefs1[1] = 2.0 * qx2 - 2.0 * qx1;
        xCoefs1[2] = qx1;
        yCoefs1[0] = qy1 - 2.0 * qy2 + qy3;
        yCoefs1[1] = 2.0 * qy2 - 2.0 * qy1;
        yCoefs1[2] = qy1;
        xCoefs2[0] = -cx1 + 3.0 * cx2 - 3.0 * cx3 + cx4;
        xCoefs2[1] = 3.0 * cx1 - 6.0 * cx2 + 3.0 * cx3;
        xCoefs2[2] = -3.0 * cx1 + 3.0 * cx2;
        xCoefs2[3] = cx1;
        yCoefs2[0] = -cy1 + 3.0 * cy2 - 3.0 * cy3 + cy4;
        yCoefs2[1] = 3.0 * cy1 - 6.0 * cy2 + 3.0 * cy3;
        yCoefs2[2] = -3.0 * cy1 + 3.0 * cy2;
        yCoefs2[3] = cy1;
        params[1] = 0.25;
        params[0] = 0.25;
        GeometryUtil.quadAndCubicNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, initParams);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        params[1] = 0.5;
        params[0] = 0.5;
        GeometryUtil.quadAndCubicNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, params);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        params[1] = 0.75;
        params[0] = 0.75;
        GeometryUtil.quadAndCubicNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, params);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        return quantity;
    }

    public static int intersectCubics(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double cx1, double cy1, double cx2, double cy2, double cx3, double cy3, double cx4, double cy4, double[] params) {
        int quantity = 0;
        double[] initParams = new double[3];
        double[] xCoefs1 = new double[4];
        double[] yCoefs1 = new double[4];
        double[] xCoefs2 = new double[4];
        double[] yCoefs2 = new double[4];
        xCoefs1[0] = -x1 + 3.0 * x2 - 3.0 * x3 + x4;
        xCoefs1[1] = 3.0 * x1 - 6.0 * x2 + 3.0 * x3;
        xCoefs1[2] = -3.0 * x1 + 3.0 * x2;
        xCoefs1[3] = x1;
        yCoefs1[0] = -y1 + 3.0 * y2 - 3.0 * y3 + y4;
        yCoefs1[1] = 3.0 * y1 - 6.0 * y2 + 3.0 * y3;
        yCoefs1[2] = -3.0 * y1 + 3.0 * y2;
        yCoefs1[3] = y1;
        xCoefs2[0] = -cx1 + 3.0 * cx2 - 3.0 * cx3 + cx4;
        xCoefs2[1] = 3.0 * cx1 - 6.0 * cx2 + 3.0 * cx3;
        xCoefs2[2] = -3.0 * cx1 + 3.0 * cx2;
        xCoefs2[3] = cx1;
        yCoefs2[0] = -cy1 + 3.0 * cy2 - 3.0 * cy3 + cy4;
        yCoefs2[1] = 3.0 * cy1 - 6.0 * cy2 + 3.0 * cy3;
        yCoefs2[2] = -3.0 * cy1 + 3.0 * cy2;
        yCoefs2[3] = cy1;
        params[1] = 0.25;
        params[0] = 0.25;
        GeometryUtil.cubicNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, initParams);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        params[1] = 0.5;
        params[0] = 0.5;
        GeometryUtil.cubicNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, params);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        params[1] = 0.75;
        params[0] = 0.75;
        GeometryUtil.cubicNewton(xCoefs1, yCoefs1, xCoefs2, yCoefs2, params);
        if (initParams[0] <= 1.0 && initParams[0] >= 0.0 && initParams[1] >= 0.0 && initParams[1] <= 1.0) {
            params[2 * quantity] = initParams[0];
            params[2 * quantity + 1] = initParams[1];
            ++quantity;
        }
        return quantity;
    }

    public static double line(double t, double x1, double x2) {
        return x1 * (1.0 - t) + x2 * t;
    }

    public static double quad(double t, double x1, double x2, double x3) {
        return x1 * (1.0 - t) * (1.0 - t) + 2.0 * x2 * t * (1.0 - t) + x3 * t * t;
    }

    public static double cubic(double t, double x1, double x2, double x3, double x4) {
        return x1 * (1.0 - t) * (1.0 - t) * (1.0 - t) + 3.0 * x2 * (1.0 - t) * (1.0 - t) * t + 3.0 * x3 * (1.0 - t) * t * t + x4 * t * t * t;
    }

    public static void subQuad(double[] coef, double t0, boolean left) {
        if (left) {
            coef[2] = (1.0 - t0) * coef[0] + t0 * coef[2];
            coef[3] = (1.0 - t0) * coef[1] + t0 * coef[3];
        } else {
            coef[2] = (1.0 - t0) * coef[2] + t0 * coef[4];
            coef[3] = (1.0 - t0) * coef[3] + t0 * coef[5];
        }
    }

    public static void subCubic(double[] coef, double t0, boolean left) {
        if (left) {
            coef[2] = (1.0 - t0) * coef[0] + t0 * coef[2];
            coef[3] = (1.0 - t0) * coef[1] + t0 * coef[3];
        } else {
            coef[4] = (1.0 - t0) * coef[4] + t0 * coef[6];
            coef[5] = (1.0 - t0) * coef[5] + t0 * coef[7];
        }
    }

    private static void cubicNewton(double[] xCoefs1, double[] yCoefs1, double[] xCoefs2, double[] yCoefs2, double[] params) {
        double t = 0.0;
        double s = 0.0;
        double t1 = params[0];
        double s1 = params[1];
        while (Math.sqrt((t - t1) * (t - t1) + (s - s1) * (s - s1)) > EPSILON) {
            double d = -(3.0 * t * t * xCoefs1[0] + 2.0 * t * xCoefs1[1] + xCoefs1[2]) * (3.0 * s * s * yCoefs2[0] + 2.0 * s * yCoefs2[1] + yCoefs2[2]) + (3.0 * t * t * yCoefs1[0] + 2.0 * t * yCoefs1[1] + yCoefs1[2]) * (3.0 * s * s * xCoefs2[0] + 2.0 * s * xCoefs2[1] + xCoefs2[2]);
            double dt = (t * t * t * xCoefs1[0] + t * t * xCoefs1[1] + t * xCoefs1[2] + xCoefs1[3] - s * s * s * xCoefs2[0] - s * s * xCoefs2[1] - s * xCoefs2[2] - xCoefs2[3]) * (-3.0 * s * s * yCoefs2[0] - 2.0 * s * yCoefs2[1] - yCoefs2[2]) + (t * t * t * yCoefs1[0] + t * t * yCoefs1[1] + t * yCoefs1[2] + yCoefs1[3] - s * s * s * yCoefs2[0] - s * s * yCoefs2[1] - s * yCoefs2[2] - yCoefs2[3]) * (3.0 * s * s * xCoefs2[0] + 2.0 * s * xCoefs2[1] + xCoefs2[2]);
            double ds = (3.0 * t * t * xCoefs1[0] + 2.0 * t * xCoefs1[1] + xCoefs1[2]) * (t * t * t * yCoefs1[0] + t * t * yCoefs1[1] + t * yCoefs1[2] + yCoefs1[3] - s * s * s * yCoefs2[0] - s * s * yCoefs2[1] - s * yCoefs2[2] - yCoefs2[3]) - (3.0 * t * t * yCoefs1[0] + 2.0 * t * yCoefs1[1] + yCoefs1[2]) * (t * t * t * xCoefs1[0] + t * t * xCoefs1[1] + t * xCoefs1[2] + xCoefs1[3] - s * s * s * xCoefs2[0] - s * s * xCoefs2[1] - s * xCoefs2[2] - xCoefs2[3]);
            t1 = t - dt / d;
            s1 = s - ds / d;
        }
        params[0] = t1;
        params[1] = s1;
    }

    private static void quadAndCubicNewton(double[] xCoefs1, double[] yCoefs1, double[] xCoefs2, double[] yCoefs2, double[] params) {
        double t = 0.0;
        double s = 0.0;
        double t1 = params[0];
        double s1 = params[1];
        while (Math.sqrt((t - t1) * (t - t1) + (s - s1) * (s - s1)) > EPSILON) {
            double d = -(2.0 * t * xCoefs1[0] + xCoefs1[1]) * (3.0 * s * s * yCoefs2[0] + 2.0 * s * yCoefs2[1] + yCoefs2[2]) + (2.0 * t * yCoefs1[0] + yCoefs1[1]) * (3.0 * s * s * xCoefs2[0] + 2.0 * s * xCoefs2[1] + xCoefs2[2]);
            double dt = (t * t * xCoefs1[0] + t * xCoefs1[1] + xCoefs1[2] + -s * s * s * xCoefs2[0] - s * s * xCoefs2[1] - s * xCoefs2[2] - xCoefs2[3]) * (-3.0 * s * s * yCoefs2[0] - 2.0 * s * yCoefs2[1] - yCoefs2[2]) + (t * t * yCoefs1[0] + t * yCoefs1[1] + yCoefs1[2] - s * s * s * yCoefs2[0] - s * s * yCoefs2[1] - s * yCoefs2[2] - yCoefs2[3]) * (3.0 * s * s * xCoefs2[0] + 2.0 * s * xCoefs2[1] + xCoefs2[2]);
            double ds = (2.0 * t * xCoefs1[0] + xCoefs1[1]) * (t * t * yCoefs1[0] + t * yCoefs1[1] + yCoefs1[2] - s * s * s * yCoefs2[0] - s * s * yCoefs2[1] - s * yCoefs2[2] - yCoefs2[3]) - (2.0 * t * yCoefs1[0] + yCoefs1[1]) * (t * t * xCoefs1[0] + t * xCoefs1[1] + xCoefs1[2] - s * s * s * xCoefs2[0] - s * s * xCoefs2[1] - s * xCoefs2[2] - xCoefs2[3]);
            t1 = t - dt / d;
            s1 = s - ds / d;
        }
        params[0] = t1;
        params[1] = s1;
    }

    private static void quadNewton(double[] xCoefs1, double[] yCoefs1, double[] xCoefs2, double[] yCoefs2, double[] params) {
        double t = 0.0;
        double s = 0.0;
        double t1 = params[0];
        double s1 = params[1];
        while (Math.sqrt((t - t1) * (t - t1) + (s - s1) * (s - s1)) > EPSILON) {
            t = t1;
            s = s1;
            double d = -(2.0 * t * xCoefs1[0] + xCoefs1[1]) * (2.0 * s * yCoefs2[0] + yCoefs2[1]) + (2.0 * s * xCoefs2[0] + xCoefs2[1]) * (2.0 * t * yCoefs1[0] + yCoefs1[1]);
            double dt = -(t * t * xCoefs1[0] + t * xCoefs1[1] + xCoefs1[1] - s * s * xCoefs2[0] - s * xCoefs2[1] - xCoefs2[2]) * (2.0 * s * yCoefs2[0] + yCoefs2[1]) + (2.0 * s * xCoefs2[0] + xCoefs2[1]) * (t * t * yCoefs1[0] + t * yCoefs1[1] + yCoefs1[2] - s * s * yCoefs2[0] - s * yCoefs2[1] - yCoefs2[2]);
            double ds = (2.0 * t * xCoefs1[0] + xCoefs1[1]) * (t * t * yCoefs1[0] + t * yCoefs1[1] + yCoefs1[2] - s * s * yCoefs2[0] - s * yCoefs2[1] - yCoefs2[2]) - (2.0 * t * yCoefs1[0] + yCoefs1[1]) * (t * t * xCoefs1[0] + t * xCoefs1[1] + xCoefs1[2] - s * s * xCoefs2[0] - s * xCoefs2[1] - xCoefs2[2]);
            t1 = t - dt / d;
            s1 = s - ds / d;
        }
        params[0] = t1;
        params[1] = s1;
    }
}

