/*
 * Decompiled with CFR 0.152.
 */
package harmony.java.awt.geom;

import harmony.java.awt.Rectangle;
import harmony.java.awt.Shape;
import harmony.java.awt.geom.AffineTransform;
import harmony.java.awt.geom.FlatteningPathIterator;
import harmony.java.awt.geom.PathIterator;
import harmony.java.awt.geom.Point2D;
import harmony.java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.geom.CrossingHelper;
import org.apache.harmony.awt.geom.CurveCrossingHelper;
import org.apache.harmony.awt.geom.GeometryUtil;
import org.apache.harmony.awt.geom.IntersectPoint;
import org.apache.harmony.awt.gl.Crossing;
import org.apache.harmony.awt.internal.nls.Messages;

public class Area
implements Shape,
Cloneable {
    private double[] coords = new double[20];
    private int coordsSize = 0;
    private int[] rules = new int[10];
    private int rulesSize = 0;
    private int[] offsets = new int[10];
    private int moveToCount = 0;
    private boolean isPolygonal = true;

    public Area() {
    }

    public Area(Shape s) {
        double[] segmentCoords = new double[6];
        double lastMoveX = 0.0;
        double lastMoveY = 0.0;
        int rulesIndex = 0;
        int coordsIndex = 0;
        PathIterator pi = s.getPathIterator(null);
        while (!pi.isDone()) {
            this.coords = Area.adjustSize(this.coords, coordsIndex + 6);
            this.rules = Area.adjustSize(this.rules, rulesIndex + 1);
            this.offsets = Area.adjustSize(this.offsets, rulesIndex + 1);
            this.rules[rulesIndex] = pi.currentSegment(segmentCoords);
            this.offsets[rulesIndex] = coordsIndex;
            switch (this.rules[rulesIndex]) {
                case 0: {
                    this.coords[coordsIndex++] = segmentCoords[0];
                    this.coords[coordsIndex++] = segmentCoords[1];
                    lastMoveX = segmentCoords[0];
                    lastMoveY = segmentCoords[1];
                    ++this.moveToCount;
                    break;
                }
                case 1: {
                    if (segmentCoords[0] != lastMoveX || segmentCoords[1] != lastMoveY) {
                        this.coords[coordsIndex++] = segmentCoords[0];
                        this.coords[coordsIndex++] = segmentCoords[1];
                        break;
                    }
                    --rulesIndex;
                    break;
                }
                case 2: {
                    System.arraycopy(segmentCoords, 0, this.coords, coordsIndex, 4);
                    coordsIndex += 4;
                    this.isPolygonal = false;
                    break;
                }
                case 3: {
                    System.arraycopy(segmentCoords, 0, this.coords, coordsIndex, 6);
                    coordsIndex += 6;
                    this.isPolygonal = false;
                    break;
                }
            }
            ++rulesIndex;
            pi.next();
        }
        if (rulesIndex != 0 && this.rules[rulesIndex - 1] != 4) {
            this.rules[rulesIndex] = 4;
            this.offsets[rulesIndex] = this.coordsSize;
        }
        this.rulesSize = rulesIndex;
        this.coordsSize = coordsIndex;
    }

    @Override
    public boolean contains(double x, double y) {
        return !this.isEmpty() && this.containsExact(x, y) > 0;
    }

    @Override
    public boolean contains(double x, double y, double width, double height) {
        int crossCount = Crossing.intersectPath(this.getPathIterator(null), x, y, width, height);
        return crossCount != 255 && Crossing.isInsideEvenOdd(crossCount);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean equals(Area obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Area area = (Area)this.clone();
        area.subtract(obj);
        return area.isEmpty();
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            return false;
        }
        if (!this.getBounds2D().intersects(x, y, width, height)) {
            return false;
        }
        int crossCount = Crossing.intersectShape(this, x, y, width, height);
        return Crossing.isInsideEvenOdd(crossCount);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        double maxX = this.coords[0];
        double maxY = this.coords[1];
        double minX = this.coords[0];
        double minY = this.coords[1];
        int i = 0;
        while (i < this.coordsSize) {
            minX = Math.min(minX, this.coords[i]);
            maxX = Math.max(maxX, this.coords[i++]);
            minY = Math.min(minY, this.coords[i]);
            maxY = Math.max(maxY, this.coords[i++]);
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t) {
        return new AreaPathIterator(this, t);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(t), flatness);
    }

    public boolean isEmpty() {
        return this.rulesSize == 0 && this.coordsSize == 0;
    }

    public boolean isPolygonal() {
        return this.isPolygonal;
    }

    public boolean isRectangular() {
        return this.isPolygonal && this.rulesSize <= 5 && this.coordsSize <= 8 && this.coords[1] == this.coords[3] && this.coords[7] == this.coords[5] && this.coords[0] == this.coords[6] && this.coords[2] == this.coords[4];
    }

    public boolean isSingular() {
        return this.moveToCount <= 1;
    }

    public void reset() {
        this.coordsSize = 0;
        this.rulesSize = 0;
    }

    public void transform(AffineTransform t) {
        this.copy(new Area(t.createTransformedShape(this)), this);
    }

    public Area createTransformedArea(AffineTransform t) {
        return new Area(t.createTransformedShape(this));
    }

    public Object clone() {
        Area area = new Area();
        this.copy(this, area);
        return area;
    }

    public void add(Area area) {
        if (area == null || area.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.copy(area, this);
            return;
        }
        if (this.isPolygonal() && area.isPolygonal()) {
            this.addPolygon(area);
        } else {
            this.addCurvePolygon(area);
        }
        if (this.getAreaBoundsSquare() < GeometryUtil.EPSILON) {
            this.reset();
        }
    }

    public void intersect(Area area) {
        if (area == null) {
            return;
        }
        if (this.isEmpty() || area.isEmpty()) {
            this.reset();
            return;
        }
        if (this.isPolygonal() && area.isPolygonal()) {
            this.intersectPolygon(area);
        } else {
            this.intersectCurvePolygon(area);
        }
        if (this.getAreaBoundsSquare() < GeometryUtil.EPSILON) {
            this.reset();
        }
    }

    public void subtract(Area area) {
        if (area == null || this.isEmpty() || area.isEmpty()) {
            return;
        }
        if (this.isPolygonal() && area.isPolygonal()) {
            this.subtractPolygon(area);
        } else {
            this.subtractCurvePolygon(area);
        }
        if (this.getAreaBoundsSquare() < GeometryUtil.EPSILON) {
            this.reset();
        }
    }

    public void exclusiveOr(Area area) {
        Area a = (Area)this.clone();
        a.intersect(area);
        this.add(area);
        this.subtract(a);
    }

    private void addCurvePolygon(Area area) {
        IntersectPoint nextPoint;
        CurveCrossingHelper crossHelper = new CurveCrossingHelper(new double[][]{this.coords, area.coords}, new int[]{this.coordsSize, area.coordsSize}, new int[][]{this.rules, area.rules}, new int[]{this.rulesSize, area.rulesSize}, new int[][]{this.offsets, area.offsets});
        IntersectPoint[] intersectPoints = crossHelper.findCrossing();
        if (intersectPoints.length == 0) {
            if (area.contains(this.getBounds2D())) {
                this.copy(area, this);
            } else if (!this.contains(area.getBounds2D())) {
                this.coords = Area.adjustSize(this.coords, this.coordsSize + area.coordsSize);
                System.arraycopy(area.coords, 0, this.coords, this.coordsSize, area.coordsSize);
                this.coordsSize += area.coordsSize;
                this.rules = Area.adjustSize(this.rules, this.rulesSize + area.rulesSize);
                System.arraycopy(area.rules, 0, this.rules, this.rulesSize, area.rulesSize);
                this.rulesSize += area.rulesSize;
                this.offsets = Area.adjustSize(this.offsets, this.rulesSize + area.rulesSize);
                System.arraycopy(area.offsets, 0, this.offsets, this.rulesSize, area.rulesSize);
            }
            return;
        }
        double[] resultCoords = new double[this.coordsSize + area.coordsSize + intersectPoints.length];
        int[] resultRules = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int[] resultOffsets = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int resultCoordPos = 0;
        int resultRulesPos = 0;
        boolean isCurrentArea = true;
        IntersectPoint point = intersectPoints[0];
        resultRules[resultRulesPos] = 0;
        resultOffsets[resultRulesPos++] = resultCoordPos;
        do {
            resultCoords[resultCoordPos++] = point.getX();
            resultCoords[resultCoordPos++] = point.getY();
            int curIndex = point.getEndIndex(true);
            isCurrentArea = curIndex < 0 ? !isCurrentArea : area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) <= 0;
            nextPoint = this.getNextIntersectPoint(intersectPoints, point, isCurrentArea);
            double[] coords = isCurrentArea ? this.coords : area.coords;
            int[] offsets = isCurrentArea ? this.offsets : area.offsets;
            int[] rules = isCurrentArea ? this.rules : area.rules;
            int offset = point.getRuleIndex(isCurrentArea);
            boolean isCopyUntilZero = false;
            if (point.getRuleIndex(isCurrentArea) > nextPoint.getRuleIndex(isCurrentArea)) {
                int rulesSize = isCurrentArea ? this.rulesSize : area.rulesSize;
                resultCoordPos = this.includeCoordsAndRules(offset + 1, rulesSize, rules, offsets, resultRules, resultOffsets, resultCoords, coords, resultRulesPos, resultCoordPos, point, isCurrentArea, false, 0);
                resultRulesPos += rulesSize - offset - 1;
                offset = 1;
                isCopyUntilZero = true;
            }
            int length = nextPoint.getRuleIndex(isCurrentArea) - offset + 1;
            if (isCopyUntilZero) {
                offset = 0;
            }
            resultCoordPos = this.includeCoordsAndRules(offset, length, rules, offsets, resultRules, resultOffsets, resultCoords, coords, resultRulesPos, resultCoordPos, point, isCurrentArea, true, 0);
            resultRulesPos += length - offset;
        } while ((point = nextPoint) != intersectPoints[0]);
        resultRules[resultRulesPos++] = 4;
        resultOffsets[resultRulesPos - 1] = resultCoordPos;
        this.coords = resultCoords;
        this.rules = resultRules;
        this.offsets = resultOffsets;
        this.coordsSize = resultCoordPos;
        this.rulesSize = resultRulesPos;
    }

    private void addPolygon(Area area) {
        IntersectPoint nextPoint;
        CrossingHelper crossHelper = new CrossingHelper(new double[][]{this.coords, area.coords}, new int[]{this.coordsSize, area.coordsSize});
        IntersectPoint[] intersectPoints = crossHelper.findCrossing();
        if (intersectPoints.length == 0) {
            if (area.contains(this.getBounds2D())) {
                this.copy(area, this);
            } else if (!this.contains(area.getBounds2D())) {
                this.coords = Area.adjustSize(this.coords, this.coordsSize + area.coordsSize);
                System.arraycopy(area.coords, 0, this.coords, this.coordsSize, area.coordsSize);
                this.coordsSize += area.coordsSize;
                this.rules = Area.adjustSize(this.rules, this.rulesSize + area.rulesSize);
                System.arraycopy(area.rules, 0, this.rules, this.rulesSize, area.rulesSize);
                this.rulesSize += area.rulesSize;
                this.offsets = Area.adjustSize(this.offsets, this.rulesSize + area.rulesSize);
                System.arraycopy(area.offsets, 0, this.offsets, this.rulesSize, area.rulesSize);
            }
            return;
        }
        double[] resultCoords = new double[this.coordsSize + area.coordsSize + intersectPoints.length];
        int[] resultRules = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int[] resultOffsets = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int resultCoordPos = 0;
        int resultRulesPos = 0;
        boolean isCurrentArea = true;
        IntersectPoint point = intersectPoints[0];
        resultRules[resultRulesPos] = 0;
        resultOffsets[resultRulesPos++] = resultCoordPos;
        do {
            resultCoords[resultCoordPos++] = point.getX();
            resultCoords[resultCoordPos++] = point.getY();
            resultRules[resultRulesPos] = 1;
            resultOffsets[resultRulesPos++] = resultCoordPos - 2;
            int curIndex = point.getEndIndex(true);
            isCurrentArea = curIndex < 0 ? !isCurrentArea : area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) <= 0;
            nextPoint = this.getNextIntersectPoint(intersectPoints, point, isCurrentArea);
            double[] coords = isCurrentArea ? this.coords : area.coords;
            int offset = 2 * point.getEndIndex(isCurrentArea);
            if (offset >= 0 && nextPoint.getBegIndex(isCurrentArea) < point.getEndIndex(isCurrentArea)) {
                int coordSize = isCurrentArea ? this.coordsSize : area.coordsSize;
                int length = coordSize - offset;
                System.arraycopy(coords, offset, resultCoords, resultCoordPos, length);
                int i = 0;
                while (i < length / 2) {
                    resultRules[resultRulesPos] = 1;
                    resultOffsets[resultRulesPos++] = resultCoordPos;
                    resultCoordPos += 2;
                    ++i;
                }
                offset = 0;
            }
            if (offset < 0) continue;
            int length = 2 * nextPoint.getBegIndex(isCurrentArea) - offset + 2;
            System.arraycopy(coords, offset, resultCoords, resultCoordPos, length);
            int i = 0;
            while (i < length / 2) {
                resultRules[resultRulesPos] = 1;
                resultOffsets[resultRulesPos++] = resultCoordPos;
                resultCoordPos += 2;
                ++i;
            }
        } while ((point = nextPoint) != intersectPoints[0]);
        resultRules[resultRulesPos - 1] = 4;
        resultOffsets[resultRulesPos - 1] = resultCoordPos;
        this.coords = resultCoords;
        this.rules = resultRules;
        this.offsets = resultOffsets;
        this.coordsSize = resultCoordPos;
        this.rulesSize = resultRulesPos;
    }

    private void intersectCurvePolygon(Area area) {
        CurveCrossingHelper crossHelper = new CurveCrossingHelper(new double[][]{this.coords, area.coords}, new int[]{this.coordsSize, area.coordsSize}, new int[][]{this.rules, area.rules}, new int[]{this.rulesSize, area.rulesSize}, new int[][]{this.offsets, area.offsets});
        IntersectPoint[] intersectPoints = crossHelper.findCrossing();
        if (intersectPoints.length == 0) {
            if (this.contains(area.getBounds2D())) {
                this.copy(area, this);
            } else if (!area.contains(this.getBounds2D())) {
                this.reset();
            }
            return;
        }
        double[] resultCoords = new double[this.coordsSize + area.coordsSize + intersectPoints.length];
        int[] resultRules = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int[] resultOffsets = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int resultCoordPos = 0;
        int resultRulesPos = 0;
        boolean isCurrentArea = true;
        IntersectPoint point = intersectPoints[0];
        IntersectPoint nextPoint = intersectPoints[0];
        resultRules[resultRulesPos] = 0;
        resultOffsets[resultRulesPos++] = resultCoordPos;
        do {
            resultCoords[resultCoordPos++] = point.getX();
            resultCoords[resultCoordPos++] = point.getY();
            int curIndex = point.getEndIndex(true);
            isCurrentArea = curIndex < 0 || area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) == 0 ? !isCurrentArea : area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) > 0;
            nextPoint = this.getNextIntersectPoint(intersectPoints, point, isCurrentArea);
            double[] coords = isCurrentArea ? this.coords : area.coords;
            int[] offsets = isCurrentArea ? this.offsets : area.offsets;
            int[] rules = isCurrentArea ? this.rules : area.rules;
            int offset = point.getRuleIndex(isCurrentArea);
            boolean isCopyUntilZero = false;
            if (point.getRuleIndex(isCurrentArea) > nextPoint.getRuleIndex(isCurrentArea)) {
                int rulesSize = isCurrentArea ? this.rulesSize : area.rulesSize;
                resultCoordPos = this.includeCoordsAndRules(offset + 1, rulesSize, rules, offsets, resultRules, resultOffsets, resultCoords, coords, resultRulesPos, resultCoordPos, point, isCurrentArea, false, 1);
                resultRulesPos += rulesSize - offset - 1;
                offset = 1;
                isCopyUntilZero = true;
            }
            int length = nextPoint.getRuleIndex(isCurrentArea) - offset + 1;
            if (isCopyUntilZero) {
                offset = 0;
                isCopyUntilZero = false;
            }
            if (length == offset && nextPoint.getRule(isCurrentArea) != 1 && nextPoint.getRule(isCurrentArea) != 4 && point.getRule(isCurrentArea) != 1 && point.getRule(isCurrentArea) != 4) {
                isCopyUntilZero = true;
                ++length;
            }
            resultCoordPos = this.includeCoordsAndRules(offset, length, rules, offsets, resultRules, resultOffsets, resultCoords, coords, resultRulesPos, resultCoordPos, nextPoint, isCurrentArea, true, 1);
            int n = resultRulesPos = length <= offset || isCopyUntilZero ? resultRulesPos + 1 : resultRulesPos + length;
        } while ((point = nextPoint) != intersectPoints[0]);
        if (resultRules[resultRulesPos - 1] == 1) {
            resultRules[resultRulesPos - 1] = 4;
        } else {
            resultCoords[resultCoordPos++] = nextPoint.getX();
            resultCoords[resultCoordPos++] = nextPoint.getY();
            resultRules[resultRulesPos++] = 4;
        }
        resultOffsets[resultRulesPos - 1] = resultCoordPos;
        this.coords = resultCoords;
        this.rules = resultRules;
        this.offsets = resultOffsets;
        this.coordsSize = resultCoordPos;
        this.rulesSize = resultRulesPos;
    }

    private void intersectPolygon(Area area) {
        IntersectPoint nextPoint;
        CrossingHelper crossHelper = new CrossingHelper(new double[][]{this.coords, area.coords}, new int[]{this.coordsSize, area.coordsSize});
        IntersectPoint[] intersectPoints = crossHelper.findCrossing();
        if (intersectPoints.length == 0) {
            if (this.contains(area.getBounds2D())) {
                this.copy(area, this);
            } else if (!area.contains(this.getBounds2D())) {
                this.reset();
            }
            return;
        }
        double[] resultCoords = new double[this.coordsSize + area.coordsSize + intersectPoints.length];
        int[] resultRules = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int[] resultOffsets = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int resultCoordPos = 0;
        int resultRulesPos = 0;
        boolean isCurrentArea = true;
        IntersectPoint point = intersectPoints[0];
        resultRules[resultRulesPos] = 0;
        resultOffsets[resultRulesPos++] = resultCoordPos;
        do {
            resultCoords[resultCoordPos++] = point.getX();
            resultCoords[resultCoordPos++] = point.getY();
            resultRules[resultRulesPos] = 1;
            resultOffsets[resultRulesPos++] = resultCoordPos - 2;
            int curIndex = point.getEndIndex(true);
            isCurrentArea = curIndex < 0 || area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) == 0 ? !isCurrentArea : area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) > 0;
            nextPoint = this.getNextIntersectPoint(intersectPoints, point, isCurrentArea);
            double[] coords = isCurrentArea ? this.coords : area.coords;
            int offset = 2 * point.getEndIndex(isCurrentArea);
            if (offset >= 0 && nextPoint.getBegIndex(isCurrentArea) < point.getEndIndex(isCurrentArea)) {
                int coordSize = isCurrentArea ? this.coordsSize : area.coordsSize;
                int length = coordSize - offset;
                System.arraycopy(coords, offset, resultCoords, resultCoordPos, length);
                int i = 0;
                while (i < length / 2) {
                    resultRules[resultRulesPos] = 1;
                    resultOffsets[resultRulesPos++] = resultCoordPos;
                    resultCoordPos += 2;
                    ++i;
                }
                offset = 0;
            }
            if (offset < 0) continue;
            int length = 2 * nextPoint.getBegIndex(isCurrentArea) - offset + 2;
            System.arraycopy(coords, offset, resultCoords, resultCoordPos, length);
            int i = 0;
            while (i < length / 2) {
                resultRules[resultRulesPos] = 1;
                resultOffsets[resultRulesPos++] = resultCoordPos;
                resultCoordPos += 2;
                ++i;
            }
        } while ((point = nextPoint) != intersectPoints[0]);
        resultRules[resultRulesPos - 1] = 4;
        resultOffsets[resultRulesPos - 1] = resultCoordPos;
        this.coords = resultCoords;
        this.rules = resultRules;
        this.offsets = resultOffsets;
        this.coordsSize = resultCoordPos;
        this.rulesSize = resultRulesPos;
    }

    private void subtractCurvePolygon(Area area) {
        IntersectPoint nextPoint;
        CurveCrossingHelper crossHelper = new CurveCrossingHelper(new double[][]{this.coords, area.coords}, new int[]{this.coordsSize, area.coordsSize}, new int[][]{this.rules, area.rules}, new int[]{this.rulesSize, area.rulesSize}, new int[][]{this.offsets, area.offsets});
        IntersectPoint[] intersectPoints = crossHelper.findCrossing();
        if (intersectPoints.length == 0 && this.contains(area.getBounds2D())) {
            this.copy(area, this);
            return;
        }
        double[] resultCoords = new double[this.coordsSize + area.coordsSize + intersectPoints.length];
        int[] resultRules = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int[] resultOffsets = new int[this.rulesSize + area.rulesSize + intersectPoints.length];
        int resultCoordPos = 0;
        int resultRulesPos = 0;
        boolean isCurrentArea = true;
        IntersectPoint point = intersectPoints[0];
        resultRules[resultRulesPos] = 0;
        resultOffsets[resultRulesPos++] = resultCoordPos;
        do {
            resultCoords[resultCoordPos++] = point.getX();
            resultCoords[resultCoordPos++] = point.getY();
            int curIndex = this.offsets[point.getRuleIndex(true)] % this.coordsSize;
            isCurrentArea = area.containsExact(this.coords[curIndex], this.coords[curIndex + 1]) == 0 ? !isCurrentArea : area.containsExact(this.coords[curIndex], this.coords[curIndex + 1]) <= 0;
            nextPoint = isCurrentArea ? this.getNextIntersectPoint(intersectPoints, point, isCurrentArea) : this.getPrevIntersectPoint(intersectPoints, point, isCurrentArea);
            double[] coords = isCurrentArea ? this.coords : area.coords;
            int[] offsets = isCurrentArea ? this.offsets : area.offsets;
            int[] rules = isCurrentArea ? this.rules : area.rules;
            int offset = isCurrentArea ? point.getRuleIndex(isCurrentArea) : nextPoint.getRuleIndex(isCurrentArea);
            boolean isCopyUntilZero = false;
            if (isCurrentArea && point.getRuleIndex(isCurrentArea) > nextPoint.getRuleIndex(isCurrentArea) || !isCurrentArea && nextPoint.getRuleIndex(isCurrentArea) > nextPoint.getRuleIndex(isCurrentArea)) {
                int rulesSize = isCurrentArea ? this.rulesSize : area.rulesSize;
                resultCoordPos = this.includeCoordsAndRules(offset + 1, rulesSize, rules, offsets, resultRules, resultOffsets, resultCoords, coords, resultRulesPos, resultCoordPos, point, isCurrentArea, false, 2);
                resultRulesPos += rulesSize - offset - 1;
                offset = 1;
                isCopyUntilZero = true;
            }
            int length = nextPoint.getRuleIndex(isCurrentArea) - offset + 1;
            if (isCopyUntilZero) {
                offset = 0;
                isCopyUntilZero = false;
            }
            resultCoordPos = this.includeCoordsAndRules(offset, length, rules, offsets, resultRules, resultOffsets, resultCoords, coords, resultRulesPos, resultCoordPos, point, isCurrentArea, true, 2);
            if (length == offset && (rules[offset] == 2 || rules[offset] == 3)) {
                ++resultRulesPos;
                continue;
            }
            int n = resultRulesPos = length < offset || isCopyUntilZero ? resultRulesPos + 1 : resultRulesPos + length - offset;
        } while ((point = nextPoint) != intersectPoints[0]);
        resultRules[resultRulesPos++] = 4;
        resultOffsets[resultRulesPos - 1] = resultCoordPos;
        this.coords = resultCoords;
        this.rules = resultRules;
        this.offsets = resultOffsets;
        this.coordsSize = resultCoordPos;
        this.rulesSize = resultRulesPos;
    }

    private void subtractPolygon(Area area) {
        CrossingHelper crossHelper = new CrossingHelper(new double[][]{this.coords, area.coords}, new int[]{this.coordsSize, area.coordsSize});
        IntersectPoint[] intersectPoints = crossHelper.findCrossing();
        if (intersectPoints.length == 0) {
            if (this.contains(area.getBounds2D())) {
                this.copy(area, this);
                return;
            }
            return;
        }
        double[] resultCoords = new double[2 * (this.coordsSize + area.coordsSize + intersectPoints.length)];
        int[] resultRules = new int[2 * (this.rulesSize + area.rulesSize + intersectPoints.length)];
        int[] resultOffsets = new int[2 * (this.rulesSize + area.rulesSize + intersectPoints.length)];
        int resultCoordPos = 0;
        int resultRulesPos = 0;
        boolean isCurrentArea = true;
        int countPoints = 0;
        boolean curArea = false;
        boolean addArea = false;
        IntersectPoint point = intersectPoints[0];
        resultRules[resultRulesPos] = 0;
        resultOffsets[resultRulesPos++] = resultCoordPos;
        do {
            int offset;
            resultCoords[resultCoordPos++] = point.getX();
            resultCoords[resultCoordPos++] = point.getY();
            resultRules[resultRulesPos] = 1;
            resultOffsets[resultRulesPos++] = resultCoordPos - 2;
            int curIndex = point.getEndIndex(true);
            isCurrentArea = curIndex < 0 || area.isVertex(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) && crossHelper.containsPoint(new double[]{this.coords[2 * curIndex], this.coords[2 * curIndex + 1]}) && (this.coords[2 * curIndex] != point.getX() || this.coords[2 * curIndex + 1] != point.getY()) ? !isCurrentArea : area.containsExact(this.coords[2 * curIndex], this.coords[2 * curIndex + 1]) <= 0;
            if (countPoints >= intersectPoints.length) {
                boolean bl = isCurrentArea = !isCurrentArea;
            }
            if (isCurrentArea) {
                curArea = true;
            } else {
                addArea = true;
            }
            IntersectPoint nextPoint = isCurrentArea ? this.getNextIntersectPoint(intersectPoints, point, isCurrentArea) : this.getPrevIntersectPoint(intersectPoints, point, isCurrentArea);
            double[] coords = isCurrentArea ? this.coords : area.coords;
            int n = offset = isCurrentArea ? 2 * point.getEndIndex(isCurrentArea) : 2 * nextPoint.getEndIndex(isCurrentArea);
            if (offset > 0 && (isCurrentArea && nextPoint.getBegIndex(isCurrentArea) < point.getEndIndex(isCurrentArea) || !isCurrentArea && nextPoint.getEndIndex(isCurrentArea) < nextPoint.getBegIndex(isCurrentArea))) {
                int coordSize = isCurrentArea ? this.coordsSize : area.coordsSize;
                int length = coordSize - offset;
                if (isCurrentArea) {
                    System.arraycopy(coords, offset, resultCoords, resultCoordPos, length);
                } else {
                    double[] temp = new double[length];
                    System.arraycopy(coords, offset, temp, 0, length);
                    this.reverseCopy(temp);
                    System.arraycopy(temp, 0, resultCoords, resultCoordPos, length);
                }
                int i = 0;
                while (i < length / 2) {
                    resultRules[resultRulesPos] = 1;
                    resultOffsets[resultRulesPos++] = resultCoordPos;
                    resultCoordPos += 2;
                    ++i;
                }
                offset = 0;
            }
            if (offset >= 0) {
                int length;
                int n2 = length = isCurrentArea ? 2 * nextPoint.getBegIndex(isCurrentArea) - offset + 2 : 2 * point.getBegIndex(isCurrentArea) - offset + 2;
                if (isCurrentArea) {
                    System.arraycopy(coords, offset, resultCoords, resultCoordPos, length);
                } else {
                    double[] temp = new double[length];
                    System.arraycopy(coords, offset, temp, 0, length);
                    this.reverseCopy(temp);
                    System.arraycopy(temp, 0, resultCoords, resultCoordPos, length);
                }
                int i = 0;
                while (i < length / 2) {
                    resultRules[resultRulesPos] = 1;
                    resultOffsets[resultRulesPos++] = resultCoordPos;
                    resultCoordPos += 2;
                    ++i;
                }
            }
            point = nextPoint;
            ++countPoints;
        } while (point != intersectPoints[0] || !curArea || !addArea);
        resultRules[resultRulesPos - 1] = 4;
        resultOffsets[resultRulesPos - 1] = resultCoordPos;
        this.coords = resultCoords;
        this.rules = resultRules;
        this.offsets = resultOffsets;
        this.coordsSize = resultCoordPos;
        this.rulesSize = resultRulesPos;
    }

    private IntersectPoint getNextIntersectPoint(IntersectPoint[] iPoints, IntersectPoint isectPoint, boolean isCurrentArea) {
        int endIndex = isectPoint.getEndIndex(isCurrentArea);
        if (endIndex < 0) {
            return iPoints[Math.abs(endIndex) - 1];
        }
        IntersectPoint firstIsectPoint = null;
        IntersectPoint nextIsectPoint = null;
        IntersectPoint[] intersectPointArray = iPoints;
        int n = iPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IntersectPoint point = intersectPointArray[n2];
            int begIndex = point.getBegIndex(isCurrentArea);
            if (begIndex >= 0) {
                if (firstIsectPoint == null) {
                    firstIsectPoint = point;
                } else if (begIndex < firstIsectPoint.getBegIndex(isCurrentArea)) {
                    firstIsectPoint = point;
                }
            }
            if (endIndex <= begIndex) {
                if (nextIsectPoint == null) {
                    nextIsectPoint = point;
                } else if (begIndex < nextIsectPoint.getBegIndex(isCurrentArea)) {
                    nextIsectPoint = point;
                }
            }
            ++n2;
        }
        return nextIsectPoint != null ? nextIsectPoint : firstIsectPoint;
    }

    private IntersectPoint getPrevIntersectPoint(IntersectPoint[] iPoints, IntersectPoint isectPoint, boolean isCurrentArea) {
        int begIndex = isectPoint.getBegIndex(isCurrentArea);
        if (begIndex < 0) {
            return iPoints[Math.abs(begIndex) - 1];
        }
        IntersectPoint firstIsectPoint = null;
        IntersectPoint predIsectPoint = null;
        IntersectPoint[] intersectPointArray = iPoints;
        int n = iPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IntersectPoint point = intersectPointArray[n2];
            int endIndex = point.getEndIndex(isCurrentArea);
            if (endIndex >= 0) {
                if (firstIsectPoint == null) {
                    firstIsectPoint = point;
                } else if (endIndex < firstIsectPoint.getEndIndex(isCurrentArea)) {
                    firstIsectPoint = point;
                }
            }
            if (endIndex <= begIndex) {
                if (predIsectPoint == null) {
                    predIsectPoint = point;
                } else if (endIndex > predIsectPoint.getEndIndex(isCurrentArea)) {
                    predIsectPoint = point;
                }
            }
            ++n2;
        }
        return predIsectPoint != null ? predIsectPoint : firstIsectPoint;
    }

    private int includeCoordsAndRules(int offset, int length, int[] rules, int[] offsets, int[] resultRules, int[] resultOffsets, double[] resultCoords, double[] coords, int resultRulesPos, int resultCoordPos, IntersectPoint point, boolean isCurrentArea, boolean way, int operation) {
        int i;
        double[] temp = new double[8 * length];
        int coordsCount = 0;
        boolean isMoveIndex = true;
        boolean isMoveLength = true;
        boolean additional = false;
        if (length <= offset) {
            i = resultRulesPos;
            while (i < resultRulesPos + 1) {
                resultRules[i] = 1;
                ++i;
            }
        } else {
            int j = resultRulesPos;
            int i2 = offset;
            while (i2 < length) {
                resultRules[j++] = 1;
                ++i2;
            }
        }
        if (length == offset && (rules[offset] == 2 || rules[offset] == 3)) {
            ++length;
            additional = true;
        }
        i = offset;
        while (i < length) {
            int index = offsets[i];
            if (!isMoveIndex) {
                index -= 2;
            }
            if (!isMoveLength) {
                ++length;
                isMoveLength = true;
            }
            switch (rules[i]) {
                case 0: {
                    isMoveIndex = false;
                    isMoveLength = false;
                    break;
                }
                case 1: 
                case 4: {
                    boolean isLeft;
                    resultRules[resultRulesPos] = 1;
                    resultOffsets[resultRulesPos++] = resultCoordPos + 2;
                    boolean bl = isLeft = CrossingHelper.compare(coords[index], coords[index + 1], point.getX(), point.getY()) > 0;
                    if (!way && isLeft) break;
                    temp[coordsCount++] = coords[index];
                    temp[coordsCount++] = coords[index + 1];
                    break;
                }
                case 2: {
                    boolean isLeft;
                    resultRules[resultRulesPos] = 2;
                    resultOffsets[resultRulesPos++] = resultCoordPos + 4;
                    double[] coefs = new double[]{coords[index - 2], coords[index - 1], coords[index], coords[index + 1], coords[index + 2], coords[index + 3]};
                    boolean bl = isLeft = CrossingHelper.compare(coords[index - 2], coords[index - 1], point.getX(), point.getY()) > 0;
                    if (!(additional || operation != 0 && operation != 2)) {
                        isLeft = !isLeft;
                        way = false;
                    }
                    GeometryUtil.subQuad(coefs, point.getParam(isCurrentArea), isLeft);
                    if (way || isLeft) {
                        temp[coordsCount++] = coefs[2];
                        temp[coordsCount++] = coefs[3];
                        break;
                    }
                    System.arraycopy(coefs, 2, temp, coordsCount, 4);
                    coordsCount += 4;
                    break;
                }
                case 3: {
                    resultRules[resultRulesPos] = 3;
                    resultOffsets[resultRulesPos++] = resultCoordPos + 6;
                    double[] coefs = new double[]{coords[index - 2], coords[index - 1], coords[index], coords[index + 1], coords[index + 2], coords[index + 3], coords[index + 4], coords[index + 5]};
                    boolean isLeft = CrossingHelper.compare(coords[index - 2], coords[index - 1], point.getX(), point.getY()) > 0;
                    GeometryUtil.subCubic(coefs, point.getParam(isCurrentArea), !isLeft);
                    if (isLeft) {
                        System.arraycopy(coefs, 2, temp, coordsCount, 6);
                        coordsCount += 6;
                        break;
                    }
                    System.arraycopy(coefs, 2, temp, coordsCount, 4);
                    coordsCount += 4;
                }
            }
            ++i;
        }
        if (operation == 2 && !isCurrentArea && coordsCount > 2) {
            this.reverseCopy(temp);
            System.arraycopy(temp, 0, resultCoords, resultCoordPos, coordsCount);
        } else {
            System.arraycopy(temp, 0, resultCoords, resultCoordPos, coordsCount);
        }
        return resultCoordPos + coordsCount;
    }

    private static double[] adjustSize(double[] array, int newSize) {
        if (newSize <= array.length) {
            return array;
        }
        double[] newArray = new double[2 * newSize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private static int[] adjustSize(int[] array, int newSize) {
        if (newSize <= array.length) {
            return array;
        }
        int[] newArray = new int[2 * newSize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private void copy(Area src, Area dst) {
        dst.coordsSize = src.coordsSize;
        dst.coords = (double[])src.coords.clone();
        dst.rulesSize = src.rulesSize;
        dst.rules = (int[])src.rules.clone();
        dst.moveToCount = src.moveToCount;
        dst.offsets = (int[])src.offsets.clone();
    }

    private int containsExact(double x, double y) {
        PathIterator pi = this.getPathIterator(null);
        int crossCount = Crossing.crossPath(pi, x, y);
        if (Crossing.isInsideEvenOdd(crossCount)) {
            return 1;
        }
        double[] segmentCoords = new double[6];
        double[] resultPoints = new double[6];
        double curX = -1.0;
        double curY = -1.0;
        double moveX = -1.0;
        double moveY = -1.0;
        pi = this.getPathIterator(null);
        while (!pi.isDone()) {
            int rule = pi.currentSegment(segmentCoords);
            switch (rule) {
                case 0: {
                    moveX = curX = segmentCoords[0];
                    moveY = curY = segmentCoords[1];
                    break;
                }
                case 1: {
                    if (GeometryUtil.intersectLines(curX, curY, segmentCoords[0], segmentCoords[1], x, y, x, y, resultPoints) != 0) {
                        return 0;
                    }
                    curX = segmentCoords[0];
                    curY = segmentCoords[1];
                    break;
                }
                case 2: {
                    if (GeometryUtil.intersectLineAndQuad(x, y, x, y, curX, curY, segmentCoords[0], segmentCoords[1], segmentCoords[2], segmentCoords[3], resultPoints) > 0) {
                        return 0;
                    }
                    curX = segmentCoords[2];
                    curY = segmentCoords[3];
                    break;
                }
                case 3: {
                    if (GeometryUtil.intersectLineAndCubic(x, y, x, y, curX, curY, segmentCoords[0], segmentCoords[1], segmentCoords[2], segmentCoords[3], segmentCoords[4], segmentCoords[5], resultPoints) > 0) {
                        return 0;
                    }
                    curX = segmentCoords[4];
                    curY = segmentCoords[5];
                    break;
                }
                case 4: {
                    if (GeometryUtil.intersectLines(curX, curY, moveX, moveY, x, y, x, y, resultPoints) != 0) {
                        return 0;
                    }
                    curX = moveX;
                    curY = moveY;
                }
            }
            pi.next();
        }
        return -1;
    }

    private void reverseCopy(double[] coords) {
        double[] temp = new double[coords.length];
        System.arraycopy(coords, 0, temp, 0, coords.length);
        int i = 0;
        while (i < coords.length) {
            coords[i] = temp[coords.length - i - 2];
            coords[i + 1] = temp[coords.length - i - 1];
            i += 2;
        }
    }

    private double getAreaBoundsSquare() {
        Rectangle2D bounds = this.getBounds2D();
        return bounds.getHeight() * bounds.getWidth();
    }

    private boolean isVertex(double x, double y) {
        int i = 0;
        while (i < this.coordsSize) {
            if (x != this.coords[i++] || y != this.coords[i++]) continue;
            return true;
        }
        return false;
    }

    private class AreaPathIterator
    implements PathIterator {
        AffineTransform transform;
        Area area;
        int curRuleIndex = 0;
        int curCoordIndex = 0;

        AreaPathIterator(Area area2) {
            this(area2, null);
        }

        AreaPathIterator(Area area2, AffineTransform t) {
            this.area = area2;
            this.transform = t;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.curRuleIndex >= Area.this.rulesSize;
        }

        @Override
        public void next() {
            switch (Area.this.rules[this.curRuleIndex]) {
                case 0: 
                case 1: {
                    this.curCoordIndex += 2;
                    break;
                }
                case 2: {
                    this.curCoordIndex += 4;
                    break;
                }
                case 3: {
                    this.curCoordIndex += 6;
                }
            }
            ++this.curRuleIndex;
        }

        @Override
        public int currentSegment(double[] c) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            int count = 0;
            switch (Area.this.rules[this.curRuleIndex]) {
                case 3: {
                    c[4] = Area.this.coords[this.curCoordIndex + 4];
                    c[5] = Area.this.coords[this.curCoordIndex + 5];
                    count = 1;
                }
                case 2: {
                    c[2] = Area.this.coords[this.curCoordIndex + 2];
                    c[3] = Area.this.coords[this.curCoordIndex + 3];
                    ++count;
                }
                case 0: 
                case 1: {
                    c[0] = Area.this.coords[this.curCoordIndex];
                    c[1] = Area.this.coords[this.curCoordIndex + 1];
                    ++count;
                }
            }
            if (this.transform != null) {
                this.transform.transform(c, 0, c, 0, count);
            }
            return Area.this.rules[this.curRuleIndex];
        }

        @Override
        public int currentSegment(float[] c) {
            double[] doubleCoords = new double[6];
            int rule = this.currentSegment(doubleCoords);
            int i = 0;
            while (i < 6) {
                c[i] = (float)doubleCoords[i];
                ++i;
            }
            return rule;
        }
    }
}

