/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Jpeg
extends Image {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APP2 = 226;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID;
    private byte[][] icc;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        JFIF_ID = byArray;
    }

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    public Jpeg(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    public Jpeg(byte[] img, float width, float height) throws BadElementException, IOException {
        this(img);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    private static final int getShort(InputStream is) throws IOException {
        return (is.read() << 8) + is.read();
    }

    private static final int marker(int marker) {
        int i = 0;
        while (i < VALID_MARKERS.length) {
            if (marker == VALID_MARKERS[i]) {
                return 0;
            }
            ++i;
        }
        i = 0;
        while (i < NOPARAM_MARKERS.length) {
            if (marker == NOPARAM_MARKERS[i]) {
                return 2;
            }
            ++i;
        }
        i = 0;
        while (i < UNSUPPORTED_MARKERS.length) {
            if (marker == UNSUPPORTED_MARKERS[i]) {
                return 1;
            }
            ++i;
        }
        return -1;
    }

    private void processParameters() throws BadElementException, IOException {
        this.type = 32;
        this.originalType = 1;
        InputStream is = null;
        try {
            String errorID;
            if (this.rawData == null) {
                is = this.url.openStream();
                errorID = this.url.toString();
            } else {
                is = new ByteArrayInputStream(this.rawData);
                errorID = "Byte array";
            }
            if (is.read() != 255 || is.read() != 216) {
                throw new BadElementException(String.valueOf(errorID) + " is not a valid JPEG-file.");
            }
            boolean firstPass = true;
            while (true) {
                int len;
                int v;
                if ((v = is.read()) < 0) {
                    throw new IOException("Premature EOF while reading JPG.");
                }
                if (v != 255) continue;
                int marker = is.read();
                if (firstPass && marker == 224) {
                    firstPass = false;
                    len = Jpeg.getShort(is);
                    if (len < 16) {
                        Utilities.skip(is, len - 2);
                        continue;
                    }
                    byte[] bcomp = new byte[JFIF_ID.length];
                    int r = is.read(bcomp);
                    if (r != bcomp.length) {
                        throw new BadElementException(String.valueOf(errorID) + " corrupted JFIF marker.");
                    }
                    boolean found = true;
                    int k = 0;
                    while (k < bcomp.length) {
                        if (bcomp[k] != JFIF_ID[k]) {
                            found = false;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        Utilities.skip(is, len - 2 - bcomp.length);
                        continue;
                    }
                    Utilities.skip(is, 2);
                    int units = is.read();
                    int dx = Jpeg.getShort(is);
                    int dy = Jpeg.getShort(is);
                    if (units == 1) {
                        this.dpiX = dx;
                        this.dpiY = dy;
                    } else if (units == 2) {
                        this.dpiX = (int)((float)dx * 2.54f + 0.5f);
                        this.dpiY = (int)((float)dy * 2.54f + 0.5f);
                    }
                    Utilities.skip(is, len - 2 - bcomp.length - 7);
                    continue;
                }
                if (marker == 238) {
                    String appe;
                    len = Jpeg.getShort(is) - 2;
                    byte[] byteappe = new byte[len];
                    int k = 0;
                    while (k < len) {
                        byteappe[k] = (byte)is.read();
                        ++k;
                    }
                    if (byteappe.length < 12 || !(appe = new String(byteappe, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                    this.invert = true;
                    continue;
                }
                if (marker == 226) {
                    len = Jpeg.getShort(is) - 2;
                    byte[] byteapp2 = new byte[len];
                    int k = 0;
                    while (k < len) {
                        byteapp2[k] = (byte)is.read();
                        ++k;
                    }
                    if (byteapp2.length < 14) continue;
                    String app2 = new String(byteapp2, 0, 11, "ISO-8859-1");
                    app2.equals("ICC_PROFILE");
                    continue;
                }
                firstPass = false;
                int markertype = Jpeg.marker(marker);
                if (markertype == 0) {
                    Utilities.skip(is, 2);
                    if (is.read() != 8) {
                        throw new BadElementException(String.valueOf(errorID) + " must have 8 bits per component.");
                    }
                    this.scaledHeight = Jpeg.getShort(is);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(is);
                    this.setRight(this.scaledWidth);
                    this.colorspace = is.read();
                    this.bpc = 8;
                    break;
                }
                if (markertype == 1) {
                    throw new BadElementException(String.valueOf(errorID) + ": unsupported JPEG marker: " + marker);
                }
                if (markertype == 2) continue;
                Utilities.skip(is, Jpeg.getShort(is) - 2);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
        if (this.icc != null) {
            int total = 0;
            int k = 0;
            while (k < this.icc.length) {
                if (this.icc[k] == null) {
                    this.icc = null;
                    return;
                }
                total += this.icc[k].length - 14;
                ++k;
            }
            byte[] ficc = new byte[total];
            total = 0;
            int k2 = 0;
            while (k2 < this.icc.length) {
                System.arraycopy(this.icc[k2], 14, ficc, total, this.icc[k2].length - 14);
                total += this.icc[k2].length - 14;
                ++k2;
            }
            this.icc = null;
        }
    }
}

