/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo.activity;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.Adapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ViewAnimator;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.Hit;
import com.artifex.mupdfdemo.MuPDFAlert;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFPageAdapter;
import com.artifex.mupdfdemo.MuPDFReaderView;
import com.artifex.mupdfdemo.MuPDFReaderViewListener;
import com.artifex.mupdfdemo.MuPDFView;
import com.artifex.mupdfdemo.OutlineActivityData;
import com.artifex.mupdfdemo.OutlineItem;
import com.artifex.mupdfdemo.ReaderView;
import com.artifex.mupdfdemo.SearchTask;
import com.artifex.mupdfdemo.SearchTaskResult;
import com.artifex.mupdfdemo.activity.OutlineActivity;
import com.artifex.mupdfdemo.activity.SavePdf;
import com.artifex.mupdfdemo.widget.VDHDeepLayout;
import com.lonelypluto.pdflibrary.R;
import com.lonelypluto.pdflibrary.utils.Logger;
import com.lonelypluto.pdflibrary.utils.SharedPreferencesUtil;
import java.util.concurrent.Executor;

public class OpenPDFActivity
extends AppCompatActivity {
    private static final String TAG = OpenPDFActivity.class.getSimpleName();
    private final int OUTLINE_REQUEST = 0;
    private String filePath = Environment.getExternalStorageDirectory() + "/pdf_t1.pdf";
    private String fileName;
    private AlertDialog.Builder mAlertBuilder;
    private static AlertDialog.Builder gAlertBuilder;
    private MuPDFCore muPDFCore;
    private MuPDFReaderView muPDFReaderView;
    private boolean mAlertsActive = false;
    private AsyncTask<Void, Void, MuPDFAlert> mAlertTask;
    private AlertDialog mAlertDialog;
    private ViewAnimator mTopBarSwitcher;
    private ImageButton mLinkButton;
    private ImageButton mOutlineButton;
    private ImageButton mSearchButton;
    private ImageButton mAnnotButton;
    private EditText mSearchText;
    private ImageButton mSearchBack;
    private ImageButton mSearchFwd;
    private TextView mAnnotTypeText;
    private TextView mPageNumberView;
    private SeekBar mPageSlider;
    private int mPageSliderRes;
    private boolean mButtonsVisible;
    private TopBarMode mTopBarMode = TopBarMode.Main;
    private AcceptMode mAcceptMode;
    private SearchTask mSearchTask;
    private boolean mLinkHighlight = false;
    private Button btn_change_hv;
    private boolean ischangeHV = false;
    private Button btn_linkhighlightcolor;
    private Button btn_searchtextcolor;
    private Button btn_paintcolor;
    private Button btn_paintstrokewidth;
    private Button btn_sign;
    private Button btn_save;
    private VDHDeepLayout vdhDeepLayout;
    private ImageView iv_sign;
    private ImageView iv_test;
    private SavePdfTask savePdfTask;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_open_pdf);
        this.initView();
    }

    private void initView() {
        SharedPreferencesUtil.init(this.getApplication());
        this.muPDFReaderView = (MuPDFReaderView)this.findViewById(R.id.open_pdf_mupdfreaderview);
        this.initToolsView();
        gAlertBuilder = this.mAlertBuilder = new AlertDialog.Builder((Context)this);
        String path = this.filePath;
        this.muPDFCore = this.openFile(path);
        SearchTaskResult.set(null);
        if (this.muPDFCore == null) {
            AlertDialog alert = this.mAlertBuilder.create();
            alert.setTitle(R.string.cannot_open_document);
            alert.setButton(-1, (CharSequence)this.getString(R.string.dismiss), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    OpenPDFActivity.this.finish();
                }
            });
            alert.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    OpenPDFActivity.this.finish();
                }
            });
            alert.show();
            return;
        }
        this.createUI();
        this.btn_change_hv = (Button)this.findViewById(R.id.btn_change_hv);
        this.btn_change_hv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OpenPDFActivity.this.ischangeHV) {
                    OpenPDFActivity.this.muPDFReaderView.setHorizontalScrolling(OpenPDFActivity.this.ischangeHV);
                    OpenPDFActivity.this.btn_change_hv.setText((CharSequence)"\u6a2a");
                    OpenPDFActivity.this.ischangeHV = false;
                } else {
                    OpenPDFActivity.this.muPDFReaderView.setHorizontalScrolling(OpenPDFActivity.this.ischangeHV);
                    OpenPDFActivity.this.btn_change_hv.setText((CharSequence)"\u7ad6");
                    OpenPDFActivity.this.ischangeHV = true;
                }
            }
        });
        this.btn_linkhighlightcolor = (Button)this.findViewById(R.id.btn_linkhighlightcolor);
        this.btn_linkhighlightcolor.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.setLinkHighlightColor(ContextCompat.getColor((Context)OpenPDFActivity.this, (int)R.color.link_bg));
            }
        });
        this.btn_searchtextcolor = (Button)this.findViewById(R.id.btn_searchtextcolor);
        this.btn_searchtextcolor.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.setSearchTextColor(ContextCompat.getColor((Context)OpenPDFActivity.this, (int)R.color.search_bg));
            }
        });
        this.btn_paintcolor = (Button)this.findViewById(R.id.btn_set_paint_color);
        this.btn_paintcolor.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int c = ContextCompat.getColor((Context)OpenPDFActivity.this, (int)R.color.rv_item_line_bg);
                Logger.e(TAG, "color = " + c);
                OpenPDFActivity.this.setColor(c);
                OpenPDFActivity.this.setInkColor(-16776961);
            }
        });
        this.btn_paintstrokewidth = (Button)this.findViewById(R.id.btn_set_paint_strokewidth);
        this.btn_paintstrokewidth.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.setPaintStrockWidth(20.0f);
            }
        });
        this.btn_sign = (Button)this.findViewById(R.id.btn_sign);
        this.btn_sign.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Logger.e(TAG, "btn_sign");
                OpenPDFActivity.this.vdhDeepLayout.setVisibility(0);
            }
        });
        this.btn_save = (Button)this.findViewById(R.id.btn_save);
        this.btn_save.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Logger.e(TAG, "btn_save");
                String in_path = OpenPDFActivity.this.filePath;
                String out_path = in_path.substring(0, in_path.length() - 4) + "_t2.pdf";
                SavePdf savePdf = new SavePdf(in_path, out_path);
                savePdf.setScale(OpenPDFActivity.this.muPDFReaderView.getCurrentScale());
                savePdf.setPageNum(OpenPDFActivity.this.muPDFReaderView.getDisplayedViewIndex() + 1);
                savePdf.setWidthScale(1.0f * OpenPDFActivity.this.muPDFReaderView.getScaleX() / (float)OpenPDFActivity.this.muPDFReaderView.getDisplayedView().getWidth());
                savePdf.setHeightScale(1.0f * OpenPDFActivity.this.muPDFReaderView.getScaleY() / (float)OpenPDFActivity.this.muPDFReaderView.getDisplayedView().getHeight());
                Logger.e(TAG, "scaleX = " + OpenPDFActivity.this.muPDFReaderView.getScaleX() + "   " + OpenPDFActivity.this.muPDFReaderView.getDisplayedView().getWidth());
                savePdf.setWH(OpenPDFActivity.this.iv_sign.getX(), OpenPDFActivity.this.iv_sign.getY());
                DisplayMetrics metric = new DisplayMetrics();
                OpenPDFActivity.this.getWindowManager().getDefaultDisplay().getMetrics(metric);
                float density = metric.density;
                savePdf.setDensity(density);
                Bitmap bitmap = OpenPDFActivity.getBitmap((Context)OpenPDFActivity.this, R.mipmap.ic_launcher);
                savePdf.setBitmap(bitmap);
                Logger.e(TAG, "iv_p = " + OpenPDFActivity.this.iv_sign.getX() + " " + OpenPDFActivity.this.iv_sign.getY());
                Logger.e(TAG, "\u5c4f\u5e55 = " + OpenPDFActivity.this.vdhDeepLayout.getWidth() + " " + OpenPDFActivity.this.vdhDeepLayout.getHeight());
                OpenPDFActivity.this.savePdfTask = new SavePdfTask(savePdf);
                OpenPDFActivity.this.savePdfTask.execute(new Object[0]);
            }
        });
        this.vdhDeepLayout = (VDHDeepLayout)this.findViewById(R.id.VDHDeepLayout);
        this.iv_sign = (ImageView)this.findViewById(R.id.iv_sign);
        this.iv_test = (ImageView)this.findViewById(R.id.iv_test);
    }

    private static Bitmap getBitmap(Context context, int vectorDrawableId) {
        Bitmap bitmap = null;
        if (Build.VERSION.SDK_INT > 21) {
            Drawable vectorDrawable = context.getDrawable(vectorDrawableId);
            bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            vectorDrawable.draw(canvas);
        } else {
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)vectorDrawableId);
        }
        return bitmap;
    }

    public void setColor(int color2) {
        int red = (color2 & 0xFF0000) >> 16;
        int green = (color2 & 0xFF00) >> 8;
        int blue = color2 & 0xFF;
        Logger.e(TAG, "r = " + red + " g = " + green + " b = " + blue);
    }

    private void initToolsView() {
        this.mTopBarSwitcher = (ViewAnimator)this.findViewById(R.id.switcher);
        this.mLinkButton = (ImageButton)this.findViewById(R.id.linkButton);
        this.mAnnotButton = (ImageButton)this.findViewById(R.id.reflowButton);
        this.mOutlineButton = (ImageButton)this.findViewById(R.id.outlineButton);
        this.mSearchButton = (ImageButton)this.findViewById(R.id.searchButton);
        this.mSearchText = (EditText)this.findViewById(R.id.searchText);
        this.mSearchBack = (ImageButton)this.findViewById(R.id.searchBack);
        this.mSearchFwd = (ImageButton)this.findViewById(R.id.searchForward);
        this.mAnnotTypeText = (TextView)this.findViewById(R.id.annotType);
        this.mPageNumberView = (TextView)this.findViewById(R.id.pageNumber);
        this.mPageSlider = (SeekBar)this.findViewById(R.id.pageSlider);
        this.mTopBarSwitcher.setVisibility(4);
        this.mPageNumberView.setVisibility(4);
        this.mPageSlider.setVisibility(4);
    }

    private MuPDFCore openFile(String path) {
        int lastSlashPos = path.lastIndexOf(47);
        this.fileName = new String(lastSlashPos == -1 ? path : path.substring(lastSlashPos + 1));
        Logger.e(TAG, "filename = " + this.fileName);
        Logger.e(TAG, "Trying to open " + path);
        try {
            this.muPDFCore = new MuPDFCore((Context)this, path);
            OutlineActivityData.set(null);
        }
        catch (Exception e) {
            Logger.e(TAG, "openFile catch:" + e.toString());
            return null;
        }
        catch (OutOfMemoryError e) {
            Logger.e(TAG, "openFile catch: OutOfMemoryError " + e.toString());
            return null;
        }
        return this.muPDFCore;
    }

    private void createUI() {
        if (this.muPDFCore == null) {
            return;
        }
        int smax = Math.max(this.muPDFCore.countPages() - 1, 1);
        this.mPageSliderRes = (10 + smax - 1) / smax * 2;
        this.muPDFReaderView.setListener(new MuPDFReaderViewListener(){

            @Override
            public void onMoveToChild(int i) {
                if (OpenPDFActivity.this.muPDFCore == null) {
                    return;
                }
                OpenPDFActivity.this.mPageNumberView.setText((CharSequence)String.format("%d / %d", i + 1, OpenPDFActivity.this.muPDFCore.countPages()));
                OpenPDFActivity.this.mPageSlider.setMax((OpenPDFActivity.this.muPDFCore.countPages() - 1) * OpenPDFActivity.this.mPageSliderRes);
                OpenPDFActivity.this.mPageSlider.setProgress(i * OpenPDFActivity.this.mPageSliderRes);
            }

            @Override
            public void onTapMainDocArea() {
                if (!OpenPDFActivity.this.mButtonsVisible) {
                    OpenPDFActivity.this.showButtons();
                } else if (OpenPDFActivity.this.mTopBarMode == TopBarMode.Main) {
                    OpenPDFActivity.this.hideButtons();
                }
            }

            @Override
            public void onDocMotion() {
                OpenPDFActivity.this.hideButtons();
            }

            @Override
            public void onHit(Hit item) {
                switch (OpenPDFActivity.this.mTopBarMode) {
                    case Annot: {
                        if (item != Hit.Annotation) break;
                        OpenPDFActivity.this.showButtons();
                        OpenPDFActivity.this.mTopBarMode = TopBarMode.Delete;
                        OpenPDFActivity.this.mTopBarSwitcher.setDisplayedChild(OpenPDFActivity.this.mTopBarMode.ordinal());
                        break;
                    }
                    case Delete: {
                        OpenPDFActivity.this.mTopBarMode = TopBarMode.Annot;
                        OpenPDFActivity.this.mTopBarSwitcher.setDisplayedChild(OpenPDFActivity.this.mTopBarMode.ordinal());
                    }
                    default: {
                        MuPDFView pageView = (MuPDFView)OpenPDFActivity.this.muPDFReaderView.getDisplayedView();
                        if (pageView == null) break;
                        pageView.deselectAnnotation();
                    }
                }
            }
        });
        this.muPDFReaderView.setAdapter((Adapter)new MuPDFPageAdapter((Context)this, this.muPDFCore));
        this.muPDFReaderView.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.muPDFReaderView_bg));
        this.mSearchTask = new SearchTask((Context)this, this.muPDFCore){

            @Override
            protected void onTextFound(SearchTaskResult result) {
                SearchTaskResult.set(result);
                OpenPDFActivity.this.muPDFReaderView.setDisplayedViewIndex(result.pageNumber);
                OpenPDFActivity.this.muPDFReaderView.resetupChildren();
            }
        };
        this.mPageSlider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                OpenPDFActivity.this.muPDFReaderView.setDisplayedViewIndex((seekBar.getProgress() + OpenPDFActivity.this.mPageSliderRes / 2) / OpenPDFActivity.this.mPageSliderRes);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                OpenPDFActivity.this.updatePageNumView((progress + OpenPDFActivity.this.mPageSliderRes / 2) / OpenPDFActivity.this.mPageSliderRes);
            }
        });
        this.mSearchButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.searchModeOn();
            }
        });
        if (this.muPDFCore.fileFormat().startsWith("PDF") && this.muPDFCore.isUnencryptedPDF() && !this.muPDFCore.wasOpenedFromBuffer()) {
            this.mAnnotButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    OpenPDFActivity.this.mTopBarMode = TopBarMode.Annot;
                    OpenPDFActivity.this.mTopBarSwitcher.setDisplayedChild(OpenPDFActivity.this.mTopBarMode.ordinal());
                }
            });
        } else {
            this.mAnnotButton.setVisibility(8);
        }
        this.mSearchBack.setEnabled(false);
        this.mSearchFwd.setEnabled(false);
        this.mSearchBack.setColorFilter(Color.argb((int)255, (int)250, (int)250, (int)250));
        this.mSearchFwd.setColorFilter(Color.argb((int)255, (int)250, (int)250, (int)250));
        this.mSearchText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                boolean haveText = s.toString().length() > 0;
                OpenPDFActivity.this.setButtonEnabled(OpenPDFActivity.this.mSearchBack, haveText);
                OpenPDFActivity.this.setButtonEnabled(OpenPDFActivity.this.mSearchFwd, haveText);
                if (SearchTaskResult.get() != null && !OpenPDFActivity.this.mSearchText.getText().toString().equals(SearchTaskResult.get().txt)) {
                    SearchTaskResult.set(null);
                    OpenPDFActivity.this.muPDFReaderView.resetupChildren();
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mSearchText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    OpenPDFActivity.this.search(1);
                }
                return false;
            }
        });
        this.mSearchText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 66) {
                    OpenPDFActivity.this.search(1);
                }
                return false;
            }
        });
        this.mSearchBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.search(-1);
            }
        });
        this.mSearchFwd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.search(1);
            }
        });
        this.mLinkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenPDFActivity.this.setLinkHighlight(!OpenPDFActivity.this.mLinkHighlight);
            }
        });
        if (this.muPDFCore.hasOutline()) {
            this.mOutlineButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    OutlineItem[] outline = OpenPDFActivity.this.muPDFCore.getOutline();
                    if (outline != null) {
                        OutlineActivityData.get().items = outline;
                        Intent intent = new Intent((Context)OpenPDFActivity.this, OutlineActivity.class);
                        OpenPDFActivity.this.startActivityForResult(intent, 0);
                    }
                }
            });
        } else {
            this.mOutlineButton.setVisibility(8);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 0: {
                if (resultCode < 0) break;
                this.muPDFReaderView.setDisplayedViewIndex(resultCode);
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void showButtons() {
        if (this.muPDFCore == null) {
            return;
        }
        if (!this.mButtonsVisible) {
            this.mButtonsVisible = true;
            int index = this.muPDFReaderView.getDisplayedViewIndex();
            this.updatePageNumView(index);
            this.mPageSlider.setMax((this.muPDFCore.countPages() - 1) * this.mPageSliderRes);
            this.mPageSlider.setProgress(index * this.mPageSliderRes);
            if (this.mTopBarMode == TopBarMode.Search) {
                this.mSearchText.requestFocus();
                this.showKeyboard();
            }
            TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, (float)(-this.mTopBarSwitcher.getHeight()), 0.0f);
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    OpenPDFActivity.this.mTopBarSwitcher.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                }
            });
            this.mTopBarSwitcher.startAnimation((Animation)anim);
            anim = new TranslateAnimation(0.0f, 0.0f, (float)this.mPageSlider.getHeight(), 0.0f);
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    OpenPDFActivity.this.mPageSlider.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    OpenPDFActivity.this.mPageNumberView.setVisibility(0);
                }
            });
            this.mPageSlider.startAnimation((Animation)anim);
        }
    }

    private void hideButtons() {
        if (this.mButtonsVisible) {
            this.mButtonsVisible = false;
            this.hideKeyboard();
            TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-this.mTopBarSwitcher.getHeight()));
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    OpenPDFActivity.this.mTopBarSwitcher.setVisibility(4);
                }
            });
            this.mTopBarSwitcher.startAnimation((Animation)anim);
            anim = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.mPageSlider.getHeight());
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    OpenPDFActivity.this.mPageNumberView.setVisibility(4);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    OpenPDFActivity.this.mPageSlider.setVisibility(4);
                }
            });
            this.mPageSlider.startAnimation((Animation)anim);
        }
    }

    private void updatePageNumView(int index) {
        if (this.muPDFCore == null) {
            return;
        }
        this.mPageNumberView.setText((CharSequence)String.format("%d / %d", index + 1, this.muPDFCore.countPages()));
    }

    private void showKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInput((View)this.mSearchText, 0);
        }
    }

    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.mSearchText.getWindowToken(), 0);
        }
    }

    public void OnEditAnnotButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Main;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnCopyTextButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.CopyText;
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText((CharSequence)this.getString(R.string.copy_text));
        this.showInfo(this.getString(R.string.select_text));
    }

    public void OnCancelSearchButtonClick(View v) {
        this.searchModeOff();
    }

    public void OnCancelMoreButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Main;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    private void searchModeOn() {
        if (this.mTopBarMode != TopBarMode.Search) {
            this.mTopBarMode = TopBarMode.Search;
            this.mSearchText.requestFocus();
            this.showKeyboard();
            this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        }
    }

    private void searchModeOff() {
        if (this.mTopBarMode == TopBarMode.Search) {
            this.mTopBarMode = TopBarMode.Main;
            this.hideKeyboard();
            this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
            SearchTaskResult.set(null);
            this.muPDFReaderView.resetupChildren();
        }
    }

    public void OnHighlightButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.Highlight;
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText(R.string.pdf_tools_highlight);
        this.showInfo(this.getString(R.string.select_text));
    }

    public void OnUnderlineButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.Underline;
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText(R.string.pdf_tools_underline);
        this.showInfo(this.getString(R.string.select_text));
    }

    public void OnStrikeOutButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.StrikeOut;
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText(R.string.pdf_tools_strike_out);
        this.showInfo(this.getString(R.string.select_text));
    }

    public void OnInkButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.Ink;
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Drawing);
        this.mAnnotTypeText.setText(R.string.pdf_tools_ink);
        this.showInfo(this.getString(R.string.pdf_tools_draw_annotation));
    }

    public void OnDeleteButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.muPDFReaderView.getDisplayedView();
        if (pageView != null) {
            pageView.deleteSelectedAnnotation();
        }
        this.mTopBarMode = TopBarMode.Annot;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnCancelDeleteButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.muPDFReaderView.getDisplayedView();
        if (pageView != null) {
            pageView.deselectAnnotation();
        }
        this.mTopBarMode = TopBarMode.Annot;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnCancelAcceptButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.muPDFReaderView.getDisplayedView();
        if (pageView != null) {
            pageView.deselectText();
            pageView.cancelDraw();
        }
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Viewing);
        switch (this.mAcceptMode) {
            case CopyText: {
                this.mTopBarMode = TopBarMode.Main;
                break;
            }
            default: {
                this.mTopBarMode = TopBarMode.Annot;
            }
        }
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnAcceptButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.muPDFReaderView.getDisplayedView();
        boolean success = false;
        switch (this.mAcceptMode) {
            case CopyText: {
                if (pageView != null) {
                    success = pageView.copySelection();
                }
                this.mTopBarMode = TopBarMode.Main;
                this.showInfo(success ? this.getString(R.string.copied_to_clipboard) : this.getString(R.string.no_text_selected));
                break;
            }
            case Highlight: {
                if (pageView != null) {
                    success = pageView.markupSelection(Annotation.Type.HIGHLIGHT);
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(R.string.no_text_selected));
                break;
            }
            case Underline: {
                if (pageView != null) {
                    success = pageView.markupSelection(Annotation.Type.UNDERLINE);
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(R.string.no_text_selected));
                break;
            }
            case StrikeOut: {
                if (pageView != null) {
                    success = pageView.markupSelection(Annotation.Type.STRIKEOUT);
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(R.string.no_text_selected));
                break;
            }
            case Ink: {
                if (pageView != null) {
                    success = pageView.saveDraw();
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(R.string.nothing_to_save));
            }
        }
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.muPDFReaderView.setMode(MuPDFReaderView.Mode.Viewing);
    }

    private void setButtonEnabled(ImageButton button, boolean enabled) {
        button.setEnabled(enabled);
        button.setColorFilter(enabled ? Color.argb((int)255, (int)250, (int)250, (int)250) : Color.argb((int)255, (int)250, (int)250, (int)250));
    }

    private void search(int direction) {
        this.hideKeyboard();
        int displayPage = this.muPDFReaderView.getDisplayedViewIndex();
        SearchTaskResult r = SearchTaskResult.get();
        int searchPage = r != null ? r.pageNumber : -1;
        this.mSearchTask.go(this.mSearchText.getText().toString(), direction, displayPage, searchPage);
    }

    private void setLinkHighlight(boolean highlight) {
        this.mLinkHighlight = highlight;
        this.mLinkButton.setColorFilter(highlight ? Color.argb((int)255, (int)255, (int)160, (int)0) : Color.argb((int)255, (int)255, (int)255, (int)255));
        this.muPDFReaderView.setLinksEnabled(highlight);
    }

    private void setLinkHighlightColor(int color2) {
        this.muPDFReaderView.setLinkHighlightColor(color2);
    }

    private void setSearchTextColor(int color2) {
        this.muPDFReaderView.setSearchTextColor(color2);
    }

    private void setInkColor(int color2) {
        this.muPDFReaderView.setInkColor(color2);
    }

    private void setPaintStrockWidth(float inkThickness) {
        this.muPDFReaderView.setPaintStrockWidth(inkThickness);
    }

    private void showInfo(String message) {
        LayoutInflater inflater = this.getLayoutInflater();
        View toastLayout = inflater.inflate(R.layout.toast, (ViewGroup)this.findViewById(R.id.toast_root_view));
        TextView header = (TextView)toastLayout.findViewById(R.id.toast_message);
        header.setText((CharSequence)message);
        Toast toast = new Toast(this.getApplicationContext());
        toast.setGravity(87, 0, 0);
        toast.setDuration(1);
        toast.setView(toastLayout);
        toast.show();
    }

    public static AlertDialog.Builder getAlertBuilder() {
        return gAlertBuilder;
    }

    public void createAlertWaiter() {
        this.mAlertsActive = true;
        if (this.mAlertTask != null) {
            this.mAlertTask.cancel(true);
            this.mAlertTask = null;
        }
        if (this.mAlertDialog != null) {
            this.mAlertDialog.cancel();
            this.mAlertDialog = null;
        }
        this.mAlertTask = new AsyncTask<Void, Void, MuPDFAlert>(){

            protected MuPDFAlert doInBackground(Void ... arg0) {
                if (!OpenPDFActivity.this.mAlertsActive) {
                    return null;
                }
                return OpenPDFActivity.this.muPDFCore.waitForAlert();
            }

            protected void onPostExecute(final MuPDFAlert result) {
                if (result == null) {
                    return;
                }
                final MuPDFAlert.ButtonPressed[] pressed = new MuPDFAlert.ButtonPressed[3];
                for (int i = 0; i < 3; ++i) {
                    pressed[i] = MuPDFAlert.ButtonPressed.None;
                }
                DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        OpenPDFActivity.this.mAlertDialog = null;
                        if (OpenPDFActivity.this.mAlertsActive) {
                            int index = 0;
                            switch (which) {
                                case -1: {
                                    index = 0;
                                    break;
                                }
                                case -2: {
                                    index = 1;
                                    break;
                                }
                                case -3: {
                                    index = 2;
                                }
                            }
                            result.buttonPressed = pressed[index];
                            OpenPDFActivity.this.muPDFCore.replyToAlert(result);
                            OpenPDFActivity.this.createAlertWaiter();
                        }
                    }
                };
                OpenPDFActivity.this.mAlertDialog = OpenPDFActivity.this.mAlertBuilder.create();
                OpenPDFActivity.this.mAlertDialog.setTitle((CharSequence)result.title);
                OpenPDFActivity.this.mAlertDialog.setMessage((CharSequence)result.message);
                switch (result.iconType) {
                    case Error: {
                        break;
                    }
                    case Warning: {
                        break;
                    }
                    case Question: {
                        break;
                    }
                }
                switch (result.buttonGroupType) {
                    case OkCancel: {
                        OpenPDFActivity.this.mAlertDialog.setButton(-2, (CharSequence)OpenPDFActivity.this.getString(R.string.cancel), listener);
                        pressed[1] = MuPDFAlert.ButtonPressed.Cancel;
                    }
                    case Ok: {
                        OpenPDFActivity.this.mAlertDialog.setButton(-1, (CharSequence)OpenPDFActivity.this.getString(R.string.okay), listener);
                        pressed[0] = MuPDFAlert.ButtonPressed.Ok;
                        break;
                    }
                    case YesNoCancel: {
                        OpenPDFActivity.this.mAlertDialog.setButton(-3, (CharSequence)OpenPDFActivity.this.getString(R.string.cancel), listener);
                        pressed[2] = MuPDFAlert.ButtonPressed.Cancel;
                    }
                    case YesNo: {
                        OpenPDFActivity.this.mAlertDialog.setButton(-1, (CharSequence)OpenPDFActivity.this.getString(R.string.yes), listener);
                        pressed[0] = MuPDFAlert.ButtonPressed.Yes;
                        OpenPDFActivity.this.mAlertDialog.setButton(-2, (CharSequence)OpenPDFActivity.this.getString(R.string.no), listener);
                        pressed[1] = MuPDFAlert.ButtonPressed.No;
                    }
                }
                OpenPDFActivity.this.mAlertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        OpenPDFActivity.this.mAlertDialog = null;
                        if (OpenPDFActivity.this.mAlertsActive) {
                            result.buttonPressed = MuPDFAlert.ButtonPressed.None;
                            OpenPDFActivity.this.muPDFCore.replyToAlert(result);
                            OpenPDFActivity.this.createAlertWaiter();
                        }
                    }
                });
                OpenPDFActivity.this.mAlertDialog.show();
            }
        };
        this.mAlertTask.executeOnExecutor((Executor)new ThreadPerTaskExecutor(), (Object[])new Void[0]);
    }

    public void destroyAlertWaiter() {
        this.mAlertsActive = false;
        if (this.mAlertDialog != null) {
            this.mAlertDialog.cancel();
            this.mAlertDialog = null;
        }
        if (this.mAlertTask != null) {
            this.mAlertTask.cancel(true);
            this.mAlertTask = null;
        }
    }

    protected void onStart() {
        if (this.muPDFCore != null) {
            this.muPDFCore.startAlerts();
            this.createAlertWaiter();
        }
        super.onStart();
    }

    protected void onPause() {
        super.onPause();
        if (this.mSearchTask != null) {
            this.mSearchTask.stop();
        }
    }

    protected void onStop() {
        if (this.muPDFCore != null) {
            this.destroyAlertWaiter();
            this.muPDFCore.stopAlerts();
        }
        super.onStop();
    }

    protected void onDestroy() {
        if (this.muPDFReaderView != null) {
            this.muPDFReaderView.applyToChildren(new ReaderView.ViewMapper(){

                @Override
                public void applyToView(View view) {
                    ((MuPDFView)view).releaseBitmaps();
                }
            });
        }
        if (this.muPDFCore != null) {
            this.muPDFCore.onDestroy();
        }
        if (this.mAlertTask != null) {
            this.mAlertTask.cancel(true);
            this.mAlertTask = null;
        }
        this.muPDFCore = null;
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.muPDFCore != null && this.muPDFCore.hasChanges()) {
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (which == -1) {
                        OpenPDFActivity.this.muPDFCore.save();
                    }
                    OpenPDFActivity.this.finish();
                }
            };
            AlertDialog alert = this.mAlertBuilder.create();
            alert.setTitle(R.string.dialog_title);
            alert.setMessage((CharSequence)this.getString(R.string.document_has_changes_save_them));
            alert.setButton(-1, (CharSequence)this.getString(R.string.yes), listener);
            alert.setButton(-2, (CharSequence)this.getString(R.string.no), listener);
            alert.show();
        } else {
            this.finish();
        }
    }

    static enum AcceptMode {
        Highlight,
        Underline,
        StrikeOut,
        Ink,
        CopyText;

    }

    static enum TopBarMode {
        Main,
        Search,
        Annot,
        Delete,
        Accept;

    }

    class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }

    class SavePdfTask
    extends AsyncTask {
        SavePdf savePdf;

        public SavePdfTask(SavePdf savePdf) {
            this.savePdf = savePdf;
        }

        protected Object doInBackground(Object[] params) {
            this.savePdf.addText();
            return null;
        }

        protected void onPostExecute(Object o) {
            Logger.e(TAG, "\u5b58\u50a8\u5b8c\u6210");
        }
    }
}

