/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.artifex.mupdfdemo.OutlineItem;
import com.lonelypluto.pdflibrary.R;

public class OutlineAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context mContext;
    private OutlineItem[] mList;

    public OutlineAdapter(Context context, OutlineItem[] mList) {
        this.mContext = context;
        this.mList = mList;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.outline_item, parent, false);
        return new OutlineViewHolder(itemView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        OutlineItem bean = this.mList[position];
        if (null == bean) {
            return;
        }
        OutlineViewHolder viewHolder = (OutlineViewHolder)holder;
        int level = bean.level;
        if (level > 8) {
            level = 8;
        }
        String space = "";
        for (int i = 0; i < level; ++i) {
            space = space + "   ";
        }
        String text = space + bean.title;
        viewHolder.tv_title.setText((CharSequence)text);
        viewHolder.tv_page.setText((CharSequence)String.valueOf(bean.page + 1));
    }

    public int getItemCount() {
        return this.mList.length;
    }

    public static class OutlineViewHolder
    extends RecyclerView.ViewHolder {
        public TextView tv_title;
        public TextView tv_page;

        public OutlineViewHolder(View itemView) {
            super(itemView);
            this.tv_title = (TextView)itemView.findViewById(R.id.outline_item_title);
            this.tv_page = (TextView)itemView.findViewById(R.id.outline_item_page);
        }
    }
}

