/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo.activity;

import android.graphics.Bitmap;
import com.lonelypluto.pdflibrary.utils.Logger;
import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class SavePdf {
    private float defaultScale = 0.90756303f;
    float widthScale;
    float heightScale;
    String inPath;
    String outPath;
    private int pageNum;
    private Bitmap bitmap;
    private float scale;
    private float density;
    private float width;
    private float height;

    public void setWidthScale(float widthScale) {
        this.widthScale = widthScale;
    }

    public void setHeightScale(float heightScale) {
        this.heightScale = heightScale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setWH(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public SavePdf(String inPath, String outPath) {
        this.inPath = inPath;
        this.outPath = outPath;
    }

    public void addText() {
        try {
            PdfReader reader = new PdfReader(this.inPath, "PDF".getBytes());
            FileOutputStream outputStream = new FileOutputStream(this.outPath);
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)outputStream);
            PdfContentByte over = stamp.getOverContent(this.pageNum);
            byte[] bytes = this.Bitmap2Bytes(this.bitmap);
            Image img = Image.getInstance((byte[])bytes);
            Rectangle rectangle = reader.getPageSize(this.pageNum);
            img.setAlignment(1);
            Logger.e("zyw", "position = " + rectangle.getWidth() * this.widthScale + "  " + rectangle.getHeight() * this.heightScale);
            Logger.e("zyw", "density = " + this.density);
            Logger.e("zyw", "img.getWidth() = " + img.getWidth() + "  img.getHeight() = " + img.getHeight());
            Logger.e("zyw", "scale = " + this.scale);
            Logger.e("zyw", "widthScale = " + this.widthScale + "  heightScale = " + this.heightScale);
            Logger.e("zyw", "bitmap.w = " + this.bitmap.getWidth() + "  bitmap.h = " + this.bitmap.getHeight());
            Logger.e("zyw", "rectangle.getLeft = " + rectangle.getLeft() + "  rectangle.getBottom() = " + rectangle.getBottom());
            Logger.e("zyw", "rectangle.getWidth = " + rectangle.getWidth() + "  rectangle.getHeight = " + rectangle.getHeight());
            Logger.e("zyw", "\u6bd4\u4f8b1 = " + rectangle.getWidth() / img.getWidth() * 100.0f);
            Logger.e("zyw", "\u6bd4\u4f8b2 = " + rectangle.getWidth() * this.widthScale * 100.0f);
            Logger.e("zyw", "\u5750\u6807AbsolutePosition = " + this.width * (rectangle.getWidth() * this.widthScale) + " " + (1964.0f - this.height - img.getHeight()) * (rectangle.getWidth() * this.widthScale));
            Logger.e("zyw", "\u5dee\u503c = " + rectangle.getHeight() * (this.heightScale - this.widthScale));
            Logger.e("zyw", "\u7f29\u653e\u6bd4\u4f8b = " + this.scale / this.defaultScale);
            img.scalePercent(rectangle.getWidth() * this.widthScale * 100.0f);
            img.setAbsolutePosition(this.width * (rectangle.getWidth() * this.widthScale) * this.scale, rectangle.getHeight() - this.height * (rectangle.getWidth() * this.widthScale) * (this.scale / this.defaultScale) + img.getHeight() / 2.0f * this.widthScale * 100.0f);
            over.addImage(img);
            stamp.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public byte[] Bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }
}

