/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo.activity;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.artifex.mupdfdemo.OutlineActivityData;
import com.artifex.mupdfdemo.OutlineItem;
import com.artifex.mupdfdemo.adapter.OutlineAdapter;
import com.artifex.mupdfdemo.widget.OnRecyclerItemClickListener;
import com.lonelypluto.pdflibrary.R;

public class OutlineActivity
extends AppCompatActivity {
    private RecyclerView recyclerView;
    private OutlineAdapter adapter;
    private OutlineItem[] mItems;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_outline);
        this.initData();
        this.initView();
        this.setListener();
    }

    private void initData() {
        this.mItems = OutlineActivityData.get().items;
    }

    private void initView() {
        this.adapter = new OutlineAdapter((Context)this, this.mItems);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.outline_rv);
        this.recyclerView.setHasFixedSize(true);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        linearLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void setListener() {
        this.recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new OnRecyclerItemClickListener(this.recyclerView){

            @Override
            public void onItemClick(RecyclerView.ViewHolder vh) {
                OutlineActivityData.get().position = vh.getLayoutPosition();
                OutlineActivity.this.setResult(((OutlineActivity)OutlineActivity.this).mItems[vh.getLayoutPosition()].page);
                OutlineActivity.this.finish();
            }

            @Override
            public void onItemLongClick(RecyclerView.ViewHolder vh) {
            }
        });
    }
}

