/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.AsyncTask;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.artifex.mupdfdemo.FilePicker;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFPageView;

public class MuPDFPageAdapter
extends BaseAdapter {
    private final Context mContext;
    private final FilePicker.FilePickerSupport mFilePickerSupport;
    private final MuPDFCore mCore;
    private final SparseArray<PointF> mPageSizes = new SparseArray();
    private Bitmap mSharedHqBm;

    public MuPDFPageAdapter(Context c, FilePicker.FilePickerSupport filePickerSupport, MuPDFCore core) {
        this.mContext = c;
        this.mFilePickerSupport = filePickerSupport;
        this.mCore = core;
    }

    public int getCount() {
        return this.mCore.countPages();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public void releaseBitmaps() {
        if (this.mSharedHqBm != null) {
            this.mSharedHqBm.recycle();
        }
        this.mSharedHqBm = null;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        MuPDFPageView pageView;
        if (convertView == null) {
            if (this.mSharedHqBm == null || this.mSharedHqBm.getWidth() != parent.getWidth() || this.mSharedHqBm.getHeight() != parent.getHeight()) {
                this.mSharedHqBm = Bitmap.createBitmap((int)parent.getWidth(), (int)parent.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            pageView = new MuPDFPageView(this.mContext, this.mFilePickerSupport, this.mCore, new Point(parent.getWidth(), parent.getHeight()), this.mSharedHqBm);
        } else {
            pageView = (MuPDFPageView)convertView;
        }
        PointF pageSize = (PointF)this.mPageSizes.get(position);
        if (pageSize != null) {
            pageView.setPage(position, pageSize);
        } else {
            pageView.blank(position);
            AsyncTask<Void, Void, PointF> sizingTask = new AsyncTask<Void, Void, PointF>(){

                protected PointF doInBackground(Void ... arg0) {
                    return MuPDFPageAdapter.this.mCore.getPageSize(position);
                }

                protected void onPostExecute(PointF result) {
                    super.onPostExecute((Object)result);
                    MuPDFPageAdapter.this.mPageSizes.put(position, (Object)result);
                    if (pageView.getPage() == position) {
                        pageView.setPage(position, result);
                    }
                }
            };
            sizingTask.execute((Object[])new Void[]{null});
        }
        return pageView;
    }
}

