/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import repack.org.bouncycastle.crypto.AsymmetricBlockCipher;
import repack.org.bouncycastle.crypto.CipherParameters;
import repack.org.bouncycastle.crypto.InvalidCipherTextException;
import repack.org.bouncycastle.crypto.digests.MD5Digest;
import repack.org.bouncycastle.crypto.digests.SHA1Digest;
import repack.org.bouncycastle.crypto.digests.SHA224Digest;
import repack.org.bouncycastle.crypto.digests.SHA256Digest;
import repack.org.bouncycastle.crypto.digests.SHA384Digest;
import repack.org.bouncycastle.crypto.digests.SHA512Digest;
import repack.org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import repack.org.bouncycastle.crypto.encodings.OAEPEncoding;
import repack.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import repack.org.bouncycastle.crypto.engines.RSAEngine;
import repack.org.bouncycastle.crypto.params.ParametersWithRandom;
import repack.org.bouncycastle.crypto.params.RSAKeyParameters;
import repack.org.bouncycastle.jce.provider.RSAUtil;
import repack.org.bouncycastle.jce.provider.WrapCipherSpi;
import repack.org.bouncycastle.util.Strings;

public class JCERSACipher
extends WrapCipherSpi {
    private AsymmetricBlockCipher cipher;
    private AlgorithmParameterSpec paramSpec;
    private AlgorithmParameters engineParams;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public JCERSACipher(AsymmetricBlockCipher engine) {
        this.cipher = engine;
    }

    public JCERSACipher(boolean publicKeyOnly, boolean privateKeyOnly, AsymmetricBlockCipher engine) {
        this.publicKeyOnly = publicKeyOnly;
        this.privateKeyOnly = privateKeyOnly;
        this.cipher = engine;
    }

    @Override
    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return k.getModulus().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey k = (RSAPublicKey)key;
            return k.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an RSA key!");
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("OAEP", "BC");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String md = Strings.toUpperCase(mode);
        if (md.equals("NONE") || md.equals("ECB")) {
            return;
        }
        if (md.equals("1")) {
            this.privateKeyOnly = true;
            this.publicKeyOnly = false;
            return;
        }
        if (md.equals("2")) {
            this.privateKeyOnly = false;
            this.publicKeyOnly = true;
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String pad = Strings.toUpperCase(padding);
        if (pad.equals("NOPADDING")) {
            this.cipher = new RSAEngine();
        } else if (pad.equals("PKCS1PADDING")) {
            this.cipher = new PKCS1Encoding(new RSAEngine());
        } else if (pad.equals("OAEPPADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine());
        } else if (pad.equals("ISO9796-1PADDING")) {
            this.cipher = new ISO9796d1Encoding(new RSAEngine());
        } else if (pad.equals("OAEPWITHMD5ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine(), new MD5Digest());
        } else if (pad.equals("OAEPWITHSHA1ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine(), new SHA1Digest());
        } else if (pad.equals("OAEPWITHSHA224ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine(), new SHA224Digest());
        } else if (pad.equals("OAEPWITHSHA256ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine(), new SHA256Digest());
        } else if (pad.equals("OAEPWITHSHA384ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine(), new SHA384Digest());
        } else if (pad.equals("OAEPWITHSHA512ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSAEngine(), new SHA512Digest());
        } else {
            throw new NoSuchPaddingException(String.valueOf(padding) + " unavailable with RSA.");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        if (params != null) throw new IllegalArgumentException("unknown parameter type.");
        if (key instanceof RSAPublicKey) {
            if (this.privateKeyOnly) {
                throw new InvalidKeyException("mode 1 requires RSAPrivateKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)key);
        } else {
            if (!(key instanceof RSAPrivateKey)) throw new InvalidKeyException("unknown key type passed to RSA");
            if (this.publicKeyOnly) {
                throw new InvalidKeyException("mode 2 requires RSAPublicKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)key);
        }
        if (!(this.cipher instanceof RSAEngine)) {
            void var5_7;
            if (random != null) {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, random);
            } else {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, new SecureRandom());
            }
        }
        switch (opmode) {
            case 1: 
            case 3: {
                void var5_10;
                this.cipher.init(true, (CipherParameters)var5_10);
                return;
            }
            case 2: 
            case 4: {
                void var5_10;
                this.cipher.init(false, (CipherParameters)var5_10);
                return;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("can't handle parameters in RSA");
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            return this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out;
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            out = this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
        int i = 0;
        while (i != out.length) {
            output[outputOffset + i] = out[i];
            ++i;
        }
        return out.length;
    }

    public static class ISO9796d1Padding
    extends JCERSACipher {
        public ISO9796d1Padding() {
            super(new ISO9796d1Encoding(new RSAEngine()));
        }
    }

    public static class NoPadding
    extends JCERSACipher {
        public NoPadding() {
            super(new RSAEngine());
        }
    }

    public static class OAEPPadding
    extends JCERSACipher {
        public OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine()));
        }
    }

    public static class PKCS1v1_5Padding
    extends JCERSACipher {
        public PKCS1v1_5Padding() {
            super(new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class PKCS1v1_5Padding_PrivateOnly
    extends JCERSACipher {
        public PKCS1v1_5Padding_PrivateOnly() {
            super(false, true, new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class PKCS1v1_5Padding_PublicOnly
    extends JCERSACipher {
        public PKCS1v1_5Padding_PublicOnly() {
            super(true, false, new PKCS1Encoding(new RSAEngine()));
        }
    }
}

