/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.ASN1OctetString;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERBitString;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.DEROctetString;
import repack.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import repack.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import repack.org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.asn1.x9.X962Parameters;
import repack.org.bouncycastle.asn1.x9.X9ECParameters;
import repack.org.bouncycastle.asn1.x9.X9ECPoint;
import repack.org.bouncycastle.asn1.x9.X9IntegerConverter;
import repack.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import repack.org.bouncycastle.crypto.params.ECDomainParameters;
import repack.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import repack.org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import repack.org.bouncycastle.jce.interfaces.ECPointEncoder;
import repack.org.bouncycastle.jce.interfaces.ECPublicKey;
import repack.org.bouncycastle.jce.provider.ProviderUtil;
import repack.org.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import repack.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import repack.org.bouncycastle.jce.spec.ECParameterSpec;
import repack.org.bouncycastle.jce.spec.ECPublicKeySpec;
import repack.org.bouncycastle.math.ec.ECCurve;
import repack.org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    public JCEECPublicKey(String algorithm, JCEECPublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.gostParams = key.gostParams;
    }

    public JCEECPublicKey(String algorithm, ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.q = spec.getQ();
        if (spec.getParams() != null) {
            this.ecSpec = spec.getParams();
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec s = ProviderUtil.getEcImplicitlyCa();
                this.q = s.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = spec == null ? new ECParameterSpec(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed()) : spec;
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params) {
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = null;
    }

    JCEECPublicKey(ECPublicKey key) {
        this.q = key.getQ();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParameters();
    }

    JCEECPublicKey(String algorithm, ECPoint q, ECParameterSpec ecSpec) {
        this.algorithm = algorithm;
        this.q = q;
        this.ecSpec = ecSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo info) {
        this.populateFromPubKeyInfo(info);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        if (info.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString key;
            DERBitString bits = info.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                key = (ASN1OctetString)ASN1Object.fromByteArray(bits.getBytes());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] keyEnc = key.getOctets();
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            int i = 0;
            while (i != x.length) {
                x[i] = keyEnc[31 - i];
                ++i;
            }
            i = 0;
            while (i != y.length) {
                y[i] = keyEnc[63 - i];
                ++i;
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)info.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec spec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = spec;
            this.q = spec.getCurve().createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
        } else {
            int qLength;
            ECCurve curve;
            X962Parameters params = new X962Parameters((DERObject)info.getAlgorithmId().getParameters());
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
                this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName(oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                curve = this.ecSpec.getCurve();
            } else if (params.isImplicitlyCA()) {
                this.ecSpec = null;
                curve = ProviderUtil.getEcImplicitlyCa().getCurve();
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                this.ecSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                curve = this.ecSpec.getCurve();
            }
            DERBitString bits = info.getPublicKeyData();
            byte[] data = bits.getBytes();
            ASN1OctetString key = new DEROctetString(data);
            if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3) && (qLength = new X9IntegerConverter().getByteLength(curve)) >= data.length - 3) {
                try {
                    key = (ASN1OctetString)ASN1Object.fromByteArray(data);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint derQ = new X9ECPoint(curve, key);
            this.q = derQ.getPoint();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo info;
        if (this.algorithm.equals("ECGOST3410")) {
            ASN1Encodable params = null;
            if (this.gostParams != null) {
                params = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                params = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                ECParameterSpec p = this.ecSpec;
                ECCurve curve = p.getG().getCurve();
                ECPoint generator = curve.createPoint(p.getG().getX().toBigInteger(), p.getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters ecP = new X9ECParameters(p.getCurve(), generator, p.getN(), p.getH(), p.getSeed());
                params = new X962Parameters(ecP);
            }
            ECPoint qq = this.getQ();
            ECPoint point = qq.getCurve().createPoint(qq.getX().toBigInteger(), qq.getY().toBigInteger(), false);
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(point).getDERObject();
            BigInteger bX = this.q.getX().toBigInteger();
            BigInteger bY = this.q.getY().toBigInteger();
            byte[] encKey = new byte[64];
            byte[] val = bX.toByteArray();
            int i = 0;
            while (i != 32) {
                encKey[i] = val[val.length - 1 - i];
                ++i;
            }
            val = bY.toByteArray();
            i = 0;
            while (i != 32) {
                encKey[32 + i] = val[val.length - 1 - i];
                ++i;
            }
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, params.getDERObject()), new DEROctetString(encKey));
        } else {
            X962Parameters params = null;
            if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                DERObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                if (curveOid == null) {
                    curveOid = new DERObjectIdentifier(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                }
                params = new X962Parameters(curveOid);
            } else if (this.ecSpec == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                ECParameterSpec p = this.ecSpec;
                ECCurve curve = p.getG().getCurve();
                ECPoint generator = curve.createPoint(p.getG().getX().toBigInteger(), p.getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters ecP = new X9ECParameters(p.getCurve(), generator, p.getN(), p.getH(), p.getSeed());
                params = new X962Parameters(ecP);
            }
            ECCurve curve = this.engineGetQ().getCurve();
            ECPoint point = curve.createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression);
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(point).getDERObject();
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params.getDERObject()), p.getOctets());
        }
        return info.getDEREncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    @Override
    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("EC Public Key").append(nl);
        buf.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    @Override
    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey other = (JCEECPublicKey)o;
        return this.getQ().equals(other.getQ()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(enc)));
        this.algorithm = (String)in.readObject();
        this.withCompression = in.readBoolean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getEncoded());
        out.writeObject(this.algorithm);
        out.writeBoolean(this.withCompression);
    }
}

