/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import repack.org.bouncycastle.crypto.BlockCipher;
import repack.org.bouncycastle.crypto.CipherParameters;
import repack.org.bouncycastle.crypto.InvalidCipherTextException;
import repack.org.bouncycastle.crypto.Wrapper;
import repack.org.bouncycastle.crypto.modes.CBCBlockCipher;
import repack.org.bouncycastle.crypto.params.ParametersWithIV;
import repack.org.bouncycastle.crypto.params.ParametersWithRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher engine) {
        this.engine = new CBCBlockCipher(engine);
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            this.rand = p.getRandom();
            this.param = (ParametersWithIV)p.getParameters();
        } else {
            if (forWrapping) {
                this.rand = new SecureRandom();
            }
            this.param = (ParametersWithIV)param;
        }
    }

    @Override
    public String getAlgorithmName() {
        return String.valueOf(this.engine.getUnderlyingCipher().getAlgorithmName()) + "/RFC3211Wrap";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.engine.init(true, this.param);
        int blockSize = this.engine.getBlockSize();
        byte[] cekBlock = inLen + 4 < blockSize * 2 ? new byte[blockSize * 2] : new byte[(inLen + 4) % blockSize == 0 ? inLen + 4 : ((inLen + 4) / blockSize + 1) * blockSize];
        cekBlock[0] = (byte)inLen;
        cekBlock[1] = ~in[inOff];
        cekBlock[2] = ~in[inOff + 1];
        cekBlock[3] = ~in[inOff + 2];
        System.arraycopy(in, inOff, cekBlock, 4, inLen);
        int i = inLen + 4;
        while (i < cekBlock.length) {
            cekBlock[i] = (byte)this.rand.nextInt();
            ++i;
        }
        i = 0;
        while (i < cekBlock.length) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
            i += blockSize;
        }
        i = 0;
        while (i < cekBlock.length) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
            i += blockSize;
        }
        return cekBlock;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int blockSize = this.engine.getBlockSize();
        if (inLen < 2 * blockSize) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] cekBlock = new byte[inLen];
        byte[] iv = new byte[blockSize];
        System.arraycopy(in, inOff, cekBlock, 0, inLen);
        System.arraycopy(in, inOff, iv, 0, iv.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), iv));
        int i = blockSize;
        while (i < cekBlock.length) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
            i += blockSize;
        }
        System.arraycopy(cekBlock, cekBlock.length - iv.length, iv, 0, iv.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), iv));
        this.engine.processBlock(cekBlock, 0, cekBlock, 0);
        this.engine.init(false, this.param);
        i = 0;
        while (i < cekBlock.length) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
            i += blockSize;
        }
        if ((cekBlock[0] & 0xFF) > cekBlock.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] key = new byte[cekBlock[0] & 0xFF];
        System.arraycopy(cekBlock, 4, key, 0, cekBlock[0]);
        int nonEqual = 0;
        int i2 = 0;
        while (i2 != 3) {
            byte check = ~cekBlock[1 + i2];
            nonEqual |= check ^ key[i2];
            ++i2;
        }
        if (nonEqual != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return key;
    }
}

