/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert.ocsp;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.DERBitString;
import repack.org.bouncycastle.asn1.DERGeneralizedTime;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import repack.org.bouncycastle.asn1.ocsp.CertStatus;
import repack.org.bouncycastle.asn1.ocsp.ResponseData;
import repack.org.bouncycastle.asn1.ocsp.RevokedInfo;
import repack.org.bouncycastle.asn1.ocsp.SingleResponse;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.CRLReason;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.asn1.x509.X509Extensions;
import repack.org.bouncycastle.cert.X509CertificateHolder;
import repack.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import repack.org.bouncycastle.cert.ocsp.CertificateID;
import repack.org.bouncycastle.cert.ocsp.CertificateStatus;
import repack.org.bouncycastle.cert.ocsp.OCSPException;
import repack.org.bouncycastle.cert.ocsp.RespID;
import repack.org.bouncycastle.cert.ocsp.RevokedStatus;
import repack.org.bouncycastle.cert.ocsp.UnknownStatus;
import repack.org.bouncycastle.operator.ContentSigner;
import repack.org.bouncycastle.operator.DigestCalculator;

public class BasicOCSPRespBuilder {
    private List list = new ArrayList();
    private X509Extensions responseExtensions = null;
    private RespID responderID;

    public BasicOCSPRespBuilder(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespBuilder(SubjectPublicKeyInfo key, DigestCalculator digCalc) throws OCSPException {
        this.responderID = new RespID(key, digCalc);
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus) {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, null));
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, X509Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, X509Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), nextUpdate, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder setResponseExtensions(X509Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
        return this;
    }

    public BasicOCSPResp build(ContentSigner signer, X509CertificateHolder[] chain, Date producedAt) throws OCSPException {
        DERBitString bitSig;
        Iterator it = this.list.iterator();
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add(((ResponseObject)it.next()).toResponse());
            }
            catch (Exception e) {
                throw new OCSPException("exception creating Request", e);
            }
        }
        ResponseData tbsResp = new ResponseData(this.responderID.toASN1Object(), new DERGeneralizedTime(producedAt), new DERSequence(responses), this.responseExtensions);
        try {
            OutputStream sigOut = signer.getOutputStream();
            sigOut.write(tbsResp.getEncoded("DER"));
            sigOut.close();
            bitSig = new DERBitString(signer.getSignature());
        }
        catch (Exception e) {
            throw new OCSPException("exception processing TBSRequest: " + e.getMessage(), e);
        }
        AlgorithmIdentifier sigAlgId = signer.getAlgorithmIdentifier();
        DERSequence chainSeq = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            int i = 0;
            while (i != chain.length) {
                v.add(chain[i].toASN1Structure());
                ++i;
            }
            chainSeq = new DERSequence(v);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, chainSeq));
    }

    private class ResponseObject {
        CertificateID certId;
        CertStatus certStatus;
        DERGeneralizedTime thisUpdate;
        DERGeneralizedTime nextUpdate;
        X509Extensions extensions;

        public ResponseObject(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions extensions) {
            RevokedStatus rs;
            this.certId = certId;
            this.certStatus = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, new DERNull()) : ((rs = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new DERGeneralizedTime(rs.getRevocationTime()), new CRLReason(rs.getRevocationReason()))) : new CertStatus(new RevokedInfo(new DERGeneralizedTime(rs.getRevocationTime()), null))));
            this.thisUpdate = new DERGeneralizedTime(thisUpdate);
            this.nextUpdate = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.extensions = extensions;
        }

        public SingleResponse toResponse() throws Exception {
            return new SingleResponse(this.certId.toASN1Object(), this.certStatus, this.thisUpdate, this.nextUpdate, this.extensions);
        }
    }
}

