package com.lonelypluto.pdflibrary.utils;

import android.util.Log;

/**
 * @Description: Log日志
 * @author: ZhangYW
 * @time: 2018/8/21 16:09
 */
public class Logger {

    //设为false关闭日志
    private static final boolean LOG_ENABLE = true;

    public static void i(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.i(tag, msg);
        }
    }

    public static void v(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.v(tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.d(tag, msg);
        }
    }

    public static void w(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.w(tag, msg);
        }
    }

    public static void e(String tag, String msg) {
        if (LOG_ENABLE) {
            int max_str_length = 2001 - tag.length();
            //大于4000时
            while (msg.length() > max_str_length) {
                Log.e(tag, msg.substring(0, max_str_length));
                msg = msg.substring(max_str_length);
            }
            Log.e(tag, msg);
        }
//        int max_str_length = 2001 - tag.length();
//        //大于4000时
//        while (msg.length() > max_str_length) {
//            Log.e(tag, msg.substring(0, max_str_length));
//            msg = msg.substring(max_str_length);
//        }
//        //剩余部分
//        Log.e(tag, msg);
    }

}
