/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotocorelib.api.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.logmein.gotocorelib.api.model.TokenResponse;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JsonUtil {
    public static ObjectMapper mapper;
    private static SimpleDateFormat sdf;

    private static Module getModule() {
        SimpleModule module = new SimpleModule("BooleanAsString", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(Boolean.class, (JsonDeserializer)new JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                String value = jp.getValueAsString();
                return "true".equalsIgnoreCase(value);
            }
        });
        module.addDeserializer(TokenResponse.AccountTypeEnum.class, (JsonDeserializer)new JsonDeserializer<TokenResponse.AccountTypeEnum>(){

            public TokenResponse.AccountTypeEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(TokenResponse.AccountTypeEnum.class, jp.getValueAsString());
            }
        });
        return module;
    }

    public static ObjectMapper getJsonMapper() {
        return mapper;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        try {
            return Enum.valueOf(c, string);
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static String Stringify(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            return sdf.format((Date)obj);
        }
        return obj.toString();
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        mapper.setDateFormat((DateFormat)sdf);
        mapper.registerModule(JsonUtil.getModule());
        mapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

