/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotocorelib.api;

import com.logmein.gotocorelib.api.common.ApiException;
import com.logmein.gotocorelib.api.common.ApiInvoker;
import com.logmein.gotocorelib.api.model.TokenResponse;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class OAuth2Api {
    private String basePath = "https://api.getgo.com/oauth/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public OAuth2Api(String consumerKey, String consumerSecret) {
        this.apiInvoker.addDefaultHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(consumerKey + ":" + consumerSecret).getBytes()));
    }

    public OAuth2Api(String basePath, String consumerKey, String consumerSecret) {
        this(consumerKey, consumerSecret);
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getOAuth2AuthorisationUrl(String clientId) {
        return this.getOAuth2AuthorizationUrl(clientId, null);
    }

    public String getOAuth2AuthorizationUrl(String clientId, String redirectUrl) {
        String authUrl = String.format("/authorize?client_id=%s&response_type=code", clientId);
        String redirectUriParam = StringUtils.isNotEmpty((CharSequence)redirectUrl) ? String.format("&redirect_uri=%s", redirectUrl) : "";
        return String.format("%s%s%s", this.basePath, authUrl, redirectUriParam);
    }

    public String getResponseKey(URL navigatedUrl) throws ApiException {
        String query = navigatedUrl.getQuery();
        if (StringUtils.isBlank((CharSequence)query)) {
            return null;
        }
        String[] pairs = query.split("[ .&,?,/]+");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            String[] nameValue = pair.split("=", 2);
            parameters.put(nameValue[0], nameValue[1]);
        }
        if (parameters.containsKey("code")) {
            return (String)parameters.get("code");
        }
        if (parameters.containsKey("error_description")) {
            throw new ApiException((String)parameters.get("error_description"));
        }
        return null;
    }

    public TokenResponse getAccessTokenResponse(String responseKey) throws ApiException {
        if (responseKey == null) {
            throw new ApiException("Required parameter responseKey is null.");
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("grant_type", "authorization_code");
        formParams.put("code", responseKey);
        return this.executeTokenRequest(formParams);
    }

    @Deprecated
    public TokenResponse directLogin(String username, String password) throws ApiException {
        if (username == null) {
            throw new ApiException("Required parameter username is null.");
        }
        if (password == null) {
            throw new ApiException("Required parameter password is null.");
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("grant_type", "password");
        formParams.put("username", username);
        formParams.put("password", password);
        return this.executeTokenRequest(formParams);
    }

    public TokenResponse getAccessTokenUsingRefreshToken(String refreshToken) throws ApiException {
        if (refreshToken == null) {
            throw new ApiException("Required parameter refreshToken is null.");
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("grant_type", "refresh_token");
        formParams.put("refresh_token", refreshToken);
        return this.executeTokenRequest(formParams);
    }

    private TokenResponse executeTokenRequest(Map<String, String> formParams) throws ApiException {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Accept", "application/json");
        String response = this.apiInvoker.invokeAPI(this.basePath, "/token", "POST", Collections.EMPTY_MAP, null, headerParams, formParams, "application/x-www-form-urlencoded");
        if (response != null) {
            return (TokenResponse)ApiInvoker.deserialize(response, "", TokenResponse.class);
        }
        return null;
    }
}

