/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.UpdateResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.phonesendotp.PhoneSendOtpData;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class PasswordlessLoginAPI {
    private ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);

    public PasswordlessLoginAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void loginByEmail(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        this.apiService.getPasswordlessLogin("identity/v2/auth/login/passwordlesslogin/email", QueryMapHelper.getMapPasswordlessLoginByEmail(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void loginByPhone(QueryParams queryParams, JsonObject securityanswer, final AsyncHandler<LoginData> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("phone", queryParams.getPhone());
        data.addProperty("otp", queryParams.getOtp());
        if (securityanswer != null) {
            data.add("securityanswer", (JsonElement)securityanswer);
        }
        this.apiService.getPasswordlessLoginByPhone("identity/v2/auth/login/passwordlesslogin/otp/verify", QueryMapHelper.getMapPasswordlessLoginByPhone(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onNext(LoginData value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void loginByUsername(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        this.apiService.getPasswordlessLogin("identity/v2/auth/login/passwordlesslogin/email", QueryMapHelper.getMapPasswordlessLoginByUsername(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void sendOtpToPhone(QueryParams queryParams, final AsyncHandler<PhoneSendOtpData> handler) {
        this.apiService.getPhoneSendOtp("identity/v2/auth/login/passwordlesslogin/otp", QueryMapHelper.getMapPhoneSendOtp(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneSendOtpData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PhoneSendOtpData response) {
                handler.onSuccess(response);
            }
        });
    }

    public void verifyLink(QueryParams queryParams, final AsyncHandler<LoginData> handler) {
        this.apiService.getPasswordlessLoginVerify("identity/v2/auth/login/passwordlesslogin/email/verify", QueryMapHelper.getMapPasswordlessLoginVerify(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onNext(LoginData value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }
}

