/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import android.content.Context;
import android.content.Intent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loginradius.androidsdk.activity.RequiredFieldsActivity;
import com.loginradius.androidsdk.api.ConfigurationAPI;
import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.LoginDataHandler;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.AccessTokenResponse;
import com.loginradius.androidsdk.response.CheckAvailability;
import com.loginradius.androidsdk.response.DeleteAccountResponse;
import com.loginradius.androidsdk.response.UpdateProfileResponse;
import com.loginradius.androidsdk.response.UpdateResponse;
import com.loginradius.androidsdk.response.VerifyEmailResponse;
import com.loginradius.androidsdk.response.config.ConfigResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.password.ForgotPasswordResponse;
import com.loginradius.androidsdk.response.phone.PhoneForgotPasswordResponse;
import com.loginradius.androidsdk.response.phone.PhoneResponse;
import com.loginradius.androidsdk.response.phonesendotp.PhoneSendOtpData;
import com.loginradius.androidsdk.response.register.DeleteResponse;
import com.loginradius.androidsdk.response.register.RegisterResponse;
import com.loginradius.androidsdk.response.register.RegistrationData;
import com.loginradius.androidsdk.response.securityquestions.SecurityQuestionsResponse;
import com.loginradius.androidsdk.response.securityquestions.UpdateSecurityQuestionsResponse;
import com.loginradius.androidsdk.response.userprofile.LoginRadiusUltimateUserProfile;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;

public class AuthenticationAPI {
    private ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);
    private boolean askRequiredFieldsOnTraditionalLogin = true;

    public AuthenticationAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void addEmail(QueryParams queryParams, JsonObject update, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getAddEmail("identity/v2/auth/email", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapAddEmail(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void changePassword(QueryParams queryParams, JsonObject change, final AsyncHandler<RegisterResponse> handler) {
        String newPassword;
        String confirmPassword = change.get("ConfirmPassword").getAsString().trim();
        if (!confirmPassword.equals(newPassword = change.get("NewPassword").getAsString().trim())) {
            throw new IllegalArgumentException("Passwords don't match");
        }
        this.apiService.getChangePassword("identity/v2/auth/password/change", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapChangePassword(queryParams), change).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void deleteAccount(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        this.apiService.getDeleteAccount("identity/v2/auth/account/delete", QueryMapHelper.getMapDeleteAccount(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void deleteAccountByConfirmEmail(QueryParams queryParams, final AsyncHandler<DeleteAccountResponse> handler) {
        this.apiService.getDeleteAccountByConfirmEmail("identity/v2/auth/account", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapDeleteAccountByConfirmEmail(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<DeleteAccountResponse>(){

            public void onNext(DeleteAccountResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void checkEmailAvailability(QueryParams queryParams, final AsyncHandler<CheckAvailability> handler) {
        this.apiService.getEmailAvailability("identity/v2/auth/email", QueryMapHelper.getMapEmailAvailability(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<CheckAvailability>(){

            public void onNext(CheckAvailability value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void forgotPasswordByEmail(QueryParams queryParams, final AsyncHandler<ForgotPasswordResponse> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("email", queryParams.getEmail());
        this.apiService.getForgotPasswordByEmail("identity/v2/auth/password", QueryMapHelper.getMapForgotPasswordByEmail(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<ForgotPasswordResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(ForgotPasswordResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void forgotPasswordByPhone(QueryParams queryParams, final AsyncHandler<PhoneForgotPasswordResponse> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("phone", queryParams.getPhone());
        this.apiService.getForgotPasswordByPhone("identity/v2/auth/password/otp", QueryMapHelper.getMapForgotPasswordByPhone(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneForgotPasswordResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PhoneForgotPasswordResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getSecurityQuestions(QueryParams queryParams, final AsyncHandler<SecurityQuestionsResponse[]> handler) {
        String urlEndpoint = "";
        if (queryParams.getAccess_token() != null) {
            this.getSecurityQuestionsByAccessToken(queryParams, handler);
        } else {
            if (queryParams.getPhone() != null) {
                urlEndpoint = "phone";
            } else if (queryParams.getUsername() != null) {
                urlEndpoint = "username";
            } else if (queryParams.getEmail() != null) {
                urlEndpoint = "email";
            }
            this.apiService.getSecurityQuestions("identity/v2/auth/securityquestion/" + urlEndpoint, QueryMapHelper.getMapSecurityQuestions(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<SecurityQuestionsResponse[]>(){

                public void onComplete() {
                }

                public void onError(Throwable e) {
                    ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                    handler.onFailure(exceptionResponse.t, exceptionResponse.message);
                }

                public void onNext(SecurityQuestionsResponse[] response) {
                    handler.onSuccess(response);
                }
            });
        }
    }

    private void getSecurityQuestionsByAccessToken(QueryParams queryParams, final AsyncHandler<SecurityQuestionsResponse[]> handler) {
        this.apiService.getSecurityQuestionsByAccessToken("identity/v2/auth/securityquestion/accesstoken", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapSecurityQuestionsByAccessToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<SecurityQuestionsResponse[]>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(SecurityQuestionsResponse[] response) {
                handler.onSuccess(response);
            }
        });
    }

    public void getSocialProfile(QueryParams queryParams, final AsyncHandler<LoginRadiusUltimateUserProfile> handler) {
        this.apiService.getSocialProfile("identity/v2/auth/socialIdentity", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapSocialProfile(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusUltimateUserProfile>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginRadiusUltimateUserProfile response) {
                handler.onSuccess(response);
            }
        });
    }

    public void invalidateAccessToken(QueryParams queryParams, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getInvalidateAccessToken("identity/v2/auth/access_token/invalidate", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapInvalidateAccessToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void linkAccount(QueryParams queryParams, JsonObject change, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getLinking("identity/v2/auth/socialIdentity", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapLink(queryParams), change).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void loginWithSecurityQuestion(final Context context, final QueryParams queryParams, JsonObject securityAnswer, final AsyncHandler<LoginData> handler) {
        JsonObject object = new JsonObject();
        if (queryParams.getPhone() != null) {
            object.addProperty("phone", queryParams.getPhone());
        } else if (queryParams.getUsername() != null) {
            object.addProperty("username", queryParams.getUsername());
        } else {
            object.addProperty("email", queryParams.getEmail());
        }
        object.addProperty("password", queryParams.getPassword());
        if (securityAnswer != null) {
            object.add("securityanswer", (JsonElement)securityAnswer);
        }
        this.apiService.getTraditionalLogin("identity/v2/auth/login", QueryMapHelper.getMapLogin(queryParams), object).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginData response) {
                AuthenticationAPI.this.validateLoginConfiguration(context, queryParams, response, handler);
            }
        });
    }

    private void validateLoginConfiguration(final Context context, final QueryParams queryParams, final LoginData response, final AsyncHandler<LoginData> handler) {
        if (this.askRequiredFieldsOnTraditionalLogin) {
            ConfigurationAPI api = new ConfigurationAPI();
            api.getResponse(new AsyncHandler<ConfigResponse>(){

                @Override
                public void onSuccess(ConfigResponse data) {
                    if (data.getAskRequiredFieldsOnTraditionalLogin().booleanValue()) {
                        Intent intent = new Intent(context, RequiredFieldsActivity.class);
                        intent.putExtra("apikey", LoginRadiusSDK.getApiKey());
                        intent.putExtra("verificationurl", LoginRadiusSDK.getVerificationUrl());
                        intent.putExtra("fieldsColor", queryParams.getFieldsColor());
                        LoginDataHandler loginDataHandler = LoginDataHandler.getInstance();
                        loginDataHandler.setResponse(response);
                        loginDataHandler.setHandler(handler);
                        context.startActivity(intent);
                    } else {
                        handler.onSuccess(response);
                    }
                }

                @Override
                public void onFailure(Throwable error, String errorcode) {
                    handler.onFailure(error, errorcode);
                }
            });
        } else {
            handler.onSuccess(response);
        }
    }

    public void login(Context context, QueryParams queryParams, AsyncHandler<LoginData> handler) {
        this.loginWithSecurityQuestion(context, queryParams, null, handler);
    }

    public void verifyOtp(QueryParams queryParams, JsonObject data, final AsyncHandler<LoginData> handler) {
        String url = "identity/v2/auth/phone/otp";
        this.apiService.getOtpVerification(url, QueryMapHelper.getMapOtpVerification(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginData response) {
                handler.onSuccess(response);
            }
        });
    }

    public void verifyOtpForgotPassword(JsonObject data, final AsyncHandler<RegisterResponse> handler) {
        String newPassword = data.get("password").getAsString();
        String confirmPassword = data.get("confirmpassword").getAsString();
        if (!confirmPassword.equals(newPassword)) {
            throw new IllegalArgumentException("Passwords don't match");
        }
        String url = "identity/v2/auth/password/otp";
        this.apiService.getResetPasswordByOtp(url, QueryMapHelper.getMapOtpVerifyForgotPassword(), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    @Deprecated
    public void loginWithPhoneUsingOtp(QueryParams queryParams, final AsyncHandler<LoginData> handler) {
        this.apiService.getTraditionalLogin("identity/v2/auth/login", QueryMapHelper.getMapPhoneLoginUsingOtp(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginData response) {
                handler.onSuccess(response);
            }
        });
    }

    public void checkPhoneAvailability(QueryParams queryParams, final AsyncHandler<CheckAvailability> handler) {
        this.apiService.getPhoneNumberAvailability("identity/v2/auth/phone", QueryMapHelper.getMapPhoneAvailability(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<CheckAvailability>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(CheckAvailability response) {
                handler.onSuccess(response);
            }
        });
    }

    public void sendOtpToPhone(QueryParams queryParams, final AsyncHandler<PhoneSendOtpData> handler) {
        this.apiService.getPhoneSendOtp("identity/v2/auth/login/otp", QueryMapHelper.getMapPhoneSendOtp(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneSendOtpData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PhoneSendOtpData response) {
                handler.onSuccess(response);
            }
        });
    }

    public void register(QueryParams queryParams, String sott, RegistrationData registrationData, final AsyncHandler<RegisterResponse> handler) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("X-LoginRadius-Sott", sott);
        if (!LoginRadiusSDK.getReferer().isEmpty()) {
            headers.put("Referer", LoginRadiusSDK.getReferer());
        }
        this.apiService.getTraditionalRegister("identity/v2/auth/register", headers, QueryMapHelper.getMapRegistration(queryParams), registrationData).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void register(QueryParams queryParams, String sott, JsonObject data, final AsyncHandler<RegisterResponse> handler) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("X-LoginRadius-Sott", sott);
        if (!LoginRadiusSDK.getReferer().isEmpty()) {
            headers.put("Referer", LoginRadiusSDK.getReferer());
        }
        this.apiService.getTraditionalRegister("identity/v2/auth/register", headers, QueryMapHelper.getMapRegistration(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void removeEmail(QueryParams queryParams, JsonObject delete, final AsyncHandler<DeleteResponse> handler) {
        this.apiService.getRemoveEmail("identity/v2/auth/email", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapRemoveEmail(queryParams), delete).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<DeleteResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(DeleteResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void resendEmailVerification(QueryParams queryParams, JsonObject update, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getResendEmailVerification("identity/v2/auth/register", QueryMapHelper.getMapResendEmailVerification(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void resendOtp(QueryParams params, JsonObject data, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getResendotp("identity/v2/auth/phone/otp", QueryMapHelper.getMapResendOtp(params), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void resendOtpByToken(QueryParams queryParams, JsonObject data, final AsyncHandler<PhoneResponse> handler) {
        this.apiService.getResendotpbytoken("identity/v2/auth/phone/otp", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapResendOtpByToken(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PhoneResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void resetPasswordByResetToken(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        String newPassword = queryParams.getPassword();
        String confirmPassword = queryParams.getConfirmPassword();
        if (!confirmPassword.equals(newPassword)) {
            throw new IllegalArgumentException("Passwords don't match");
        }
        JsonObject update = new JsonObject();
        update.addProperty("resettoken", queryParams.getResetToken());
        update.addProperty("password", queryParams.getPassword());
        update.addProperty("welcomeemailtemplate", queryParams.getWelcomeEmailTemplate() != null ? queryParams.getWelcomeEmailTemplate() : "");
        update.addProperty("resetpasswordemailtemplate", queryParams.getResetPasswordEmailTemplate() != null ? queryParams.getResetPasswordEmailTemplate() : "");
        this.apiService.getResetPasswordByResetToken("identity/v2/auth/password/reset", QueryMapHelper.getMapResetPasswordToken(), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void resetPasswordBySecurityQuestions(QueryParams queryParams, JsonObject update, final AsyncHandler<RegisterResponse> handler) {
        String newPassword = queryParams.getPassword();
        String confirmPassword = queryParams.getConfirmPassword();
        if (!confirmPassword.equals(newPassword)) {
            throw new IllegalArgumentException("Passwords don't match");
        }
        if (queryParams.getEmail() != null) {
            update.addProperty("email", queryParams.getEmail());
        } else if (queryParams.getPhone() != null) {
            update.addProperty("phone", queryParams.getPhone());
        } else if (queryParams.getUsername() != null) {
            update.addProperty("username", queryParams.getUsername());
        }
        update.addProperty("password", queryParams.getPassword());
        update.addProperty("resetpasswordemailtemplate", queryParams.getResetPasswordEmailTemplate() != null ? queryParams.getResetPasswordEmailTemplate() : "");
        this.apiService.getResetPasswordbySecurityQuestion("identity/v2/auth/password/securityanswer", QueryMapHelper.getMapResetPasswordSecurityQuestion(), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void resetPasswordByOtp(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        String newPassword = queryParams.getPassword();
        String confirmPassword = queryParams.getConfirmPassword();
        if (!confirmPassword.equals(newPassword)) {
            throw new IllegalArgumentException("Passwords don't match");
        }
        JsonObject update = new JsonObject();
        update.addProperty("password", queryParams.getPassword());
        update.addProperty("welcomeemailtemplate", queryParams.getWelcomeEmailTemplate() != null ? queryParams.getWelcomeEmailTemplate() : "");
        update.addProperty("resetpasswordemailtemplate", queryParams.getResetPasswordEmailTemplate() != null ? queryParams.getResetPasswordEmailTemplate() : "");
        update.addProperty("otp", queryParams.getOtp());
        update.addProperty("email", queryParams.getEmail());
        this.apiService.getResetPasswordByEmailOtp("identity/v2/auth/password/reset", QueryMapHelper.getMapResetPasswordToken(), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void readAllUserProfile(QueryParams queryParams, final AsyncHandler<LoginRadiusUltimateUserProfile> handler) {
        this.apiService.getReadAllUserProfile("identity/v2/auth/account", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapReadAllUserProfile(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusUltimateUserProfile>(){

            public void onNext(LoginRadiusUltimateUserProfile userProfile) {
                handler.onSuccess(userProfile);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void unlinkAccount(QueryParams queryParams, JsonObject json, final AsyncHandler<DeleteResponse> handler) {
        this.apiService.getUnlinking("identity/v2/auth/socialIdentity", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUnlink(queryParams), json).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<DeleteResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(DeleteResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void removePhoneIDByAccessToken(QueryParams queryParams, final AsyncHandler<DeleteResponse> handler) {
        this.apiService.getRemovePhoneIDByAccessToken("identity/v2/auth/phone", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapRemovePhoneIDByAccessToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<DeleteResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(DeleteResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void updatePhone(QueryParams queryParams, JsonObject update, final AsyncHandler<PhoneResponse> handler) {
        this.apiService.getUpdatephone("identity/v2/auth/phone", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUpdatePhone(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<PhoneResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(PhoneResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void updateProfile(QueryParams queryParams, JsonObject data, final AsyncHandler<UpdateProfileResponse> handler) {
        this.apiService.getUpdateprofile("identity/v2/auth/account", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUpdateProfile(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateProfileResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(UpdateProfileResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void updateProfile(QueryParams queryParams, RegistrationData data, final AsyncHandler<UpdateProfileResponse> handler) {
        this.apiService.getUpdateprofile("identity/v2/auth/account", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUpdateProfile(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateProfileResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(UpdateProfileResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void updateSecurityQuestionByAccessToken(QueryParams queryParams, JsonObject update, final AsyncHandler<UpdateSecurityQuestionsResponse> handler) {
        this.apiService.getUpdateSecurityQuestionByAccessToken("identity/v2/auth/account", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUpdateSecurityQuestionToken(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateSecurityQuestionsResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(UpdateSecurityQuestionsResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void updateUsername(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        JsonObject update = new JsonObject();
        update.addProperty("username", queryParams.getUsername());
        this.apiService.getUpdateUsername("identity/v2/auth/username", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUpdateUsername(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void checkUsernameAvailability(QueryParams queryParams, final AsyncHandler<CheckAvailability> handler) {
        this.apiService.getUsernameAvailability("identity/v2/auth/username", QueryMapHelper.getMapCheckUsername(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<CheckAvailability>(){

            public void onNext(CheckAvailability value) {
                handler.onSuccess(value);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void validateAccessToken(QueryParams queryParams, final AsyncHandler<AccessTokenResponse> handler) {
        this.apiService.getValidateAccessToken("identity/v2/auth/access_token/validate", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapValidateAccessToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<AccessTokenResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(AccessTokenResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void verifyEmail(QueryParams queryParams, final AsyncHandler<VerifyEmailResponse> handler) {
        this.apiService.getVerifyEmail("identity/v2/auth/email", QueryMapHelper.getMapVerifyEmail(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<VerifyEmailResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(VerifyEmailResponse value) {
                handler.onSuccess(value);
            }
        });
    }

    public void verifyEmailByOtp(QueryParams queryParams, JsonObject securityAnswer, final AsyncHandler<VerifyEmailResponse> handler) {
        JsonObject data = new JsonObject();
        data.addProperty("otp", queryParams.getOtp());
        data.addProperty("email", queryParams.getEmail());
        if (securityAnswer != null) {
            data.add("securityanswer", (JsonElement)securityAnswer);
        }
        this.apiService.getVerifyEmailByOtp("identity/v2/auth/email", QueryMapHelper.getMapVerifyEmailByOtp(queryParams), data).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<VerifyEmailResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(VerifyEmailResponse value) {
                handler.onSuccess(value);
            }
        });
    }

    public void verifyOtpByToken(QueryParams queryParams, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getVerifyOtp("identity/v2/auth/phone/otp", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapVerifyOtpByToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void acceptPrivacyPolicy(QueryParams queryParams, final AsyncHandler<LoginRadiusUltimateUserProfile> handler) {
        this.apiService.getAcceptPrivacyPolicy("identity/v2/auth/privacypolicy/accept", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapAcceptPrivacyPolicy(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginRadiusUltimateUserProfile>(){

            public void onNext(LoginRadiusUltimateUserProfile data) {
                handler.onSuccess(data);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void sendWelcomeEmail(QueryParams queryParams, final AsyncHandler<UpdateResponse> handler) {
        this.apiService.getSendWelcomeEmail("identity/v2/auth/account/sendwelcomeemail", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapSendWelcomeEmail(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<UpdateResponse>(){

            public void onNext(UpdateResponse data) {
                handler.onSuccess(data);
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onComplete() {
            }
        });
    }

    public void setAskRequiredFieldsOnTraditionalLogin(boolean askRequiredFieldsOnTraditionalLogin) {
        this.askRequiredFieldsOnTraditionalLogin = askRequiredFieldsOnTraditionalLogin;
    }
}

