package com.loginradius.androidsdk.ui;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/**
 * Created by loginradius on 10-Dec-16.
 */

public class CountryCodes {
    public final Map<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    public CountryCodes() {
        map.put("Bangladesh","BD,880");
        map.put("Belgium","BE,32");
        map.put("Burkina Faso","BF,226");
        map.put("Bulgaria","BG,359");
        map.put("Bosnia and Herzegovina","BA,387");
        map.put("Barbados","BB,+1-246");
        map.put("Wallis and Futuna","WF,681");
        map.put("Saint Barthelemy","BL,590");
        map.put("Bermuda","BM,+1-441");
        map.put("Brunei","BN,673");
        map.put("Bolivia","BO,591");
        map.put("Bahrain","BH,973");
        map.put("Burundi","BI,257");
        map.put("Benin","BJ,229");
        map.put("Bhutan","BT,975");
        map.put("Jamaica","JM,+1-876");
        map.put("Bouvet Island","BV,");
        map.put("Botswana","BW,267");
        map.put("Samoa","WS,685");
        map.put("Bonaire, Saint Eustatius and Saba ","BQ,599");
        map.put("Brazil","BR,55");
        map.put("Bahamas","BS,+1-242");
        map.put("Jersey","JE,+44-1534");
        map.put("Belarus","BY,375");
        map.put("Belize","BZ,501");
        map.put("Russia","RU,7");
        map.put("Rwanda","RW,250");
        map.put("Serbia","RS,381");
        map.put("East Timor","TL,670");
        map.put("Reunion","RE,262");
        map.put("Turkmenistan","TM,993");
        map.put("Tajikistan","TJ,992");
        map.put("Romania","RO,40");
        map.put("Tokelau","TK,690");
        map.put("Guinea-Bissau","GW,245");
        map.put("Guam","GU,+1-671");
        map.put("Guatemala","GT,502");
        map.put("South Georgia and the South Sandwich Islands","GS,");
        map.put("Greece","GR,30");
        map.put("Equatorial Guinea","GQ,240");
        map.put("Guadeloupe","GP,590");
        map.put("Japan","JP,81");
        map.put("Guyana","GY,592");
        map.put("Guernsey","GG,+44-1481");
        map.put("French Guiana","GF,594");
        map.put("Georgia","GE,995");
        map.put("Grenada","GD,+1-473");
        map.put("United Kingdom","GB,44");
        map.put("Gabon","GA,241");
        map.put("El Salvador","SV,503");
        map.put("Guinea","GN,224");
        map.put("Gambia","GM,220");
        map.put("Greenland","GL,299");
        map.put("Gibraltar","GI,350");
        map.put("Ghana","GH,233");
        map.put("Oman","OM,968");
        map.put("Tunisia","TN,216");
        map.put("Jordan","JO,962");
        map.put("Croatia","HR,385");
        map.put("Haiti","HT,509");
        map.put("Hungary","HU,36");
        map.put("Hong Kong","HK,852");
        map.put("Honduras","HN,504");
        map.put("Heard Island and McDonald Islands","HM, ");
        map.put("Venezuela","VE,58");
        map.put("Puerto Rico","PR,+1-787 and 1-939");
        map.put("Palestinian Territory","PS,970");
        map.put("Palau","PW,680");
        map.put("Portugal","PT,351");
        map.put("Svalbard and Jan Mayen","SJ,47");
        map.put("Paraguay","PY,595");
        map.put("Iraq","IQ,964");
        map.put("Panama","PA,507");
        map.put("French Polynesia","PF,689");
        map.put("Papua New Guinea","PG,675");
        map.put("Peru","PE,51");
        map.put("Pakistan","PK,92");
        map.put("Philippines","PH,63");
        map.put("Pitcairn","PN,870");
        map.put("Poland","PL,48");
        map.put("Saint Pierre and Miquelon","PM,508");
        map.put("Zambia","ZM,260");
        map.put("Western Sahara","EH,212");
        map.put("Estonia","EE,372");
        map.put("Egypt","EG,20");
        map.put("South Africa","ZA,27");
        map.put("Ecuador","EC,593");
        map.put("Italy","IT,39");
        map.put("Vietnam","VN,84");
        map.put("Solomon Islands","SB,677");
        map.put("Ethiopia","ET,251");
        map.put("Somalia","SO,252");
        map.put("Zimbabwe","ZW,263");
        map.put("Saudi Arabia","SA,966");
        map.put("Spain","ES,34");
        map.put("Eritrea","ER,291");
        map.put("Montenegro","ME,382");
        map.put("Moldova","MD,373");
        map.put("Madagascar","MG,261");
        map.put("Saint Martin","MF,590");
        map.put("Morocco","MA,212");
        map.put("Monaco","MC,377");
        map.put("Uzbekistan","UZ,998");
        map.put("Myanmar","MM,95");
        map.put("Mali","ML,223");
        map.put("Macao","MO,853");
        map.put("Mongolia","MN,976");
        map.put("Marshall Islands","MH,692");
        map.put("Macedonia","MK,389");
        map.put("Mauritius","MU,230");
        map.put("Malta","MT,356");
        map.put("Malawi","MW,265");
        map.put("Maldives","MV,960");
        map.put("Martinique","MQ,596");
        map.put("Northern Mariana Islands","MP,+1-670");
        map.put("Montserrat","MS,+1-664");
        map.put("Mauritania","MR,222");
        map.put("Isle of Man","IM,+44-1624");
        map.put("Uganda","UG,256");
        map.put("Tanzania","TZ,255");
        map.put("Malaysia","MY,60");
        map.put("Mexico","MX,52");
        map.put("Israel","IL,972");
        map.put("France","FR,33");
        map.put("British Indian Ocean Territory","IO,246");
        map.put("Saint Helena","SH,290");
        map.put("Finland","FI,358");
        map.put("Fiji","FJ,679");
        map.put("Falkland Islands","FK,500");
        map.put("Micronesia","FM,691");
        map.put("Faroe Islands","FO,298");
        map.put("Nicaragua","NI,505");
        map.put("Netherlands","NL,31");
        map.put("Norway","NO,47");
        map.put("Namibia","NA,264");
        map.put("Vanuatu","VU,678");
        map.put("New Caledonia","NC,687");
        map.put("Niger","NE,227");
        map.put("Norfolk Island","NF,672");
        map.put("Nigeria","NG,234");
        map.put("New Zealand","NZ,64");
        map.put("Nepal","NP,977");
        map.put("Nauru","NR,674");
        map.put("Niue","NU,683");
        map.put("Cook Islands","CK,682");
        map.put("Kosovo","XK,");
        map.put("Ivory Coast","CI,225");
        map.put("Switzerland","CH,41");
        map.put("Colombia","CO,57");
        map.put("China","CN,86");
        map.put("Cameroon","CM,237");
        map.put("Chile","CL,56");
        map.put("Cocos Islands","CC,61");
        map.put("Canada","CA,1");
        map.put("Republic of the Congo","CG,242");
        map.put("Central African Republic","CF,236");
        map.put("Democratic Republic of the Congo","CD,243");
        map.put("Czech Republic","CZ,420");
        map.put("Cyprus","CY,357");
        map.put("Christmas Island","CX,61");
        map.put("Costa Rica","CR,506");
        map.put("Curacao","CW,599");
        map.put("Cape Verde","CV,238");
        map.put("Cuba","CU,53");
        map.put("Swaziland","SZ,268");
        map.put("Syria","SY,963");
        map.put("Sint Maarten","SX,599");
        map.put("Kyrgyzstan","KG,996");
        map.put("Kenya","KE,254");
        map.put("South Sudan","SS,211");
        map.put("Suriname","SR,597");
        map.put("Kiribati","KI,686");
        map.put("Cambodia","KH,855");
        map.put("Saint Kitts and Nevis","KN,+1-869");
        map.put("Comoros","KM,269");
        map.put("Sao Tome and Principe","ST,239");
        map.put("Slovakia","SK,421");
        map.put("South Korea","KR,82");
        map.put("Slovenia","SI,386");
        map.put("North Korea","KP,850");
        map.put("Kuwait","KW,965");
        map.put("Senegal","SN,221");
        map.put("San Marino","SM,378");
        map.put("Sierra Leone","SL,232");
        map.put("Seychelles","SC,248");
        map.put("Kazakhstan","KZ,7");
        map.put("Cayman Islands","KY,+1-345");
        map.put("Singapore","SG,65");
        map.put("Sweden","SE,46");
        map.put("Sudan","SD,249");
        map.put("Dominican Republic","DO,+1-809 and 1-829");
        map.put("Dominica","DM,+1-767");
        map.put("Djibouti","DJ,253");
        map.put("Denmark","DK,45");
        map.put("British Virgin Islands","VG,+1-284");
        map.put("Germany","DE,49");
        map.put("Yemen","YE,967");
        map.put("Algeria","DZ,213");
        map.put("United States","US,1");
        map.put("Uruguay","UY,598");
        map.put("Mayotte","YT,262");
        map.put("United States Minor Outlying Islands","UM,1");
        map.put("Lebanon","LB,961");
        map.put("Saint Lucia","LC,+1-758");
        map.put("Laos","LA,856");
        map.put("Tuvalu","TV,688");
        map.put("Taiwan","TW,886");
        map.put("Trinidad and Tobago","TT,+1-868");
        map.put("Turkey","TR,90");
        map.put("Sri Lanka","LK,94");
        map.put("Liechtenstein","LI,423");
        map.put("Latvia","LV,371");
        map.put("Tonga","TO,676");
        map.put("Lithuania","LT,370");
        map.put("Luxembourg","LU,352");
        map.put("Liberia","LR,231");
        map.put("Lesotho","LS,266");
        map.put("Thailand","TH,66");
        map.put("French Southern Territories","TF,");
        map.put("Togo","TG,228");
        map.put("Chad","TD,235");
        map.put("Turks and Caicos Islands","TC,+1-649");
        map.put("Libya","LY,218");
        map.put("Vatican","VA,379");
        map.put("Saint Vincent and the Grenadines","VC,+1-784");
        map.put("United Arab Emirates","AE,971");
        map.put("Andorra","AD,376");
        map.put("Antigua and Barbuda","AG,+1-268");
        map.put("Afghanistan","AF,93");
        map.put("Anguilla","AI,+1-264");
        map.put("U.S. Virgin Islands","VI,+1-340");
        map.put("Iceland","IS,354");
        map.put("Iran","IR,98");
        map.put("Armenia","AM,374");
        map.put("Albania","AL,355");
        map.put("Angola","AO,244");
        map.put("Antarctica","AQ,");
        map.put("American Samoa","AS,+1-684");
        map.put("Argentina","AR,54");
        map.put("Australia","AU,61");
        map.put("Austria","AT,43");
        map.put("Aruba","AW,297");
        map.put("India","IN,91");
        map.put("Aland Islands","AX,+358-18");
        map.put("Azerbaijan","AZ,994");
        map.put("Ireland","IE,353");
        map.put("Indonesia","ID,62");
        map.put("Ukraine","UA,380");
        map.put("Qatar","QA,974");
        map.put("Mozambique","MZ,258");
    }

    public String getCode(String country){
        if(country!=null && country.length()>0){
            String countryFound = map.get(country).split(",")[0];
            if(countryFound==null){
                countryFound="CA";
            }
            return countryFound;
        }
        return "";
    }

    public String getCallingCode(String country){
        if(country!=null && country.length()>0){
            String code = map.get(country).split(",")[1];
            if (code == null || code.length()==0){
                code = "+1";
            }
            return code;
        }
        return "";
    }

    public static class StringComparator implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}