/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.helper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.Scope;
import com.loginradius.androidsdk.activity.FacebookNativeActivity;
import com.loginradius.androidsdk.activity.GoogleNativeActivity;
import com.loginradius.androidsdk.activity.VkontakteNativeActivity;
import com.loginradius.androidsdk.activity.WebViewActivity;
import com.loginradius.androidsdk.resource.SocialProviderConstant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LoginRadiusSDK {
    private LoginRadiusSDK() {
    }

    public static boolean validate() {
        if (Initialize.apiKey == null || Initialize.apiKey.length() == 0) {
            return false;
        }
        return Initialize.siteName != null && Initialize.siteName.length() != 0;
    }

    public static String getApiKey() {
        return Initialize.apiKey;
    }

    public static String getSiteName() {
        return Initialize.siteName;
    }

    public static String getReferer() {
        return Initialize.referer;
    }

    public static Map<String, String> getCustomHeader() {
        return Initialize.customHeader;
    }

    public static String getVerificationUrl() {
        if (Initialize.verificationUrl != null && Initialize.verificationUrl.length() > 0) {
            return Initialize.verificationUrl;
        }
        return "https://auth.lrcontent.com/mobile/verification/index.html";
    }

    public static String getResetPasswordUrl() {
        if (Initialize.resetPasswordUrl != null && Initialize.resetPasswordUrl.length() > 0) {
            return Initialize.resetPasswordUrl;
        }
        return "https://auth.lrcontent.com/mobile/verification/index.html";
    }

    public static Collection<String> getFaceBookPermissions() {
        return NativeLogin.facebookPermissions;
    }

    public static String getGoogleServerClientID() {
        return NativeLogin.googleServerClientID;
    }

    public static Scope[] getGoogleScopes() {
        return NativeLogin.googleScopes;
    }

    public static String getSocialAppName() {
        return NativeLogin.socialAppName;
    }

    public static class InitializeException
    extends RuntimeException {
        public InitializeException() {
            super("LoginRadius SDK not initialized properly");
        }
    }

    public static class NativeLogin {
        private boolean isRequired = true;
        private int fieldsColor;
        private Intent intent;
        private static Collection<String> facebookPermissions;
        private static Scope[] googleScopes;
        private static String googleServerClientID;
        private static String socialAppName;

        public NativeLogin() {
            googleScopes = new Scope[]{new Scope("profile"), new Scope("email")};
            facebookPermissions = Arrays.asList("public_profile", "email");
            if (!LoginRadiusSDK.validate()) {
                throw new InitializeException();
            }
        }

        public NativeLogin setRequired(boolean required) {
            this.isRequired = required;
            return this;
        }

        public NativeLogin setFieldsColor(int fieldsColor) {
            this.fieldsColor = fieldsColor;
            return this;
        }

        public void setGoogleServerClientID(String googleServerClientID) {
            NativeLogin.googleServerClientID = googleServerClientID;
        }

        public void setSocialAppName(String socialAppName) {
            NativeLogin.socialAppName = socialAppName;
        }

        public void setPermissions(@NonNull Collection<String> permissions) {
            facebookPermissions = permissions;
        }

        public void setGoogleScopes(Scope ... scope) {
            googleScopes = scope;
        }

        private void startNativeLogin(Activity activity, int requestCode) {
            this.intent.putExtra("isRequired", this.isRequired);
            this.intent.putExtra("fieldsColor", this.fieldsColor);
            activity.startActivityForResult(this.intent, requestCode);
        }

        public void startFacebookNativeLogin(Activity activity, int requestCode) {
            this.intent = new Intent((Context)activity, FacebookNativeActivity.class);
            this.startNativeLogin(activity, requestCode);
        }

        public void startGoogleNativeLogin(Activity activity, int requestCode) {
            this.intent = new Intent((Context)activity, GoogleNativeActivity.class);
            this.startNativeLogin(activity, requestCode);
        }

        public void startVkontakteNativeLogin(Activity activity, int appId, int requestCode) {
            this.intent = new Intent((Context)activity, VkontakteNativeActivity.class);
            this.intent.putExtra("appId", appId);
            this.startNativeLogin(activity, requestCode);
        }
    }

    public static class WebLogin {
        private String provider;
        private boolean isRequired = true;
        private int fieldsColor;
        private boolean reloadOnError;
        private boolean customScopeEnabled;

        public WebLogin() {
            if (!LoginRadiusSDK.validate()) {
                throw new InitializeException();
            }
        }

        public WebLogin setProvider(SocialProviderConstant provider) {
            this.provider = provider.value;
            return this;
        }

        public WebLogin setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public WebLogin setRequired(boolean required) {
            this.isRequired = required;
            return this;
        }

        public WebLogin setFieldsColor(int fieldsColor) {
            this.fieldsColor = fieldsColor;
            return this;
        }

        public WebLogin setReloadOnError(boolean reloadOnError) {
            this.reloadOnError = reloadOnError;
            return this;
        }

        public void setCustomScopeEnabled(boolean customScopeEnabled) {
            this.customScopeEnabled = customScopeEnabled;
        }

        public void startWebLogin(Activity activity, int requestCode) {
            if (this.provider == null) {
                throw new IllegalArgumentException("Social provider cannot be null");
            }
            Intent intent = new Intent((Context)activity, WebViewActivity.class);
            intent.putExtra("provider", this.provider);
            intent.putExtra("isRequired", this.isRequired);
            intent.putExtra("fieldsColor", this.fieldsColor);
            intent.putExtra("reloadOnError", this.reloadOnError);
            intent.putExtra("customScopeEnabled", this.customScopeEnabled);
            activity.startActivityForResult(intent, requestCode);
        }
    }

    public static class Initialize {
        private static String apiKey;
        private static String siteName;
        private static String verificationUrl;
        private static String resetPasswordUrl;
        private static String referer;
        private static Map<String, String> customHeader;

        public void setApiKey(String apiKey) {
            Initialize.apiKey = apiKey;
        }

        public void setSiteName(String siteName) {
            Initialize.siteName = siteName;
        }

        public void setVerificationUrl(String verificationUrl) {
            Initialize.verificationUrl = verificationUrl;
        }

        public void setResetPasswordUrl(String resetPasswordUrl) {
            Initialize.resetPasswordUrl = resetPasswordUrl;
        }

        public void setCustomHeader(Map<String, String> customHeader) {
            Initialize.customHeader = customHeader;
        }

        public void setReferer(String referer) {
            Initialize.referer = referer;
        }

        static {
            referer = "Android";
            customHeader = new HashMap<String, String>();
        }
    }
}

