/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import com.loginradius.androidsdk.R;
import com.loginradius.androidsdk.api.AuthenticationAPI;
import com.loginradius.androidsdk.api.ConfigurationAPI;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.JsonDeserializer;
import com.loginradius.androidsdk.helper.ErrorResponse;
import com.loginradius.androidsdk.helper.LoginRadiusAuthManager;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.AccessTokenResponse;
import com.loginradius.androidsdk.response.UpdateProfileResponse;
import com.loginradius.androidsdk.response.config.ConfigResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.register.RegisterResponse;
import com.loginradius.androidsdk.response.traditionalinterface.UserRegistration;
import com.loginradius.androidsdk.response.userprofile.LoginRadiusUltimateUserProfile;
import com.loginradius.androidsdk.ui.FieldViewUtil;
import com.loginradius.androidsdk.ui.RequiredFieldsViewGenerator;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.List;

public class WeChatNativeActivity
extends Activity
implements IWXAPIEventHandler {
    public static String wxAppId;
    public static String wxError;
    private IWXAPI api;
    public static AccessTokenResponse wxResponse;
    public static boolean isRequired;
    private boolean promptPassword;
    private boolean askOptionalOnSocialLogin;
    public static int fieldsColor;
    RequiredFieldsViewGenerator gtr;
    FieldViewUtil fieldUtil;
    Context context;
    List<UserRegistration> raasSchemaList;
    LoginRadiusUltimateUserProfile userProfile;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.api = WXAPIFactory.createWXAPI((Context)this, (String)wxAppId, (boolean)true);
        this.context = this;
        this.api.registerApp(wxAppId);
        this.api.handleIntent(this.getIntent(), (IWXAPIEventHandler)this);
    }

    public void onReq(BaseReq baseReq) {
        Log.e((String)"yc", (String)("onReq:" + baseReq.toString()));
    }

    public void onResp(BaseResp resp) {
        switch (resp.errCode) {
            case 0: {
                try {
                    SendAuth.Resp sendResp = (SendAuth.Resp)resp;
                    this.exchangeToken(sendResp.code);
                }
                catch (Exception e) {
                    this.sendAccessToken(null, null, null, e.getMessage());
                }
                break;
            }
            case -2: {
                this.sendAccessToken(null, null, null, "Wx User canceled the request");
                break;
            }
            case -4: {
                this.sendAccessToken(null, null, null, "Wx User denied the request");
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.api.handleIntent(data, (IWXAPIEventHandler)this);
    }

    public void exchangeToken(String code) {
        LoginRadiusAuthManager.getResponseWeChat(code, new AsyncHandler<AccessTokenResponse>(){

            @Override
            public void onSuccess(AccessTokenResponse data) {
                wxResponse = data;
                WeChatNativeActivity.wxResponse.provider = "wechat";
                if (isRequired) {
                    WeChatNativeActivity.this.getRaasSchema();
                } else {
                    WeChatNativeActivity.this.sendAccessToken(data.access_token, data.refresh_token, data.expires_in, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                WeChatNativeActivity.this.sendAccessToken(null, null, null, "lr_api_error");
            }
        });
    }

    private void getRaasSchema() {
        this.gtr = new RequiredFieldsViewGenerator(this.context, fieldsColor);
        this.setContentView((View)this.gtr.generateProgressBar());
        ConfigurationAPI api = new ConfigurationAPI();
        api.getResponse(new AsyncHandler<ConfigResponse>(){

            @Override
            public void onSuccess(ConfigResponse data) {
                WeChatNativeActivity.this.raasSchemaList = data.getRegistrationFormSchema();
                WeChatNativeActivity.this.promptPassword = data.getAskPasswordOnSocialLogin();
                WeChatNativeActivity.this.askOptionalOnSocialLogin = data.getAskOptionalFieldsOnSocialSignup();
                WeChatNativeActivity.this.validateRaasSchema();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                Log.i((String)"lr_api_error", (String)error.getMessage());
                WeChatNativeActivity.this.sendAccessToken(null, null, null, "lr_api_error");
            }
        });
    }

    private void validateRaasSchema() {
        boolean containsRequired = false;
        for (int i = 0; i < this.raasSchemaList.size(); ++i) {
            if (!this.raasSchemaList.get(i).getRules().contains("required") || containsRequired) continue;
            containsRequired = true;
        }
        if (containsRequired) {
            this.getUserProfile();
        } else {
            this.sendAccessToken(WeChatNativeActivity.wxResponse.access_token, WeChatNativeActivity.wxResponse.refresh_token, WeChatNativeActivity.wxResponse.expires_in, null);
        }
    }

    private void getUserProfile() {
        AuthenticationAPI api = new AuthenticationAPI();
        QueryParams queryParams = new QueryParams();
        queryParams.setAccess_token(WeChatNativeActivity.wxResponse.access_token);
        api.readAllUserProfile(queryParams, new AsyncHandler<LoginRadiusUltimateUserProfile>(){

            @Override
            public void onSuccess(LoginRadiusUltimateUserProfile data) {
                WeChatNativeActivity.this.userProfile = data;
                WeChatNativeActivity.this.setRequiredFieldsView();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                Log.i((String)"lr_api_error", (String)error.getMessage());
                WeChatNativeActivity.this.sendAccessToken(null, null, null, "lr_api_error");
            }
        });
    }

    private void setRequiredFieldsView() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ScrollView>(){

            public void subscribe(ObservableEmitter<ScrollView> e) throws Exception {
                e.onNext((Object)WeChatNativeActivity.this.getFieldsView());
                e.onComplete();
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
        Observer<ScrollView> observer = new Observer<ScrollView>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ScrollView value) {
                if (value.getChildCount() > 0) {
                    WeChatNativeActivity.this.setContentView((View)value);
                } else {
                    WeChatNativeActivity.this.sendAccessToken(WeChatNativeActivity.wxResponse.access_token, WeChatNativeActivity.wxResponse.refresh_token, WeChatNativeActivity.wxResponse.expires_in, null);
                }
            }

            public void onError(Throwable e) {
                Log.i((String)"lr_api_error", (String)e.getMessage());
            }

            public void onComplete() {
            }
        };
        observable.subscribe((Observer)observer);
    }

    private ScrollView getFieldsView() {
        this.fieldUtil = new FieldViewUtil();
        boolean isRequiredAdded = false;
        ScrollView svParent = this.gtr.generateParentView();
        final LinearLayout linearContainer = this.gtr.generateParentContainerView();
        svParent.addView((View)linearContainer);
        LinkedTreeMap customFields = null;
        if (this.userProfile.getCustomFields() != null) {
            customFields = (LinkedTreeMap)this.userProfile.getCustomFields();
        }
        TextView tvLabel = this.gtr.generateLabelTextView("Please fill the required fields to continue");
        tvLabel.setGravity(1);
        linearContainer.addView((View)tvLabel);
        for (int i = 0; i < this.raasSchemaList.size(); ++i) {
            UserRegistration userField = this.raasSchemaList.get(i);
            if (userField.getRules() == null) continue;
            if (userField.getRules().contains("required") && !isRequiredAdded) {
                isRequiredAdded = this.fieldUtil.addFieldView(this.gtr, this.userProfile, userField, linearContainer, customFields, this.promptPassword);
                continue;
            }
            this.fieldUtil.addFieldView(this.gtr, this.userProfile, userField, linearContainer, customFields, this.promptPassword);
        }
        if (isRequiredAdded || this.askOptionalOnSocialLogin && this.userProfile.getNoOfLogins() == 1) {
            Button submitButton = this.gtr.generateSubmitButton("Register");
            submitButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe(){

                        public void subscribe(ObservableEmitter e) throws Exception {
                            WeChatNativeActivity.this.startUpdateProcess(linearContainer);
                        }
                    });
                    observable.subscribe();
                }
            });
            linearContainer.addView((View)submitButton);
            return svParent;
        }
        return this.gtr.generateParentView();
    }

    private void startUpdateProcess(LinearLayout linearContainer) {
        Log.i((String)"AccessToken", (String)WeChatNativeActivity.wxResponse.access_token);
        if (this.fieldUtil.validateFields(this.gtr, linearContainer)) {
            this.setContentView((View)this.gtr.generateProgressBar());
            AuthenticationAPI api = new AuthenticationAPI();
            QueryParams queryParams = new QueryParams();
            queryParams.setAccess_token(WeChatNativeActivity.wxResponse.access_token);
            JsonObject jsonData = this.fieldUtil.getData(this.gtr, linearContainer);
            api.updateProfile(queryParams, jsonData, new AsyncHandler<UpdateProfileResponse>(){

                @Override
                public void onSuccess(UpdateProfileResponse data) {
                    if (WeChatNativeActivity.this.fieldUtil.getPhone() != null) {
                        WeChatNativeActivity.this.showMobileInfoDialog();
                        return;
                    }
                    if (WeChatNativeActivity.this.fieldUtil.getEmail() != null) {
                        WeChatNativeActivity.this.showEmailInfoDialog();
                        return;
                    }
                    WeChatNativeActivity.this.sendAccessToken(WeChatNativeActivity.wxResponse.access_token, WeChatNativeActivity.wxResponse.refresh_token, WeChatNativeActivity.wxResponse.expires_in, null);
                }

                @Override
                public void onFailure(Throwable error, String errorcode) {
                    ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                    int errorCode = errorResponse.getErrorCode();
                    Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                    switch (errorCode) {
                        case 936: {
                            Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"Email already exists", (int)0).show();
                            WeChatNativeActivity.this.setRequiredFieldsView();
                            break;
                        }
                        case 1058: {
                            Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"Mobile number already exists", (int)0).show();
                            WeChatNativeActivity.this.setRequiredFieldsView();
                            break;
                        }
                        case 970: {
                            WeChatNativeActivity.this.showEmailInfoDialog();
                            break;
                        }
                        case 1066: {
                            WeChatNativeActivity.this.showMobileInfoDialog();
                            break;
                        }
                        default: {
                            Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                            WeChatNativeActivity.this.setRequiredFieldsView();
                        }
                    }
                }
            });
        }
    }

    private void showEmailInfoDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.context);
        alert.setTitle((CharSequence)"Message");
        alert.setMessage((CharSequence)"We've sent a verification mail on your email address. Please verify your email address to login.");
        alert.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WeChatNativeActivity.this.sendAccessToken(null, null, null, "We've sent a verification mail on your email address. Please verify your email address to login.");
            }
        });
        AlertDialog dialog = alert.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void showMobileInfoDialog() {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.context);
        alert.setTitle((CharSequence)"Message");
        alert.setMessage((CharSequence)"We've sent an OTP on your mobile number. Please verify your mobile number to login.");
        alert.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WeChatNativeActivity.this.setOTPView();
            }
        });
        AlertDialog dialog = alert.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void setOTPView() {
        RelativeLayout view = this.gtr.generateOTPLayout();
        Button btnSubmit = (Button)view.findViewWithTag((Object)"submit");
        Button btnResend = (Button)view.findViewWithTag((Object)"resend_otp");
        final EditText etOTP = (EditText)view.findViewWithTag((Object)"otp");
        btnSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String otp = etOTP.getText().toString().trim();
                if (otp.length() == 0) {
                    etOTP.setError((CharSequence)"Required");
                    etOTP.setBackgroundResource(R.drawable.red_border);
                } else {
                    WeChatNativeActivity.this.submitOTP(otp);
                }
            }
        });
        btnResend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WeChatNativeActivity.this.resendOTP();
            }
        });
        this.setContentView((View)view);
    }

    private void resendOTP() {
        this.setContentView((View)this.gtr.generateProgressBar());
        AuthenticationAPI api = new AuthenticationAPI();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Phone", this.fieldUtil.getPhone());
        api.resendOtp(null, jsonObject, new AsyncHandler<RegisterResponse>(){

            @Override
            public void onSuccess(RegisterResponse data) {
                Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"OTP sent to your mobile number", (int)0).show();
                WeChatNativeActivity.this.setOTPView();
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                int errorCode = errorResponse.getErrorCode();
                Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                WeChatNativeActivity.this.setOTPView();
            }
        });
    }

    private void submitOTP(String otp) {
        this.setContentView((View)this.gtr.generateProgressBar());
        AuthenticationAPI api = new AuthenticationAPI();
        QueryParams queryParams = new QueryParams();
        queryParams.setOtp(otp);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Phone", this.fieldUtil.getPhone());
        api.verifyOtp(queryParams, jsonObject, new AsyncHandler<LoginData>(){

            @Override
            public void onSuccess(LoginData data) {
                WeChatNativeActivity.this.sendAccessToken(data.getAccessToken(), data.getRefreshToken(), data.getExpiresIn(), null);
            }

            @Override
            public void onFailure(Throwable error, String errorcode) {
                ErrorResponse errorResponse = JsonDeserializer.deserializeJson(error.getMessage(), ErrorResponse.class);
                int errorCode = errorResponse.getErrorCode();
                Log.i((String)"ErrorCode", (String)String.valueOf(errorCode));
                if (errorCode == 1067) {
                    Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"OTP is not correct. Please try again", (int)0).show();
                } else {
                    Toast.makeText((Context)WeChatNativeActivity.this.context, (CharSequence)"Unable to complete the request at the moment", (int)0).show();
                }
                WeChatNativeActivity.this.setOTPView();
            }
        });
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void sendAccessToken(String accessToken, String refreshToken, String expiresIn, String error) {
        wxResponse.setAccess_token(accessToken);
        wxResponse.setRefresh_token(refreshToken);
        wxResponse.setProvider("wechat");
        wxResponse.setExpires_in(expiresIn);
        wxError = error;
        this.finish();
    }

    static {
        isRequired = false;
        fieldsColor = 0;
    }
}

