/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.sencent.qrcodelib.BarcodeType;
import com.sencent.qrcodelib.CameraPreview;
import com.sencent.qrcodelib.IdentifyUtil;
import com.sencent.qrcodelib.ProcessDataTask;
import com.sencent.qrcodelib.R;
import com.sencent.qrcodelib.ScanBoxView;
import com.sencent.qrcodelib.ScanResult;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0007\n\u0002\b\r\b&\u0018\u0000 \u0093\u00012\u00020\u00012\u00020\u0002:\u0004\u0093\u0001\u0094\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020FJ\u0006\u0010H\u001a\u00020FJ\u000e\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020KJ\u000e\u0010I\u001a\u00020F2\u0006\u0010L\u001a\u00020MJ\u0010\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u00020\t2\u0006\u0010R\u001a\u00020\tH\u0002J\u0006\u0010S\u001a\u00020\u001eJ\u0006\u0010T\u001a\u00020@J\b\u0010U\u001a\u0004\u0018\u00010:J\u001a\u0010V\u001a\u00020F2\b\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010Y\u001a\u00020\u0013H\u0002J%\u0010Z\u001a\u00020@2\u000e\u0010[\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0006\u0010\\\u001a\u00020MH\u0002\u00a2\u0006\u0002\u0010]J\u0006\u0010^\u001a\u00020FJ\b\u0010_\u001a\u00020@H\u0004J\b\u0010`\u001a\u00020@H\u0004J\u0006\u0010a\u001a\u00020FJ\b\u0010b\u001a\u00020FH\u0014J\u0017\u0010c\u001a\u00020F2\b\u0010d\u001a\u0004\u0018\u00010eH\u0000\u00a2\u0006\u0002\bfJ\u0017\u0010g\u001a\u00020F2\b\u0010d\u001a\u0004\u0018\u00010eH\u0000\u00a2\u0006\u0002\bhJ\u001c\u0010i\u001a\u00020F2\b\u0010W\u001a\u0004\u0018\u00010X2\b\u0010Y\u001a\u0004\u0018\u00010\u0013H\u0016J\u0015\u0010j\u001a\u00020F2\u0006\u0010k\u001a\u00020lH\u0000\u00a2\u0006\u0002\bmJ\u0006\u0010n\u001a\u00020FJ\u0006\u0010o\u001a\u00020FJ\u0014\u0010p\u001a\u0004\u0018\u00010e2\b\u0010J\u001a\u0004\u0018\u00010KH&J,\u0010q\u001a\u0004\u0018\u00010e2\b\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010r\u001a\u00020\t2\u0006\u0010s\u001a\u00020\t2\u0006\u0010t\u001a\u00020@H&J\u0006\u0010u\u001a\u00020FJ\u000e\u0010v\u001a\u00020F2\u0006\u0010w\u001a\u00020$J\b\u0010x\u001a\u00020FH\u0002J\b\u0010y\u001a\u00020FH$J\u0006\u0010z\u001a\u00020FJ \u0010{\u001a\u00020F2\u0006\u0010|\u001a\u00020\t2\u0006\u0010}\u001a\u00020\t2\u0006\u0010\\\u001a\u00020MH\u0002J\b\u0010~\u001a\u00020FH\u0016J\u000e\u0010~\u001a\u00020F2\u0006\u0010R\u001a\u00020\tJ\u0011\u0010\u007f\u001a\u00020F2\u0007\u0010\u0080\u0001\u001a\u00020\tH\u0002J\u0007\u0010\u0081\u0001\u001a\u00020FJ\u0007\u0010\u0082\u0001\u001a\u00020FJ\t\u0010\u0083\u0001\u001a\u00020FH\u0016J\u0007\u0010\u0084\u0001\u001a\u00020FJ\u0007\u0010\u0085\u0001\u001a\u00020FJN\u0010\u0086\u0001\u001a\u00020/2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u0088\u00012\b\u0010\u008a\u0001\u001a\u00030\u0088\u00012\b\u0010\u008b\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008c\u0001\u001a\u00020@2\u0007\u0010\u008d\u0001\u001a\u00020\t2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010lH\u0002J<\u0010\u008f\u0001\u001a\u00020@2\u000f\u0010\u0090\u0001\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010l2\u0007\u0010\u0091\u0001\u001a\u00020@2\u0006\u0010\\\u001a\u00020MH\u0004\u00a2\u0006\u0003\u0010\u0092\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00100R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00103\u001a\u0004\u0018\u000104X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006\u0095\u0001"}, d2={"Lcom/sencent/qrcodelib/QRCodeView;", "Landroid/widget/RelativeLayout;", "Landroid/hardware/Camera$PreviewCallback;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mAmbientBrightnessDarkIndex", "", "mAutoZoomAnimator", "Landroid/animation/ValueAnimator;", "mBarcodeType", "Lcom/sencent/qrcodelib/BarcodeType;", "getMBarcodeType", "()Lcom/sencent/qrcodelib/BarcodeType;", "setMBarcodeType", "(Lcom/sencent/qrcodelib/BarcodeType;)V", "mCamera", "Landroid/hardware/Camera;", "getMCamera", "()Landroid/hardware/Camera;", "setMCamera", "(Landroid/hardware/Camera;)V", "mCameraId", "getMCameraId", "()I", "setMCameraId", "(I)V", "mCameraPreview", "Lcom/sencent/qrcodelib/CameraPreview;", "getMCameraPreview", "()Lcom/sencent/qrcodelib/CameraPreview;", "setMCameraPreview", "(Lcom/sencent/qrcodelib/CameraPreview;)V", "mDelegate", "Lcom/sencent/qrcodelib/QRCodeView$Delegate;", "getMDelegate", "()Lcom/sencent/qrcodelib/QRCodeView$Delegate;", "setMDelegate", "(Lcom/sencent/qrcodelib/QRCodeView$Delegate;)V", "mLastAmbientBrightnessRecordTime", "", "mLastAutoZoomTime", "mLastPreviewFrameTime", "mLocationPoints", "", "Landroid/graphics/PointF;", "[Landroid/graphics/PointF;", "mPaint", "Landroid/graphics/Paint;", "mProcessDataTask", "Lcom/sencent/qrcodelib/ProcessDataTask;", "getMProcessDataTask", "()Lcom/sencent/qrcodelib/ProcessDataTask;", "setMProcessDataTask", "(Lcom/sencent/qrcodelib/ProcessDataTask;)V", "mScanBoxView", "Lcom/sencent/qrcodelib/ScanBoxView;", "getMScanBoxView", "()Lcom/sencent/qrcodelib/ScanBoxView;", "setMScanBoxView", "(Lcom/sencent/qrcodelib/ScanBoxView;)V", "mSpotAble", "", "getMSpotAble", "()Z", "setMSpotAble", "(Z)V", "changeToScanBarcodeStyle", "", "changeToScanQRCodeStyle", "closeFlashlight", "decodeQRCode", "bitmap", "Landroid/graphics/Bitmap;", "picturePath", "", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "findCameraIdByFacing", "cameraFacing", "getCameraPreview", "getIsScanBarcodeStyle", "getScanBoxView", "handleAmbientBrightness", "data", "", "camera", "handleAutoZoom", "locationPoints", "result", "([Landroid/graphics/PointF;Ljava/lang/String;)Z", "hiddenScanRect", "isAutoZoom", "isShowLocationPoint", "onDestroy", "onDetachedFromWindow", "onPostParseBitmapOrPicture", "scanResult", "Lcom/sencent/qrcodelib/ScanResult;", "onPostParseBitmapOrPicture$library_release", "onPostParseData", "onPostParseData$library_release", "onPreviewFrame", "onScanBoxRectChanged", "rect", "Landroid/graphics/Rect;", "onScanBoxRectChanged$library_release", "openFlashlight", "pauseCamera", "processBitmapData", "processData", "width", "height", "isRetry", "resumeCamera", "setDelegate", "delegate", "setOneShotPreviewCallback", "setupReader", "showScanRect", "startAutoZoom", "oldZoom", "newZoom", "startCamera", "startCameraById", "cameraId", "startSpot", "startSpotAndShowRect", "stopCamera", "stopSpot", "stopSpotAndHiddenRect", "transform", "originX", "", "originY", "cameraPreviewWidth", "cameraPreviewHeight", "isMirrorPreview", "statusBarHeight", "scanBoxAreaRect", "transformToViewCoordinates", "pointArr", "isNeedAutoZoom", "([Landroid/graphics/PointF;Landroid/graphics/Rect;ZLjava/lang/String;)Z", "Companion", "Delegate", "library_release"})
public abstract class QRCodeView
extends RelativeLayout
implements Camera.PreviewCallback {
    @Nullable
    private Camera mCamera;
    @NotNull
    private CameraPreview mCameraPreview;
    @Nullable
    private ScanBoxView mScanBoxView;
    @Nullable
    private Delegate mDelegate;
    private boolean mSpotAble;
    @Nullable
    private ProcessDataTask mProcessDataTask;
    private int mCameraId;
    private PointF[] mLocationPoints;
    private Paint mPaint;
    @NotNull
    private BarcodeType mBarcodeType;
    private long mLastPreviewFrameTime;
    private ValueAnimator mAutoZoomAnimator;
    private long mLastAutoZoomTime;
    private long mLastAmbientBrightnessRecordTime;
    private int mAmbientBrightnessDarkIndex;
    private static final int NO_CAMERA_ID = -1;
    private static final long[] AMBIENT_BRIGHTNESS_DARK_LIST;
    private static final int AMBIENT_BRIGHTNESS_WAIT_SCAN_TIME = 150;
    private static final int AMBIENT_BRIGHTNESS_DARK = 60;
    public static final Companion Companion;

    @Nullable
    protected final Camera getMCamera() {
        return this.mCamera;
    }

    protected final void setMCamera(@Nullable Camera camera) {
        this.mCamera = camera;
    }

    @NotNull
    protected final CameraPreview getMCameraPreview() {
        return this.mCameraPreview;
    }

    protected final void setMCameraPreview(@NotNull CameraPreview cameraPreview) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cameraPreview), (String)"<set-?>");
        this.mCameraPreview = cameraPreview;
    }

    @Nullable
    protected final ScanBoxView getMScanBoxView() {
        return this.mScanBoxView;
    }

    protected final void setMScanBoxView(@Nullable ScanBoxView scanBoxView) {
        this.mScanBoxView = scanBoxView;
    }

    @Nullable
    protected final Delegate getMDelegate() {
        return this.mDelegate;
    }

    protected final void setMDelegate(@Nullable Delegate delegate) {
        this.mDelegate = delegate;
    }

    protected final boolean getMSpotAble() {
        return this.mSpotAble;
    }

    protected final void setMSpotAble(boolean bl) {
        this.mSpotAble = bl;
    }

    @Nullable
    protected final ProcessDataTask getMProcessDataTask() {
        return this.mProcessDataTask;
    }

    protected final void setMProcessDataTask(@Nullable ProcessDataTask processDataTask) {
        this.mProcessDataTask = processDataTask;
    }

    protected final int getMCameraId() {
        return this.mCameraId;
    }

    protected final void setMCameraId(int n) {
        this.mCameraId = n;
    }

    @NotNull
    protected final BarcodeType getMBarcodeType() {
        return this.mBarcodeType;
    }

    protected final void setMBarcodeType(@NotNull BarcodeType barcodeType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)barcodeType), (String)"<set-?>");
        this.mBarcodeType = barcodeType;
    }

    private final void setOneShotPreviewCallback() {
        Camera camera = this.mCamera;
        if (camera == null) {
            return;
        }
        Camera camera2 = camera;
        if (this.mSpotAble && this.mCameraPreview.isPreviewing()) {
            try {
                camera2.setOneShotPreviewCallback((Camera.PreviewCallback)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract void setupReader();

    public final void setDelegate(@NotNull Delegate delegate) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.mDelegate = delegate;
    }

    @NotNull
    public final CameraPreview getCameraPreview() {
        return this.mCameraPreview;
    }

    @Nullable
    public final ScanBoxView getScanBoxView() {
        return this.mScanBoxView;
    }

    public final void showScanRect() {
        if (this.mScanBoxView != null) {
            ScanBoxView scanBoxView = this.mScanBoxView;
            if (scanBoxView == null) {
                Intrinsics.throwNpe();
            }
            scanBoxView.setVisibility(0);
        }
    }

    public final void hiddenScanRect() {
        if (this.mScanBoxView != null) {
            ScanBoxView scanBoxView = this.mScanBoxView;
            if (scanBoxView == null) {
                Intrinsics.throwNpe();
            }
            scanBoxView.setVisibility(8);
        }
    }

    public void startCamera() {
        this.startCamera(this.mCameraId);
    }

    public final void startCamera(int cameraFacing) {
        if (this.mCamera != null || Camera.getNumberOfCameras() == 0) {
            return;
        }
        int ultimateCameraId = this.findCameraIdByFacing(cameraFacing);
        if (ultimateCameraId != NO_CAMERA_ID) {
            this.startCameraById(ultimateCameraId);
            return;
        }
        if (cameraFacing == 0) {
            ultimateCameraId = this.findCameraIdByFacing(1);
        } else if (cameraFacing == 1) {
            ultimateCameraId = this.findCameraIdByFacing(0);
        }
        if (ultimateCameraId != NO_CAMERA_ID) {
            this.startCameraById(ultimateCameraId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int findCameraIdByFacing(int cameraFacing) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int n = 0;
        int n2 = Camera.getNumberOfCameras();
        while (n < n2) {
            void cameraId;
            try {
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing == cameraFacing) {
                    return (int)cameraId;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++cameraId;
        }
        return NO_CAMERA_ID;
    }

    private final void startCameraById(int cameraId) {
        block3: {
            try {
                this.mCameraId = cameraId;
                this.mCamera = Camera.open((int)cameraId);
                this.mCameraPreview.setCamera(this.mCamera);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mDelegate == null) break block3;
                Delegate delegate = this.mDelegate;
                if (delegate == null) {
                    Intrinsics.throwNpe();
                }
                delegate.onScanQRCodeOpenCameraError();
            }
        }
    }

    public void stopCamera() {
        try {
            this.stopSpotAndHiddenRect();
            if (this.mCamera != null) {
                this.mCameraPreview.stopCameraPreview();
                this.mCameraPreview.setCamera(null);
                Camera camera = this.mCamera;
                if (camera == null) {
                    Intrinsics.throwNpe();
                }
                camera.release();
                this.mCamera = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void resumeCamera() {
        if (this.mCamera != null) {
            this.mCameraPreview.reactNativeShowCameraPreview();
        }
    }

    public final void pauseCamera() {
        if (this.mCamera != null) {
            this.mCameraPreview.stopCameraPreview();
        }
    }

    public final void startSpot() {
        this.mSpotAble = true;
        this.startCamera();
        this.setOneShotPreviewCallback();
    }

    public final void stopSpot() {
        this.mSpotAble = false;
        if (this.mProcessDataTask != null) {
            ProcessDataTask processDataTask = this.mProcessDataTask;
            if (processDataTask == null) {
                Intrinsics.throwNpe();
            }
            processDataTask.cancelTask();
            this.mProcessDataTask = null;
        }
        if (this.mCamera != null) {
            try {
                Camera camera = this.mCamera;
                if (camera == null) {
                    Intrinsics.throwNpe();
                }
                camera.setOneShotPreviewCallback(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void stopSpotAndHiddenRect() {
        this.stopSpot();
        this.hiddenScanRect();
    }

    public final void startSpotAndShowRect() {
        this.startSpot();
        this.showScanRect();
    }

    public final void openFlashlight() {
        this.postDelayed(new Runnable(this){
            final /* synthetic */ QRCodeView this$0;

            public final void run() {
                this.this$0.getMCameraPreview().openFlashlight();
            }
            {
                this.this$0 = qRCodeView;
            }
        }, this.mCameraPreview.isPreviewing() ? 0 : 500);
    }

    public final void closeFlashlight() {
        this.mCameraPreview.closeFlashlight();
    }

    public final void onDestroy() {
        this.stopCamera();
        this.mDelegate = null;
    }

    public final void changeToScanBarcodeStyle() {
        ScanBoxView scanBoxView = this.mScanBoxView;
        if (scanBoxView == null) {
            return;
        }
        ScanBoxView scanBoxView2 = scanBoxView;
        if (!scanBoxView2.getIsBarcode()) {
            scanBoxView2.setIsBarcode(true);
        }
    }

    public final void changeToScanQRCodeStyle() {
        ScanBoxView scanBoxView = this.mScanBoxView;
        if (scanBoxView == null) {
            return;
        }
        ScanBoxView scanBoxView2 = scanBoxView;
        if (scanBoxView2.getIsBarcode()) {
            scanBoxView2.setIsBarcode(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getIsScanBarcodeStyle() {
        if (this.mScanBoxView != null) return false;
        ScanBoxView scanBoxView = this.mScanBoxView;
        if (scanBoxView == null) {
            Intrinsics.throwNpe();
        }
        if (!scanBoxView.getIsBarcode()) return false;
        return true;
    }

    public void onPreviewFrame(@Nullable byte[] data, @Nullable Camera camera) {
        block11: {
            block10: {
                Camera camera2 = camera;
                if (camera2 == null) {
                    return;
                }
                Camera currentCamera = camera2;
                if (IdentifyUtil.INSTANCE.isDebug()) {
                    IdentifyUtil.INSTANCE.d("\u4e24\u6b21 onPreviewFrame \u65f6\u95f4\u95f4\u9694\uff1a" + (System.currentTimeMillis() - this.mLastPreviewFrameTime));
                    this.mLastPreviewFrameTime = System.currentTimeMillis();
                }
                if (this.mCameraPreview.isPreviewing()) {
                    try {
                        this.handleAmbientBrightness(data, currentCamera);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!this.mSpotAble) break block10;
                if (this.mProcessDataTask == null) break block11;
                ProcessDataTask processDataTask = this.mProcessDataTask;
                if (processDataTask == null) {
                    Intrinsics.throwNpe();
                }
                if (processDataTask.getStatus() == AsyncTask.Status.PENDING) break block10;
                ProcessDataTask processDataTask2 = this.mProcessDataTask;
                if (processDataTask2 == null) {
                    Intrinsics.throwNpe();
                }
                if (processDataTask2.getStatus() != AsyncTask.Status.RUNNING) break block11;
            }
            return;
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.mProcessDataTask = new ProcessDataTask(camera, data, this, IdentifyUtil.INSTANCE.isPortrait(context)).perform();
    }

    private final void handleAmbientBrightness(byte[] data, Camera camera) {
        if (!this.mCameraPreview.isPreviewing()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastAmbientBrightnessRecordTime < (long)AMBIENT_BRIGHTNESS_WAIT_SCAN_TIME) {
            return;
        }
        this.mLastAmbientBrightnessRecordTime = currentTime;
        Camera.Parameters parameters = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"camera.parameters");
        int width = parameters.getPreviewSize().width;
        Camera.Parameters parameters2 = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"camera.parameters");
        int height = parameters2.getPreviewSize().height;
        long pixelLightCount = 0L;
        long pixelCount = width * height;
        int step = 10;
        if (data == null) {
            return;
        }
        byte[] previewData = data;
        if (Math.abs((float)previewData.length - (float)pixelCount * 1.5f) < 1.0E-5f) {
            int i = 0;
            while ((long)i < pixelCount) {
                pixelLightCount += (long)previewData[i] & 0xFFL;
                i += step;
            }
            long cameraLight = pixelLightCount / (pixelCount / (long)step);
            int lightSize = AMBIENT_BRIGHTNESS_DARK_LIST.length;
            this.mAmbientBrightnessDarkIndex %= lightSize;
            QRCodeView.AMBIENT_BRIGHTNESS_DARK_LIST[this.mAmbientBrightnessDarkIndex] = cameraLight;
            int n = this.mAmbientBrightnessDarkIndex;
            this.mAmbientBrightnessDarkIndex = n + 1;
            boolean isDarkEnv = true;
            for (long ambientBrightness : AMBIENT_BRIGHTNESS_DARK_LIST) {
                if (ambientBrightness <= (long)AMBIENT_BRIGHTNESS_DARK) continue;
                isDarkEnv = false;
                break;
            }
            IdentifyUtil.INSTANCE.d("\u6444\u50cf\u5934\u73af\u5883\u4eae\u5ea6\u4e3a\uff1a" + cameraLight);
            if (this.mDelegate != null) {
                Delegate delegate = this.mDelegate;
                if (delegate == null) {
                    Intrinsics.throwNpe();
                }
                delegate.onCameraAmbientBrightnessChanged(isDarkEnv);
            }
        }
    }

    public final void decodeQRCode(@NotNull String picturePath) {
        Intrinsics.checkParameterIsNotNull((Object)picturePath, (String)"picturePath");
        this.mProcessDataTask = new ProcessDataTask(picturePath, this).perform();
    }

    public final void decodeQRCode(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.mProcessDataTask = new ProcessDataTask(bitmap, this).perform();
    }

    @Nullable
    public abstract ScanResult processData(@Nullable byte[] var1, int var2, int var3, boolean var4);

    @Nullable
    public abstract ScanResult processBitmapData(@Nullable Bitmap var1);

    public final void onPostParseData$library_release(@Nullable ScanResult scanResult) {
        String result;
        if (!this.mSpotAble) {
            return;
        }
        ScanResult scanResult2 = scanResult;
        String string = result = scanResult2 != null ? scanResult2.getResult() : null;
        if (TextUtils.isEmpty((CharSequence)result)) {
            Camera camera = this.mCamera;
            if (camera == null) {
                return;
            }
            Camera camera2 = camera;
            try {
                camera2.setOneShotPreviewCallback((Camera.PreviewCallback)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.mSpotAble = false;
            Delegate delegate = this.mDelegate;
            if (delegate == null) {
                return;
            }
            Delegate delegate2 = delegate;
            try {
                delegate2.onScanQRCodeSuccess(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void onPostParseBitmapOrPicture$library_release(@Nullable ScanResult scanResult) {
        Delegate delegate = this.mDelegate;
        if (delegate == null) {
            return;
        }
        Delegate delegate2 = delegate;
        ScanResult scanResult2 = scanResult;
        String result = scanResult2 != null ? scanResult2.getResult() : null;
        delegate2.onScanQRCodeSuccess(result);
    }

    public final void onScanBoxRectChanged$library_release(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        this.mCameraPreview.onScanBoxRectChanged$library_release(rect);
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        if (this.mLocationPoints == null) {
            return;
        }
        PointF[] locationPoints = this.mLocationPoints;
        if (!this.isShowLocationPoint()) {
            return;
        }
        for (PointF pointF : locationPoints) {
            canvas.drawCircle(pointF.x, pointF.y, 10.0f, this.mPaint);
        }
        this.mLocationPoints = null;
        this.postInvalidateDelayed(2000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isShowLocationPoint() {
        if (this.mScanBoxView == null) return false;
        ScanBoxView scanBoxView = this.mScanBoxView;
        if (scanBoxView == null) {
            Intrinsics.throwNpe();
        }
        if (!scanBoxView.isShowLocationPoint()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isAutoZoom() {
        if (this.mScanBoxView == null) return false;
        ScanBoxView scanBoxView = this.mScanBoxView;
        if (scanBoxView == null) {
            Intrinsics.throwNpe();
        }
        if (!scanBoxView.isAutoZoom()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean transformToViewCoordinates(@Nullable PointF[] pointArr, @Nullable Rect scanBoxAreaRect, boolean isNeedAutoZoom, @NotNull String result) {
        PointF[] pointFArray;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (pointArr == null || (pointFArray = pointArr).length == 0) {
            return false;
        }
        Camera camera = this.mCamera;
        if (camera == null) {
            return false;
        }
        Camera camera2 = camera;
        try {
            Camera.Parameters parameters = camera2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"camera.parameters");
            Camera.Size size = parameters.getPreviewSize();
            boolean isMirrorPreview = this.mCameraId == 1;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            int statusBarHeight = IdentifyUtil.INSTANCE.getStatusBarHeight(context);
            int size$iv = pointArr.length;
            PointF[] result$iv = new PointF[size$iv];
            int n = 0;
            int n2 = result$iv.length;
            while (n < n2) {
                void it;
                PointF pointF;
                void i$iv;
                void var14_14 = i$iv;
                void var18_16 = i$iv++;
                PointF[] pointFArray2 = result$iv;
                pointFArray2[var18_16] = pointF = this.transform(pointArr[it].x, pointArr[it].y, size.width, size.height, isMirrorPreview, statusBarHeight, scanBoxAreaRect);
            }
            PointF[] transformedPoints = result$iv;
            this.mLocationPoints = transformedPoints;
            this.postInvalidate();
            return isNeedAutoZoom ? this.handleAutoZoom(transformedPoints, result) : false;
        }
        catch (Exception e) {
            this.mLocationPoints = null;
            e.printStackTrace();
            return false;
        }
    }

    private final boolean handleAutoZoom(PointF[] locationPoints, String result) {
        int scanBoxWidth;
        float yLen;
        Camera.Parameters parameters;
        PointF[] pointFArray;
        Camera camera = this.mCamera;
        if (camera == null) {
            return false;
        }
        Camera camera2 = camera;
        ScanBoxView scanBoxView = this.mScanBoxView;
        if (scanBoxView == null) {
            return false;
        }
        ScanBoxView scanBoxView2 = scanBoxView;
        if (locationPoints == null || (pointFArray = locationPoints).length == 0) {
            return false;
        }
        if (this.mAutoZoomAnimator != null) {
            ValueAnimator valueAnimator = this.mAutoZoomAnimator;
            if (valueAnimator == null) {
                Intrinsics.throwNpe();
            }
            if (valueAnimator.isRunning()) {
                return true;
            }
        }
        if (System.currentTimeMillis() - this.mLastAutoZoomTime < (long)1200) {
            return true;
        }
        Camera.Parameters parameters2 = parameters = camera2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
        if (!parameters2.isZoomSupported()) {
            return false;
        }
        float point1X = locationPoints[0].x;
        float point1Y = locationPoints[0].y;
        float point2X = locationPoints[1].x;
        float point2Y = locationPoints[1].y;
        float xLen = Math.abs(point1X - point2X);
        int len = (int)Math.sqrt(xLen * xLen + (yLen = Math.abs(point1Y - point2Y)) * yLen);
        if (len > (scanBoxWidth = scanBoxView2.getRectWidth()) / 4) {
            return false;
        }
        int maxZoom = parameters.getMaxZoom();
        int zoomStep = maxZoom / 4;
        int zoom = parameters.getZoom();
        this.post(new Runnable(this, zoom, zoomStep, maxZoom, result){
            final /* synthetic */ QRCodeView this$0;
            final /* synthetic */ int $zoom;
            final /* synthetic */ int $zoomStep;
            final /* synthetic */ int $maxZoom;
            final /* synthetic */ String $result;

            public final void run() {
                QRCodeView.access$startAutoZoom(this.this$0, this.$zoom, Math.min(this.$zoom + this.$zoomStep, this.$maxZoom), this.$result);
            }
            {
                this.this$0 = qRCodeView;
                this.$zoom = n;
                this.$zoomStep = n2;
                this.$maxZoom = n3;
                this.$result = string;
            }
        });
        return true;
    }

    private final void startAutoZoom(int oldZoom, int newZoom, String result) {
        Camera camera = this.mCamera;
        if (camera == null) {
            return;
        }
        Camera camera2 = camera;
        ValueAnimator valueAnimator = this.mAutoZoomAnimator = ValueAnimator.ofInt((int[])new int[]{oldZoom, newZoom});
        if (valueAnimator == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, camera2){
            final /* synthetic */ QRCodeView this$0;
            final /* synthetic */ Camera $camera;

            public final void onAnimationUpdate(ValueAnimator animation) {
                Camera.Parameters parameters;
                if (this.this$0.getMCameraPreview() == null || !this.this$0.getMCameraPreview().isPreviewing()) {
                    return;
                }
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                int zoom = (Integer)object;
                Camera.Parameters parameters2 = parameters = this.$camera.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
                parameters2.setZoom(zoom);
                this.$camera.setParameters(parameters);
            }
            {
                this.this$0 = qRCodeView;
                this.$camera = camera;
            }
        });
        ValueAnimator valueAnimator2 = this.mAutoZoomAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, result){
            final /* synthetic */ QRCodeView this$0;
            final /* synthetic */ String $result;

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                this.this$0.onPostParseData$library_release(new ScanResult(this.$result));
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
            }
        });
        ValueAnimator valueAnimator3 = this.mAutoZoomAnimator;
        if (valueAnimator3 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator3.setDuration(600L);
        ValueAnimator valueAnimator4 = this.mAutoZoomAnimator;
        if (valueAnimator4 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator4.setRepeatCount(0);
        ValueAnimator valueAnimator5 = this.mAutoZoomAnimator;
        if (valueAnimator5 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator5.start();
        this.mLastAutoZoomTime = System.currentTimeMillis();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAutoZoomAnimator != null) {
            ValueAnimator valueAnimator = this.mAutoZoomAnimator;
            if (valueAnimator == null) {
                Intrinsics.throwNpe();
            }
            valueAnimator.cancel();
        }
    }

    private final PointF transform(float originX, float originY, float cameraPreviewWidth, float cameraPreviewHeight, boolean isMirrorPreview, int statusBarHeight, Rect scanBoxAreaRect) {
        PointF result;
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        if (IdentifyUtil.INSTANCE.isPortrait(context)) {
            float scaleX = (float)viewWidth / cameraPreviewHeight;
            float scaleY = (float)viewHeight / cameraPreviewWidth;
            result = new PointF((cameraPreviewHeight - originX) * scaleX, (cameraPreviewWidth - originY) * scaleY);
            result.y = (float)viewHeight - result.y;
            result.x = (float)viewWidth - result.x;
            if (scanBoxAreaRect == null) {
                result.y += (float)statusBarHeight;
            }
        } else {
            float scaleX = (float)viewWidth / cameraPreviewWidth;
            float scaleY = (float)viewHeight / cameraPreviewHeight;
            result = new PointF(originX * scaleX, originY * scaleY);
            if (isMirrorPreview) {
                result.x = (float)viewWidth - result.x;
            }
        }
        if (scanBoxAreaRect != null) {
            result.y += (float)scanBoxAreaRect.top;
            result.x += (float)scanBoxAreaRect.left;
        }
        return result;
    }

    public QRCodeView(@NotNull Context context, @Nullable AttributeSet attrs) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.mCameraPreview = new CameraPreview(context);
        this.mPaint = new Paint();
        this.mBarcodeType = BarcodeType.HIGH_FREQUENCY;
        this.mLastAmbientBrightnessRecordTime = System.currentTimeMillis();
        this.mCameraPreview.setDelegate$library_release(new CameraPreview.Delegate(){

            @Override
            public void onStartPreview() {
                this.setOneShotPreviewCallback();
            }
        });
        ScanBoxView scanBoxView = this.mScanBoxView = new ScanBoxView(context);
        if (scanBoxView != null) {
            scanBoxView.init(this, attrs);
        }
        this.mCameraPreview.setId(R.id.qrcode_camera_preview);
        this.addView((View)this.mCameraPreview);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(context, attrs);
        layoutParams.addRule(6, this.mCameraPreview.getId());
        layoutParams.addRule(8, this.mCameraPreview.getId());
        this.addView(this.mScanBoxView, (ViewGroup.LayoutParams)layoutParams);
        this.mPaint = new Paint();
        if (this.getScanBoxView() == null) {
            n = -1;
        } else {
            ScanBoxView scanBoxView2 = this.getScanBoxView();
            if (scanBoxView2 == null) {
                Intrinsics.throwNpe();
            }
            n = scanBoxView2.getCornerColor();
        }
        this.mPaint.setColor(n);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.setupReader();
    }

    static {
        Companion = new Companion(null);
        NO_CAMERA_ID = -1;
        AMBIENT_BRIGHTNESS_DARK_LIST = new long[]{255L, 255L, 255L, 255L};
        AMBIENT_BRIGHTNESS_WAIT_SCAN_TIME = 150;
        AMBIENT_BRIGHTNESS_DARK = 60;
    }

    public static final /* synthetic */ void access$startAutoZoom(QRCodeView $this, int oldZoom, int newZoom, @NotNull String result) {
        $this.startAutoZoom(oldZoom, newZoom, result);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0012\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/sencent/qrcodelib/QRCodeView$Delegate;", "", "onCameraAmbientBrightnessChanged", "", "isDark", "", "onScanQRCodeOpenCameraError", "onScanQRCodeSuccess", "result", "", "library_release"})
    public static interface Delegate {
        public void onScanQRCodeSuccess(@Nullable String var1);

        public void onCameraAmbientBrightnessChanged(boolean var1);

        public void onScanQRCodeOpenCameraError();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/sencent/qrcodelib/QRCodeView$Companion;", "", "()V", "AMBIENT_BRIGHTNESS_DARK", "", "AMBIENT_BRIGHTNESS_DARK_LIST", "", "AMBIENT_BRIGHTNESS_WAIT_SCAN_TIME", "NO_CAMERA_ID", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

