/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002J*\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J$\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010J \u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010J(\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\nJ2\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\nR-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/sencent/qrcodelib/QRCodeEncoder;", "", "()V", "HINTS", "Ljava/util/HashMap;", "Lcom/google/zxing/EncodeHintType;", "Lkotlin/collections/HashMap;", "getHINTS", "()Ljava/util/HashMap;", "addLogoToQRCode", "Landroid/graphics/Bitmap;", "src", "logo", "getRoundBitmapByShader", "bitmap", "offset", "", "radius", "", "boarder", "showContent", "barcodeBitmap", "content", "", "textSize", "syncEncodeBarcode", "width", "height", "syncEncodeQRCode", "size", "foregroundColor", "backgroundColor", "library_release"})
public final class QRCodeEncoder {
    @NotNull
    private static final HashMap<EncodeHintType, Object> HINTS;
    public static final QRCodeEncoder INSTANCE;

    @NotNull
    public final HashMap<EncodeHintType, Object> getHINTS() {
        return HINTS;
    }

    @Nullable
    public final Bitmap syncEncodeQRCode(@NotNull String content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        return this.syncEncodeQRCode(content, size, -16777216, -1, null);
    }

    @Nullable
    public final Bitmap syncEncodeQRCode(@NotNull String content, int size, int foregroundColor) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        return this.syncEncodeQRCode(content, size, foregroundColor, -1, null);
    }

    @Nullable
    public final Bitmap syncEncodeQRCode(@NotNull String content, int size, int foregroundColor, @NotNull Bitmap logo) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)logo, (String)"logo");
        return this.syncEncodeQRCode(content, size, foregroundColor, -1, logo);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bitmap syncEncodeQRCode(@NotNull String content, int size, int foregroundColor, int backgroundColor, @Nullable Bitmap logo) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, size, size, (Map)HINTS);
            int[] pixels = new int[size * size];
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void y;
                int n3 = 0;
                int n4 = size;
                while (n3 < n4) {
                    void x;
                    pixels[y * size + x] = matrix.get((int)x, (int)y) ? -16777216 : -1;
                    ++x;
                }
                ++y;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, size, 0, 0, size, size);
            return this.addLogoToQRCode(bitmap, logo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final Bitmap addLogoToQRCode(Bitmap src, Bitmap logo) {
        if (src == null || logo == null) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        float scaleFactor = (float)srcWidth * 1.0f / 5.0f / (float)logoWidth;
        Bitmap bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            Canvas canvas = new Canvas(bitmap2);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            canvas.scale(scaleFactor, scaleFactor, (float)(srcWidth / 2), (float)(srcHeight / 2));
            canvas.drawBitmap(logo, (float)((srcWidth - logoWidth) / 2), (float)((srcHeight - logoHeight) / 2), null);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    @Nullable
    public final Bitmap getRoundBitmapByShader(@Nullable Bitmap bitmap, int offset, float radius, float boarder) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int outWidth = width + offset;
        int outHeight = height + offset;
        float widthScale = (float)outWidth * 1.0f / (float)width;
        float heightScale = (float)outHeight * 1.0f / (float)height;
        Matrix matrix = new Matrix();
        matrix.setScale(widthScale, heightScale);
        Bitmap desBitmap = Bitmap.createBitmap((int)outWidth, (int)outHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(desBitmap);
        Paint paint = new Paint(1);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)bitmapShader);
        RectF rect = new RectF(boarder, boarder, (float)outWidth - boarder, (float)outHeight - boarder);
        canvas.drawRoundRect(rect, radius, radius, paint);
        if (boarder > 0.0f) {
            Paint boarderPaint = new Paint(1);
            boarderPaint.setColor(-1);
            boarderPaint.setStyle(Paint.Style.STROKE);
            boarderPaint.setStrokeWidth(boarder);
            canvas.drawRoundRect(rect, radius, radius, boarderPaint);
        }
        return desBitmap;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bitmap syncEncodeBarcode(@NotNull String content, int width, int height, int textSize) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        HashMap hints = new HashMap();
        Map map = hints;
        EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
        Object object = "utf-8";
        map.put(encodeHintType, object);
        map = hints;
        encodeHintType = EncodeHintType.ERROR_CORRECTION;
        object = ErrorCorrectionLevel.H;
        map.put(encodeHintType, object);
        map = hints;
        encodeHintType = EncodeHintType.MARGIN;
        object = 0;
        map.put(encodeHintType, object);
        try {
            Bitmap bitmap;
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.CODE_128, width, height, (Map)hints);
            int[] pixels = new int[width * height];
            int n = 0;
            int n2 = height;
            while (n < n2) {
                void y;
                int n3 = 0;
                int n4 = width;
                while (n3 < n4) {
                    void x;
                    pixels[y * width + x] = bitMatrix.get((int)x, (int)y) ? -16777216 : -1;
                    ++x;
                }
                ++y;
            }
            Bitmap bitmap2 = bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            bitmap2.setPixels(pixels, 0, width, 0, 0, width, height);
            if (textSize > 0) {
                bitmap = this.showContent(bitmap, content, textSize);
            }
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final Bitmap showContent(Bitmap barcodeBitmap, String content, int textSize) {
        if (TextUtils.isEmpty((CharSequence)content) || barcodeBitmap == null) {
            return null;
        }
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize((float)textSize);
        paint.setTextAlign(Paint.Align.CENTER);
        int textWidth = (int)paint.measureText(content);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)(fm.bottom - fm.top);
        float scaleRateX = (float)barcodeBitmap.getWidth() * 1.0f / (float)textWidth;
        if (scaleRateX < 1.0f) {
            paint.setTextScaleX(scaleRateX);
        }
        int baseLine = barcodeBitmap.getHeight() + textHeight;
        Bitmap bitmap = Bitmap.createBitmap((int)barcodeBitmap.getWidth(), (int)(barcodeBitmap.getHeight() + 2 * textHeight), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas();
        canvas.drawColor(-1);
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(barcodeBitmap, 0.0f, 0.0f, null);
        canvas.drawText(content, (float)(barcodeBitmap.getWidth() / 2), (float)baseLine, paint);
        canvas.save();
        canvas.restore();
        return bitmap;
    }

    private QRCodeEncoder() {
    }

    static {
        QRCodeEncoder qRCodeEncoder;
        INSTANCE = qRCodeEncoder = new QRCodeEncoder();
        HINTS = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)EncodeHintType.CHARACTER_SET, (Object)"utf-8"), new Pair((Object)EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H), new Pair((Object)EncodeHintType.MARGIN, (Object)0)});
    }
}

