/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.graphics.Bitmap;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.sencent.qrcodelib.IdentifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00020$R=\u0010\u0003\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR=\u0010\u000b\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u00010\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR=\u0010\r\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u00010\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR=\u0010\u000f\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR=\u0010\u0011\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR=\u0010\u0013\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u00010\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00010\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR=\u0010\u0015\u001a.\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0004j\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR!\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR!\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001c\u00a8\u0006("}, d2={"Lcom/sencent/qrcodelib/QRCodeDecoder;", "", "()V", "ALL_HINT_MAP", "Ljava/util/HashMap;", "Lcom/google/zxing/DecodeHintType;", "Ljava/io/Serializable;", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashMap;", "getALL_HINT_MAP", "()Ljava/util/HashMap;", "CODE_128_HINT_MAP", "getCODE_128_HINT_MAP", "EAN_13_HINT_MAP", "getEAN_13_HINT_MAP", "HIGH_FREQUENCY_HINT_MAP", "getHIGH_FREQUENCY_HINT_MAP", "ONE_DIMENSION_HINT_MAP", "getONE_DIMENSION_HINT_MAP", "QR_CODE_HINT_MAP", "getQR_CODE_HINT_MAP", "TWO_DIMENSION_HINT_MAP", "getTWO_DIMENSION_HINT_MAP", "allFormatList", "Ljava/util/ArrayList;", "Lcom/google/zxing/BarcodeFormat;", "Lkotlin/collections/ArrayList;", "getAllFormatList", "()Ljava/util/ArrayList;", "highFrequencyFormatList", "getHighFrequencyFormatList", "oneDimenFormatList", "getOneDimenFormatList", "twoDimenFormatList", "getTwoDimenFormatList", "syncDecodeQRCode", "", "bitmap", "Landroid/graphics/Bitmap;", "picturePath", "library_release"})
public final class QRCodeDecoder {
    @NotNull
    private static final ArrayList<BarcodeFormat> allFormatList;
    @NotNull
    private static final HashMap<DecodeHintType, Serializable> ALL_HINT_MAP;
    @NotNull
    private static final ArrayList<BarcodeFormat> oneDimenFormatList;
    @NotNull
    private static final HashMap<DecodeHintType, Serializable> ONE_DIMENSION_HINT_MAP;
    @NotNull
    private static final ArrayList<BarcodeFormat> twoDimenFormatList;
    @NotNull
    private static final HashMap<DecodeHintType, Serializable> TWO_DIMENSION_HINT_MAP;
    @NotNull
    private static final HashMap<DecodeHintType, Object> QR_CODE_HINT_MAP;
    @NotNull
    private static final HashMap<DecodeHintType, Object> CODE_128_HINT_MAP;
    @NotNull
    private static final HashMap<DecodeHintType, Object> EAN_13_HINT_MAP;
    @NotNull
    private static final ArrayList<BarcodeFormat> highFrequencyFormatList;
    @NotNull
    private static final HashMap<DecodeHintType, Serializable> HIGH_FREQUENCY_HINT_MAP;
    public static final QRCodeDecoder INSTANCE;

    @NotNull
    public final ArrayList<BarcodeFormat> getAllFormatList() {
        return allFormatList;
    }

    @NotNull
    public final HashMap<DecodeHintType, Serializable> getALL_HINT_MAP() {
        return ALL_HINT_MAP;
    }

    @NotNull
    public final ArrayList<BarcodeFormat> getOneDimenFormatList() {
        return oneDimenFormatList;
    }

    @NotNull
    public final HashMap<DecodeHintType, Serializable> getONE_DIMENSION_HINT_MAP() {
        return ONE_DIMENSION_HINT_MAP;
    }

    @NotNull
    public final ArrayList<BarcodeFormat> getTwoDimenFormatList() {
        return twoDimenFormatList;
    }

    @NotNull
    public final HashMap<DecodeHintType, Serializable> getTWO_DIMENSION_HINT_MAP() {
        return TWO_DIMENSION_HINT_MAP;
    }

    @NotNull
    public final HashMap<DecodeHintType, Object> getQR_CODE_HINT_MAP() {
        return QR_CODE_HINT_MAP;
    }

    @NotNull
    public final HashMap<DecodeHintType, Object> getCODE_128_HINT_MAP() {
        return CODE_128_HINT_MAP;
    }

    @NotNull
    public final HashMap<DecodeHintType, Object> getEAN_13_HINT_MAP() {
        return EAN_13_HINT_MAP;
    }

    @NotNull
    public final ArrayList<BarcodeFormat> getHighFrequencyFormatList() {
        return highFrequencyFormatList;
    }

    @NotNull
    public final HashMap<DecodeHintType, Serializable> getHIGH_FREQUENCY_HINT_MAP() {
        return HIGH_FREQUENCY_HINT_MAP;
    }

    @Nullable
    public final String syncDecodeQRCode(@NotNull String picturePath) {
        Intrinsics.checkParameterIsNotNull((Object)picturePath, (String)"picturePath");
        return this.syncDecodeQRCode(IdentifyUtil.INSTANCE.getDecodeAbleBitmap(picturePath));
    }

    @Nullable
    public final String syncDecodeQRCode(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        RGBLuminanceSource source = null;
        try {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            source = new RGBLuminanceSource(width, height, pixels);
            Result result = new MultiFormatReader().decode(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source)), (Map)ALL_HINT_MAP);
            Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"MultiFormatReader().deco\u2026r(source)), ALL_HINT_MAP)");
            Result result2 = result;
            return result2.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (source != null) {
                try {
                    Result result = new MultiFormatReader().decode(new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source)), (Map)ALL_HINT_MAP);
                    Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"MultiFormatReader().deco\u2026r(source)), ALL_HINT_MAP)");
                    Result result2 = result;
                    return result2.getText();
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
            }
            return null;
        }
    }

    private QRCodeDecoder() {
    }

    static {
        QRCodeDecoder qRCodeDecoder;
        INSTANCE = qRCodeDecoder = new QRCodeDecoder();
        allFormatList = CollectionsKt.arrayListOf((Object[])new BarcodeFormat[]{BarcodeFormat.AZTEC, BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.DATA_MATRIX, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.MAXICODE, BarcodeFormat.PDF_417, BarcodeFormat.QR_CODE, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION});
        ALL_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, allFormatList), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
        oneDimenFormatList = CollectionsKt.arrayListOf((Object[])new BarcodeFormat[]{BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.PDF_417, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION});
        ONE_DIMENSION_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, oneDimenFormatList), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
        twoDimenFormatList = CollectionsKt.arrayListOf((Object[])new BarcodeFormat[]{BarcodeFormat.AZTEC, BarcodeFormat.DATA_MATRIX, BarcodeFormat.MAXICODE, BarcodeFormat.QR_CODE});
        TWO_DIMENSION_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, twoDimenFormatList), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
        QR_CODE_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, (Object)CollectionsKt.listOf((Object)BarcodeFormat.QR_CODE)), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
        CODE_128_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, (Object)CollectionsKt.listOf((Object)BarcodeFormat.CODE_128)), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
        EAN_13_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, (Object)CollectionsKt.listOf((Object)BarcodeFormat.EAN_13)), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
        highFrequencyFormatList = CollectionsKt.arrayListOf((Object[])new BarcodeFormat[]{BarcodeFormat.QR_CODE, BarcodeFormat.UPC_A, BarcodeFormat.EAN_13, BarcodeFormat.CODE_128});
        HIGH_FREQUENCY_HINT_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{new Pair((Object)DecodeHintType.POSSIBLE_FORMATS, highFrequencyFormatList), new Pair((Object)DecodeHintType.TRY_HARDER, (Object)Boolean.TRUE), new Pair((Object)DecodeHintType.CHARACTER_SET, (Object)"utf-8")});
    }
}

