/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.sencent.qrcodelib.IdentifyUtil;
import com.sencent.qrcodelib.QRCodeView;
import com.sencent.qrcodelib.ScanResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012B\u0005\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u001d\u001a\u00020\u001eJ'\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020!\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u001eH\u0014J\u0012\u0010$\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010\u0003H\u0014J\u0006\u0010&\u001a\u00020\u0000J\u0012\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/sencent/qrcodelib/ProcessDataTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "Lcom/sencent/qrcodelib/ScanResult;", "camera", "Landroid/hardware/Camera;", "data", "", "qrCodeView", "Lcom/sencent/qrcodelib/QRCodeView;", "isPortrait", "", "(Landroid/hardware/Camera;[BLcom/sencent/qrcodelib/QRCodeView;Z)V", "picturePath", "", "(Ljava/lang/String;Lcom/sencent/qrcodelib/QRCodeView;)V", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;Lcom/sencent/qrcodelib/QRCodeView;)V", "()V", "mBitmap", "mCamera", "mData", "mIsPortrait", "mPicturePath", "mQRCodeViewRef", "Ljava/lang/ref/WeakReference;", "sLastStartTime", "", "cancelTask", "", "doInBackground", "params", "", "([Ljava/lang/Void;)Lcom/sencent/qrcodelib/ScanResult;", "onCancelled", "onPostExecute", "result", "perform", "processData", "library_release"})
public final class ProcessDataTask
extends AsyncTask<Void, Void, ScanResult> {
    private Camera mCamera;
    private byte[] mData;
    private boolean mIsPortrait;
    private String mPicturePath;
    private Bitmap mBitmap;
    private WeakReference<QRCodeView> mQRCodeViewRef;
    private long sLastStartTime;

    @NotNull
    public final ProcessDataTask perform() {
        this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return this;
    }

    public final void cancelTask() {
        if (this.getStatus() != AsyncTask.Status.FINISHED) {
            this.cancel(true);
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        WeakReference<QRCodeView> weakReference = this.mQRCodeViewRef;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.mBitmap = null;
        this.mData = null;
    }

    /*
     * WARNING - void declaration
     */
    private final ScanResult processData(QRCodeView qrCodeView) {
        if (this.mData == null) {
            return null;
        }
        Camera camera = this.mCamera;
        if (camera == null) {
            return null;
        }
        Camera camera2 = camera;
        int width = 0;
        int height = 0;
        byte[] data = this.mData;
        try {
            Camera.Parameters parameters;
            Camera.Parameters parameters2 = parameters = camera2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
            Camera.Size size = parameters2.getPreviewSize();
            width = size.width;
            height = size.height;
            if (this.mIsPortrait) {
                if (this.mData == null) {
                    Intrinsics.throwNpe();
                }
                data = new byte[this.mData.length];
                int n = 0;
                int n2 = height;
                while (n < n2) {
                    void y;
                    int n3 = 0;
                    int n4 = width;
                    while (n3 < n4) {
                        void x;
                        void v2 = x * height + height - y - true;
                        if (this.mData == null) {
                            Intrinsics.throwNpe();
                        }
                        data[v2] = this.mData[x + y * width];
                        ++x;
                    }
                    ++y;
                }
                int tmp = width;
                width = height;
                height = tmp;
            }
            return qrCodeView.processData(data, width, height, false);
        }
        catch (Exception e1) {
            ScanResult scanResult;
            e1.printStackTrace();
            try {
                ScanResult scanResult2;
                if (width != 0 && height != 0) {
                    IdentifyUtil.INSTANCE.d("\u8bc6\u522b\u5931\u8d25\u91cd\u8bd5");
                    scanResult2 = qrCodeView.processData(data, width, height, true);
                } else {
                    scanResult2 = null;
                }
                scanResult = scanResult2;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                scanResult = null;
            }
            return scanResult;
        }
    }

    @Nullable
    protected ScanResult doInBackground(Void ... params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Object object = this.mQRCodeViewRef;
        if (object == null || (object = (QRCodeView)((Object)((Reference)object).get())) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"mQRCodeViewRef?.get() ?: return null");
        Object qrCodeView = object;
        if (this.mPicturePath != null) {
            return ((QRCodeView)((Object)qrCodeView)).processBitmapData(IdentifyUtil.INSTANCE.getDecodeAbleBitmap(this.mPicturePath));
        }
        if (this.mBitmap != null) {
            ScanResult result = ((QRCodeView)((Object)qrCodeView)).processBitmapData(this.mBitmap);
            this.mBitmap = null;
            return result;
        }
        if (IdentifyUtil.INSTANCE.isDebug()) {
            IdentifyUtil.INSTANCE.d("\u4e24\u6b21\u4efb\u52a1\u6267\u884c\u7684\u65f6\u95f4\u95f4\u9694\uff1a" + (System.currentTimeMillis() - this.sLastStartTime));
            this.sLastStartTime = System.currentTimeMillis();
        }
        long startTime = System.currentTimeMillis();
        ScanResult scanResult = this.processData((QRCodeView)((Object)qrCodeView));
        if (IdentifyUtil.INSTANCE.isDebug()) {
            long time = System.currentTimeMillis() - startTime;
            if (scanResult != null && !TextUtils.isEmpty((CharSequence)scanResult.getResult())) {
                IdentifyUtil.INSTANCE.d("\u8bc6\u522b\u6210\u529f\u65f6\u95f4\u4e3a\uff1a" + time);
            } else {
                IdentifyUtil.INSTANCE.e("\u8bc6\u522b\u5931\u8d25\u65f6\u95f4\u4e3a\uff1a" + time);
            }
        }
        return scanResult;
    }

    protected void onPostExecute(@Nullable ScanResult result) {
        Object object = this.mQRCodeViewRef;
        if (object == null || (object = (QRCodeView)((Object)((Reference)object).get())) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"mQRCodeViewRef?.get() ?: return");
        Object qrCodeView = object;
        if (this.mPicturePath != null || this.mBitmap != null) {
            this.mBitmap = null;
            ((QRCodeView)((Object)qrCodeView)).onPostParseBitmapOrPicture$library_release(result);
        } else {
            ((QRCodeView)((Object)qrCodeView)).onPostParseData$library_release(result);
        }
    }

    public ProcessDataTask() {
    }

    public ProcessDataTask(@NotNull Camera camera, @Nullable byte[] data, @NotNull QRCodeView qrCodeView, boolean isPortrait) {
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        Intrinsics.checkParameterIsNotNull((Object)((Object)qrCodeView), (String)"qrCodeView");
        this();
        this.mCamera = camera;
        this.mData = data;
        this.mQRCodeViewRef = new WeakReference<QRCodeView>(qrCodeView);
        this.mIsPortrait = isPortrait;
    }

    public ProcessDataTask(@NotNull String picturePath, @NotNull QRCodeView qrCodeView) {
        Intrinsics.checkParameterIsNotNull((Object)picturePath, (String)"picturePath");
        Intrinsics.checkParameterIsNotNull((Object)((Object)qrCodeView), (String)"qrCodeView");
        this();
        this.mPicturePath = picturePath;
        this.mQRCodeViewRef = new WeakReference<QRCodeView>(qrCodeView);
    }

    public ProcessDataTask(@NotNull Bitmap bitmap, @NotNull QRCodeView qrCodeView) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)((Object)qrCodeView), (String)"qrCodeView");
        this();
        this.mBitmap = bitmap;
        this.mQRCodeViewRef = new WeakReference<QRCodeView>(qrCodeView);
    }
}

