/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.MotionEvent;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJE\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0019J%\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"J\u0016\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0012\u0010)\u001a\u0004\u0018\u00010\u00062\b\u0010*\u001a\u0004\u0018\u00010\"J\u000e\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&J\u000e\u0010-\u001a\u00020\t2\u0006\u0010%\u001a\u00020&J\u0006\u0010.\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&J!\u00100\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u00101\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b2J\u0016\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0011J\u000e\u00106\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/sencent/qrcodelib/IdentifyUtil;", "", "()V", "debug", "", "adjustPhotoRotation", "Landroid/graphics/Bitmap;", "inputBitmap", "orientationDegree", "", "adjustPhotoRotation$library_release", "calculateFingerSpacing", "", "event", "Landroid/view/MotionEvent;", "calculateFingerSpacing$library_release", "calculateFocusMeteringArea", "Landroid/graphics/Rect;", "coefficient", "originFocusCenterX", "originFocusCenterY", "originFocusWidth", "originFocusHeight", "previewViewWidth", "previewViewHeight", "calculateFocusMeteringArea$library_release", "clamp", "value", "min", "max", "clamp$library_release", "d", "", "message", "", "tag", "dp2px", "context", "Landroid/content/Context;", "dpValue", "e", "getDecodeAbleBitmap", "picturePath", "getScreenResolution", "Landroid/graphics/Point;", "getStatusBarHeight", "isDebug", "isPortrait", "makeTintBitmap", "tintColor", "makeTintBitmap$library_release", "printRect", "prefix", "rect", "setDebug", "sp2px", "spValue", "library_release"})
public final class IdentifyUtil {
    private static boolean debug;
    public static final IdentifyUtil INSTANCE;

    public final void setDebug(boolean debug) {
        IdentifyUtil.debug = debug;
    }

    public final boolean isDebug() {
        return debug;
    }

    public final void d(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.d("QRCode", message);
    }

    public final void printRect(@NotNull String prefix, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        this.d("QRCodeFocusArea", prefix + " centerX\uff1a" + rect.centerX() + " centerY\uff1a" + rect.centerY() + " width\uff1a" + rect.width() + " height\uff1a" + rect.height() + " rectHalfWidth\uff1a" + rect.width() / 2 + " rectHalfHeight\uff1a" + rect.height() / 2 + " left\uff1a" + rect.left + " top\uff1a" + rect.top + " right\uff1a" + rect.right + " bottom\uff1a" + rect.bottom);
    }

    public final void d(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (debug) {
            Log.d((String)tag, (String)message);
        }
    }

    public final void e(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (debug) {
            Log.e((String)"QRCode", (String)message);
        }
    }

    public final boolean isPortrait(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Point screenResolution = this.getScreenResolution(context);
        return screenResolution.y > screenResolution.x;
    }

    @NotNull
    public final Point getScreenResolution(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Point screenResolution = new Point();
        display.getSize(screenResolution);
        return screenResolution;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{16843277});
        boolean windowFullscreen = typedArray.getBoolean(0, false);
        typedArray.recycle();
        if (windowFullscreen) {
            return 0;
        }
        int height = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = context.getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    public final int dp2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final int sp2px(@NotNull Context context, float spValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)resources.getDisplayMetrics());
    }

    @Nullable
    public final Bitmap adjustPhotoRotation$library_release(@Nullable Bitmap inputBitmap, int orientationDegree) {
        float outputY;
        float outputX;
        if (inputBitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float)orientationDegree, (float)inputBitmap.getWidth() / (float)2, (float)inputBitmap.getHeight() / (float)2);
        if (orientationDegree == 90) {
            outputX = inputBitmap.getHeight();
            outputY = 0.0f;
        } else {
            outputX = inputBitmap.getHeight();
            outputY = inputBitmap.getWidth();
        }
        float[] values = new float[9];
        matrix.getValues(values);
        float x1 = values[2];
        float y1 = values[5];
        matrix.postTranslate(outputX - x1, outputY - y1);
        Bitmap outputBitmap = Bitmap.createBitmap((int)inputBitmap.getHeight(), (int)inputBitmap.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(outputBitmap);
        canvas.drawBitmap(inputBitmap, matrix, paint);
        return outputBitmap;
    }

    @Nullable
    public final Bitmap makeTintBitmap$library_release(@Nullable Bitmap inputBitmap, int tintColor) {
        if (inputBitmap == null) {
            return null;
        }
        Bitmap outputBitmap = Bitmap.createBitmap((int)inputBitmap.getWidth(), (int)inputBitmap.getHeight(), (Bitmap.Config)inputBitmap.getConfig());
        Canvas canvas = new Canvas(outputBitmap);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(tintColor, PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(inputBitmap, 0.0f, 0.0f, paint);
        return outputBitmap;
    }

    @NotNull
    public final Rect calculateFocusMeteringArea$library_release(float coefficient, float originFocusCenterX, float originFocusCenterY, int originFocusWidth, int originFocusHeight, int previewViewWidth, int previewViewHeight) {
        int halfFocusAreaWidth = (int)((float)originFocusWidth * coefficient / (float)2);
        int halfFocusAreaHeight = (int)((float)originFocusHeight * coefficient / (float)2);
        int centerX = (int)(originFocusCenterX / (float)previewViewWidth * (float)2000 - (float)1000);
        int centerY = (int)(originFocusCenterY / (float)previewViewHeight * (float)2000 - (float)1000);
        RectF rectF = new RectF((float)this.clamp$library_release(centerX - halfFocusAreaWidth, -1000, 1000), (float)this.clamp$library_release(centerY - halfFocusAreaHeight, -1000, 1000), (float)this.clamp$library_release(centerX + halfFocusAreaWidth, -1000, 1000), (float)this.clamp$library_release(centerY + halfFocusAreaHeight, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    public final int clamp$library_release(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public final float calculateFingerSpacing$library_release(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    @Nullable
    public final Bitmap getDecodeAbleBitmap(@Nullable String picturePath) {
        if (picturePath == null) {
            return null;
        }
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)picturePath, (BitmapFactory.Options)options);
            int sampleSize = options.outHeight / 400;
            if (sampleSize <= 0) {
                sampleSize = 1;
            }
            options.inSampleSize = sampleSize;
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)picturePath, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IdentifyUtil() {
    }

    static {
        IdentifyUtil identifyUtil;
        INSTANCE = identifyUtil = new IdentifyUtil();
    }
}

