/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.sencent.qrcodelib.CameraConfigurationManager;
import com.sencent.qrcodelib.IdentifyUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001:B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\rH\u0002J(\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0006\u0010\u001e\u001a\u00020\rJ\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J\u0017\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$H\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020\u0013J\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010+\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\u0015\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020\u0013H\u0002J\u0006\u00101\u001a\u00020\u0013J(\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0019H\u0016J\u0010\u00108\u001a\u00020\u00132\u0006\u00103\u001a\u000204H\u0016J\u0010\u00109\u001a\u00020\u00132\u0006\u00103\u001a\u000204H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/sencent/qrcodelib/CameraPreview;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCamera", "Landroid/hardware/Camera;", "mCameraConfigurationManager", "Lcom/sencent/qrcodelib/CameraConfigurationManager;", "mDelegate", "Lcom/sencent/qrcodelib/CameraPreview$Delegate;", "mIsTouchFocusing", "", "mOldDist", "", "mPreviewing", "mSurfaceCreated", "closeFlashlight", "", "flashLightAvailable", "handleFocusMetering", "originFocusCenterX", "originFocusCenterY", "originFocusWidth", "", "originFocusHeight", "handleZoom", "isZoomIn", "camera", "isPreviewing", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScanBoxRectChanged", "scanRect", "Landroid/graphics/Rect;", "onScanBoxRectChanged$library_release", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "openFlashlight", "reactNativeShowCameraPreview", "setCamera", "setDelegate", "delegate", "setDelegate$library_release", "showCameraPreview", "startContinuousAutoFocus", "stopCameraPreview", "surfaceChanged", "surfaceHolder", "Landroid/view/SurfaceHolder;", "format", "width", "height", "surfaceCreated", "surfaceDestroyed", "Delegate", "library_release"})
public final class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private Camera mCamera;
    private boolean mPreviewing;
    private boolean mSurfaceCreated;
    private boolean mIsTouchFocusing;
    private float mOldDist;
    private CameraConfigurationManager mCameraConfigurationManager;
    private Delegate mDelegate;

    public final void setCamera(@Nullable Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            CameraConfigurationManager cameraConfigurationManager = this.mCameraConfigurationManager = new CameraConfigurationManager(context);
            if (cameraConfigurationManager == null) {
                Intrinsics.throwNpe();
            }
            Camera camera2 = this.mCamera;
            if (camera2 == null) {
                Intrinsics.throwNpe();
            }
            cameraConfigurationManager.initFromCameraParameters(camera2);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public final void setDelegate$library_release(@NotNull Delegate delegate) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.mDelegate = delegate;
    }

    public void surfaceCreated(@NotNull SurfaceHolder surfaceHolder) {
        Intrinsics.checkParameterIsNotNull((Object)surfaceHolder, (String)"surfaceHolder");
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(@NotNull SurfaceHolder surfaceHolder, int format, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)surfaceHolder, (String)"surfaceHolder");
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder surfaceHolder) {
        Intrinsics.checkParameterIsNotNull((Object)surfaceHolder, (String)"surfaceHolder");
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public final void reactNativeShowCameraPreview() {
        block3: {
            block2: {
                if (this.getHolder() == null) break block2;
                SurfaceHolder surfaceHolder = this.getHolder();
                Intrinsics.checkExpressionValueIsNotNull((Object)surfaceHolder, (String)"holder");
                if (surfaceHolder.getSurface() != null) break block3;
            }
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    private final void showCameraPreview() {
        Camera camera = this.mCamera;
        if (camera == null) {
            return;
        }
        Camera camera2 = camera;
        try {
            this.mPreviewing = true;
            SurfaceHolder surfaceHolder = this.getHolder();
            surfaceHolder.setKeepScreenOn(true);
            camera2.setPreviewDisplay(surfaceHolder);
            CameraConfigurationManager cameraConfigurationManager = this.mCameraConfigurationManager;
            if (cameraConfigurationManager != null) {
                cameraConfigurationManager.setDesiredCameraParameters(camera2);
            }
            camera2.startPreview();
            if (this.mDelegate != null) {
                Delegate delegate = this.mDelegate;
                if (delegate != null) {
                    delegate.onStartPreview();
                }
            }
            this.startContinuousAutoFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void stopCameraPreview() {
        Camera camera = this.mCamera;
        if (camera == null) {
            return;
        }
        Camera camera2 = camera;
        try {
            this.mPreviewing = false;
            camera2.cancelAutoFocus();
            camera2.setOneShotPreviewCallback(null);
            camera2.stopPreview();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void openFlashlight() {
        block2: {
            Camera camera = this.mCamera;
            if (camera == null) {
                return;
            }
            Camera camera2 = camera;
            if (!this.flashLightAvailable()) break block2;
            CameraConfigurationManager cameraConfigurationManager = this.mCameraConfigurationManager;
            if (cameraConfigurationManager != null) {
                cameraConfigurationManager.openFlashlight(camera2);
            }
        }
    }

    public final void closeFlashlight() {
        block2: {
            Camera camera = this.mCamera;
            if (camera == null) {
                return;
            }
            Camera camera2 = camera;
            if (!this.flashLightAvailable()) break block2;
            CameraConfigurationManager cameraConfigurationManager = this.mCameraConfigurationManager;
            if (cameraConfigurationManager != null) {
                cameraConfigurationManager.closeFlashlight(camera2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean flashLightAvailable() {
        if (!this.isPreviewing()) return false;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        if (!context.getPackageManager().hasSystemFeature("android.hardware.camera.flash")) return false;
        return true;
    }

    public final void onScanBoxRectChanged$library_release(@Nullable Rect scanRect) {
        Rect scanRect2 = scanRect;
        if (this.mCamera == null || scanRect2 == null || scanRect2.left <= 0 || scanRect2.top <= 0) {
            return;
        }
        int centerX = scanRect2.centerX();
        int centerY = scanRect2.centerY();
        int rectHalfWidth = scanRect2.width() / 2;
        int rectHalfHeight = scanRect2.height() / 2;
        IdentifyUtil.INSTANCE.printRect("\u8f6c\u6362\u524d", scanRect2);
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        if (IdentifyUtil.INSTANCE.isPortrait(context)) {
            int temp = centerX;
            centerX = centerY;
            centerY = temp;
            temp = rectHalfWidth;
            rectHalfWidth = rectHalfHeight;
            rectHalfHeight = temp;
        }
        scanRect2 = new Rect(centerX - rectHalfWidth, centerY - rectHalfHeight, centerX + rectHalfWidth, centerY + rectHalfHeight);
        IdentifyUtil.INSTANCE.printRect("\u8f6c\u6362\u540e", scanRect2);
        IdentifyUtil.INSTANCE.d("\u626b\u7801\u6846\u53d1\u751f\u53d8\u5316\u89e6\u53d1\u5bf9\u7126\u6d4b\u5149");
        this.handleFocusMetering(scanRect2.centerX(), scanRect2.centerY(), scanRect2.width(), scanRect2.height());
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isPreviewing()) {
            return super.onTouchEvent(event);
        }
        if (event.getPointerCount() == 1 && (event.getAction() & 0xFF) == 1) {
            if (this.mIsTouchFocusing) {
                return true;
            }
            this.mIsTouchFocusing = true;
            IdentifyUtil.INSTANCE.d("\u624b\u6307\u89e6\u6478\u89e6\u53d1\u5bf9\u7126\u6d4b\u5149");
            float centerX = event.getX();
            float centerY = event.getY();
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            if (IdentifyUtil.INSTANCE.isPortrait(context)) {
                float temp = centerX;
                centerX = centerY;
                centerY = temp;
            }
            Context context2 = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            int focusSize = IdentifyUtil.INSTANCE.dp2px(context2, 120.0f);
            this.handleFocusMetering(centerX, centerY, focusSize, focusSize);
        }
        if (event.getPointerCount() == 2) {
            switch (event.getAction() & 0xFF) {
                case 5: {
                    this.mOldDist = IdentifyUtil.INSTANCE.calculateFingerSpacing$library_release(event);
                    break;
                }
                case 2: {
                    float newDist = IdentifyUtil.INSTANCE.calculateFingerSpacing$library_release(event);
                    if (newDist > this.mOldDist) {
                        Camera camera = this.mCamera;
                        if (camera == null) {
                            return true;
                        }
                        this.handleZoom(true, camera);
                        break;
                    }
                    if (!(newDist < this.mOldDist)) break;
                    Camera camera = this.mCamera;
                    if (camera == null) {
                        return true;
                    }
                    this.handleZoom(false, camera);
                }
            }
        }
        return true;
    }

    private final void handleZoom(boolean isZoomIn, Camera camera) {
        Camera.Parameters params;
        Camera.Parameters parameters = params = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"params");
        if (parameters.isZoomSupported()) {
            int zoom = params.getZoom();
            if (isZoomIn && zoom < params.getMaxZoom()) {
                IdentifyUtil.INSTANCE.d("\u653e\u5927");
                ++zoom;
            } else if (!isZoomIn && zoom > 0) {
                IdentifyUtil.INSTANCE.d("\u7f29\u5c0f");
                --zoom;
            } else {
                IdentifyUtil.INSTANCE.d("\u65e2\u4e0d\u653e\u5927\u4e5f\u4e0d\u7f29\u5c0f");
            }
            params.setZoom(zoom);
            camera.setParameters(params);
        } else {
            IdentifyUtil.INSTANCE.d("\u4e0d\u652f\u6301\u7f29\u653e");
        }
    }

    private final void handleFocusMetering(float originFocusCenterX, float originFocusCenterY, int originFocusWidth, int originFocusHeight) {
        Camera camera = this.mCamera;
        if (camera == null) {
            return;
        }
        Camera camera2 = camera;
        try {
            Camera.Parameters focusMeteringParameters;
            boolean isNeedUpdate = false;
            Camera.Parameters parameters = focusMeteringParameters = camera2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"focusMeteringParameters");
            Camera.Size size = parameters.getPreviewSize();
            if (focusMeteringParameters.getMaxNumFocusAreas() > 0) {
                IdentifyUtil.INSTANCE.d("\u652f\u6301\u8bbe\u7f6e\u5bf9\u7126\u533a\u57df");
                isNeedUpdate = true;
                Rect focusRect = IdentifyUtil.INSTANCE.calculateFocusMeteringArea$library_release(1.0f, originFocusCenterX, originFocusCenterY, originFocusWidth, originFocusHeight, size.width, size.height);
                IdentifyUtil.INSTANCE.printRect("\u5bf9\u7126\u533a\u57df", focusRect);
                focusMeteringParameters.setFocusAreas(CollectionsKt.listOf((Object)new Camera.Area(focusRect, 1000)));
                focusMeteringParameters.setFocusMode("macro");
            } else {
                IdentifyUtil.INSTANCE.d("\u4e0d\u652f\u6301\u8bbe\u7f6e\u5bf9\u7126\u533a\u57df");
            }
            if (focusMeteringParameters.getMaxNumMeteringAreas() > 0) {
                IdentifyUtil.INSTANCE.d("\u652f\u6301\u8bbe\u7f6e\u6d4b\u5149\u533a\u57df");
                isNeedUpdate = true;
                Rect meteringRect = IdentifyUtil.INSTANCE.calculateFocusMeteringArea$library_release(1.5f, originFocusCenterX, originFocusCenterY, originFocusWidth, originFocusHeight, size.width, size.height);
                IdentifyUtil.INSTANCE.printRect("\u6d4b\u5149\u533a\u57df", meteringRect);
                focusMeteringParameters.setMeteringAreas(CollectionsKt.listOf((Object)new Camera.Area(meteringRect, 1000)));
            } else {
                IdentifyUtil.INSTANCE.d("\u4e0d\u652f\u6301\u8bbe\u7f6e\u6d4b\u5149\u533a\u57df");
            }
            if (isNeedUpdate) {
                camera2.cancelAutoFocus();
                camera2.setParameters(focusMeteringParameters);
                camera2.autoFocus(new Camera.AutoFocusCallback(this){
                    final /* synthetic */ CameraPreview this$0;

                    public final void onAutoFocus(boolean success, Camera $noName_1) {
                        if (success) {
                            IdentifyUtil.INSTANCE.d("\u5bf9\u7126\u6d4b\u5149\u6210\u529f");
                        } else {
                            IdentifyUtil.INSTANCE.e("\u5bf9\u7126\u6d4b\u5149\u5931\u8d25");
                        }
                        CameraPreview.access$startContinuousAutoFocus(this.this$0);
                    }
                    {
                        this.this$0 = cameraPreview;
                    }
                });
            } else {
                this.mIsTouchFocusing = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IdentifyUtil.INSTANCE.e("\u5bf9\u7126\u6d4b\u5149\u5931\u8d25\uff1a" + e.getMessage());
            this.startContinuousAutoFocus();
        }
    }

    private final void startContinuousAutoFocus() {
        this.mIsTouchFocusing = false;
        Camera camera = this.mCamera;
        if (camera == null) {
            return;
        }
        Camera camera2 = camera;
        try {
            Camera.Parameters parameters;
            Camera.Parameters parameters2 = parameters = camera2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
            parameters2.setFocusMode("continuous-picture");
            camera2.setParameters(parameters);
            camera2.cancelAutoFocus();
        }
        catch (Exception e) {
            IdentifyUtil.INSTANCE.e("\u8fde\u7eed\u5bf9\u7126\u5931\u8d25");
        }
    }

    public final boolean isPreviewing() {
        return this.mCamera != null && this.mPreviewing && this.mSurfaceCreated;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        CameraConfigurationManager cameraConfigurationManager = this.mCameraConfigurationManager;
        if (cameraConfigurationManager == null) {
            return;
        }
        CameraConfigurationManager cameraConfigurationManager2 = cameraConfigurationManager;
        int width = SurfaceView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = SurfaceView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        if (cameraConfigurationManager2.getCameraResolution() != null) {
            Point point = cameraConfigurationManager2.getCameraResolution();
            if (point == null) {
                return;
            }
            Point cameraResolution = point;
            int cameraPreviewWidth = cameraResolution.x;
            int cameraPreviewHeight = cameraResolution.y;
            if ((float)width * 1.0f / (float)height < (float)cameraPreviewWidth * 1.0f / (float)cameraPreviewHeight) {
                float ratio = (float)cameraPreviewHeight * 1.0f / (float)cameraPreviewWidth;
                width = (int)((float)height / ratio + 0.5f);
            } else {
                float ratio = (float)cameraPreviewWidth * 1.0f / (float)cameraPreviewHeight;
                height = (int)((float)width / ratio + 0.5f);
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public CameraPreview(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mPreviewing = true;
        this.mOldDist = 1.0f;
    }

    public static final /* synthetic */ void access$startContinuousAutoFocus(CameraPreview $this) {
        $this.startContinuousAutoFocus();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/sencent/qrcodelib/CameraPreview$Delegate;", "", "onStartPreview", "", "library_release"})
    public static interface Delegate {
        public void onStartPreview();
    }
}

