/*
 * Decompiled with CFR 0.152.
 */
package com.sencent.qrcodelib;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.view.Display;
import android.view.WindowManager;
import com.sencent.qrcodelib.IdentifyUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u000b0\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J3\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u001a\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\u00062\n\u0010 \u001a\u00060!R\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/sencent/qrcodelib/CameraConfigurationManager;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCameraResolution", "Landroid/graphics/Point;", "mPreviewResolution", "autoFocusAble", "", "camera", "Landroid/hardware/Camera;", "closeFlashlight", "", "doSetTorch", "newSetting", "findBestPreviewSizeValue", "supportSizeList", "", "Landroid/hardware/Camera$Size;", "screenResolution", "findSettableValue", "", "supportedValues", "", "desiredValues", "", "(Ljava/util/Collection;[Ljava/lang/String;)Ljava/lang/String;", "getCameraResolution", "getDisplayOrientation", "", "getPreviewResolution", "parameters", "Landroid/hardware/Camera$Parameters;", "initFromCameraParameters", "openFlashlight", "selectPreviewFpsRange", "", "desiredPreviewFps", "", "setDesiredCameraParameters", "library_release"})
public final class CameraConfigurationManager {
    private Point mCameraResolution;
    private Point mPreviewResolution;
    private final Context mContext;

    public final void initFromCameraParameters(@NotNull Camera camera) {
        Point point;
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        Point screenResolution = IdentifyUtil.INSTANCE.getScreenResolution(this.mContext);
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = screenResolution.x;
        screenResolutionForCamera.y = screenResolution.y;
        if (IdentifyUtil.INSTANCE.isPortrait(this.mContext)) {
            screenResolutionForCamera.x = screenResolution.y;
            screenResolutionForCamera.y = screenResolution.x;
        }
        Camera.Parameters parameters = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"camera.parameters");
        this.mPreviewResolution = this.getPreviewResolution(parameters, screenResolutionForCamera);
        if (IdentifyUtil.INSTANCE.isPortrait(this.mContext)) {
            Point point2 = this.mPreviewResolution;
            if (point2 == null) {
                Intrinsics.throwNpe();
            }
            int n = point2.y;
            Point point3 = this.mPreviewResolution;
            if (point3 == null) {
                Intrinsics.throwNpe();
            }
            point = new Point(n, point3.x);
        } else {
            point = this.mPreviewResolution;
        }
        this.mCameraResolution = point;
    }

    private final boolean autoFocusAble(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"camera.parameters");
        List supportedFocusModes = parameters.getSupportedFocusModes();
        String focusMode = this.findSettableValue(supportedFocusModes, "auto");
        return focusMode != null;
    }

    @Nullable
    public final Point getCameraResolution() {
        return this.mCameraResolution;
    }

    public final void setDesiredCameraParameters(@NotNull Camera camera) {
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        Point point = this.mPreviewResolution;
        if (point == null) {
            return;
        }
        Point previewResolution = point;
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPreviewSize(previewResolution.x, previewResolution.y);
        int[] previewFpsRange = this.selectPreviewFpsRange(camera, 60.0f);
        if (previewFpsRange != null) {
            parameters.setPreviewFpsRange(previewFpsRange[0], previewFpsRange[1]);
        }
        camera.setDisplayOrientation(this.getDisplayOrientation());
        camera.setParameters(parameters);
    }

    private final int[] selectPreviewFpsRange(Camera camera, float desiredPreviewFps) {
        int desiredPreviewFpsScaled = (int)(desiredPreviewFps * 1000.0f);
        int[] selectedFpsRange = null;
        int minDiff = Integer.MAX_VALUE;
        Camera.Parameters parameters = camera.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"camera.parameters");
        List previewFpsRangeList = parameters.getSupportedPreviewFpsRange();
        for (int[] range : previewFpsRangeList) {
            int deltaMin = desiredPreviewFpsScaled - range[0];
            int deltaMax = desiredPreviewFpsScaled - range[1];
            int diff = Math.abs(deltaMin) + Math.abs(deltaMax);
            if (diff >= minDiff) continue;
            selectedFpsRange = range;
            minDiff = diff;
        }
        return selectedFpsRange;
    }

    public final void openFlashlight(@NotNull Camera camera) {
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        this.doSetTorch(camera, true);
    }

    public final void closeFlashlight(@NotNull Camera camera) {
        Intrinsics.checkParameterIsNotNull((Object)camera, (String)"camera");
        this.doSetTorch(camera, false);
    }

    private final void doSetTorch(Camera camera, boolean newSetting) {
        String flashMode;
        String string;
        Camera.Parameters parameters = camera.getParameters();
        if (newSetting) {
            Camera.Parameters parameters2 = parameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters2, (String)"parameters");
            string = this.findSettableValue(parameters2.getSupportedFlashModes(), "torch", "on");
        } else {
            Camera.Parameters parameters3 = parameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters3, (String)"parameters");
            string = flashMode = this.findSettableValue(parameters3.getSupportedFlashModes(), "off");
        }
        if (flashMode != null) {
            parameters.setFlashMode(flashMode);
        }
        camera.setParameters(parameters);
    }

    private final String findSettableValue(Collection<String> supportedValues, String ... desiredValues) {
        String result = null;
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                result = desiredValue;
                break;
            }
        }
        return result;
    }

    private final int getDisplayOrientation() {
        int result;
        Display display;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        Object object = this.mContext.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        if (windowManager == null) {
            return 0;
        }
        WindowManager wm = windowManager;
        Display display2 = display = wm.getDefaultDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display2, (String)"display");
        int rotation = display2.getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private final Point getPreviewResolution(Camera.Parameters parameters, Point screenResolution) {
        List list = parameters.getSupportedPreviewSizes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"parameters.supportedPreviewSizes");
        Point previewResolution = this.findBestPreviewSizeValue(list, screenResolution);
        if (previewResolution == null) {
            previewResolution = new Point(screenResolution.x >> 3 << 3, screenResolution.y >> 3 << 3);
        }
        return previewResolution;
    }

    private final Point findBestPreviewSizeValue(List<? extends Camera.Size> supportSizeList, Point screenResolution) {
        int bestX = 0;
        int bestY = 0;
        int diff = Integer.MAX_VALUE;
        for (Camera.Size size : supportSizeList) {
            int newX = size.width;
            int newY = size.height;
            int newDiff = Math.abs(newX - screenResolution.x) + Math.abs(newY - screenResolution.y);
            if (newDiff == 0) {
                bestX = newX;
                bestY = newY;
                break;
            }
            if (newDiff >= diff) continue;
            bestX = newX;
            bestY = newY;
            diff = newDiff;
        }
        return bestX > 0 && bestY > 0 ? new Point(bestX, bestY) : null;
    }

    public CameraConfigurationManager(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
    }
}

