/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.sunflower.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import com.iflytek.sunflower.util.a;
import com.iflytek.sunflower.util.d;
import com.iflytek.sunflower.util.j;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Linker {
    private static final String FLYIME_SO_ABI = "armeabi";
    private static final String LIB_DIR = "lib";
    private static final int MAX_TRIES = 5;
    private static final int COPY_BUFFER_SIZE = 4096;
    private static final String TAG = "Linker";

    private Linker() {
    }

    public static boolean loadLibrary(Context context, String string, long l2, String string2) {
        if (context == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            j.c(TAG, "loadLibrary | System.loadLibrary error", unsatisfiedLinkError);
            File file = Linker.getWorkaroundLibFile(context, string);
            if (!file.exists() || l2 > 0L && l2 != file.length() || TextUtils.isEmpty((CharSequence)string2) || !string2.equalsIgnoreCase(d.a(file))) {
                Linker.unpackLibrary(context, string);
            }
            try {
                System.load(file.getAbsolutePath());
                return true;
            }
            catch (Throwable throwable) {
                j.d(TAG, "loadLibrary | System.load error");
                return false;
            }
        }
    }

    public static boolean loadLibrary(Context context, String string) {
        return Linker.loadLibrary(context, string, -1L, "");
    }

    private static File getWorkaroundLibDir(Context context) {
        return context.getDir(LIB_DIR, 0);
    }

    private static File getWorkaroundLibFile(Context context, String string) {
        String string2 = System.mapLibraryName(string);
        return new File(Linker.getWorkaroundLibDir(context), string2);
    }

    private static void clearWorkaroundLibDir(Context context, String string) {
        File[] fileArray;
        String string2 = string;
        File file = Linker.getWorkaroundLibDir(context);
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().contains(string2)) continue;
                file2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @TargetApi(value=9)
    private static void unpackLibrary(Context context, String string) {
        ZipFile zipFile = null;
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int n2 = 0;
            while (n2++ < 5) {
                try {
                    zipFile = new ZipFile(new File(applicationInfo.sourceDir), 1);
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (zipFile == null) {
                return;
            }
            n2 = 0;
            while (n2++ < 5) {
                ZipEntry zipEntry = null;
                String string2 = "lib/armeabi/" + System.mapLibraryName(string);
                zipEntry = zipFile.getEntry(string2);
                if (zipEntry == null) {
                    break;
                }
                File file = Linker.getWorkaroundLibFile(context, string);
                Linker.clearWorkaroundLibDir(context, string);
                try {
                    if (!file.createNewFile()) {
                    }
                }
                catch (IOException iOException) {}
                continue;
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    inputStream = zipFile.getInputStream(zipEntry);
                    fileOutputStream = new FileOutputStream(file);
                    Linker.copy(inputStream, fileOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Linker.closeSilently(inputStream);
                    Linker.closeSilently(fileOutputStream);
                    continue;
                }
                catch (IOException iOException) {
                    Linker.closeSilently(inputStream);
                    Linker.closeSilently(fileOutputStream);
                    continue;
                    {
                        catch (Throwable throwable) {
                            Linker.closeSilently(inputStream);
                            Linker.closeSilently(fileOutputStream);
                            throw throwable;
                        }
                    }
                }
                Linker.closeSilently(inputStream);
                Linker.closeSilently(fileOutputStream);
                if (a.b() >= 9) {
                    file.setReadable(true, false);
                    file.setExecutable(true, false);
                    file.setWritable(true);
                } else {
                    try {
                        Runtime.getRuntime().exec("chmod 777 " + file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) {
        int n2;
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    private static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

