/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.cloud.msc.ist;

import com.iflytek.cloud.msc.i.b.a;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class AudioAccessor {
    private String mFilePath = null;
    private AccesserType mAccesserType = AccesserType.WRITE_READ;
    private int mOffset = 0;
    private static final int MAX_BUF_LEN = 0x500000;
    private ByteBuffer mByteBuffer = ByteBuffer.allocate(0x500000);
    private byte[] mBuffer = new byte[0x500000];
    private int mBufLen = 0;
    private int mDataCount = 0;
    private static final int MIN_OUTPUT_TIME = 3000;
    private long mLastFlushTime = System.currentTimeMillis();
    private File mAudioFile = null;
    private RandomAccessFile mAccessFile = null;
    private FileChannel mFileChannel = null;
    private Object mFileSyncObj = new Object();
    private final String FILE_FMT = ".wav";
    private final int SIZE_OF_WAVE_HEADER = 44;
    private final int DATA_LENGTH_OFFSET = 40;
    private final int FILE_LENGTH_OFFSET = 4;
    private short mNumChannels = 1;
    private short mFormat = 1;
    private short mBitsPerSample = (short)16;
    private int mSampleRate = 16000;

    public static AudioAccessor createBufferAccessor() {
        return new AudioAccessor();
    }

    public static AudioAccessor createReadOnlyAccessor(String string) {
        return new AudioAccessor(string);
    }

    public static AudioAccessor createWriteReadAccessor(String string, int n2) {
        return new AudioAccessor(string, n2);
    }

    protected AudioAccessor() {
        this.mAccesserType = AccesserType.BUFFER;
    }

    protected AudioAccessor(String string) {
        this.mFilePath = string;
        this.mAccesserType = AccesserType.READ_ONLY;
        this.initFile();
    }

    protected AudioAccessor(String string, int n2) {
        this.mFilePath = string;
        this.mSampleRate = n2;
        this.mAccesserType = AccesserType.WRITE_READ;
        this.initFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilePath() {
        String string = null;
        Object object = this.mFileSyncObj;
        synchronized (object) {
            if (null != this.mAudioFile) {
                string = this.mAudioFile.getAbsolutePath();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDataLength() {
        long l2 = 0L;
        Object object = this.mFileSyncObj;
        synchronized (object) {
            l2 = this.mDataCount;
        }
        return l2;
    }

    public String getAudioInfo(AudioKeys audioKeys) {
        String string = null;
        switch (audioKeys) {
            case CHANNEL: {
                string = String.valueOf(this.mNumChannels);
                break;
            }
            case FORMAT: {
                string = String.valueOf(this.mFormat);
                break;
            }
            case BIT: {
                string = String.valueOf(this.mBitsPerSample);
                break;
            }
            case RATE: {
                string = String.valueOf(this.mSampleRate);
                break;
            }
        }
        return string;
    }

    public int getBufferLength() {
        return 0x500000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheLeft() {
        int n2 = 0;
        Object object = this.mFileSyncObj;
        synchronized (object) {
            n2 = 0x280000 - this.mBufLen;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAudio(byte[] byArray) {
        a.d("getAudioData enter");
        int n2 = 0;
        if (AccesserType.BUFFER == this.mAccesserType) {
            if (null == byArray || byArray.length != this.getBufferLength()) {
                n2 = -1;
                a.c("getAudioData buffer is null or length is error !");
            } else {
                Object object = this.mFileSyncObj;
                synchronized (object) {
                    if (null == this.mBuffer) {
                        throw new IOException("Data array is null!");
                    }
                    if (this.mBufLen > 0) {
                        System.arraycopy(this.mBuffer, 0, byArray, 0, this.mBufLen);
                        n2 = this.mBufLen;
                        this.mBufLen = 0;
                        a.d("getAudioData len:" + n2);
                    }
                }
            }
        } else if (null == byArray || byArray.length != this.getBufferLength()) {
            n2 = -1;
            a.c("getAudioData buffer is null or length is not enough !");
        } else {
            Object object = this.mFileSyncObj;
            synchronized (object) {
                if (null == this.mFileChannel) {
                    throw new IOException("File is null!");
                }
                if (this.getFileLength() > 44L) {
                    this.mByteBuffer.clear();
                    int n3 = (int)Math.min((long)this.mByteBuffer.capacity(), this.getFileLength() - (long)this.mOffset);
                    a.d("getAudioData buffer len:" + n3);
                    if (n3 > 0) {
                        this.mFileChannel.position(this.mOffset);
                        if (n3 != this.readBytes(this.mOffset, this.mByteBuffer)) {
                            throw new IOException("Read audio length error:" + n3);
                        }
                        this.mByteBuffer.position(0);
                        this.mByteBuffer.get(byArray, 0, n3);
                        this.mOffset += n3;
                        n2 = n3;
                        a.d("getAudioData read len:" + n3);
                    }
                }
            }
        }
        a.d("getAudioData leave");
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean putAudio(byte[] byArray, int n2) {
        a.d("putAudio enter");
        if (null == byArray) {
            a.c("data is null !");
            throw new NullPointerException();
        }
        if (AccesserType.BUFFER == this.mAccesserType && 0x500000 < this.mBufLen + n2) {
            a.c("Buffer is not enough ! " + this.mBufLen);
            throw new IOException("Buffer is not enough ! " + this.mBufLen);
        }
        if (AccesserType.READ_ONLY == this.mAccesserType) {
            a.c("Current type is " + (Object)((Object)this.mAccesserType));
            throw new IOException("Current type is " + (Object)((Object)this.mAccesserType));
        }
        if (null != byArray && n2 > 0) {
            Object object = this.mFileSyncObj;
            synchronized (object) {
                a.d("putAudio data len=" + n2);
                System.arraycopy(byArray, 0, this.mBuffer, this.mBufLen, n2);
                this.mBufLen += n2;
                this.mDataCount += n2;
                a.d("putAudio buf len=" + this.mBufLen);
            }
        }
        if (AccesserType.WRITE_READ == this.mAccesserType) {
            this.saveAudio();
        }
        a.d("putAudio leave");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        if (AccesserType.WRITE_READ != this.mAccesserType) {
            throw new IOException("Current type is " + (Object)((Object)this.mAccesserType));
        }
        Object object = this.mFileSyncObj;
        synchronized (object) {
            this.mFileChannel.force(true);
            this.mLastFlushTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        a.a("AudioAccesser close enter");
        Object object = this.mFileSyncObj;
        synchronized (object) {
            if (AccesserType.WRITE_READ == this.mAccesserType) {
                this.saveAudio();
            }
            if (AccesserType.BUFFER != this.mAccesserType) {
                if (null != this.mFileChannel) {
                    this.mFileChannel.force(true);
                    this.mFileChannel.close();
                    this.mFileChannel = null;
                }
                if (null != this.mAccessFile) {
                    this.mAccessFile.close();
                    this.mAccessFile = null;
                }
            }
            this.mBuffer = null;
            this.mByteBuffer.clear();
            this.mByteBuffer = null;
        }
        a.a("AudioAccesser close leave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAudio() {
        a.d("saveAudioData enter");
        Object object = this.mFileSyncObj;
        synchronized (object) {
            if (null != this.mFileChannel) {
                a.d("saveAudio write audio len:" + this.mBufLen + ", file length=" + this.getFileLength());
                if (0 < this.mBufLen) {
                    this.mByteBuffer.clear();
                    int n2 = this.mByteBuffer.capacity() - this.mBufLen;
                    this.mByteBuffer.position(n2);
                    this.mByteBuffer.put(this.mBuffer, 0, this.mBufLen);
                    this.writeBytes((int)this.getFileLength(), this.mByteBuffer, n2);
                    this.mBufLen = 0;
                    this.updateAudioFileHeader();
                }
                if (AccesserType.WRITE_READ == this.mAccesserType && this.isTimeToFlush()) {
                    a.d("saveAudio flush to device.");
                    this.flush();
                }
            }
        }
        a.d("saveAudioData leave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFile() {
        if (AccesserType.BUFFER == this.mAccesserType) {
            return;
        }
        Object object = this.mFileSyncObj;
        synchronized (object) {
            if (null == this.mFilePath) {
                throw new IOException("File path is null");
            }
            if (AccesserType.WRITE_READ == this.mAccesserType) {
                File file;
                String string;
                String string2 = string = this.mFilePath;
                if (string.endsWith("/")) {
                    string2 = string.substring(0, string.lastIndexOf("/"));
                }
                if (!((file = new File(string2)).isDirectory() && file.exists() || file.mkdirs())) {
                    IOException iOException = new IOException("create file path failed");
                    throw iOException;
                }
                if (!string.endsWith(".wav") && !string.endsWith(".pcm")) {
                    if (!string.endsWith("/")) {
                        string = string.concat("/");
                    }
                    Date date = new Date(System.currentTimeMillis());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS", Locale.CHINA);
                    String string3 = simpleDateFormat.format(date);
                    string = string.concat(string3);
                    this.mAudioFile = new File(string + ".wav");
                    int n2 = 0;
                    while (this.mAudioFile.exists()) {
                        String string4 = string + "_" + ++n2 + ".wav";
                        this.mAudioFile = new File(string4);
                    }
                } else {
                    this.mAudioFile = new File(string);
                    if (this.mAudioFile.exists()) {
                        throw new IOException("File is exists:" + string);
                    }
                }
                a.a("initFile createNewFile:" + string);
                if (!this.mAudioFile.createNewFile()) {
                    throw new IOException("create new file \"" + this.mAudioFile.getAbsolutePath() + "\" failed.");
                }
                this.mAccessFile = new RandomAccessFile(this.mAudioFile, "rw");
                this.mFileChannel = this.mAccessFile.getChannel();
                this.initAudioFileHeader();
            } else if (AccesserType.READ_ONLY == this.mAccesserType) {
                this.mAudioFile = new File(this.mFilePath);
                if (!this.mAudioFile.exists()) {
                    throw new IOException("File is not exist:" + this.mFilePath);
                }
                this.mAccessFile = new RandomAccessFile(this.mAudioFile, "rw");
                this.mFileChannel = this.mAccessFile.getChannel();
                this.readAudioInfo();
            }
        }
    }

    protected void initAudioFileHeader() {
        String string = "RIFF";
        String string2 = "WAVE";
        String string3 = "fmt ";
        String string4 = "data";
        int n2 = 0;
        this.writeBytes(n2, "RIFF".getBytes());
        this.writeInt(n2 += "RIFF".length(), 44);
        this.writeBytes(n2 += 4, "WAVE".getBytes());
        this.writeBytes(n2 += "WAVE".length(), "fmt ".getBytes());
        this.writeInt(n2 += "fmt ".length(), 16);
        this.writeShort(n2 += 4, this.mFormat);
        this.writeShort(n2 += 2, this.mNumChannels);
        this.writeInt(n2 += 2, this.mSampleRate);
        int n3 = this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8;
        short s2 = (short)(this.mNumChannels * this.mBitsPerSample / 8);
        a.d("writeAudioFileHeader NumChannels=" + this.mNumChannels + "SampleRate=" + this.mSampleRate + ", transferRate=" + n3 + ", adjustValue=" + s2 + ", bit=" + this.mBitsPerSample);
        this.writeInt(n2 += 4, n3);
        this.writeShort(n2 += 4, s2);
        this.writeShort(n2 += 2, this.mBitsPerSample);
        this.writeBytes(n2 += 2, "data".getBytes());
        this.writeInt(n2 += "data".length(), 0);
    }

    protected void readAudioInfo() {
        String string = "RIFF";
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.readBytes(0, byteBuffer);
        String string2 = new String(byteBuffer.array());
        if (!"RIFF".equalsIgnoreCase(string2)) {
            return;
        }
        int n2 = 20;
        this.mFormat = this.readShort(n2);
        this.mNumChannels = this.readShort(n2 += 2);
        this.mSampleRate = this.readInt(n2 += 2);
        n2 += 4;
        n2 += 4;
        this.mBitsPerSample = this.readShort(n2 += 2);
    }

    protected void writeBytes(int n2, ByteBuffer byteBuffer) {
        a.d("writeBytes buffer len=" + byteBuffer.capacity());
        byteBuffer.rewind();
        this.mFileChannel.position(n2);
        int n3 = this.mFileChannel.write(byteBuffer);
        a.d("writeBytes writen len=" + n3);
    }

    protected void writeBytes(int n2, ByteBuffer byteBuffer, int n3) {
        a.d("writeBytes buffer len=" + (byteBuffer.capacity() - n3));
        byteBuffer.position(n3);
        this.mFileChannel.position(n2);
        int n4 = this.mFileChannel.write(byteBuffer);
        a.d("writeBytes writen len=" + n4);
    }

    protected void writeBytes(int n2, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        this.writeBytes(n2, byteBuffer);
    }

    protected void writeInt(int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(0, (byte)(n3 >> 0));
        byteBuffer.put(1, (byte)(n3 >> 8));
        byteBuffer.put(2, (byte)(n3 >> 16));
        byteBuffer.put(3, (byte)(n3 >> 24));
        this.writeBytes(n2, byteBuffer);
    }

    protected void writeShort(int n2, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put(0, (byte)(s2 >> 0));
        byteBuffer.put(1, (byte)(s2 >> 8));
        this.writeBytes(n2, byteBuffer);
    }

    protected int readInt(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.mFileChannel.position(n2);
        this.mFileChannel.read(byteBuffer);
        return byteBuffer.getInt(0) << 0 | byteBuffer.getInt(1) << 8 | byteBuffer.getInt(2) << 16 | byteBuffer.getInt(3) << 24;
    }

    protected int readBytes(int n2, ByteBuffer byteBuffer) {
        this.mFileChannel.position(n2);
        return this.mFileChannel.read(byteBuffer);
    }

    protected short readShort(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.mFileChannel.position(n2);
        this.mFileChannel.read(byteBuffer);
        return (short)(byteBuffer.getShort(0) << 0 | byteBuffer.getShort(1) << 8);
    }

    protected void updateAudioFileHeader() {
        a.d("updateHeader File length:" + this.getDataLength() + ", mem file length:" + this.mFileChannel.size());
        this.writeInt(4, (int)this.getDataLength());
        a.d("updateHeader data length:" + (this.getDataLength() - 44L));
        this.writeInt(40, (int)this.getDataLength() - 44);
    }

    private boolean isTimeToFlush() {
        return 3000L <= System.currentTimeMillis() - this.mLastFlushTime;
    }

    private long getFileLength() {
        int n2 = 0;
        if (null != this.mFileChannel) {
            n2 = (int)this.mFileChannel.size();
        }
        a.a("getFileLength:" + n2);
        return n2;
    }

    public static enum AudioKeys {
        CHANNEL,
        FORMAT,
        BIT,
        RATE;

    }

    static enum AccesserType {
        WRITE_READ,
        READ_ONLY,
        BUFFER;

    }
}

