package com.locnavi.map.ui.widget;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.location.xunjimap.utils.MixpanelConstants;
import com.locnavi.location.xunjimap.utils.MixpanelEvent;
import com.locnavi.map.R;

public class LocShareJoinFromShareDialog {

    private Dialog dialog;
    private View contentView;
    private TextView tvClose;
    private Context context;
    private TextView tvName;
    private Pinview pinview;
    private Button btnJoin;
    private Button btnClose;

    public LocShareJoinFromShareDialog(Context context, String groupId, String userName, View.OnClickListener joinClickListener,
                                       View.OnClickListener closeClickListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_loc_share_join_from_share, null);
        tvName = (TextView) contentView.findViewById(R.id.tv_user_name);
        pinview = (Pinview) contentView.findViewById(R.id.pinview);
        tvName.setText(userName);
        pinview.setValue(groupId);
        pinview.setFocusable(false);
        btnJoin = (Button) contentView.findViewById(R.id.btn_join);
        btnClose = (Button) contentView.findViewById(R.id.btn_close);
        pinview.setOnTouchListener((v, event) -> false);
        btnJoin.setOnClickListener(v -> {
            MixpanelEvent.locShareJoinDialog(MixpanelConstants.LOC_SHARE_JOIN_DIALOG_CLICK_JOIN);
            joinClickListener.onClick(v);
            dismiss();
        });
        btnClose.setOnClickListener(v -> {
            MixpanelEvent.locShareJoinDialog(MixpanelConstants.LOC_SHARE_JOIN_DIALOG_CLICK_CLOSE);
            closeClickListener.onClick(v);
            dismiss();
        });

        dialog = new Dialog(context, R.style.IpsmapDialogDimEnabled);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        int padding = DensityUtils.dp2px(context, 16);
        win.getDecorView().setPadding(padding, 0, padding, 0);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);
        dialog.setCancelable(false);
    }

    public void show() {
        Activity activity = (Activity) context;
        if (dialog != null && dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            pinview.clearEditTextList();
            dialog.dismiss();
        }
    }

}
