package com.locnavi.map.ui.item;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.utils.IpsUtils;
import com.locnavi.map.XJMapSDK;
//import com.xunji.xunjimap.XJMapSDK;
//import com.locnavi.map.R;

import com.locnavi.map.R;
import com.sails.engine.SAILS;


public class RegionSearchDataItem extends BaseRecyclerItemFactory<RegionSearchDataItem.LocationRegionDataRecyclerItem> {

    Context context;
    SAILS sails;
    String type;
    public static final String START_REGION = XJMapSDK.context.getString(R.string.ipsmap_start_go), TARGET_REGION = XJMapSDK.context.getString(R.string.ipsmap_go_this);
    private OnItemClickListener onItemNavClickListener;

    public RegionSearchDataItem(Context context, SAILS sails, String type) {
        this.context = context;
        this.sails = sails;
        this.type = type;
    }

    public void setOnItemNavClickListener(OnItemClickListener onItemNavClickListener) {
        this.onItemNavClickListener = onItemNavClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionData;
    }

    @Override
    public LocationRegionDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionDataRecyclerItem(parent, this);
    }

    public class LocationRegionDataRecyclerItem extends BaseRecyclerItem<LocationRegionData, RegionSearchDataItem> {

        private RelativeLayout rlRoot;
        private TextView tvRegionName, tvFloorName, tvGo, tvDistance;
        private LinearLayout llNav;
        private TextView tvLessDistance;
        private TextView tvIsSameFloor;

        protected LocationRegionDataRecyclerItem(ViewGroup parent, RegionSearchDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_region_search, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            rlRoot = (RelativeLayout) convertView.findViewById(R.id.rl_root);
            tvFloorName = (TextView) convertView.findViewById(R.id.tv_floor_name);
            tvRegionName = (TextView) convertView.findViewById(R.id.tv_region_name);
            tvGo = (TextView) convertView.findViewById(R.id.tv_go);
            tvDistance = (TextView) convertView.findViewById(R.id.tv_distance);
            tvLessDistance = (TextView) convertView.findViewById(R.id.tv_less_distance);
            tvIsSameFloor = (TextView) convertView.findViewById(R.id.tv_is_same_floor);
            llNav = (LinearLayout) convertView.findViewById(R.id.ll_nav);
        }

        @Override
        protected void onConfigViews(final Context context) {
            if (onItemNavClickListener != null) {
                llNav.setOnClickListener(v -> onItemNavClickListener.onClick(getPosition()));
            }
            if (onItemClickListener != null) {
                rlRoot.setOnClickListener(v -> onItemClickListener.onClick(getPosition()));
            }
        }

        @Override
        protected void onSetData(int position, LocationRegionData item) {
            String buildingName = item.getBuildingName();
            String floorName = "";
            if (!TextUtils.isEmpty(buildingName)) {
                floorName += buildingName;
                floorName += "(" + IpsUtils.getFloorDescription(sails, item.getFloorName()) + ")";
            } else {
                floorName += sails.getFloorDescription(item.getFloorName());
            }
            if (item.isFirst()) {
                tvLessDistance.setVisibility(View.VISIBLE);
            } else {
                tvLessDistance.setVisibility(View.GONE);
            }
            if (item.isSameFloor()) {
                tvIsSameFloor.setVisibility(View.VISIBLE);
            } else {
                tvIsSameFloor.setVisibility(View.INVISIBLE);
//                if (item.isFirst()){
//                    tvIsSameFloor.setVisibility(View.VISIBLE);
//                    tvIsSameFloor.setText("不在同层");
//                }
            }

            tvFloorName.setText(floorName);
            tvRegionName.setText(item.getName());
            tvGo.setText(type);
            if (!item.isSelected()) {
                rlRoot.setBackgroundResource(R.color.ipsmap_white);
            } else {
                rlRoot.setBackgroundResource(R.color.ipsmap_tvGrey6);
            }

            if (item.getDistanceTemp() <= 0) {
                tvDistance.setText("");
            } else {
                tvDistance.setText((int) item.getDistanceTemp() + "m");
            }
        }

    }


}
