package com.locnavi.map.service;

import android.content.Context;
import android.text.TextUtils;


import com.sails.engine.LocationRegion;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.overlay.ListOverlay;
import com.sails.engine.overlay.OverlayItem;
import com.locnavi.location.xunjimap.utils.IpsConstants;
import com.locnavi.location.xunjimap.utils.IpsUtils;
import com.locnavi.location.xunjimap.utils.L;

import java.util.ArrayList;
import java.util.List;

import static com.locnavi.location.xunjimap.utils.IpsConstants.CHANGE_FLOOR_ELEVATOR;
import static com.locnavi.location.xunjimap.utils.IpsConstants.CHANGE_FLOOR_ESCALATOR;
import static com.locnavi.location.xunjimap.utils.IpsConstants.CHANGE_FLOOR_STAIR;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_BEHIND_LEFT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_BEHIND_RIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_DOWNSTAIRS;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_GO_ALONG;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_LEFT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_NEAR_DESTINATION;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_RIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_STRAIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_STRAIGHT_LEFT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_STRAIGHT_RIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.DIRECTION_UPSTAIRS;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_ACCURACY;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_GO_ALONG;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_GO_STRAIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_GO_STRAIGHT_CONTINUE;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_MODE_SIMULATION;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_PLEASE_DOWNSTAIRS;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_PLEASE_UPSTAIRS;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_REACH;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_BEHIND_LEFT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_BEHIND_RIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_LEFT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_RIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_ROUND;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_STRAIGHT_LEFT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_TURN_STRAIGHT_RIGHT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NEAR_DESTINATION_DISTANCE;
import static com.locnavi.map.service.NavigationData.INDEX_NEAR_DESTINATION;
import static com.locnavi.map.service.NavigationData.INDEX_STRAIGHT;
import static com.locnavi.map.service.NavigationData.INDEX_STRAIGHT1;
import static com.locnavi.map.service.NavigationData.INDEX_STRAIGHT2;
import static com.locnavi.map.service.NavigationData.INDEX_STRAIGHT3;
import static com.locnavi.map.service.NavigationData.INDEX_STRAIGHT4;
import static com.locnavi.map.service.NavigationData.INDEX_STRAIGHT5;
import static com.locnavi.map.service.NavigationData.INDEX_SWERVE;
import static com.locnavi.map.service.NavigationData.INDEX_SWERVE_FRONT;
import static com.locnavi.map.service.NavigationData.INDEX_TURN_ROUND;
import static com.locnavi.map.service.NavigationData.INDEX_UPDOWN;
import static com.locnavi.map.service.NavigationData.STATUS_OFF;
import static com.locnavi.map.service.NavigationData.STATUS_PLAYED;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_NEAR_DESTINATION;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_STRAIGHT;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_STRAIGHT1;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_STRAIGHT2;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_STRAIGHT3;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_STRAIGHT4;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_STRAIGHT5;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_SWERVE;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_SWERVE_FRONT;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_TURN_ROUND;
//import static com.xunji.xunjimap.service.NavigationData.INDEX_UPDOWN;
//import static com.xunji.xunjimap.service.NavigationData.STATUS_OFF;
//import static com.xunji.xunjimap.service.NavigationData.STATUS_PLAYED;



/**
 * Created by hdp on 17/3/9.
 */

public class NavigationHandler {

    private static String TAG = NavigationHandler.class.getName();
    private static double ONE_PEACE = 22.5; //角度
    private List<NavigationData> navigationDatas = new ArrayList<>();
    private List<List<SAILS.GeoNode>> onPathAllPointsByFloorNumber = new ArrayList<>();
    private NavigationData preFirstNavigationData;
    private boolean isNegativeDirectionStart = false;
    private int currentFloorLastSelf = 0;//当前楼层转换点 变化时才改变
    private double mapDistanceByLngLat;

    public NavigationHandler(SAILS sails, List<SAILS.GeoNode> currentAllPathNodes) {
        currentFloorLastSelf = 0;
        removeSimilarPoints(sails, currentAllPathNodes);
        navigationHandlersForMultiFloor(currentAllPathNodes);
    }

    public void clear() {
        if (navigationDatas != null) {
            navigationDatas.clear();
        }
        if (onPathAllPointsByFloorNumber != null) {
            onPathAllPointsByFloorNumber.clear();
        }
    }


    public boolean isNaN(double v) {
        return (v != v);
    }


    /**
     * 根据楼层号 做每个路径上的点的分类
     *
     * @param list
     */
    public synchronized void classifyByFloorNumber(List<SAILS.GeoNode> list) {
        if (list == null) {
            return;
        }
        onPathAllPointsByFloorNumber.clear();
        int floorNumberFlag = -1000;
        List<SAILS.GeoNode> tempList = null;
        boolean isMustTocreateList = false;
        for (int i = 0; i < list.size(); i++) {
            if (floorNumberFlag != list.get(i).floornumber) {
                isMustTocreateList = true;
            }
            if (isMustTocreateList) {
                floorNumberFlag = list.get(i).floornumber;
                if (tempList != null && tempList.size() > 1 || tempList != null && tempList.size() == 1
                        && i == 0) {
                    onPathAllPointsByFloorNumber.add(tempList);
                }
                tempList = new ArrayList<>();
                isMustTocreateList = false;
            }
            if (tempList != null) {
                tempList.add(list.get(i));
            }
        }
        onPathAllPointsByFloorNumber.add(tempList);
    }

    private List<SAILS.GeoNode> getFirstGeoNodesByFloorNumber(int floornumber) {
        List<SAILS.GeoNode> list = new ArrayList<>();
        for (int i = 0; i < onPathAllPointsByFloorNumber.size(); i++) {
            SAILS.GeoNode firstGeoNode = onPathAllPointsByFloorNumber.get(i).get(0);
            if (floornumber == firstGeoNode.floornumber) {
                list.add(firstGeoNode);
            }
        }
        return list;
    }

    private SAILS.GeoNode getFirstGeoNodeByFloorNumber(SAILS sails, SAILS.GeoNode currentGeoNode, int targetFloorNumber) {
        LocationRegion lr0 = sails.getInBuildingName(currentGeoNode.longitude, currentGeoNode.latitude);
        String buildingName = null;
        if (lr0 != null && lr0.label != null) {
            buildingName = lr0.label;
        }
        for (int i = 0; i < onPathAllPointsByFloorNumber.size(); i++) {
            SAILS.GeoNode nextFirstGeoNode = onPathAllPointsByFloorNumber.get(i).get(0);
            if (!TextUtils.isEmpty(buildingName)) {
                LocationRegion lr = sails.getInBuildingName(nextFirstGeoNode.longitude, nextFirstGeoNode.latitude);
                if (lr != null && lr.label != null && lr.label.equals(buildingName) && targetFloorNumber == nextFirstGeoNode.floornumber) {
                    return nextFirstGeoNode;
                }

            } else if (targetFloorNumber == nextFirstGeoNode.floornumber) {
                return nextFirstGeoNode;
            }
        }
        return null;
    }

    private NavigationData getIndexNavigationDataByFloor(SAILS sails, SAILS.GeoNode currentGeoNode, int index, int targetFloorNumber) {
        NavigationData navigationData = null;
        LocationRegion lr0 = sails.getInBuildingName(currentGeoNode.longitude, currentGeoNode.latitude);
        String buildingName = null;
        if (lr0 != null && lr0.label != null) {
            buildingName = lr0.label;
        }
        for (int i = 0; navigationDatas != null && i + index < navigationDatas.size(); i++) {
            NavigationData navData = navigationDatas.get(i);
            NavigationData navDataSel = navigationDatas.get(i + index);
            SAILS.GeoNode geoNode = navData.getGeoNode();
            SAILS.GeoNode geoNodeSel = navDataSel.getGeoNode();
            if (!TextUtils.isEmpty(buildingName)) {
                LocationRegion lr = sails.getInBuildingName(geoNodeSel.longitude, geoNodeSel.latitude);
                if (lr != null && lr.label != null && lr.label.equals(buildingName)
                        && targetFloorNumber == geoNode.floornumber && targetFloorNumber == geoNodeSel.floornumber) {
                    navigationData = navDataSel;
                    break;
                }

            } else if (targetFloorNumber == geoNode.floornumber && targetFloorNumber == geoNodeSel.floornumber) {
                navigationData = navDataSel;
                break;
            }
        }
        return navigationData;
    }

    private int getCurrentFloorNavigationDataSize(int floornumber) {
        int size = 0;
        for (int i = 0; i < navigationDatas.size(); i++) {
            SAILS.GeoNode geoNode = navigationDatas.get(i).getGeoNode();
            if (floornumber == geoNode.floornumber) {
                size++;
                continue;
            }
        }
        return size;
    }

    private NavigationData getFloorLastNavigationData(int floornumber) {
        for (int i = 0; i < navigationDatas.size() - 1; i++) {
            NavigationData data1 = navigationDatas.get(i);
            NavigationData data2 = navigationDatas.get(i + 1);
            if (floornumber == data1.getGeoNode().floornumber &&
                    floornumber != data2.getGeoNode().floornumber) {
                return data1;
            }
        }
        return null;
    }

    /**
     * 创建日期：2017/4/13 15:34
     *
     * @author xiaoju
     * @version 1.0
     * @since JDK 1.7.0_79
     * 类说明： 多楼层产生后的导航信息
     */
    public synchronized void navigationHandlersForMultiFloor(List<SAILS.GeoNode> allList) {
        classifyByFloorNumber(allList);
        List<NavigationData> datas = new ArrayList<>();
        for (int n = 0; n < onPathAllPointsByFloorNumber.size() - 1; n++) {
            List<SAILS.GeoNode> list = onPathAllPointsByFloorNumber.get(n);
            if (list == null) {
                //|| list.size() < 3
                return;
            }
            int size = list.size();
            if (size == 1) {
                //起点是一个的情况,楼梯附近
                SAILS.GeoNode geoNode = list.get(size - 1);
                SAILS.GeoNode nextFloorNode = onPathAllPointsByFloorNumber.get(n + 1).get(0);
                if (nextFloorNode.floornumber > geoNode.floornumber) {
                    NavigationData navigationData = new NavigationData();
                    navigationData.setGeoNode(geoNode);
                    navigationData.setNaviDirection(DIRECTION_UPSTAIRS);
                    navigationData.setToFloor(nextFloorNode.floornumber + "");
                    navigationData.setChangeFloorMode(getChangeFloorMode(nextFloorNode));
                    datas.add(navigationData);
                } else {
                    NavigationData navigationData = new NavigationData();
                    navigationData.setGeoNode(geoNode);
                    navigationData.setNaviDirection(DIRECTION_DOWNSTAIRS);
                    navigationData.setToFloor(nextFloorNode.floornumber + "");
                    navigationData.setChangeFloorMode(getChangeFloorMode(nextFloorNode));
                    datas.add(navigationData);
                }
                continue;
            }
            for (int i = 0; i < size - 2; i = i + 1) {
                double bearDiff = getDegreeDiff(list.get(i), list.get(i + 1), list.get(i + 2));
                if (bearDiff >= 90 - ONE_PEACE && bearDiff <= 90 + ONE_PEACE) {
                    NavigationData navigationData = new NavigationData();
                    SAILS.GeoNode geoNode = list.get(i + 1);
                    navigationData.setGeoNode(geoNode);
                    navigationData.setNaviDirection(DIRECTION_RIGHT);
                    datas.add(navigationData);
                    continue;
                }
                if (bearDiff >= 270 - ONE_PEACE && bearDiff <= 270 + ONE_PEACE) {
                    NavigationData navigationData = new NavigationData();
                    SAILS.GeoNode geoNode = list.get(i + 1);
                    navigationData.setGeoNode(geoNode);
                    navigationData.setNaviDirection(DIRECTION_LEFT);
                    datas.add(navigationData);
                    continue;
                }
                if (bearDiff >= 45 - ONE_PEACE && bearDiff <= 45 + ONE_PEACE) {
                    NavigationData navigationData = new NavigationData();
                    SAILS.GeoNode geoNode = list.get(i + 1);
                    navigationData.setGeoNode(geoNode);
                    navigationData.setNaviDirection(DIRECTION_STRAIGHT_RIGHT);
                    datas.add(navigationData);
                    continue;
                }
                if (bearDiff >= 315 - ONE_PEACE && bearDiff <= 315 + ONE_PEACE) {
                    NavigationData navigationData = new NavigationData();
                    SAILS.GeoNode geoNode = list.get(i + 1);
                    navigationData.setGeoNode(geoNode);
                    navigationData.setNaviDirection(DIRECTION_STRAIGHT_LEFT);
                    datas.add(navigationData);
                    continue;
                }
            }
            SAILS.GeoNode lastPointer = list.get(list.size() - 1);
            LocationRegion belongsRegion = lastPointer.BelongsRegion;
            NavigationData navigationData = new NavigationData();
            SAILS.GeoNode geoNode = list.get(size - 1);
            SAILS.GeoNode nextFloorNode = onPathAllPointsByFloorNumber.get(n + 1).get(0);
            if (nextFloorNode.floornumber > geoNode.floornumber) {
                navigationData.setNaviDirection(DIRECTION_UPSTAIRS);
                navigationData.setToFloor(nextFloorNode.floornumber + "");
                navigationData.setChangeFloorMode(getChangeFloorMode(nextFloorNode));
                SAILS.GeoNode geoNode1 = list.get(list.size() - 1);
                LocationRegion belongsRegion1 = geoNode1.BelongsRegion;
                if (belongsRegion1 != null) {
                    int self = belongsRegion1.self;
                    navigationData.setSelf(self);
                    navigationData.setSubtype(belongsRegion1.subtype);
                } else {
                    geoNode1 = list.get(size - 2);
                    belongsRegion1 = geoNode1.BelongsRegion;
                    if (belongsRegion1 != null) {
                        int self = belongsRegion1.self;
                        navigationData.setSelf(self);
                        navigationData.setSubtype(belongsRegion1.subtype);
                    } else {
                        L.e(TAG, "last has pointer");
                    }

                }
            }
            if (geoNode.floornumber > nextFloorNode.floornumber) {
                navigationData.setNaviDirection(DIRECTION_DOWNSTAIRS);
                navigationData.setToFloor(nextFloorNode.floornumber + "");
                navigationData.setChangeFloorMode(getChangeFloorMode(nextFloorNode));
                SAILS.GeoNode geoNode1 = list.get(list.size() - 1);
                LocationRegion belongsRegion1 = geoNode1.BelongsRegion;
                if (belongsRegion1 != null) {
                    int self = belongsRegion1.self;
                    navigationData.setSelf(self);
                    navigationData.setSubtype(belongsRegion1.subtype);
                } else {
                    geoNode1 = list.get(size - 2);
                    belongsRegion1 = geoNode1.BelongsRegion;
                    if (belongsRegion1 != null) {
                        int self = belongsRegion1.self;
                        navigationData.setSelf(self);
                        navigationData.setSubtype(belongsRegion1.subtype);
                    } else {
                        L.e(TAG, "last has pointer");
                    }
                }
            }
            navigationData.setGeoNode(geoNode);
            datas.add(navigationData);

        }
        //最后一个楼层的导航算法
        if (onPathAllPointsByFloorNumber.size() > 0) {
            navigationHandlersForSingleFloor(onPathAllPointsByFloorNumber.get(onPathAllPointsByFloorNumber.size() - 1), datas);
        }

        for (int i = datas.size() - 1; i > 0; i--) {
            NavigationData data1 = datas.get(i);
            NavigationData data2 = datas.get(i - 1);
            if (data1.getGeoNode().floornumber != data2.getGeoNode().floornumber) {
                data1.setPreFloor(data2.getGeoNode().floornumber + "");
                continue;
            }
        }
        setNavigationDatas(datas);

    }

    private int getChangeFloorMode(SAILS.GeoNode geoNode) {
        int mode = 1;
        if (geoNode != null) {
            LocationRegion lr = geoNode.BelongsRegion;
            if (lr != null && lr.subtype != null) {
                switch (lr.subtype) {
                    case IpsConstants.STAIR:
                        mode = CHANGE_FLOOR_STAIR;
                        break;
                    case IpsConstants.ELEVATOR:
                        mode = CHANGE_FLOOR_ELEVATOR;
                        break;
                    case IpsConstants.ESCALATOR:
                        mode = CHANGE_FLOOR_ESCALATOR;
                        break;
                }
            }
        }
        return mode;
    }

    public synchronized void setNavigationDatas(List<NavigationData> list) {
        if (list != null && list.size() > 0) {
            if (navigationDatas != null && navigationDatas.size() > 0) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = 0; j < navigationDatas.size(); j++) {
                        SAILS.GeoNode geoNode = navigationDatas.get(j).getGeoNode();
                        SAILS.GeoNode geoNodeNew = list.get(i).getGeoNode();
                        if (geoNode.latitude == geoNodeNew.latitude && geoNode.longitude == geoNodeNew.longitude &&
                                geoNode.floornumber == geoNodeNew.floornumber) {
                            list.get(i).setVoicePoints(navigationDatas.get(j).getVoicePoints());
                            list.get(i).setVoicePointIndex(navigationDatas.get(j).getVoicePointIndex());
                            continue;
                        }

                    }
                }

            }
            navigationDatas.clear();
            navigationDatas.addAll(list);
        }
//        for (int i = 0; i < navigationDatas.size(); i++) {
//            L.d("ddd", navigationDatas.get(i).getGeoNode().floornumber + "," +
//                    navigationDatas.get(i).getPreFloor() + "," + navigationDatas.get(i).getToFloor() + "EEEEE");
//        }
    }

    public void setNavigationData(NavigationData navigationData) {
        if (navigationDatas != null && navigationDatas.size() > 0) {
            for (int i = 0; i < navigationDatas.size(); i++) {
                SAILS.GeoNode geoNode = navigationDatas.get(i).getGeoNode();
                SAILS.GeoNode geoNodeNew = navigationData.getGeoNode();
                if (geoNode.latitude == geoNodeNew.latitude && geoNode.longitude == geoNodeNew.longitude &&
                        geoNode.floornumber == geoNodeNew.floornumber) {
                    navigationDatas.get(i).setVoicePoints(navigationData.getVoicePoints());
                    break;
                }
            }

        }
    }

    //获取当前楼层第一个转换点(路径规划成功时)
    public List<NavigationData> getCurrentFloorFirstData(SAILS sails, int floornumber) {
        List<NavigationData> list = new ArrayList<>();
        List<SAILS.GeoNode> firstGeoNodes = getFirstGeoNodesByFloorNumber(floornumber);
        for (int j = 0; j < firstGeoNodes.size(); j++) {
            SAILS.GeoNode geoNode = firstGeoNodes.get(j);
            for (int i = 0; i < navigationDatas.size(); i++) {
                NavigationData data = navigationDatas.get(i);
                if (geoNode != null && data.getGeoNode().floornumber == floornumber && data.getPreFloor() != null) {
                    LocationRegion lr1 = sails.getInBuildingName(geoNode.longitude, geoNode.latitude);
                    LocationRegion lr2 = sails.getInBuildingName(data.getGeoNode().longitude, data.getGeoNode().latitude);
                    if (lr1 != null && lr2 != null && lr1.label != null && lr2.label != null
                            && lr1.label.equals(lr2.label)) {
                        NavigationData navigationData = new NavigationData();
                        navigationData.setGeoNode(geoNode);
                        navigationData.setPreFloor(data.getPreFloor());
                        list.add(navigationData);
                    }
                    if (lr1 == null || lr2 == null) {
                        NavigationData navigationData = new NavigationData();
                        navigationData.setGeoNode(geoNode);
                        navigationData.setPreFloor(data.getPreFloor());
                        list.add(navigationData);
                    }

                }
            }
        }
//        for (int i = 0; i < list.size(); i++) {
//            L.d("ddd", list.get(i).getGeoNode().latitude + "&&" + list.get(i).getGeoNode().floornumber);
//        }
        return list;
    }

    //获取当前楼层最后一个转换点(路径规划成功时)
    public List<NavigationData> getCurrentFloorLastData(int floornumber) {
        List<NavigationData> list = new ArrayList<>();
        for (int i = 0; i < navigationDatas.size(); i++) {
            NavigationData navigationData = navigationDatas.get(i);
            SAILS.GeoNode geoNode = navigationData.getGeoNode();
            if (geoNode.floornumber == floornumber && navigationData.getToFloor() != null) {
                list.add(navigationData);
            }
        }
        return list;
    }


    /**
     * 根据传入的位置数据进行导航算法的计算，规划行走指示
     *
     * @param list 路径规划中的节点
     */
    public synchronized void navigationHandlersForSingleFloor(List<SAILS.GeoNode> list, List<NavigationData> NavigationDatas) {
        if (list == null) {
            return;
        }
        int size = list.size();

        for (int i = 0; i < size - 2; i = i + 1) {
            double bearDiff = getDegreeDiff(list.get(i), list.get(i + 1), list.get(i + 2));
            if (bearDiff >= 90 - ONE_PEACE && bearDiff <= 90 + ONE_PEACE) {
                NavigationData navigationData = new NavigationData();
                SAILS.GeoNode geoNode = list.get(i + 1);
                navigationData.setGeoNode(geoNode);
                navigationData.setNaviDirection(DIRECTION_RIGHT);
                NavigationDatas.add(navigationData);
                continue;
            }
            if (bearDiff >= 270 - ONE_PEACE && bearDiff <= 270 + ONE_PEACE) {
                NavigationData navigationData = new NavigationData();
                SAILS.GeoNode geoNode = list.get(i + 1);
                navigationData.setGeoNode(geoNode);
                navigationData.setNaviDirection(DIRECTION_LEFT);
                NavigationDatas.add(navigationData);
                continue;
            }
            if (bearDiff >= 45 - ONE_PEACE && bearDiff <= 45 + ONE_PEACE) {
                NavigationData navigationData = new NavigationData();
                SAILS.GeoNode geoNode = list.get(i + 1);
                navigationData.setGeoNode(geoNode);
                navigationData.setNaviDirection(DIRECTION_STRAIGHT_RIGHT);
                NavigationDatas.add(navigationData);
                continue;
            }
            if (bearDiff >= 315 - ONE_PEACE && bearDiff <= 315 + ONE_PEACE) {
                NavigationData navigationData = new NavigationData();
                SAILS.GeoNode geoNode = list.get(i + 1);
                navigationData.setGeoNode(geoNode);
                navigationData.setNaviDirection(DIRECTION_STRAIGHT_LEFT);
                NavigationDatas.add(navigationData);
                continue;
            }

        }

        NavigationData navigationData = new NavigationData();
        SAILS.GeoNode geoNode = list.get(size - 1);
        navigationData.setGeoNode(geoNode);
        navigationData.setNaviDirection(DIRECTION_GO_ALONG);
        NavigationDatas.add(navigationData);
    }


    /**
     * @param currentGeoNode
     * @param mSails
     * @param myLocationOverlayItems
     * @param myLocationOverlay
     * @param sailsMapView           @return
     */
    public synchronized NavigationData getNavigationData(SAILS.GeoNode currentGeoNode,
                                                         SAILS mSails, List<SAILS.GeoNode> currentAllPathNodes,
                                                         List<OverlayItem> myLocationOverlayItems, ListOverlay myLocationOverlay,
                                                         SAILSMapView sailsMapView, Context context, int navMode) {
        removeSimilarPoints(mSails, currentAllPathNodes);
        navigationHandlersForMultiFloor(currentAllPathNodes);
        //第一个点必须为当前楼层
        for (int i = 0; i < navigationDatas.size(); i++) {
            SAILS.GeoNode geoNode = navigationDatas.get(i).getGeoNode();
            if (geoNode.floornumber != currentGeoNode.floornumber) {
                navigationDatas.remove(i);
                i = -1;
            } else {
                break;
            }
        }
        NavigationData navigationData = new NavigationData();
        if (currentGeoNode == null || (isNaN(currentGeoNode.longitude) || isNaN(currentGeoNode.latitude))) {
            navigationData.setNavigationText("當前室內定位失敗，請到開闊地！");
            navigationData.setNavigationVoiceText("當前室內定位失敗，請到開闊地！");
            return navigationData;
        }
        if (!navigationDatas.isEmpty() && currentAllPathNodes != null && !currentAllPathNodes.isEmpty()) {
            navigationData = navigationDatas.get(0);
            SAILS.GeoNode nextGeoNode = navigationData.getGeoNode();
            double distanceX = getDistance(mSails, currentGeoNode, nextGeoNode);
//            removePreFirstPoint(distanceX);
            double currentFloorDistance = getCurrentFloorDistance(mSails, currentGeoNode);
            List<NavigationData.VoicePoint> voicePoints = navigationData.getVoicePoints();

            //方向走反
            SAILS.GeoNode firstGeoNode = currentAllPathNodes.get(0);
            double distanceDash = getDistance(mSails, currentGeoNode, firstGeoNode);
            double distanceDiff = getDistance(mSails, currentGeoNode, nextGeoNode) -
                    getDistance(mSails, firstGeoNode, nextGeoNode);
            double bearDegree = SAILS.GetBearDegree(firstGeoNode.longitude, firstGeoNode.latitude,
                    nextGeoNode.longitude, nextGeoNode.latitude);
            //第一条线太短按下一条线方向
//            if (distanceDash > voicePoints.get(INDEX_TURN_ROUND).getMilestone() &&
//                    getDistance(mSails, firstGeoNode, nextGeoNode) < 3 && navigationDatas.size() > 1) {
//                bearDegree = SAILS.GetBearDegree(nextGeoNode.longitude, nextGeoNode.latitude,
//                        navigationDatas.get(1).getGeoNode().longitude, navigationDatas.get(1).getGeoNode().latitude);
//            }
            double userHeading = mSails.getUserHeading();
            double bearDiff = userHeading - bearDegree;
            if (bearDiff < 0) {
                bearDiff += 360;
            }
            boolean isNegativeDirection = false;
            if (bearDiff < 270 && bearDiff > 90) {
                if (isNegativeDirectionStart) {
                    isNegativeDirection = true;
                }
                isNegativeDirectionStart = true;
            } else {
                isNegativeDirectionStart = false;
            }
//          T.showShort(distance0 + "," + bearDiff);
            if (distanceDiff > voicePoints.get(INDEX_TURN_ROUND).getMilestone() &&
                    isNegativeDirection && navMode != NAV_MODE_SIMULATION &&
                    currentFloorDistance > voicePoints.get(INDEX_TURN_ROUND).getMilestone() + voicePoints.get(INDEX_TURN_ROUND).getCeilOffset()) {
                String navText = NAV_TURN_ROUND;
                String navVoiceText = NAV_TURN_ROUND;
                navigationData.setNavigationText(navText);
                navigationData.setNavigationVoiceText(navVoiceText);
                navigationData.setForcePlay(true);
                navigationData.setVoicePointIndex(INDEX_TURN_ROUND);
                if (voicePoints.get(navigationData.getVoicePointIndex()).getPlayStatus()
                        == STATUS_OFF) {
                    voicePoints.get(INDEX_TURN_ROUND).setPlayStatus(NavigationData.STATUS_READY);
                }
                return navigationData;
            }
            //文字提示方向走反
            if (isNegativeDirectionStart && navMode != NAV_MODE_SIMULATION &&
                    currentFloorDistance > voicePoints.get(INDEX_TURN_ROUND).getMilestone() + voicePoints.get(INDEX_TURN_ROUND).getCeilOffset()) {
                navigationData.setNavigationText(NAV_TURN_ROUND);
                return navigationData;
            }
            //虚线过长情况提示沿路径行走 室外15m 室内3m
            if ((distanceDash > 3 && !mSails.isUseGPS() || distanceDash > 15 && mSails.isUseGPS()) &&
                    currentFloorDistance > voicePoints.get(INDEX_UPDOWN).getMilestone() + voicePoints.get(INDEX_UPDOWN).getCeilOffset()) {
                String navText = NAV_GO_ALONG;
                navigationData.setNavigationText(navText);
                navigationData.setNavigationVoiceText(navText);
                navigationData.setVoicePointIndex(INDEX_SWERVE_FRONT);
                navigationData.setNaviDirection(DIRECTION_GO_ALONG);
                if (voicePoints.get(navigationData.getVoicePointIndex()).getPlayStatus()
                        == STATUS_OFF) {
                    voicePoints.get(INDEX_SWERVE_FRONT).setPlayStatus(NavigationData.STATUS_READY);
                }
                return navigationData;
            }
            //目的地附近
            if (navigationDatas.size() == 1 && currentGeoNode.floornumber ==
                    navigationDatas.get(navigationDatas.size() - 1).getGeoNode().floornumber &&
                    currentGeoNode.floornumber == currentAllPathNodes.get(currentAllPathNodes.size() - 1).floornumber &&
                    currentFloorDistance <= NEAR_DESTINATION_DISTANCE) {
                String navText = getDistanceShow(currentFloorDistance) + "公尺後" + NAV_REACH;
                navigationData.setNavigationText(navText);
                navigationData.setNavigationVoiceText(navText);
                navigationData.setNaviDirection(DIRECTION_NEAR_DESTINATION);
                navigationData.setForcePlay(true);
                navigationData.setVoicePointIndex(INDEX_NEAR_DESTINATION);
                voicePoints = navigationData.getVoicePoints();
                if (voicePoints.get(INDEX_NEAR_DESTINATION).getPlayStatus()
                        == STATUS_OFF) {
                    voicePoints.get(INDEX_NEAR_DESTINATION).setPlayStatus(NavigationData.STATUS_READY);
                }
                return navigationData;
            }
            if (navigationDatas.size() == 2 && currentGeoNode.floornumber ==
                    navigationDatas.get(navigationDatas.size() - 1).getGeoNode().floornumber &&
                    currentGeoNode.floornumber == currentAllPathNodes.get(currentAllPathNodes.size() - 1).floornumber &&
                    currentFloorDistance <= NEAR_DESTINATION_DISTANCE) {
                NavigationData navigationData1 = navigationDatas.get(1);
                SAILS.GeoNode secondGeoNode = navigationData1.getGeoNode();
                double distanceY = getDistance(mSails, nextGeoNode, secondGeoNode);
                if (distanceY < voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                    String navText = getDistanceShow(currentFloorDistance) + "公尺後" + NAV_REACH;
                    navigationData = navigationDatas.get(1);
                    navigationData.setNavigationText(navText);
                    navigationData.setNavigationVoiceText(navText);
                    navigationData.setNaviDirection(DIRECTION_NEAR_DESTINATION);
                    navigationData.setForcePlay(true);
                    navigationData.setVoicePointIndex(INDEX_NEAR_DESTINATION);
                    voicePoints = navigationData.getVoicePoints();
                    if (voicePoints.get(INDEX_NEAR_DESTINATION).getPlayStatus()
                            == STATUS_OFF) {
                        voicePoints.get(INDEX_NEAR_DESTINATION).setPlayStatus(NavigationData.STATUS_READY);
                    }
                    return navigationData;
                }
            }

            if (navigationDatas.size() > 1) {
                NavigationData navigationData1 = navigationDatas.get(1);
                SAILS.GeoNode secondGeoNode = navigationData1.getGeoNode();
                double distanceY = getDistance(mSails, nextGeoNode, secondGeoNode);
                L.d("ddd", "currentGeoNode:" + currentGeoNode.latitude + "," + currentGeoNode.longitude + "," + currentGeoNode.floornumber);
                L.d("ddd", "nextGeoNode:" + nextGeoNode.latitude + "," + nextGeoNode.longitude + "," + nextGeoNode.floornumber);
                L.d("ddd", "secondGeoNode:" + secondGeoNode.latitude + "," + secondGeoNode.longitude + "," + secondGeoNode.floornumber);
                L.d("ddd", "distanceX:" + distanceX + ", distanceY:" + distanceY);
                L.d("ddd", "currentFloorDistance:" + currentFloorDistance + "");
//                if (sailsMapView.getDynamicOverlays().contains(myLocationOverlay)) {
//                    sailsMapView.getDynamicOverlays().remove(myLocationOverlay);
//                }
//                myLocationOverlayItems.clear();
//                    myLocationOverlayItems.add(new Marker(new GeoPoint(currentGeoNode.latitude, currentGeoNode.longitude),
//                            Marker.boundCenterBottom(context.getResources().getDrawable(R.drawable.ipsmap_loc_point_start))));
//                    myLocationOverlayItems.add(new Marker(new GeoPoint(nextGeoNode.latitude, nextGeoNode.longitude),
//                            Marker.boundCenterBottom(context.getResources().getDrawable(R.drawable.ipsmap_loc_point_friend))));
//                    myLocationOverlayItems.add(new Marker(new GeoPoint(secondGeoNode.latitude, secondGeoNode.longitude),
//                            Marker.boundCenterBottom(context.getResources().getDrawable(R.drawable.ipsmap_loc_point_search))));
//                    sailsMapView.getDynamicOverlays().add(myLocationOverlay);
//                sailsMapView.redraw();
                //上下楼
                NavigationData lastNavigationData = getFloorLastNavigationData(currentGeoNode.floornumber);
                if (lastNavigationData != null && lastNavigationData.getToFloor() != null
                        && currentFloorDistance <= voicePoints.get(INDEX_UPDOWN).getMilestone() + voicePoints.get(INDEX_UPDOWN).getCeilOffset()) {
                    navigationData = lastNavigationData;
                    voicePoints = navigationData.getVoicePoints();
                    //上下楼
                    String floorDescription = IpsUtils.getFloorDescription(mSails, navigationData.getToFloor());
                    if (floorDescription.endsWith("F") || floorDescription.endsWith("層")) {
                        floorDescription = floorDescription.substring(0, floorDescription.length() - 1);
                    }
                    String navText = "請" + getDirection(navigationData.getNaviDirection()) + floorDescription + "層";
                    String subType = navigationData.getSubtype();
                    String navVoiceText = navText;
                    if (subType != null) {
                        if (subType.equals(IpsConstants.ESCALATOR)) {
                            navVoiceText = "请乘扶梯" + getDirection(navigationData.getNaviDirection()) + floorDescription + "層";
                        } else if (subType.equals(IpsConstants.ELEVATOR)) {
                            navVoiceText = "请乘电梯" + getDirection(navigationData.getNaviDirection()) + floorDescription + "層";
                        } else if (subType.equals(IpsConstants.STAIR)) {
                            navVoiceText = "请走楼梯" + getDirection(navigationData.getNaviDirection()) + floorDescription + "層";
                        }
                    }
                    if (floorDescription.equals("2")) {
                        navVoiceText = navVoiceText.replace("2", "二");
                    }
                    //到达楼层播报信息
                    int targetFloorNumber = Integer.parseInt(navigationData.getToFloor());
                    NavigationData nextFloorFirstNavData = getIndexNavigationDataByFloor(mSails, currentGeoNode, 0, targetFloorNumber);
                    NavigationData nextFloorSecondNavData = getIndexNavigationDataByFloor(mSails, currentGeoNode, 1, targetFloorNumber);
                    NavigationData nextFloorThirdNavData = getIndexNavigationDataByFloor(mSails, currentGeoNode, 2, targetFloorNumber);

                    if (nextFloorFirstNavData != null) {
                        SAILS.GeoNode nextFloorFirstGeoNode = nextFloorFirstNavData.getGeoNode();
                        SAILS.GeoNode nextFloorRealFirstGeoNode = getFirstGeoNodeByFloorNumber(mSails, currentGeoNode, targetFloorNumber);

                        if (nextFloorFirstGeoNode!= null && nextFloorRealFirstGeoNode != null){
                            double distance1 = getDistance(mSails, nextFloorRealFirstGeoNode, nextFloorFirstGeoNode);
                            double distance2 = 0, distance3 = 0;
                            if (distance1 > 1) {//distance1 > 1防止在楼梯附近
                                int direction = nextFloorFirstNavData.getNaviDirection();
                                if (nextFloorSecondNavData != null && nextFloorThirdNavData != null) {
                                    SAILS.GeoNode nextFloorSecondGeoNode = nextFloorSecondNavData.getGeoNode();
                                    SAILS.GeoNode nextFloorThirdGeoNode = nextFloorThirdNavData.getGeoNode();
                                    distance2 = getDistance(mSails, nextFloorFirstGeoNode, nextFloorSecondGeoNode);
                                    distance3 = getDistance(mSails, nextFloorSecondGeoNode, nextFloorThirdGeoNode);
                                    if (distance2 < voicePoints.get(INDEX_SWERVE_FRONT).getMilestone() &&
                                            nextFloorFirstNavData.getNaviDirection() == nextFloorSecondNavData.getNaviDirection() &&
                                            distance3 >= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                                        if (nextFloorFirstNavData.getNaviDirection() == DIRECTION_LEFT) {
                                            direction = DIRECTION_BEHIND_LEFT;
                                        } else if (nextFloorFirstNavData.getNaviDirection() == DIRECTION_RIGHT) {
                                            direction = DIRECTION_BEHIND_RIGHT;
                                        }
                                    }
                                }
                                if (distance1 > voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                                    direction = DIRECTION_STRAIGHT;
                                }
                                L.d("ddd", "nextFloor:" + distance1 + "," + distance2 + "," + distance3 + ",direction:" + direction);
                                navText += " 之後" + getDirection(direction);
                                navVoiceText += "。之後" + getDirection(direction);
                            }
                        }

                    }
                    navigationData.setNavigationText(navText);
                    navigationData.setNavigationVoiceText(navVoiceText);
                    navigationData.setForcePlay(true);
                    navigationData.setVoicePointIndex(INDEX_UPDOWN);
                    if (voicePoints.get(navigationData.getVoicePointIndex()).getPlayStatus()
                            == STATUS_OFF) {
                        voicePoints.get(INDEX_UPDOWN).setPlayStatus(NavigationData.STATUS_READY);
                    }
                    return navigationData;
                }
                //0-5
                if (distanceX >= 1 && distanceX <= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone() - voicePoints.get(INDEX_SWERVE_FRONT).getFloorOffset()
                        && distanceY > voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                    int direction = navigationData.getNaviDirection();
                    String navText = getDistanceShow(distanceX) + "公尺後" + getDirection(direction);
                    if (direction == DIRECTION_GO_ALONG) {
                        navText = NAV_GO_ALONG;
                    }
                    navigationData.setNavigationText(navText);
                    if (distanceX > voicePoints.get(INDEX_SWERVE).getMilestone() - voicePoints.get(INDEX_SWERVE).getFloorOffset() &&
                            distanceX <= voicePoints.get(INDEX_SWERVE).getMilestone() + voicePoints.get(INDEX_SWERVE).getCeilOffset() &&
                            voicePoints.get(INDEX_SWERVE).getPlayStatus() == STATUS_OFF &&
                            voicePoints.get(INDEX_SWERVE_FRONT).getPlayStatus() != STATUS_PLAYED) {
                        navigationData.setNavigationVoiceText(getDirection(direction));
                        navigationData.setVoicePointIndex(INDEX_SWERVE);
                        voicePoints.get(INDEX_SWERVE).setPlayStatus(NavigationData.STATUS_READY);
                    }
                    return navigationData;
                }
                //xm后左右转
                else if (distanceX >= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone() - voicePoints.get(INDEX_SWERVE_FRONT).getFloorOffset()
                        && distanceX <= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone() + voicePoints.get(INDEX_SWERVE_FRONT).getCeilOffset()
                        && distanceY >= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                    String navText = getDistanceShow(distanceX) + "公尺後" + getDirection(navigationData.getNaviDirection());
                    String navVoiceText = "前方" + getDirection(navigationData.getNaviDirection());
                    if (navigationData.getNaviDirection() == DIRECTION_STRAIGHT_LEFT ||
                            navigationData.getNaviDirection() == DIRECTION_STRAIGHT_RIGHT) {
                        navVoiceText = getDirection(navigationData.getNaviDirection());
                    }
                    navigationData.setNavigationText(navText);
                    navigationData.setNavigationVoiceText(navVoiceText);
                    navigationData.setVoicePointIndex(INDEX_SWERVE_FRONT);
                    if (voicePoints.get(navigationData.getVoicePointIndex()).getPlayStatus()
                            == STATUS_OFF) {
                        voicePoints.get(INDEX_SWERVE_FRONT).setPlayStatus(NavigationData.STATUS_READY);
                    }
                    return navigationData;
                }
                //沿路线行走
                else if (distanceX >= 1 && distanceX <= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone() - voicePoints.get(INDEX_SWERVE_FRONT).getFloorOffset()
                        && distanceY < voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()
                        && distanceY > 0) {
                    String navText = NAV_GO_ALONG;
                    int direction = DIRECTION_GO_ALONG;
                    //左右后方行走
                    if (navigationDatas.size() > 2) {
                        NavigationData navigationData2 = navigationDatas.get(2);
                        SAILS.GeoNode thirdGeoNode = navigationData2.getGeoNode();
                        double distanceZ = getDistance(mSails, secondGeoNode, thirdGeoNode);
                        if (navigationData.getNaviDirection() == navigationData1.getNaviDirection() &&
                                navigationData.getNaviDirection() == DIRECTION_LEFT && distanceZ >= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                            navText = getDistanceShow(distanceX) + "公尺後" + NAV_TURN_BEHIND_LEFT;
                            direction = DIRECTION_BEHIND_LEFT;
                        } else if (navigationData.getNaviDirection() == navigationData1.getNaviDirection() &&
                                navigationData.getNaviDirection() == DIRECTION_RIGHT && distanceZ >= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone()) {
                            navText = getDistanceShow(distanceX) + "公尺後" + NAV_TURN_BEHIND_RIGHT;
                            direction = DIRECTION_BEHIND_RIGHT;
                        }
                    }

                    navigationData.setNavigationText(navText);
                    navigationData.setNavigationVoiceText(navText);
                    navigationData.setVoicePointIndex(INDEX_SWERVE_FRONT);
                    navigationData.setNaviDirection(direction);
                    if (voicePoints.get(navigationData.getVoicePointIndex()).getPlayStatus()
                            == STATUS_OFF) {
                        voicePoints.get(INDEX_SWERVE_FRONT).setPlayStatus(NavigationData.STATUS_READY);
                    }
                    return navigationData;
                }
            }
            if (currentGeoNode.floornumber == nextGeoNode.floornumber) {
                //直行
                if ((voicePoints.get(INDEX_STRAIGHT).getPlayStatus()
                        == STATUS_OFF || voicePoints.get(INDEX_STRAIGHT).getPlayStatus()
                        == NavigationData.STATUS_FAILED) && distanceX >= voicePoints.get(INDEX_STRAIGHT).getMilestone()
                        - voicePoints.get(INDEX_STRAIGHT).getFloorOffset()) {
                    return getGoStraightData(distanceX, navigationData);
                }

                //继续直行
                if (distanceX >= voicePoints.get(INDEX_STRAIGHT4).getMilestone() + voicePoints.get(INDEX_STRAIGHT4).getCeilOffset()
                        && distanceX <= voicePoints.get(INDEX_STRAIGHT5).getMilestone() + voicePoints.get(INDEX_STRAIGHT5).getCeilOffset()) {

                    return getContinueGoStraightData(distanceX, navigationData, INDEX_STRAIGHT5);

                } else if (distanceX >= voicePoints.get(INDEX_STRAIGHT3).getMilestone() + voicePoints.get(INDEX_STRAIGHT3).getCeilOffset()
                        && distanceX <= voicePoints.get(INDEX_STRAIGHT4).getMilestone() + voicePoints.get(INDEX_STRAIGHT4).getCeilOffset()) {

                    return getContinueGoStraightData(distanceX, navigationData, INDEX_STRAIGHT4);

                } else if (distanceX >= voicePoints.get(INDEX_STRAIGHT2).getMilestone() + voicePoints.get(INDEX_STRAIGHT2).getCeilOffset()
                        && distanceX <= voicePoints.get(INDEX_STRAIGHT3).getMilestone() + voicePoints.get(INDEX_STRAIGHT3).getCeilOffset()) {

                    return getContinueGoStraightData(distanceX, navigationData, INDEX_STRAIGHT3);

                } else if (distanceX >= voicePoints.get(INDEX_STRAIGHT1).getMilestone() + voicePoints.get(INDEX_STRAIGHT1).getCeilOffset()
                        && distanceX <= voicePoints.get(INDEX_STRAIGHT2).getMilestone() + voicePoints.get(INDEX_STRAIGHT2).getCeilOffset()) {

                    return getContinueGoStraightData(distanceX, navigationData, INDEX_STRAIGHT2);

                } else if (distanceX >= voicePoints.get(INDEX_SWERVE_FRONT).getMilestone() + voicePoints.get(INDEX_SWERVE_FRONT).getCeilOffset()
                        && distanceX <= voicePoints.get(INDEX_STRAIGHT1).getMilestone() + voicePoints.get(INDEX_STRAIGHT1).getCeilOffset()) {

                    return getContinueGoStraightData(distanceX, navigationData, INDEX_STRAIGHT1);
                }
            }
        }
        return navigationData;

    }

    //请直行
    private NavigationData getGoStraightData(double distanceX, NavigationData navigationData) {
        List<NavigationData.VoicePoint> voicePoints = navigationData.getVoicePoints();
        navigationData.setNavigationText(NAV_GO_STRAIGHT + getDistanceShow(distanceX) + "公尺");
        navigationData.setNavigationVoiceText(NAV_GO_STRAIGHT);
        navigationData.setNaviDirection(DIRECTION_STRAIGHT);
        navigationData.setVoicePointIndex(INDEX_STRAIGHT);
        if ((voicePoints.get(INDEX_STRAIGHT).getPlayStatus() == STATUS_OFF
                || voicePoints.get(INDEX_STRAIGHT).getPlayStatus() == NavigationData.STATUS_FAILED)
                && distanceX >= voicePoints.get(INDEX_STRAIGHT).getMilestone() - voicePoints.get(INDEX_STRAIGHT).getFloorOffset()) {
            voicePoints.get(INDEX_STRAIGHT).setPlayStatus(NavigationData.STATUS_READY);
        }
        return navigationData;
    }

    private NavigationData getContinueGoStraightData(double distanceX, NavigationData navigationData, int index) {
        List<NavigationData.VoicePoint> voicePoints = navigationData.getVoicePoints();
        navigationData.setNavigationText(NAV_GO_STRAIGHT + getDistanceShow(distanceX) + "公尺");
        navigationData.setNavigationVoiceText(NAV_GO_STRAIGHT_CONTINUE);
        navigationData.setNaviDirection(DIRECTION_STRAIGHT);
        navigationData.setVoicePointIndex(index);
        if (voicePoints.get(navigationData.getVoicePointIndex()).getPlayStatus()
                == STATUS_OFF && distanceX >= voicePoints.get(index).getMilestone()
                - voicePoints.get(index).getFloorOffset()) {
            voicePoints.get(index).setPlayStatus(NavigationData.STATUS_READY);
        }
        return navigationData;
    }


    /**
     * 模拟导航功能需要生成路径上虚拟的点
     */
    public List<SAILS.GeoNode> productMockNodesForMultiFloor(SAILS mSails) {
        List<SAILS.GeoNode> mockNodes = new ArrayList<>();
        for (int n = 0; n < onPathAllPointsByFloorNumber.size(); n++) {
            List<SAILS.GeoNode> list = onPathAllPointsByFloorNumber.get(n);
            if (list == null) {
                return null;
            }
            int size = list.size();
            if (size == 1) {
                SAILS.GeoNode geoNode = new SAILS.GeoNode(list.get(0).longitude, list.get(0).latitude);
                geoNode.floornumber = list.get(0).floornumber;
                geoNode.floorname = list.get(0).floorname;
                mockNodes.add(geoNode);
                continue;
            }
            for (int i = 0; i < size - 1; i = i + 1) {
                double x0 = list.get(i).longitude;
                double y0 = list.get(i).latitude;
                double x1 = list.get(i + 1).longitude;
                double y1 = list.get(i + 1).latitude;
                double distance = mSails.getMapDistanceByLngLat(x0, y0, x1, y1);
                int equalTotal = (int) (distance * 10);
                for (int j = 0; j < equalTotal; j++) {
                    if (equalTotal == 1) {
                        SAILS.GeoNode geoNode = new SAILS.GeoNode(x0, y0);
                        geoNode.floornumber = list.get(i).floornumber;
                        geoNode.floorname = list.get(i).floorname;
                        mockNodes.add(geoNode);
                        break;
                    }
                    double stepX = (x1 - x0) / (equalTotal - 1);
                    double stepY = (y1 - y0) / (equalTotal - 1);
                    double x = x0 + stepX * j;
                    double y = y0 + stepY * j;
                    SAILS.GeoNode geoNode = new SAILS.GeoNode(x, y);
                    geoNode.floornumber = list.get(i).floornumber;
                    geoNode.floorname = list.get(i).floorname;

                    mockNodes.add(geoNode);
                }
            }
        }

        //添加模拟点位
//        for (int i = 0; i < mockNodes.size(); i++) {
//            SAILS.GeoNode geoNode2 = mockNodes.get(i);
//            Random random1 = new Random();
//            java.text.NumberFormat nf = java.text.NumberFormat.getInstance();
//            nf.setMaximumFractionDigits(20);
//            nf.setGroupingUsed(false);
//            String formatLatitude = nf.format(geoNode2.latitude + ((double) ((random1.nextInt(100)-50)) / 10000000.0));
//            String formatLong = nf.format(geoNode2.longitude + ((double) ((random1.nextInt(100)-50)) / 100000000.0));
//            L.e("ddd", "randomLong:" + formatLatitude + "," + "randomLatitude" + formatLong + "");
//            SAILS.GeoNode geoNode = new SAILS.GeoNode( parseDouble(formatLong),parseDouble(formatLatitude));
//            geoNode.floornumber = geoNode2.floornumber;
//            geoNode.floorname = geoNode2.floorname;
//            LocationRegion belongsRegion = geoNode2.BelongsRegion;
//            if (belongsRegion != null){
//                geoNode.BelongsRegion = geoNode2.BelongsRegion;
//            }
//            mockNodes.set(i,geoNode);
//        }
        return mockNodes;

    }


    /**
     * 将距离小于2米的点合并，目前改方法未启用
     *
     * @param geoNodeList
     */
    private synchronized void removeSimilarPoints(SAILS sails, List<SAILS.GeoNode> geoNodeList) {
        if (geoNodeList == null) {
            return;
        }
        for (int i = 0; i < geoNodeList.size() - 1; i++) {
            SAILS.GeoNode geoNode = geoNodeList.get(i);
            SAILS.GeoNode nextGeoNode = geoNodeList.get(i + 1);
            double distance = getDistance(sails, geoNode, nextGeoNode);
            if (distance < IpsConstants.SIMILAR_POINTS_RADIUS && geoNode.floornumber == nextGeoNode.floornumber) {
                LocationRegion belongsRegion = nextGeoNode.BelongsRegion;
                if (belongsRegion != null) {
                    if (belongsRegion.self != 0) {
                        continue;
                    }
                }
                geoNodeList.remove(i + 1);
                i = -1;
            }
        }

    }

    private double getDegreeDiff(SAILS.GeoNode geoNode1, SAILS.GeoNode geoNode2, SAILS.GeoNode geoNode3) {
        double bearAngle0 = SAILS.GetBearDegree(geoNode1.longitude, geoNode1.latitude, geoNode2.longitude, geoNode2.latitude);
        double bearAngle1 = SAILS.GetBearDegree(geoNode2.longitude, geoNode2.latitude, geoNode3.longitude, geoNode3.latitude);
        double bearDiff = bearAngle1 - bearAngle0;
        if (bearDiff < 0) {
            bearDiff += 360;
        }
        return bearDiff;
    }

    private void removePreFirstPoint(double distanceX) {
        //去除第一个毛刺点
        if (navigationDatas.size() > 0 && preFirstNavigationData == null && distanceX < IpsConstants.NAV_ACCURACY_FIRST) {
            navigationDatas.remove(0);
        }
        if (navigationDatas.size() > 1 && preFirstNavigationData != null &&
                preFirstNavigationData.getGeoNode().floornumber == navigationDatas.get(1).getGeoNode().floornumber
                && preFirstNavigationData.getGeoNode().latitude == navigationDatas.get(1).getGeoNode().latitude
                && preFirstNavigationData.getGeoNode().longitude == navigationDatas.get(1).getGeoNode().longitude
                && distanceX <= NAV_ACCURACY) {
            navigationDatas.remove(0);
        }
        if (navigationDatas.size() > 0) {
            preFirstNavigationData = navigationDatas.get(0);
        }
    }


    public double getCurrentFloorDistance(SAILS sails, SAILS.GeoNode node) {
        double distance = 0;
        if (navigationDatas.size() > 0 && node != null) {
            SAILS.GeoNode geoNodeFirst = navigationDatas.get(0).getGeoNode();
            distance = distance + getDistance(sails, node, geoNodeFirst);
        }
        for (int k = 0; k < navigationDatas.size() - 1; k++) {
            SAILS.GeoNode geoNode = navigationDatas.get(k).getGeoNode();
            SAILS.GeoNode geoNode1 = navigationDatas.get(k + 1).getGeoNode();
            if (geoNode.floornumber == geoNode1.floornumber) {
                distance = distance + getDistance(sails, geoNode, geoNode1);
            } else {
                return distance;
            }
        }
        return distance;
    }

    public int getCurrentFloorLastSelf(int floornumber) {
        for (int k = 0; k < navigationDatas.size(); k++) {
            SAILS.GeoNode geoNode = navigationDatas.get(k).getGeoNode();
            if (geoNode.floornumber == floornumber && navigationDatas.get(k).getSelf() != 0) {
                currentFloorLastSelf = navigationDatas.get(k).getSelf();
                break;
            }
        }
        return currentFloorLastSelf;
    }

    public boolean isCurrentFloorHasRoutePath(int floornumber) {
        boolean hasRoute = false;
        for (int i = 0; i < navigationDatas.size(); i++) {
            if (floornumber == navigationDatas.get(i).getGeoNode().floornumber) {
                hasRoute = true;
                break;
            }
        }
        return hasRoute;
    }

    private String getDirection(int direction) {
        String result = "";
        switch (direction) {
            case DIRECTION_LEFT:
                result = NAV_TURN_LEFT;
                break;
            case DIRECTION_RIGHT:
                result = NAV_TURN_RIGHT;
                break;
            case DIRECTION_STRAIGHT_LEFT:
                result = NAV_TURN_STRAIGHT_LEFT;
                break;
            case DIRECTION_STRAIGHT_RIGHT:
                result = NAV_TURN_STRAIGHT_RIGHT;
                break;
            case DIRECTION_DOWNSTAIRS:
                result = NAV_PLEASE_DOWNSTAIRS;
                break;
            case DIRECTION_UPSTAIRS:
                result = NAV_PLEASE_UPSTAIRS;
                break;
            case DIRECTION_BEHIND_LEFT:
                result = NAV_TURN_BEHIND_LEFT;
                break;
            case DIRECTION_BEHIND_RIGHT:
                result = NAV_TURN_BEHIND_RIGHT;
                break;
            case DIRECTION_STRAIGHT:
                result = NAV_GO_STRAIGHT;
                break;
            default:
                result = NAV_GO_ALONG;
                break;
        }
        return result;
    }

    private int getDistanceShow(double distance) {
        int result = 1;
        if ((int) (Math.floor(distance)) > 0) {
            result = (int) (Math.floor(distance));
        }
        return result;
    }

    private double getDistance(SAILS sails, SAILS.GeoNode geoNode1, SAILS.GeoNode geoNode2) {
        try{
            mapDistanceByLngLat = sails.getMapDistanceByLngLat(geoNode1.longitude, geoNode1.latitude, geoNode2.longitude, geoNode2.latitude);
            return mapDistanceByLngLat;
        }catch (Exception e){
            return mapDistanceByLngLat;
        }

    }

}