package com.locnavi.map.utils;

import android.content.Context;
import android.speech.tts.TextToSpeech;
import android.text.TextUtils;

import com.locnavi.location.xunjimap.utils.IpsConstants;
import com.locnavi.location.xunjimap.utils.L;

import java.util.Locale;

/**
 * Created by liberty on 2017/7/19.
 */

public class VoiceManager2 {

    private static volatile VoiceManager2 instance;
    private long lastTimeStamp = 0;
    private Context context;
    private TextToSpeech mSpeech;

    public static VoiceManager2 getInstance(Context context) {
        if (instance == null) {
            synchronized (VoiceManager2.class) {
                if (instance == null) {
                    instance = new VoiceManager2(context);
                }
            }
        }
        return instance;
    }

    public VoiceManager2(Context context) {
        this.context = context;
        if (mSpeech != null) {
            mSpeech.stop();
            mSpeech.shutdown();
            mSpeech = null;
        }
        // 创建TTS对象
        mSpeech = new TextToSpeech(context, new TTSListener());
        mSpeech.setPitch(1f);
        // 设置语速
        mSpeech.setSpeechRate(0.9f);
    }

    public void destroy() {
        if (mSpeech != null) {
            mSpeech.stop();
            mSpeech.shutdown();
            mSpeech = null;
        }
        instance = null;
    }

    public boolean textToVoice(String s, boolean isForcePlay) {
        if (isForcePlay){
            tts(s);
        }else{
            if (System.currentTimeMillis() - lastTimeStamp > IpsConstants.VOICE_TIMER_STEP){
                tts(s);
            }
        }
        lastTimeStamp = System.currentTimeMillis();
        return true;
    }

    public boolean textToVoiceFloor(String s, boolean isForcePlay) {
        if (!TextUtils.isEmpty(s)) {
            s = s.replace("-", "负");
        }
        if (isForcePlay){
            tts(s);
        }else{
            if (System.currentTimeMillis() - lastTimeStamp > IpsConstants.VOICE_TIMER_STEP){
                tts(s);
            }
        }
        return true;
    }

    private final class TTSListener implements TextToSpeech.OnInitListener {
        @Override
        public void onInit(int status) {
            L.e("初始化结果：",  (status == TextToSpeech.SUCCESS) + "");
            int result = mSpeech.setLanguage(Locale.TAIWAN);
            //如果返回值为-2，说明不支持这种语言
            L.e("是否支持该语言：",  (result != TextToSpeech.LANG_NOT_SUPPORTED) + "");
        }
    }

    private boolean tts(String s){
        try {
            mSpeech.speak(s, TextToSpeech.QUEUE_FLUSH, null);
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
        return true;
    }

}
