package com.locnavi.map.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;

import com.locnavi.location.xunjimap.model.bean.DataHolder;
import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionIconData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionTagData;
import com.locnavi.location.xunjimap.utils.KeyboardUtils;
import com.locnavi.location.xunjimap.utils.MixpanelConstants;
import com.locnavi.location.xunjimap.utils.MixpanelEvent;
import com.locnavi.location.xunjimap.utils.SpUtils;
import com.locnavi.location.xunjimap.utils.T;
import com.locnavi.map.R;
import com.locnavi.map.base.BasePresenterFragment;
import com.locnavi.map.presenter.IView.IpsMapSearchView;
import com.locnavi.map.presenter.IpsMapSearchPresenter;
import com.locnavi.map.ui.activity.XJMapActivity;
import com.locnavi.map.ui.adapter.BaseRecyclerAdapter;
import com.locnavi.map.ui.item.SearchHistoryDataItem;
import com.locnavi.map.ui.widget.TagContainerLayout;
import com.locnavi.map.ui.widget.TagView;
//import com.locnavi.map.R;
//import com.xunji.xunjimap.base.BasePresenterFragment;
//
//import com.xunji.xunjimap.presenter.IView.IpsMapSearchView;
//import com.xunji.xunjimap.presenter.IpsMapSearchPresenter;
//import com.xunji.xunjimap.ui.activity.XJMapActivity;
//import com.xunji.xunjimap.ui.adapter.BaseRecyclerAdapter;
//import com.xunji.xunjimap.ui.item.SearchHistoryDataItem;
//import com.xunji.xunjimap.ui.widget.TagContainerLayout;
//import com.xunji.xunjimap.ui.widget.TagView;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

import static com.locnavi.map.ui.activity.XJSearchActivity.REQUEST_ID;
import static com.locnavi.map.ui.activity.XJSearchActivity.REQUEST_TYPE;

//import static com.xunji.xunjimap.ui.activity.XJSearchActivity.REQUEST_ID;
//import static com.xunji.xunjimap.ui.activity.XJSearchActivity.REQUEST_TYPE;

/**
 * author:chen
 * time:2017/5/25
 * desc:
 */
public class XJSearchHistoryFragment extends BasePresenterFragment<IpsMapSearchPresenter> implements View.OnClickListener,
        IpsMapSearchView {

    private TagContainerLayout tagContainerLayout;
    private RecyclerView recyclerView;
    private BaseRecyclerAdapter adapter;
    private List<String> list;
    private ArrayList<LocationRegionData> locationRegionDatas;
    private List<LocationRegionIconData> locationRegionIconDatas;
    private String id, type;

    public static XJSearchHistoryFragment getInstance(String id, String type) {
        XJSearchHistoryFragment fragment = new XJSearchHistoryFragment();
        Bundle bundle = new Bundle();
        bundle.putString(REQUEST_ID, id);
        bundle.putString(REQUEST_TYPE, type);
//        bundle.putParcelableArrayList(REQUEST_REGIONS, locationRegionDatas);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ipsmap_fragment_search_history;
    }

    @Override
    protected void initView(Bundle saveInstanceState) {
        tagContainerLayout = (TagContainerLayout) view.findViewById(R.id.tagcontainerLayout);
        recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
        view.findViewById(R.id.tv_clear).setOnClickListener(this);
        recyclerView.setLayoutManager(new LinearLayoutManager(context));
        id = getArguments().getString(REQUEST_ID);
        type = getArguments().getString(REQUEST_TYPE);
//        locationRegionDatas = getArguments().getParcelableArrayList(REQUEST_REGIONS);
        locationRegionDatas = DataHolder.getInstance().getLocationRegions();
        tagContainerLayout.setOnTagClickListener(new TagView.OnTagClickListener() {
            @Override
            public void onTagClick(int position, String text) {
                if (locationRegionDatas != null && locationRegionDatas.size() > 0) {
                    presenter.queryByGenre(id, locationRegionIconDatas.get(position), locationRegionDatas);
                }
            }

            @Override
            public void onTagLongClick(int position, String text) {

            }

            @Override
            public void onTagCrossClick(int position) {

            }
        });
    }

    @Override
    protected void initData() {
        locationRegionIconDatas = new ArrayList<>();
        list = new ArrayList<>();
        adapter = new BaseRecyclerAdapter(list);
        SearchHistoryDataItem item = new SearchHistoryDataItem(context);
        item.setOnItemClickListener(position -> {
            if (list.size() > 0) {
                presenter.queryByContent(id, list.get(position), MixpanelConstants.SEARCH_FROM_SEARCH_HISTORY, locationRegionDatas);
            }
        });
        item.setOnDeleteClickListener(position -> {
            if (list.size() > 0) {
                list.remove(position);
                adapter.notifyItemRemoved(position);
                SpUtils.setSearchHistory(context, list.toString());
            }
        });
        adapter.addItemFactory(item);
        recyclerView.setAdapter(adapter);
        presenter.queryHotGenre(id);
        loadHistory();
    }

    @Override
    protected void lazyLoad() {

    }

    public void loadHistory() {
        list.clear();
        String json = SpUtils.getSearchHistoryJson(context);
        if (!TextUtils.isEmpty(json)) {
            try {
                JSONArray jsonArray = new JSONArray(json);
                for (int i = 0; i < jsonArray.length(); i++) {
                    String content = jsonArray.optString(i);
                    list.add(content);
                }
                adapter.notifyDataSetChanged();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.tv_clear) {
            list.clear();
            adapter.notifyDataSetChanged();
            SpUtils.clearSearchHistory(context);
        }
    }

    @Override
    public void queryByContentSuccess(String content, String from, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(content, searchRegionDatas.size(), from);
        if (searchRegionDatas.size() == 0) {
            T.showShort(getString(R.string.ipsmap_no_search_result, content));
        } else {
            KeyboardUtils.hideKeyboard(activity);
            Intent intent = new Intent();
            intent.putExtra(XJMapActivity.RESULT_SEARCH_CONTENT, content);
            intent.putExtra(XJMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            new Handler().postDelayed(() -> {
                activity.finish();
            }, 500);
        }
    }

    @Override
    public void queryByGenreSuccess(LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(locationRegionIconData.getName(), searchRegionDatas.size(), MixpanelConstants.SEARCH_FROM_SEARCH_HOT);
        if (searchRegionDatas.size() == 0) {
            T.showShort(R.string.ipsmap_no_result);
        } else {
            KeyboardUtils.hideKeyboard(activity);
            Intent intent = new Intent();
            intent.putExtra(XJMapActivity.RESULT_SEARCH_CONTENT, locationRegionIconData.getName());
            intent.putExtra(XJMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            new Handler().postDelayed(() -> {
                activity.finish();
            }, 500);
        }
    }

    @Override
    public void queryRegionIconDataSuccess(List<LocationRegionIconData> locationRegionIconDatas) {

    }

    @Override
    public void queryRegionTagDataSuccess(List<LocationRegionTagData> locationRegionTagDatas) {

    }

    @Override
    public void queryHotGenreSuccess(List<String> tags, List<LocationRegionIconData> locationRegionIconDatas) {
        this.locationRegionIconDatas = locationRegionIconDatas;
        tagContainerLayout.setTags(tags);
    }
}
