package com.locnavi.map.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.map.R;
//import com.locnavi.map.R;RΩ


import java.util.ArrayList;

public class NavFinishBottomDialog implements View.OnClickListener, CompoundButton.OnCheckedChangeListener {

    private final TextView tvUpload;
    private final ImageView ivClose;
    private Dialog dialog;
    private View contentView;
    private Context context;
    private XJRatingBar rcRate;
    private CheckBox checkBox1;
    private CheckBox checkBox2;
    private CheckBox checkBox3;
    private CheckBox checkBox4;
    private EditText tvContent;
    private ArrayList comments;
    private int score;


    public NavFinishBottomDialog(Context context,
                                 View.OnClickListener close, View.OnClickListener save) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_finish_bottom, null);
        checkBox1 = (CheckBox) contentView.findViewById(R.id.cv_checkBox1);
        checkBox1.setOnCheckedChangeListener(this);
        checkBox2 = (CheckBox) contentView.findViewById(R.id.cv_checkBox2);
        checkBox2.setOnCheckedChangeListener(this);
        checkBox3 = (CheckBox) contentView.findViewById(R.id.cv_checkBox3);
        checkBox3.setOnCheckedChangeListener(this);
        checkBox4 = (CheckBox) contentView.findViewById(R.id.cv_checkBox4);
        checkBox4.setOnCheckedChangeListener(this);
        tvContent = (EditText) contentView.findViewById(R.id.tv_content);
        tvUpload = (TextView) contentView.findViewById(R.id.tv_upload);
        tvUpload.setOnClickListener(save);
        ivClose = (ImageView) contentView.findViewById(R.id.iv_close);
        ivClose.setOnClickListener(close);
        rcRate = (XJRatingBar) contentView.findViewById(R.id.rc_rate);
        rcRate.setOnRatingChangeListener(countSelected -> {
            score = (int) Math.ceil(countSelected);
            L.e("ddd", "score+" + score);
            rcRate.setCountSelected(score);
        });
        comments = new ArrayList<String>();
        dialog = new Dialog(context, R.style.IpsmapDialogCommon);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.BOTTOM);
        dialog.setCancelable(false);
    }

    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            rcRate.setCountSelected(0);
            checkBox1.setChecked(false);
            checkBox2.setChecked(false);
            checkBox3.setChecked(false);
            checkBox4.setChecked(false);
            tvContent.setText("");
            dialog.dismiss();
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.cv_checkBox1) {

            if (checkBox1.isSelected()) {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                if (!comments.contains(context.getString(R.string.ipsmap_comment1))) {
                    comments.add(context.getString(R.string.ipsmap_comment1));
                }
            } else {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment1));
            }

        } else if (v.getId() == R.id.cv_checkBox2) {

            if (checkBox2.isSelected()) {
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                if (!comments.contains(context.getString(R.string.ipsmap_comment2))) {
                    comments.add(context.getString(R.string.ipsmap_comment2));
                }


            } else {
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment2));

            }
        } else if (v.getId() == R.id.cv_checkBox3) {

            if (checkBox3.isSelected()) {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                if (!comments.contains(context.getString(R.string.ipsmap_comment3))) {
                    comments.add(context.getString(R.string.ipsmap_comment3));
                }


            } else {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment3));

            }

        } else if (v.getId() == R.id.cv_checkBox4) {

            if (checkBox4.isSelected()) {
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                if (!comments.contains(context.getString(R.string.ipsmap_comment4))) {
                    comments.add(context.getString(R.string.ipsmap_comment4));
                }
            } else {
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment4));
            }
        }

    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (buttonView.getId() == R.id.cv_checkBox1) {

            if (isChecked) {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                comments.add(context.getString(R.string.ipsmap_comment1));
            } else {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment1));
            }

        } else if (buttonView.getId() == R.id.cv_checkBox2) {

            if (isChecked) {
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                comments.add(context.getString(R.string.ipsmap_comment2));
            } else {
                comments.remove(context.getString(R.string.ipsmap_comment2));
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
            }
        } else if (buttonView.getId() == R.id.cv_checkBox3) {

            if (isChecked) {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                comments.add(context.getString(R.string.ipsmap_comment3));
            } else {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment3));
            }

        } else if (buttonView.getId() == R.id.cv_checkBox4) {

            if (isChecked) {
                comments.add(context.getString(R.string.ipsmap_comment4));
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
            } else {
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment4));
            }

        }
    }

    public ArrayList getComments() {
        return comments;
    }

    public String getContent() {
        return tvContent.getText().toString();
    }

    public int getScore() {
        return score;
    }
}
