package com.locnavi.map.ui.item;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;


import com.bumptech.glide.Glide;
import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionTagData;
import com.locnavi.map.R;
import com.locnavi.map.ui.widget.TagContainerLayout;
import com.locnavi.map.ui.widget.TagView;
//import com.locnavi.map.R;
//
//import com.xunji.xunjimap.ui.widget.TagContainerLayout;
//import com.xunji.xunjimap.ui.widget.TagView;

import java.util.ArrayList;
import java.util.List;


public class RegionTagDataItem extends BaseRecyclerItemFactory<RegionTagDataItem.LocationRegionTypeDataRecyclerItem> {

    Context context;
    OnItemClickListener onItemClickListener;


    public RegionTagDataItem(Context context, OnItemClickListener onItemClickListener) {
        this.context = context;
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionTagData;
    }

    @Override
    public LocationRegionTypeDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionTypeDataRecyclerItem(parent, this);
    }


    public class LocationRegionTypeDataRecyclerItem extends BaseRecyclerItem<LocationRegionTagData, RegionTagDataItem> {

        private TextView tvType;
        private ImageView ivType;
        private TagContainerLayout tagContainerLayout;

        protected LocationRegionTypeDataRecyclerItem(ViewGroup parent, RegionTagDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_region_tag, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvType = (TextView) convertView.findViewById(R.id.tv_type);
            ivType = (ImageView) convertView.findViewById(R.id.iv_type);
            tagContainerLayout = (TagContainerLayout) convertView.findViewById(R.id.tagcontainerLayout);

        }

        @Override
        protected void onConfigViews(final Context context) {
            if (onItemClickListener != null) {


                tagContainerLayout.setOnTagClickListener(new TagView.OnTagClickListener() {
                    @Override
                    public void onTagClick(int position, String text) {
                        onItemClickListener.onClick(getData().getLocationRegionDatas().get(position));
                    }

                    @Override
                    public void onTagLongClick(int position, String text) {
                        onItemClickListener.onClick(getData().getLocationRegionDatas().get(position));
                    }

                    @Override
                    public void onTagCrossClick(int position) {

                    }
                });
            }
        }

        @Override
        protected void onSetData(int position, LocationRegionTagData item) {

            tvType.setText(item.getName());
            Glide.with(context)
                    .load(item.getIconUrl())
                    .crossFade()
                    // .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                    .into(ivType);
            List<String> tags = new ArrayList<>();
            for (LocationRegionData regionData : item.getLocationRegionDatas()) {
                tags.add(regionData.getName());
            }

            tagContainerLayout.setTags(tags);
        }

    }

    public interface OnItemClickListener {
        void onClick(LocationRegionData item);
    }

}
