package com.locnavi.map.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;

import com.locnavi.location.xunjimap.model.bean.DataHolder;
import com.locnavi.location.xunjimap.model.bean.LocationRegionData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionIconData;
import com.locnavi.location.xunjimap.model.bean.LocationRegionTagData;
import com.locnavi.location.xunjimap.utils.IpsException;
import com.locnavi.location.xunjimap.utils.MixpanelConstants;
import com.locnavi.location.xunjimap.utils.MixpanelEvent;
import com.locnavi.location.xunjimap.utils.T;
import com.locnavi.map.R;
import com.locnavi.map.base.BasePresenterFragment;
import com.locnavi.map.presenter.IView.IpsMapSearchView;
import com.locnavi.map.presenter.IpsMapSearchPresenter;
import com.locnavi.map.ui.activity.XJMapActivity;
import com.locnavi.map.ui.adapter.BaseRecyclerAdapter;
import com.locnavi.map.ui.adapter.RecyclerviewPagerAdapter;
import com.locnavi.map.ui.item.RegionTagDataItem;
import com.locnavi.map.ui.widget.WrapContentViewPager;
//import com.locnavi.map.R;
//import com.xunji.xunjimap.base.BasePresenterFragment;
//
//import com.xunji.xunjimap.presenter.IView.IpsMapSearchView;
//import com.xunji.xunjimap.presenter.IpsMapSearchPresenter;
//import com.xunji.xunjimap.ui.activity.XJMapActivity;
//import com.xunji.xunjimap.ui.adapter.BaseRecyclerAdapter;
//import com.xunji.xunjimap.ui.adapter.RecyclerviewPagerAdapter;
//import com.xunji.xunjimap.ui.item.RegionTagDataItem;
//import com.xunji.xunjimap.ui.widget.WrapContentViewPager;


import java.util.ArrayList;
import java.util.List;

import static com.locnavi.map.ui.activity.XJSearchActivity.REQUEST_ID;
import static com.locnavi.map.ui.activity.XJSearchActivity.REQUEST_TYPE;
import static com.locnavi.map.ui.activity.XJSearchActivity.REQUEST_TYPE_TARGET;

//import static com.xunji.xunjimap.ui.activity.XJSearchActivity.REQUEST_ID;
//import static com.xunji.xunjimap.ui.activity.XJSearchActivity.REQUEST_TYPE;
//import static com.xunji.xunjimap.ui.activity.XJSearchActivity.REQUEST_TYPE_TARGET;

/**
 * author:chen
 * time:2017/5/25
 * desc:
 */
public class XJSearchGenreFragment extends BasePresenterFragment<IpsMapSearchPresenter> implements
        SwipeRefreshLayout.OnRefreshListener, View.OnClickListener, IpsMapSearchView {

    private LinearLayout llMyLoc;
    private LinearLayout indicators;
    private SwipeRefreshLayout swipeRefreshLayout;
    private WrapContentViewPager viewPager;
    private RecyclerView recyclerView;
    private LinearLayout llGenre;
    private ArrayList<LocationRegionData> locationRegionDatas;
    private List<LocationRegionIconData> locationRegionIconDatas;
    private List<LocationRegionTagData> locationRegionTagDatas;
    private RecyclerviewPagerAdapter adapter0;
    private BaseRecyclerAdapter adapter;
    private String id, type;

    public static XJSearchGenreFragment getInstance(String id, String type) {
        XJSearchGenreFragment fragment = new XJSearchGenreFragment();
        Bundle bundle = new Bundle();
        bundle.putString(REQUEST_ID, id);
        bundle.putString(REQUEST_TYPE, type);
//        bundle.putParcelableArrayList(REQUEST_REGIONS, locationRegionDatas);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ipsmap_fragment_search_genre;
    }

    @Override
    protected void initView(Bundle saveInstanceState) {
        llMyLoc = (LinearLayout) view.findViewById(R.id.ll_my_loc);
        indicators = (LinearLayout) view.findViewById(R.id.indicators);
        swipeRefreshLayout = (SwipeRefreshLayout) view.findViewById(R.id.swipe_layout);
        viewPager = (WrapContentViewPager) view.findViewById(R.id.viewPager);
        recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
        llGenre = (LinearLayout) view.findViewById(R.id.ll_genre);
        llMyLoc.setOnClickListener(this);

        recyclerView.setLayoutManager(new LinearLayoutManager(context));
        swipeRefreshLayout.setColorSchemeResources(R.color.ipsmap_colorAccent);
        swipeRefreshLayout.setProgressViewOffset(false, -20, 150);
        swipeRefreshLayout.setOnRefreshListener(this);

        id = getArguments().getString(REQUEST_ID);
        type = getArguments().getString(REQUEST_TYPE);
//        locationRegionDatas = getArguments().getParcelableArrayList(REQUEST_REGIONS);
        locationRegionDatas = DataHolder.getInstance().getLocationRegions();
        if (locationRegionDatas == null){
            T.showShort(getString(R.string.ipsmap_get_locationdates_error));
            return;
        }

        if (type.equals(REQUEST_TYPE_TARGET)) {
            llMyLoc.setVisibility(View.GONE);
        } else {
            llMyLoc.setVisibility(View.VISIBLE);
        }
    }

    @Override
    protected void initData() {
        locationRegionIconDatas = new ArrayList<>();
        adapter0 = new RecyclerviewPagerAdapter(context);
        adapter0.setDatas(locationRegionIconDatas, indicators);
        adapter0.setOnRegionIconDataClickListener(locationRegionIconData -> {
            presenter.queryByGenre(id, locationRegionIconData, locationRegionDatas);
        });
        viewPager.setAdapter(adapter0);
        viewPager.addOnPageChangeListener(adapter0);

        locationRegionTagDatas = new ArrayList<>();
        adapter = new BaseRecyclerAdapter(locationRegionTagDatas);
        RegionTagDataItem regionTagDataItem = new RegionTagDataItem(context, item -> {
            MixpanelEvent.search(item.getName(), 1, MixpanelConstants.SEARCH_FROM_SEARCH_POI);
            Intent intent = new Intent();
            intent.putExtra(XJMapActivity.RESULT_SELECT_REGION, item);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            activity.finish();
        });
        adapter.addItemFactory(regionTagDataItem);
        recyclerView.setAdapter(adapter);
        onRefresh();
    }

    @Override
    protected void lazyLoad() {

    }

    public void onClick(View v) {
        if (v.getId() == R.id.ll_my_loc) {
            Intent intent = new Intent();
            intent.putExtra(REQUEST_TYPE, XJMapActivity.RESULT_SELECT_MY_LOCATION);
            activity.setResult(activity.RESULT_OK, intent);
            activity.finish();
        }
    }

    @Override
    public void onRefresh() {
        swipeRefreshLayout.setRefreshing(true);
        presenter.querySearchViewData(id);
    }

    @Override
    public void queryByContentSuccess(String content, String from, ArrayList<LocationRegionData> list) {

    }

    @Override
    public void queryByGenreSuccess(LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(locationRegionIconData.getName(), searchRegionDatas.size(), MixpanelConstants.SEARCH_FROM_SEARCH_GENRE);
        if (searchRegionDatas.size() == 0) {
            T.showShort(R.string.ipsmap_no_result);
        } else {
            Intent intent = new Intent();
            intent.putExtra(XJMapActivity.RESULT_SEARCH_CONTENT, locationRegionIconData.getName());
            intent.putExtra(XJMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            activity.finish();
        }
    }

    @Override
    public void queryRegionIconDataSuccess(List<LocationRegionIconData> locationRegionIconDatas0) {
        locationRegionIconDatas.clear();
        locationRegionIconDatas.addAll(locationRegionIconDatas0);
        if (locationRegionIconDatas.isEmpty()) {
            llGenre.setVisibility(View.GONE);
        } else {
            llGenre.setVisibility(View.VISIBLE);
        }
        adapter0.notifyDataSetChanged();
        viewPager.setCurrentItem(0);
    }

    @Override
    public void queryRegionTagDataSuccess(List<LocationRegionTagData> locationRegionTagDatas0) {
        swipeRefreshLayout.setRefreshing(false);
        locationRegionTagDatas.clear();
        locationRegionTagDatas.addAll(locationRegionTagDatas0);
        adapter.notifyDataSetChanged();
    }

    @Override
    public void queryHotGenreSuccess(List<String> tags, List<LocationRegionIconData> locationRegionIconDatas) {

    }

    @Override
    public void handleThrowable(IpsException ex) {
        super.handleThrowable(ex);
        swipeRefreshLayout.setRefreshing(false);
    }
}
