package com.locnavi.map.ui.widget;

import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.map.R;

import com.locnavi.map.XJMapSDK;
import com.sails.engine.LocationRegion;
import com.sails.engine.PathRoutingManager;


/**
 * Created by Chen on 2016/4/7.
 */
public class NavPreBottomDialog {

    private PopupWindow popupWindow;
    private View contentView;
    private LinearLayout llMultiFloor;
    private LinearLayout llEscalator;
    private LinearLayout llElevator;
    private LinearLayout llStair;
    private TextView tvStart, tvTarget;
    private TextView tvStartFloor, tvTargetFloor;
    private TextView tvStartBuilding, tvTargetBuilding;
    private TextView tvNavigation;
    private TextView tvEscalator;
    private TextView tvElevator;
    private TextView tvStair;
    private ImageView ivEscalator;
    private ImageView ivElevator;
    private ImageView ivStair;
    private Context context;
    private boolean isMultiFloor = false;

    public NavPreBottomDialog(Context context, OnNavBtnClickListener onNavBtnClickListener,
                              OnFloorModeSelectListener onFloorModeSelectListener, OnLocationClickListener onLocationClickListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_pre_bottom, null);
        contentView.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
        llMultiFloor = (LinearLayout) contentView.findViewById(R.id.ll_multi_floor);
        llEscalator = (LinearLayout) contentView.findViewById(R.id.ll_escalator);
        llElevator = (LinearLayout) contentView.findViewById(R.id.ll_elevator);
        llStair = (LinearLayout) contentView.findViewById(R.id.ll_stair);
        tvStart = (TextView) contentView.findViewById(R.id.tv_start_name);
        tvStartFloor = (TextView) contentView.findViewById(R.id.tv_start_floor);
        tvStartBuilding = (TextView) contentView.findViewById(R.id.tv_start_building);
        tvTarget = (TextView) contentView.findViewById(R.id.tv_target_name);
        tvTargetFloor = (TextView) contentView.findViewById(R.id.tv_target_floor);
        tvTargetBuilding = (TextView) contentView.findViewById(R.id.tv_target_building);
        tvNavigation = (TextView) contentView.findViewById(R.id.tv_navigation);
        tvElevator = (TextView) contentView.findViewById(R.id.tv_elevator);
        tvEscalator = (TextView) contentView.findViewById(R.id.tv_escalator);
        tvStair = (TextView) contentView.findViewById(R.id.tv_stair);
        ivElevator = (ImageView) contentView.findViewById(R.id.iv_elevator);
        ivEscalator = (ImageView) contentView.findViewById(R.id.iv_escalator);
        ivStair = (ImageView) contentView.findViewById(R.id.iv_stair);
        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 32),
                LinearLayout.LayoutParams.WRAP_CONTENT, false);
        contentView.findViewById(R.id.rl_start)
                .setOnClickListener(v -> onLocationClickListener.onStartClick());
        contentView.findViewById(R.id.rl_target)
                .setOnClickListener(v -> onLocationClickListener.onTargetClick());
        contentView.findViewById(R.id.tv_navigation)
                .setOnClickListener(v -> onNavBtnClickListener.onNavStart());
        contentView.findViewById(R.id.tv_simulation)
                .setOnClickListener(v -> onNavBtnClickListener.onSimStart());
        llElevator.setOnClickListener(v -> {
            changeFloorMode(PathRoutingManager.ELEVATOR_FIRST);
            onFloorModeSelectListener.elevatorMode();
        });
        llEscalator.setOnClickListener(v -> {
            changeFloorMode(PathRoutingManager.ESCALATOR_FIRST);
            onFloorModeSelectListener.escalatorMode();
        });
        llStair.setOnClickListener(v -> {
            changeFloorMode(PathRoutingManager.STAIR_FIRST);
            onFloorModeSelectListener.stairMode();
        });
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
    }

    public int getHeight() {
        int height = DensityUtils.dp2px(context, 190);
        if (isMultiFloor) {
            height += DensityUtils.dp2px(context, 60);
        }
        return height;
    }

    public void setBtnNavEnable(boolean enable) {
        tvNavigation.setEnabled(enable);
    }


    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public boolean isShowing(){
        return popupWindow.isShowing();
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            tvStart.setText(R.string.ipsmap_choice_begine);
            setMultiFloor(false);
            setBtnNavEnable(false);
            changeFloorMode(PathRoutingManager.SMART_MODE);
            popupWindow.dismiss();
        }
    }

    public void gone() {
        if (popupWindow != null && popupWindow.isShowing()) {
            popupWindow.dismiss();
        }
    }

    public void setMultiFloor(boolean isMultiFloor) {
        this.isMultiFloor = isMultiFloor;
        if (isMultiFloor) {
            llMultiFloor.setVisibility(View.VISIBLE);
        } else {
            llMultiFloor.setVisibility(View.GONE);
        }
    }

    public void setShowEscalatorFirst(boolean isEscalatorFirst) {
        if (isEscalatorFirst) {
            llEscalator.setVisibility(View.VISIBLE);
        } else {
            llEscalator.setVisibility(View.GONE);
        }
    }

    public void setStartRegion(String startRegion) {
        tvStart.setText(startRegion);
    }

    public void setStartRegion(LocationRegion startRegion) {
        String startText = "";
        if (startRegion != null) {
            startText += startRegion.getFloorDescription();
            startText += startRegion.getName();
        }
        tvStart.setText(startText);
    }

    public void setStartFloor(String startFloor) {
        tvStartFloor.setText(startFloor);
    }

    public String getStartRegion() {
        return tvStart.getText().toString();
    }

    public void setStartBuilding(String startBuilding) {
        tvStartBuilding.setText(startBuilding);
    }

    public void setTargetBuilding(String targetBuilding) {
        tvTargetBuilding.setText(targetBuilding);
    }

    public void setTargetRegion(LocationRegion targetRegion) {
        if (targetRegion != null) {
            tvTarget.setText(targetRegion.getName());
            tvTargetFloor.setText(targetRegion.getFloorDescription());
        }
    }

    public void changeFloorMode(int mode) {
        switch (mode) {
            case PathRoutingManager.ELEVATOR_FIRST:
                llEscalator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivEscalator.setImageResource(R.drawable.ipsmap_escalator_disable);
                tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                llElevator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_org4));
                ivElevator.setImageResource(R.drawable.ipsmap_elevator_enable);
                tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                llStair.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivStair.setImageResource(R.drawable.ipsmap_stair_disable);
                tvStair.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                break;
            case PathRoutingManager.STAIR_FIRST:
                llEscalator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivEscalator.setImageResource(R.drawable.ipsmap_escalator_disable);
                tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                llElevator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivElevator.setImageResource(R.drawable.ipsmap_elevator_disable);
                tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                llStair.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_org4));
                ivStair.setImageResource(R.drawable.ipsmap_stair_enable);
                tvStair.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                break;
            case PathRoutingManager.ESCALATOR_FIRST:
                llEscalator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_org4));
                ivEscalator.setImageResource(R.drawable.ipsmap_escalator_enable);
                tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
                llElevator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivElevator.setImageResource(R.drawable.ipsmap_elevator_disable);
                tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                llStair.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivStair.setImageResource(R.drawable.ipsmap_stair_disable);
                tvStair.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                break;
            default:
                llEscalator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivEscalator.setImageResource(R.drawable.ipsmap_escalator_disable);
                tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                llElevator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivElevator.setImageResource(R.drawable.ipsmap_elevator_disable);
                tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                llStair.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_black4));
                ivStair.setImageResource(R.drawable.ipsmap_stair_disable);
                tvStair.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
                break;
        }
    }

    /**
     * onNavStart 导航
     * onSimStart 模拟导航
     */
    public interface OnNavBtnClickListener {
        void onNavStart();

        void onSimStart();
    }

    /**
     * escalatorMode 扶梯
     * elevatorMode 电梯
     * stairMode 楼梯
     */
    public interface OnFloorModeSelectListener {
        void escalatorMode();

        void elevatorMode();

        void stairMode();
    }

    public interface OnLocationClickListener {
        void onStartClick();

        void onTargetClick();
    }

}
